/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.ipt.action.manage;

import freemarker.ext.beans.SimpleMapModel;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.inject.Inject;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.gbif.dwc.terms.Term;
import org.gbif.ipt.action.manage.ManagerBaseAction;
import org.gbif.ipt.action.manage.TranslationAction;
import org.gbif.ipt.config.AppConfig;
import org.gbif.ipt.model.Extension;
import org.gbif.ipt.model.ExtensionMapping;
import org.gbif.ipt.model.ExtensionProperty;
import org.gbif.ipt.model.PropertyMapping;
import org.gbif.ipt.model.Vocabulary;
import org.gbif.ipt.model.VocabularyConcept;
import org.gbif.ipt.service.SourceException;
import org.gbif.ipt.service.admin.RegistrationManager;
import org.gbif.ipt.service.admin.VocabulariesManager;
import org.gbif.ipt.service.manage.ResourceManager;
import org.gbif.ipt.service.manage.SourceManager;
import org.gbif.ipt.struts2.SimpleTextProvider;

public class TranslationAction
extends ManagerBaseAction {
    private static final long serialVersionUID = -8350422710092468050L;
    private static final Logger LOG = LogManager.getLogger(TranslationAction.class);
    private SourceManager sourceManager;
    private VocabulariesManager vocabManager;
    private Translation trans = new Translation();
    protected static final String REQ_PARAM_TERM = "term";
    protected static final String REQ_PARAM_ROWTYPE = "rowtype";
    protected static final String REQ_PARAM_MAPPINGID = "mid";
    private PropertyMapping field;
    private ExtensionProperty property;
    private ExtensionMapping mapping;
    private SimpleMapModel vocabTerms;
    private Integer mid;

    @Inject
    public TranslationAction(SimpleTextProvider textProvider, AppConfig cfg, RegistrationManager registrationManager, ResourceManager resourceManager, SourceManager sourceManager, VocabulariesManager vocabManager) {
        super(textProvider, cfg, registrationManager, resourceManager);
        this.sourceManager = sourceManager;
        this.vocabManager = vocabManager;
        this.defaultResult = "success";
    }

    public String automap() {
        if (this.property == null || this.property.getVocabulary() == null) {
            this.addActionError(this.getText("manage.translation.cantfind.vocabulary"));
        } else {
            Vocabulary vocab = this.property.getVocabulary();
            int count = 0;
            for (Map.Entry sourceValueEntry : this.getSourceValuesMap().entrySet()) {
                VocabularyConcept vc;
                if (this.getTmap().containsValue(sourceValueEntry.getValue()) || (vc = vocab.findConcept((String)sourceValueEntry.getValue())) == null) continue;
                this.getTmap().put((String)sourceValueEntry.getKey(), vc.getIdentifier());
                ++count;
            }
            this.addActionMessage(this.getText("manage.translation.mapped.terms", new String[]{String.valueOf(count)}));
        }
        return "success";
    }

    public String delete() {
        if (this.field != null) {
            this.field.setTranslation(new TreeMap());
            this.trans.setTmap(this.mapping.getExtension().getRowType(), (Term)this.property, new TreeMap(), new TreeMap());
            this.saveResource();
            this.addActionMessage(this.getText("manage.translation.deleted", new String[]{this.field.getTerm().toString()}));
            this.reloadSourceValues();
        } else {
            LOG.error("User wanted to deleted translation for propertyMapping field, but field was null");
        }
        Extension ext = this.mapping.getExtension();
        this.id = ext != null ? ext.getRowType() : null;
        return "none";
    }

    public void prepare() {
        super.prepare();
        this.notFound = true;
        try {
            String midStr = StringUtils.trimToNull((String)this.req.getParameter(REQ_PARAM_MAPPINGID));
            if (midStr != null) {
                this.mid = Integer.valueOf(midStr);
                this.mapping = this.resource.getMapping(this.req.getParameter(REQ_PARAM_ROWTYPE), this.mid);
            }
        }
        catch (Exception e) {
            LOG.error("An exception was encountered: " + e.getMessage(), (Throwable)e);
        }
        if (this.mapping != null) {
            this.field = this.mapping.getField(this.req.getParameter(REQ_PARAM_TERM));
            if (this.field != null) {
                this.notFound = false;
                this.property = this.mapping.getExtension().getProperty(this.field.getTerm());
                if (this.property.getVocabulary() != null) {
                    Map vocabTermsRawData = this.vocabManager.getI18nVocab(this.property.getVocabulary().getUriString(), this.getLocaleLanguage(), true);
                    this.vocabTerms = new SimpleMapModel(vocabTermsRawData, null);
                }
                if (!this.isLoaded(this.mapping.getExtension().getRowType(), this.field.getTerm())) {
                    this.reloadSourceValues();
                }
                if (this.isHttpPost()) {
                    this.trans.getTranslatedValues().clear();
                }
            }
        }
    }

    public String reload() {
        this.reloadSourceValues();
        return "success";
    }

    void reloadSourceValues() {
        try {
            String midStr = StringUtils.trimToNull((String)this.req.getParameter(REQ_PARAM_MAPPINGID));
            if (midStr != null) {
                this.mid = Integer.valueOf(midStr);
                this.mapping = this.resource.getMapping(this.req.getParameter(REQ_PARAM_ROWTYPE), this.mid);
            }
            if (this.trans == null) {
                this.trans = new Translation();
            }
            this.trans.setTmap(this.mapping.getExtension().getRowType(), (Term)this.property, new TreeMap(), new TreeMap());
            int i = 1;
            for (String string : this.sourceManager.inspectColumn(this.mapping.getSource(), this.field.getIndex().intValue(), 1000, 10000)) {
                String key = "k" + i;
                this.getSourceValuesMap().put(key, string);
                ++i;
            }
            if (this.field.getTranslation() != null) {
                for (Map.Entry entry : this.field.getTranslation().entrySet()) {
                    if (entry.getValue() == null || !this.getSourceValuesMap().containsValue(entry.getKey())) continue;
                    for (Map.Entry sourceValueEntry : this.getSourceValuesMap().entrySet()) {
                        if (!((String)sourceValueEntry.getValue()).equals(entry.getKey())) continue;
                        this.getTmap().put((String)sourceValueEntry.getKey(), (String)entry.getValue());
                    }
                }
            }
            this.addActionMessage(this.getText("manage.translation.reloaded.values", new String[]{String.valueOf(this.getSourceValuesMap().size()), this.field.getTerm().toString()}));
        }
        catch (SourceException e) {
            this.addActionError(this.getText("manage.translation.reloaded.fail", new String[]{this.field.getTerm().toString(), e.getMessage()}));
        }
    }

    public String save() {
        this.field.setTranslation(this.trans.getPersistentMap());
        this.saveResource();
        this.id = this.mapping.getExtension().getRowType();
        this.addActionMessage(this.getText("manage.translation.saved", new String[]{this.field.getTerm().toString()}));
        return "none";
    }

    public PropertyMapping getField() {
        return this.field;
    }

    public Integer getMid() {
        return this.mid;
    }

    public ExtensionProperty getProperty() {
        return this.property;
    }

    public Map<String, String> getSourceValuesMap() {
        return this.trans.getSourceValues();
    }

    public Map<String, String> getTmap() {
        return this.trans.getTranslatedValues();
    }

    public SimpleMapModel getVocabTerms() {
        return this.vocabTerms;
    }

    public int getVocabTermsSize() {
        return this.vocabTerms != null ? this.vocabTerms.size() : 0;
    }

    public Set<String> getVocabTermsKeys() {
        return this.vocabTerms != null && this.vocabTerms.getWrappedObject() instanceof Map ? ((Map)this.vocabTerms.getWrappedObject()).keySet() : Collections.emptySet();
    }

    public void setTmap(TreeMap<String, String> translatedValues) {
        this.trans.translatedValues = translatedValues;
    }

    public Translation getTrans() {
        return this.trans;
    }

    public void setField(PropertyMapping field) {
        this.field = field;
    }

    public void setProperty(ExtensionProperty property) {
        this.property = property;
    }

    public void setExtensionMapping(ExtensionMapping mapping) {
        this.mapping = mapping;
    }

    public boolean isLoaded(String rowType, Term term) {
        this.trans = (Translation)this.session.get("dwcTranslation");
        return this.trans != null && this.trans.rowType != null && this.trans.rowType.equals(rowType) && this.trans.term != null && this.trans.term.equals(term) && this.trans.sourceValues != null;
    }
}

