/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.ipt.action.manage;

import java.util.List;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.apache.struts2.ServletActionContext;
import org.apache.struts2.json.annotations.JSON;
import org.gbif.ipt.action.BaseAction;
import org.gbif.ipt.config.AppConfig;
import org.gbif.ipt.model.Organisation;
import org.gbif.ipt.model.datatable.DatatableRequest;
import org.gbif.ipt.model.datatable.DatatableResult;
import org.gbif.ipt.service.admin.RegistrationManager;
import org.gbif.ipt.service.manage.ResourceManager;
import org.gbif.ipt.struts2.SimpleTextProvider;

public class HomeAction
extends BaseAction {
    private static final long serialVersionUID = -7395504502586148676L;
    private DatatableResult resources = new DatatableResult();
    private final ResourceManager resourceManager;
    private List<Organisation> organisations;

    @Inject
    public HomeAction(SimpleTextProvider textProvider, AppConfig cfg, RegistrationManager registrationManager, ResourceManager resourceManager) {
        super(textProvider, cfg, registrationManager);
        this.resourceManager = resourceManager;
    }

    public String execute() {
        DatatableRequest dr = this.getRequestParameters(ServletActionContext.getRequest());
        this.resources = this.resourceManager.list(this.getCurrentUser(), dr);
        this.organisations = this.registrationManager.list();
        return "success";
    }

    private DatatableRequest getRequestParameters(HttpServletRequest request) {
        DatatableRequest result = new DatatableRequest();
        result.setLocale(this.getLocaleLanguage());
        this.getRequestParameter(request, "search[value]").map(StringUtils::trimToEmpty).ifPresent(arg_0 -> ((DatatableRequest)result).setSearch(arg_0));
        this.getRequestParameter(request, "order[0][dir]").ifPresent(arg_0 -> ((DatatableRequest)result).setSortOrder(arg_0));
        this.getRequestParameter(request, "order[0][column]").map(Integer::parseInt).ifPresent(arg_0 -> ((DatatableRequest)result).setSortFieldIndex(arg_0));
        this.getRequestParameter(request, "start").map(Long::parseLong).ifPresent(arg_0 -> ((DatatableRequest)result).setOffset(arg_0));
        this.getRequestParameter(request, "length").map(Integer::parseInt).ifPresent(arg_0 -> ((DatatableRequest)result).setLimit(arg_0));
        return result;
    }

    @JSON
    public DatatableResult getResources() {
        return this.resources;
    }

    public int getResourcesSize() {
        return this.resources != null ? this.resources.getTotalRecords() : 0;
    }

    public String locked() {
        this.addActionError(this.getText("manage.home.resource.locked"));
        return this.execute();
    }

    public List<Organisation> getOrganisations() {
        return this.organisations;
    }
}

