/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.ipt.action.manage;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Pattern;
import javax.inject.Inject;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.struts2.ActionContext;
import org.apache.struts2.ActionInvocation;
import org.gbif.ipt.action.manage.ManagerBaseAction;
import org.gbif.ipt.config.AppConfig;
import org.gbif.ipt.model.DataPackageField;
import org.gbif.ipt.model.DataPackageFieldMapping;
import org.gbif.ipt.model.DataPackageMapping;
import org.gbif.ipt.model.DataPackageSchema;
import org.gbif.ipt.model.DataPackageTableSchema;
import org.gbif.ipt.model.DataPackageTableSchemaName;
import org.gbif.ipt.model.RecordFilter;
import org.gbif.ipt.model.Source;
import org.gbif.ipt.model.SourceWithHeader;
import org.gbif.ipt.service.admin.DataPackageSchemaManager;
import org.gbif.ipt.service.admin.RegistrationManager;
import org.gbif.ipt.service.manage.ResourceManager;
import org.gbif.ipt.service.manage.SourceManager;
import org.gbif.ipt.struts2.SimpleTextProvider;
import org.gbif.ipt.validation.DataPackageMappingValidator;

public class DataPackageMappingAction
extends ManagerBaseAction {
    private static final long serialVersionUID = -2005597864256786458L;
    private static final Pattern FIELD_FORBIDDEN_CHARACTERS_PATTERN = Pattern.compile("[\\W\\s_0-9]+");
    private final DataPackageSchemaManager schemaManager;
    private final SourceManager sourceManager;
    private DataPackageSchema dataPackageSchema;
    private Integer mid;
    private DataPackageMapping mapping;
    private List<String> columns;
    private List<String[]> peek;
    private List<DataPackageFieldMapping> fields;
    private Map<String, Integer> fieldsIndices;
    private List<String> newTableSchemas = new ArrayList();
    private List<String> newSources = new ArrayList();

    @Inject
    public DataPackageMappingAction(SimpleTextProvider textProvider, AppConfig cfg, RegistrationManager registrationManager, ResourceManager resourceManager, DataPackageSchemaManager schemaManager, SourceManager sourceManager) {
        super(textProvider, cfg, registrationManager, resourceManager);
        this.schemaManager = schemaManager;
        this.sourceManager = sourceManager;
    }

    public String save() throws IOException {
        if (this.dataPackageSchema == null) {
            this.dataPackageSchema = this.schemaManager.get(this.id);
        }
        if (this.resource.getDataPackageMapping(this.mid) == null) {
            this.mid = this.resource.addDataPackageMapping(this.mapping);
        } else {
            this.mapping.setFields(this.fields);
            int fieldsMapped = this.fields.stream().map(DataPackageFieldMapping::getIndex).filter(Objects::nonNull).map(f -> 1).reduce(0, Integer::sum);
            this.mapping.setFieldsMapped(fieldsMapped);
        }
        Date lastModified = new Date();
        this.mapping.setLastModified(lastModified);
        this.resource.setMappingsModified(lastModified);
        this.saveResource();
        this.validateAndReport();
        return this.defaultResult;
    }

    private void readSource() {
        Source src = this.mapping.getSource();
        if (src == null) {
            this.columns = new ArrayList();
        } else {
            this.peek = this.sourceManager.peek(src, 5);
            this.columns = (src.isUrlSource() || src.isFileSource()) && ((SourceWithHeader)src).getIgnoreHeaderLines() == 0 ? this.mapping.getColumns(this.peek) : this.sourceManager.columns(src);
            if (this.columns.isEmpty() && src.getName() != null) {
                this.addActionWarning(this.getText("manage.mapping.source.no.columns", new String[]{src.getName()}));
            }
        }
    }

    private List<String> readSource(DataPackageMapping mapping) {
        List<String> columns;
        Source src = mapping.getSource();
        if (src == null) {
            columns = new ArrayList<String>();
        } else {
            List peek = this.sourceManager.peek(src, 5);
            columns = (src.isUrlSource() || src.isFileSource()) && ((SourceWithHeader)src).getIgnoreHeaderLines() == 0 ? mapping.getColumns(peek) : this.sourceManager.columns(src);
        }
        return columns;
    }

    public String source() {
        return "input";
    }

    public String create() {
        if (!this.isHttpPost()) {
            return "cancel";
        }
        int newMappingsNumber = Math.min(this.newTableSchemas.size(), this.newSources.size());
        for (int i = 0; i < newMappingsNumber; ++i) {
            String sourceName = (String)this.newSources.get(i);
            String tableSchemaName = (String)this.newTableSchemas.get(i);
            DataPackageMapping newMapping = new DataPackageMapping();
            Source source = this.resource.getSource(sourceName);
            newMapping.setSource(source);
            newMapping.setDataPackageSchema(this.dataPackageSchema);
            newMapping.setDataPackageTableSchemaName(new DataPackageTableSchemaName(tableSchemaName));
            newMapping.setFilter(new RecordFilter());
            ArrayList<DataPackageFieldMapping> newMappingFields = new ArrayList<DataPackageFieldMapping>();
            List sourceColumns = this.readSource(newMapping);
            DataPackageTableSchema tableSchema = this.dataPackageSchema.tableSchemaByName(tableSchemaName);
            if (tableSchema != null) {
                for (DataPackageField field : tableSchema.getFields()) {
                    DataPackageFieldMapping pm = this.populateDataSchemaFieldMapping(field);
                    newMappingFields.add(pm);
                }
            }
            this.automap(newMappingFields, sourceColumns);
            newMapping.setFields(newMappingFields);
            newMapping.setLastModified(new Date());
            this.mid = this.resource.addDataPackageMapping(newMapping);
        }
        this.addActionMessage(this.getText("manage.mapping.multiple.created", new String[]{String.valueOf(newMappingsNumber)}));
        return "success";
    }

    public void prepare() {
        super.prepare();
        String midStr = StringUtils.trimToNull((String)this.req.getParameter("mid"));
        if (midStr != null) {
            this.mid = Integer.valueOf(midStr);
        }
        if (this.id != null) {
            if (this.mid == null) {
                DataPackageSchema ds = this.schemaManager.get(this.id);
                if (ds != null) {
                    this.mapping = new DataPackageMapping();
                    this.mapping.setDataPackageSchema(ds);
                } else {
                    this.addActionError(this.getText("manage.overview.mappings.select.invalid"));
                    this.defaultResult = "error";
                }
            } else {
                List maps = this.resource.getDataPackageMappings();
                this.mapping = (DataPackageMapping)maps.get(this.mid);
            }
        } else {
            this.notFound = true;
        }
        if (!this.isPrepareBeforeDelete() && !this.cancel && this.mapping != null && this.mapping.getDataPackageSchema() != null) {
            int automapped;
            List fieldsBySchema;
            boolean mappingEmpty;
            this.dataPackageSchema = this.mapping.getDataPackageSchema();
            if (this.dataPackageSchema == null || CollectionUtils.isEmpty((Collection)this.dataPackageSchema.getTableSchemas())) {
                this.dataPackageSchema = this.schemaManager.get(this.id);
            }
            if (this.mapping.getSource() == null) {
                String source = StringUtils.trimToNull((String)this.req.getParameter("source"));
                String tableSchemaName = StringUtils.trimToNull((String)this.req.getParameter("tableSchema"));
                if (tableSchemaName != null) {
                    this.mapping.setDataPackageTableSchemaName(new DataPackageTableSchemaName(tableSchemaName));
                }
                if (source != null) {
                    Source src = this.resource.getSource(source);
                    this.mapping.setSource(src);
                } else {
                    this.defaultResult = "source";
                    return;
                }
            }
            if (this.mapping.getFilter() == null) {
                this.mapping.setFilter(new RecordFilter());
            }
            this.fields = new ArrayList();
            this.fieldsIndices = new HashMap();
            this.readSource();
            DataPackageTableSchema tableSchema = this.mapping.getDataPackageSchema().tableSchemaByName(this.mapping.getDataPackageTableSchemaName().getName());
            this.fieldsIndices = new HashMap();
            int index = 0;
            if (tableSchema != null) {
                for (DataPackageField field : tableSchema.getFields()) {
                    DataPackageFieldMapping pm = this.populateDataSchemaFieldMapping(field);
                    this.fields.add(pm);
                    this.fieldsIndices.put(field.getName(), index++);
                }
            }
            if ((mappingEmpty = (fieldsBySchema = this.mapping.getFields()).isEmpty()) && (automapped = this.automap()) > 0) {
                this.addActionMessage(this.getText("manage.mapping.automaped", new String[]{String.valueOf(automapped)}));
            }
            if (!this.isHttpPost()) {
                this.validateAndReport();
            }
        }
    }

    private void validateAndReport() {
        if (this.mapping.getSource() == null) {
            return;
        }
        DataPackageMappingValidator validator = new DataPackageMappingValidator();
        DataPackageMappingValidator.ValidationStatus v = validator.validate(this.mapping, this.resource, this.columns);
        if (v != null && !v.isValid()) {
            for (DataPackageField field : v.getMissingRequiredFields()) {
                this.addActionWarning(this.getText("validation.required", new String[]{field.getName()}));
            }
        }
    }

    private int automap() {
        int automapped = 0;
        block0: for (DataPackageFieldMapping f : this.fields) {
            int idx2 = 0;
            for (String col : this.columns) {
                String normCol = this.normalizeColumnName(col);
                if (f.getField().getName().equalsIgnoreCase(normCol)) {
                    f.setIndex(Integer.valueOf(idx2));
                    ++automapped;
                    continue block0;
                }
                ++idx2;
            }
        }
        return automapped;
    }

    private int automap(List<DataPackageFieldMapping> fields, List<String> columns) {
        int automapped = 0;
        block0: for (DataPackageFieldMapping f : fields) {
            int idx2 = 0;
            for (String col : columns) {
                String normCol = this.normalizeColumnName(col);
                if (f.getField().getName().equalsIgnoreCase(normCol)) {
                    f.setIndex(Integer.valueOf(idx2));
                    ++automapped;
                    continue block0;
                }
                ++idx2;
            }
        }
        return automapped;
    }

    private String normalizeColumnName(String col) {
        if (StringUtils.isNotBlank((CharSequence)col)) {
            String result = !"_id".equals(col.trim()) ? FIELD_FORBIDDEN_CHARACTERS_PATTERN.matcher(col.toLowerCase()).replaceAll("") : col.trim();
            if (result.contains(":")) {
                result = StringUtils.substringAfter((String)col, (String)":");
            }
            return result;
        }
        return null;
    }

    private DataPackageFieldMapping populateDataSchemaFieldMapping(DataPackageField field) {
        DataPackageFieldMapping fm = this.mapping.getField(field.getName());
        if (fm == null) {
            fm = new DataPackageFieldMapping();
        }
        fm.setField(field);
        return fm;
    }

    public String cancel() {
        if (this.mapping != null && this.mapping.getSource() == null && this.mapping.getFields().isEmpty()) {
            this.resource.deleteMapping(this.mapping);
            this.saveResource();
        }
        return "cancel";
    }

    public String delete() {
        String sourceName = Optional.ofNullable(this.mapping.getSource()).map(Source::getName).orElse("unknown");
        String tableSchemaName = Optional.ofNullable(this.mapping.getDataPackageTableSchemaName()).map(DataPackageTableSchemaName::getName).orElse("unknown");
        if (this.resource.deleteMapping(this.mapping)) {
            this.addActionMessage(this.getText("manage.mapping.deleted", new String[]{sourceName + " \u2192 " + tableSchemaName}));
            this.resource.setMappingsModified(new Date());
            this.saveResource();
        } else {
            this.addActionMessage(this.getText("manage.mapping.couldnt.delete", new String[]{sourceName + " \u2192 " + tableSchemaName}));
        }
        return "success";
    }

    public RecordFilter.Comparator[] getComparators() {
        return RecordFilter.Comparator.values();
    }

    public List<String> getNonMappedColumns() {
        ArrayList<String> mapped = new ArrayList<String>();
        if (this.columns.isEmpty()) {
            return mapped;
        }
        for (DataPackageFieldMapping field : this.fields) {
            String sourceColumn;
            if (field.getIndex() == null || field.getIndex() < 0 || field.getIndex() >= this.columns.size() || (sourceColumn = (String)this.columns.get(field.getIndex())) == null) continue;
            mapped.add(sourceColumn);
        }
        ArrayList<String> nonMapped = new ArrayList<String>(this.columns);
        nonMapped.removeAll(mapped);
        return nonMapped;
    }

    private boolean isPrepareBeforeDelete() {
        ActionInvocation invocation = ActionContext.getContext().getActionInvocation();
        String actionMethod = invocation.getProxy().getMethod();
        return "delete".equals(actionMethod);
    }

    public DataPackageSchema getDataPackageSchema() {
        return this.dataPackageSchema;
    }

    public Integer getMid() {
        return this.mid;
    }

    public DataPackageMapping getMapping() {
        return this.mapping;
    }

    public List<String> getColumns() {
        return this.columns;
    }

    public List<String[]> getPeek() {
        return this.peek;
    }

    public List<DataPackageFieldMapping> getFields() {
        return this.fields;
    }

    public void setFields(List<DataPackageFieldMapping> fields) {
        this.fields = fields;
    }

    public Map<String, Integer> getFieldsIndices() {
        return this.fieldsIndices;
    }

    public void setNewTableSchemas(List<String> newTableSchemas) {
        this.newTableSchemas = newTableSchemas;
    }

    public List<String> getNewTableSchemas() {
        return this.newTableSchemas;
    }

    public void setNewSources(List<String> newSources) {
        this.newSources = newSources;
    }

    public List<String> getNewSources() {
        return this.newSources;
    }
}

