/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.ipt.action.manage;

import freemarker.ext.beans.SimpleMapModel;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.gbif.ipt.action.manage.DataPackageFieldTranslationAction;
import org.gbif.ipt.action.manage.ManagerBaseAction;
import org.gbif.ipt.config.AppConfig;
import org.gbif.ipt.model.DataPackageField;
import org.gbif.ipt.model.DataPackageFieldMapping;
import org.gbif.ipt.model.DataPackageMapping;
import org.gbif.ipt.model.DataPackageSchema;
import org.gbif.ipt.service.SourceException;
import org.gbif.ipt.service.admin.RegistrationManager;
import org.gbif.ipt.service.manage.ResourceManager;
import org.gbif.ipt.service.manage.SourceManager;
import org.gbif.ipt.struts2.SimpleTextProvider;

public class DataPackageFieldTranslationAction
extends ManagerBaseAction {
    private static final long serialVersionUID = -5414310011336523439L;
    private static final Logger LOG = LogManager.getLogger(DataPackageFieldTranslationAction.class);
    private final SourceManager sourceManager;
    private Translation trans = new Translation();
    protected static final String REQ_PARAM_MAPPINGID = "mid";
    protected static final String REQ_FIELD = "field";
    private DataPackageFieldMapping fieldMapping;
    private DataPackageField field;
    private DataPackageMapping mapping;
    private SimpleMapModel vocabTerms;
    private Integer mid;

    @Inject
    public DataPackageFieldTranslationAction(SimpleTextProvider textProvider, AppConfig cfg, RegistrationManager registrationManager, ResourceManager resourceManager, SourceManager sourceManager) {
        super(textProvider, cfg, registrationManager, resourceManager);
        this.sourceManager = sourceManager;
        this.defaultResult = "success";
    }

    public String automap() {
        if (this.field == null || this.field.getConstraints().getVocabulary() == null) {
            this.addActionError(this.getText("manage.translation.cantfind.vocabulary"));
        } else {
            List vocab = this.field.getConstraints().getVocabulary();
            int count = 0;
            for (Map.Entry sourceValueEntry : this.getSourceValuesMap().entrySet()) {
                Optional<String> vocabularyMatch;
                if (this.getTmap().containsValue(sourceValueEntry.getValue()) || !(vocabularyMatch = vocab.stream().filter(v -> v.replaceAll("_", "").equalsIgnoreCase(((String)sourceValueEntry.getValue()).replaceAll("_", ""))).findFirst()).isPresent()) continue;
                this.getTmap().put((String)sourceValueEntry.getKey(), vocabularyMatch.get());
                ++count;
            }
            this.addActionMessage(this.getText("manage.translation.mapped.fields", new String[]{String.valueOf(count)}));
        }
        return "success";
    }

    public String delete() {
        if (this.fieldMapping != null) {
            this.fieldMapping.setTranslation(new TreeMap());
            this.trans.setTmap(this.mapping.getDataPackageTableSchemaName().getName(), this.field.getName(), new TreeMap(), new TreeMap());
            this.saveResource();
            this.addActionMessage(this.getText("manage.translation.field.deleted", new String[]{this.field.getName()}));
            this.reloadSourceValues();
        } else {
            LOG.error("User wanted to deleted translation for propertyMapping field, but field was null");
        }
        DataPackageSchema schema = this.mapping.getDataPackageSchema();
        this.id = schema != null ? schema.getIdentifier() : null;
        return "none";
    }

    public void prepare() {
        super.prepare();
        this.notFound = true;
        try {
            String midStr = StringUtils.trimToNull((String)this.req.getParameter(REQ_PARAM_MAPPINGID));
            if (midStr != null) {
                this.mid = Integer.valueOf(midStr);
                this.mapping = this.resource.getDataPackageMapping(this.mid);
            }
        }
        catch (Exception e) {
            LOG.error("An exception was encountered: " + e.getMessage(), (Throwable)e);
        }
        if (this.mapping != null) {
            String fieldParam = this.req.getParameter(REQ_FIELD);
            this.fieldMapping = this.mapping.getField(fieldParam);
            if (this.fieldMapping != null) {
                this.notFound = false;
                this.field = this.mapping.getField(fieldParam).getField();
                if (this.field.getConstraints() != null && this.field.getConstraints().getVocabulary() != null) {
                    Map vocabRawData = this.field.getConstraints().getVocabulary().stream().collect(Collectors.toMap(Function.identity(), Function.identity(), (e1, e2) -> e1, LinkedHashMap::new));
                    this.vocabTerms = new SimpleMapModel(vocabRawData, null);
                }
                if (!this.isLoaded(this.mapping.getDataPackageTableSchemaName().getName(), this.fieldMapping.getField())) {
                    this.reloadSourceValues();
                }
                if (this.isHttpPost()) {
                    this.trans.getTranslatedValues().clear();
                }
            }
        }
    }

    public String reload() {
        this.reloadSourceValues();
        return "success";
    }

    void reloadSourceValues() {
        try {
            String midStr = StringUtils.trimToNull((String)this.req.getParameter(REQ_PARAM_MAPPINGID));
            if (midStr != null) {
                this.mid = Integer.valueOf(midStr);
                this.mapping = this.resource.getDataPackageMapping(this.mid);
            }
            if (this.trans == null) {
                this.trans = new Translation();
            }
            this.trans.setTmap(this.mapping.getDataPackageTableSchemaName().getName(), this.field.getName(), new TreeMap(), new TreeMap());
            int i = 1;
            for (String string : this.sourceManager.inspectColumn(this.mapping.getSource(), this.fieldMapping.getIndex().intValue(), 1000, 10000)) {
                String key = "k" + i;
                this.getSourceValuesMap().put(key, string);
                ++i;
            }
            if (this.fieldMapping.getTranslation() != null) {
                for (Map.Entry entry : this.fieldMapping.getTranslation().entrySet()) {
                    if (entry.getValue() == null || !this.getSourceValuesMap().containsValue(entry.getKey())) continue;
                    for (Map.Entry sourceValueEntry : this.getSourceValuesMap().entrySet()) {
                        if (!((String)sourceValueEntry.getValue()).equals(entry.getKey())) continue;
                        this.getTmap().put((String)sourceValueEntry.getKey(), (String)entry.getValue());
                    }
                }
            }
            if (!this.isHttpPost()) {
                this.addActionMessage(this.getText("manage.translation.reloaded.field.values", new String[]{String.valueOf(this.getSourceValuesMap().size()), this.fieldMapping.getField().getName()}));
            }
        }
        catch (SourceException e) {
            this.addActionError(this.getText("manage.translation.reloaded.field.fail", new String[]{this.fieldMapping.getField().getName(), e.getMessage()}));
        }
    }

    public String save() {
        this.fieldMapping.setTranslation(this.trans.getPersistentMap());
        this.saveResource();
        this.id = this.mapping.getDataPackageTableSchemaName().getName();
        this.addActionMessage(this.getText("manage.translation.field.saved", new String[]{this.fieldMapping.getField().getName()}));
        return "none";
    }

    public Map<String, String> getSourceValuesMap() {
        return this.trans.getSourceValues();
    }

    public Map<String, String> getTmap() {
        return this.trans.getTranslatedValues();
    }

    public int getVocabTermsSize() {
        return this.vocabTerms != null ? this.vocabTerms.size() : 0;
    }

    public Set<String> getVocabTermsKeys() {
        return this.vocabTerms != null && this.vocabTerms.getWrappedObject() instanceof Map ? ((Map)this.vocabTerms.getWrappedObject()).keySet() : Collections.emptySet();
    }

    public void setTmap(TreeMap<String, String> translatedValues) {
        this.trans.translatedValues = translatedValues;
    }

    public boolean isLoaded(String tableSchema, DataPackageField field) {
        this.trans = (Translation)this.session.get("dwcTranslation");
        return this.trans != null && this.trans.tableSchema != null && this.trans.tableSchema.equals(tableSchema) && this.trans.field != null && this.trans.field.equals(field.getName()) && this.trans.sourceValues != null;
    }

    public Translation getTrans() {
        return this.trans;
    }

    public DataPackageFieldMapping getFieldMapping() {
        return this.fieldMapping;
    }

    public DataPackageField getField() {
        return this.field;
    }

    public DataPackageMapping getMapping() {
        return this.mapping;
    }

    public SimpleMapModel getVocabTerms() {
        return this.vocabTerms;
    }

    public Integer getMid() {
        return this.mid;
    }
}

