/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.ipt.action.manage;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.inject.Inject;
import org.apache.commons.io.IOUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.gbif.ipt.action.BaseAction;
import org.gbif.ipt.action.POSTAction;
import org.gbif.ipt.config.AppConfig;
import org.gbif.ipt.config.DataDir;
import org.gbif.ipt.model.DataPackageSchema;
import org.gbif.ipt.model.Organisation;
import org.gbif.ipt.model.Resource;
import org.gbif.ipt.service.AlreadyExistingException;
import org.gbif.ipt.service.DeletionNotAllowedException;
import org.gbif.ipt.service.ImportException;
import org.gbif.ipt.service.InvalidFilenameException;
import org.gbif.ipt.service.admin.DataPackageSchemaManager;
import org.gbif.ipt.service.admin.RegistrationManager;
import org.gbif.ipt.service.admin.VocabulariesManager;
import org.gbif.ipt.service.manage.ResourceManager;
import org.gbif.ipt.struts2.SimpleTextProvider;
import org.gbif.ipt.utils.MapUtils;
import org.gbif.ipt.validation.ResourceValidator;

public class CreateResourceAction
extends POSTAction {
    private static final Logger LOG = LogManager.getLogger(CreateResourceAction.class);
    private ResourceManager resourceManager;
    private DataDir dataDir;
    private File file;
    private String fileContentType;
    private String fileFileName;
    private String shortname;
    private String resourceType;
    private Map<String, String> types;
    private Map<String, String> dataPackageTypes;
    private List<Organisation> organisations;
    private final VocabulariesManager vocabManager;
    private final DataPackageSchemaManager schemaManager;
    private final ResourceValidator validator = new ResourceValidator();

    @Inject
    public CreateResourceAction(SimpleTextProvider textProvider, AppConfig cfg, RegistrationManager registrationManager, ResourceManager resourceManager, DataDir dataDir, VocabulariesManager vocabManager, DataPackageSchemaManager schemaManager) {
        super(textProvider, cfg, registrationManager);
        this.resourceManager = resourceManager;
        this.dataDir = dataDir;
        this.vocabManager = vocabManager;
        this.schemaManager = schemaManager;
    }

    public String getShortname() {
        return this.shortname;
    }

    public void prepare() {
        super.prepare();
        this.organisations = this.registrationManager.list();
    }

    public String save() throws IOException {
        if (this.resourceManager.get(this.shortname) != null) {
            this.addFieldError("resource.shortname", this.getText("validation.resource.shortname.exists", new String[]{this.shortname}));
            return "input";
        }
        Date start = new Date();
        long startTimeInMs = start.getTime() - 10000L;
        try {
            File tmpFile = this.uploadToTmp();
            if (tmpFile == null) {
                this.resourceManager.create(this.shortname, this.resourceType, this.getCurrentUser());
            } else {
                this.resourceManager.create(this.shortname, this.resourceType, tmpFile, this.getCurrentUser(), (BaseAction)this);
            }
        }
        catch (AlreadyExistingException e) {
            this.addFieldError("resource.shortname", this.getText("validation.resource.shortname.exists", new String[]{this.shortname}));
            return "input";
        }
        catch (ImportException e) {
            LOG.error("Error importing the archive: " + e.getMessage(), (Throwable)e);
            this.addActionError(this.getText("validation.resource.import.exception"));
            this.cleanupResourceFolder(this.shortname, startTimeInMs);
            return "input";
        }
        catch (InvalidFilenameException e) {
            this.addActionError(this.getText("manage.source.invalidFileName"));
            return "input";
        }
        return "success";
    }

    protected void cleanupResourceFolder(String shortname, long startTimeInMs) {
        Objects.requireNonNull(shortname);
        Resource resource = this.resourceManager.get(shortname);
        File directory = new File(this.dataDir.dataFile("resources"), shortname);
        if (resource != null && directory.exists() && directory.isDirectory() && directory.lastModified() > startTimeInMs) {
            LOG.info("Deleting resource and its folder from data directory: " + String.valueOf(directory));
            try {
                this.resourceManager.delete(resource, true);
            }
            catch (IOException e) {
                LOG.error("Deleting resource failed: " + e.getMessage(), (Throwable)e);
            }
            catch (DeletionNotAllowedException e) {
                LOG.error("Deleting resource not allowed", (Throwable)e);
            }
        }
    }

    public void setFile(File file) {
        this.file = file;
    }

    public void setFileContentType(String fileContentType) {
        this.fileContentType = fileContentType;
    }

    public void setFileFileName(String fileFileName) {
        this.fileFileName = fileFileName;
    }

    public void setShortname(String shortname) {
        this.shortname = shortname;
    }

    private File uploadToTmp() throws ImportException {
        if (this.fileFileName == null) {
            return null;
        }
        File tmpFile = this.dataDir.tmpFile(this.shortname, this.fileFileName);
        LOG.debug("Uploading dwc archive file for new resource " + this.shortname + " to " + tmpFile.getAbsolutePath());
        try (FileInputStream input = new FileInputStream(this.file);
             FileOutputStream output = new FileOutputStream(tmpFile);){
            IOUtils.copy((InputStream)input, (OutputStream)output);
            output.flush();
            LOG.debug("Uploaded file " + this.fileFileName + " with content-type " + this.fileContentType);
        }
        catch (IOException e) {
            LOG.error((Object)e);
            throw new ImportException("Failed to upload file to tmp file", (Throwable)e);
        }
        return tmpFile;
    }

    public void validate() {
        if (this.isHttpPost()) {
            this.validator.validateCreateNew((BaseAction)this, this.shortname, this.resourceType);
        }
    }

    @Nullable
    public String getResourceType() {
        return this.resourceType;
    }

    public void setResourceType(String resourceType) {
        this.resourceType = resourceType;
    }

    public Map<String, String> getTypes() {
        this.types = new LinkedHashMap();
        this.types.putAll(this.vocabManager.getI18nVocab("http://rs.gbif.org/vocabulary/gbif/datasetType", this.getLocaleLanguage(), false));
        this.types = MapUtils.getMapWithLowercaseKeys((Map)this.types);
        return this.types;
    }

    public Map<String, String> getDataPackageTypes() {
        this.dataPackageTypes = new LinkedHashMap();
        List installedDataPackageSchemas = this.schemaManager.list();
        for (DataPackageSchema installedDataPackageSchema : installedDataPackageSchemas) {
            this.dataPackageTypes.put(installedDataPackageSchema.getName(), installedDataPackageSchema.getTitle());
        }
        this.dataPackageTypes = MapUtils.getMapWithLowercaseKeys((Map)this.dataPackageTypes);
        return this.dataPackageTypes;
    }

    public List<Organisation> getOrganisations() {
        return this.organisations;
    }

    public DataDir getDataDir() {
        return this.dataDir;
    }
}

