/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.ipt.action.manage;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.TimeZone;
import javax.inject.Inject;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.gbif.ipt.action.manage.ManagerBaseAction;
import org.gbif.ipt.config.AppConfig;
import org.gbif.ipt.model.BiMonthEnum;
import org.gbif.ipt.model.DayEnum;
import org.gbif.ipt.model.MonthEnum;
import org.gbif.ipt.model.voc.PublicationMode;
import org.gbif.ipt.service.admin.RegistrationManager;
import org.gbif.ipt.service.admin.VocabulariesManager;
import org.gbif.ipt.service.manage.ResourceManager;
import org.gbif.ipt.struts2.SimpleTextProvider;
import org.gbif.ipt.utils.MapUtils;
import org.gbif.metadata.eml.ipt.model.MaintenanceUpdateFrequency;

public class AutoPublishAction
extends ManagerBaseAction {
    private static final Logger LOG = LogManager.getLogger(AutoPublishAction.class);
    private static final String OFF_FREQUENCY = "off";
    private static final String COLON = ":";
    private static final String DEFAULT_TIME = "12:00";
    private static final String DEFAULT_THRESHOLD = "10";
    private final VocabulariesManager vocabManager;
    private Map<String, String> frequencies;
    private Map<String, String> months;
    private Map<String, String> biMonths;
    private Map<Integer, String> days;
    private Map<String, String> daysOfWeek;

    @Inject
    public AutoPublishAction(SimpleTextProvider textProvider, AppConfig cfg, RegistrationManager registrationManager, ResourceManager resourceManager, VocabulariesManager vocabManager) {
        super(textProvider, cfg, registrationManager, resourceManager);
        this.vocabManager = vocabManager;
    }

    public void prepare() {
        super.prepare();
        this.populateFrequencies();
        this.populateMonths();
        this.populateBiMonths();
        this.populateDays();
        this.populateDaysOfWeek();
        this.setServerTimeZone();
        this.setUpdateFrequencyTime();
    }

    public String save() {
        String updateFrequency = this.req.getParameter("updateFrequency");
        String updateFrequencyMonth = this.req.getParameter("updateFrequencyMonth");
        String updateFrequencyBiMonth = this.req.getParameter("updateFrequencyBiMonth");
        int updateFrequencyDay = Integer.parseInt(this.req.getParameter("updateFrequencyDay"));
        String updateFrequencyDayOfWeek = this.req.getParameter("updateFrequencyDayOfWeek");
        String updateFrequencyTime = this.req.getParameter("updateFrequencyTime");
        String[] hoursAndMinutes = updateFrequencyTime != null && updateFrequencyTime.contains(COLON) ? updateFrequencyTime.split(COLON) : DEFAULT_TIME.split(COLON);
        int updateFrequencyHour = Integer.parseInt(hoursAndMinutes[0]);
        int updateFrequencyMinute = Integer.parseInt(hoursAndMinutes[1]);
        boolean skipUnchanged = Boolean.parseBoolean(this.req.getParameter("skipUnchanged"));
        boolean skipDrop = Boolean.parseBoolean(this.req.getParameter("skipDrop"));
        String recordsDropThresholdRaw = Optional.ofNullable(this.req.getParameter("recordsDropThreshold")).map(StringUtils::trimToNull).orElse(DEFAULT_THRESHOLD);
        int recordsDropThreshold = Integer.parseInt(recordsDropThresholdRaw);
        if (OFF_FREQUENCY.equals(updateFrequency)) {
            this.addActionMessage(this.getText("manage.autopublish.message.off"));
            LOG.debug("Turning off auto-publishing for [{}]", (Object)this.resource.getShortname());
            this.resource.setPublicationMode(PublicationMode.AUTO_PUBLISH_OFF);
            this.resource.clearAutoPublishingFrequency();
        } else if (MaintenanceUpdateFrequency.findByIdentifier((String)updateFrequency) != null) {
            this.addActionMessage(this.getText("manage.autopublish.message.on", new String[]{updateFrequency}));
            LOG.debug("Updating auto-publishing for [{}] to: {}", (Object)this.resource.getShortname(), (Object)updateFrequency);
            this.resource.setPublicationMode(PublicationMode.AUTO_PUBLISH_ON);
            this.resource.setAutoPublishingFrequency(updateFrequency, updateFrequencyMonth, updateFrequencyBiMonth, updateFrequencyDay, updateFrequencyDayOfWeek, updateFrequencyHour, updateFrequencyMinute);
        } else {
            this.addActionError(this.getText("manage.autopublish.message.error"));
            LOG.error("Cannot update auto-publishing setting for [{}]. Unknown frequency: {}", (Object)this.resource.getShortname(), (Object)updateFrequency);
            return "error";
        }
        this.resource.setSkipPublicationIfNotChanged(skipUnchanged);
        this.resource.setSkipPublicationIfRecordsDrop(skipDrop);
        this.resource.setRecordsDropThreshold(recordsDropThreshold);
        this.resourceManager.updatePublicationMode(this.resource);
        LOG.debug("Next published date updated for resource [{}]", (Object)this.resource.getShortname());
        this.saveResource();
        LOG.debug("Resource [{}] saved with new auto-publishing setting", (Object)this.resource.getShortname());
        return "success";
    }

    public Map<String, String> getFrequencies() {
        return this.frequencies;
    }

    public Map<String, String> getMonths() {
        return this.months;
    }

    public Map<String, String> getBiMonths() {
        return this.biMonths;
    }

    public Map<Integer, String> getDays() {
        return this.days;
    }

    public Map<String, String> getDaysOfWeek() {
        return this.daysOfWeek;
    }

    private void populateFrequencies() {
        this.frequencies = new LinkedHashMap();
        this.frequencies.put(OFF_FREQUENCY, this.getText("manage.autopublish.off"));
        Map filteredFrequencies = this.vocabManager.getI18nVocab("http://rs.gbif.org/vocabulary/eml/updateFrequency", this.getLocaleLanguage(), false);
        MapUtils.removeNonMatchingKeys((Map)filteredFrequencies, (List)MaintenanceUpdateFrequency.NON_ZERO_DAYS_UPDATE_PERIODS);
        this.frequencies.putAll(filteredFrequencies);
    }

    private void populateMonths() {
        this.months = new LinkedHashMap();
        for (MonthEnum month : MonthEnum.values()) {
            this.months.put(month.getIdentifier(), this.getText("manage.autopublish." + month.getIdentifier()));
        }
    }

    private void populateBiMonths() {
        this.biMonths = new LinkedHashMap();
        for (BiMonthEnum biMonth : BiMonthEnum.values()) {
            this.biMonths.put(biMonth.getIdentifier(), this.getText("manage.autopublish." + biMonth.getIdentifier()));
        }
    }

    private void populateDays() {
        this.days = new LinkedHashMap();
        for (int i = 1; i <= 31; ++i) {
            this.days.put(i, (i < 10 ? "0" : "") + i);
        }
    }

    private void populateDaysOfWeek() {
        this.daysOfWeek = new LinkedHashMap();
        for (DayEnum dayOfWeek : DayEnum.values()) {
            this.daysOfWeek.put(dayOfWeek.getIdentifier(), this.getText("manage.autopublish." + dayOfWeek.getIdentifier()));
        }
    }

    private void setServerTimeZone() {
        this.req.setAttribute("serverTimeZone", (Object)TimeZone.getDefault().getDisplayName(false, 0));
    }

    private void setUpdateFrequencyTime() {
        if (this.resource.getPublicationMode().equals((Object)PublicationMode.AUTO_PUBLISH_ON)) {
            int savedHour = Optional.ofNullable(this.resource.getUpdateFrequencyHour()).orElse(12);
            int savedMinute = Optional.ofNullable(this.resource.getUpdateFrequencyMinute()).orElse(0);
            String savedTime = String.format("%02d:%02d", savedHour, savedMinute);
            this.req.setAttribute("updateFrequencyTime", (Object)savedTime);
        }
    }

    public boolean isSkipUnchanged() {
        return this.resource.isSkipPublicationIfNotChanged();
    }

    public boolean isSkipDrop() {
        return this.resource.isSkipPublicationIfRecordsDrop();
    }

    public int getRecordsDropThreshold() {
        return this.resource.getRecordsDropThreshold();
    }
}

