/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.ipt.action.admin;

import at.favre.lib.crypto.bcrypt.BCrypt;
import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import javax.inject.Inject;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.RandomStringGenerator;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.gbif.ipt.action.BaseAction;
import org.gbif.ipt.action.POSTAction;
import org.gbif.ipt.config.AppConfig;
import org.gbif.ipt.model.Resource;
import org.gbif.ipt.model.User;
import org.gbif.ipt.service.AlreadyExistingException;
import org.gbif.ipt.service.DeletionNotAllowedException;
import org.gbif.ipt.service.admin.RegistrationManager;
import org.gbif.ipt.service.admin.UserAccountManager;
import org.gbif.ipt.service.manage.ResourceManager;
import org.gbif.ipt.struts2.SimpleTextProvider;
import org.gbif.ipt.validation.UserValidator;

public class UserAccountsAction
extends POSTAction {
    private static final Logger LOG = LogManager.getLogger(UserAccountsAction.class);
    private static final long serialVersionUID = 8892204508303815998L;
    private static final int PASSWORD_LENGTH = 8;
    private static final String PASSWORD_ALLOWED_CHARS = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ1234567890";
    private static final RandomStringGenerator PASSWORD_GENERATOR = new RandomStringGenerator.Builder().selectFrom("abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ1234567890".toCharArray()).build();
    private static final String EMAIL_NEW_ACCOUNT = "<a href=\"mailto:%s?subject=IPT account&amp;body=Dear %s,%%0d%%0dWe would like to inform you that we have created an IPT account for you.%%0d%%0dAccount information:%%0d%%0dIPT: %s%%0dEmail: %s%%0dPassword: %s%%0dRole: %s%%0d%%0dThank you for your attention.\">Click here</a> to share the credentials with the user";
    private static final String EMAIL_PASSWORD_CHANGE = "<a href=\"mailto:%s?subject=IPT password change&amp;body=Dear %s,%%0d%%0dWe would like to inform you that your IPT account's password has been successfully changed.%%0d%%0dAccount information:%%0d%%0dIPT: %s%%0dEmail: %s%%0dPassword: %s%%0d%%0dThank you for your attention.\">Click here</a> to share the new password with the user";
    private final UserAccountManager userManager;
    private final ResourceManager resourceManager;
    private final UserValidator validator = new UserValidator();
    private User user;
    private String password2;
    private boolean resetPassword;
    private boolean newUser;
    private List<User> users;

    @Inject
    public UserAccountsAction(SimpleTextProvider textProvider, AppConfig cfg, RegistrationManager registrationManager, UserAccountManager userManager, ResourceManager resourceManager) {
        super(textProvider, cfg, registrationManager);
        this.userManager = userManager;
        this.resourceManager = resourceManager;
    }

    private void checkUserResourcesBeforeDeletion(String email) throws DeletionNotAllowedException {
        User remUser = this.userManager.get(email);
        HashSet<String> resourcesCreatedByUser = new HashSet<String>();
        for (Resource r : this.resourceManager.list()) {
            User creator = this.userManager.get(r.getCreator().getEmail());
            if (creator == null || !creator.equals((Object)remUser)) continue;
            resourcesCreatedByUser.add(r.getShortname());
        }
        HashSet<String> resourcesManagedOnlyByUser = new HashSet<String>();
        for (Resource r : this.resourceManager.list(remUser)) {
            HashSet<User> managers = new HashSet<User>();
            User creator = this.userManager.get(r.getCreator().getEmail());
            if (creator != null && creator.hasManagerRights()) {
                managers.add(creator);
            }
            for (User m : r.getManagers()) {
                User manager = this.userManager.get(m.getEmail());
                if (manager == null) continue;
                managers.add(manager);
            }
            managers.remove(remUser);
            if (!managers.isEmpty()) continue;
            resourcesManagedOnlyByUser.add(r.getShortname());
        }
        if (!resourcesManagedOnlyByUser.isEmpty()) {
            throw new DeletionNotAllowedException(DeletionNotAllowedException.Reason.LAST_RESOURCE_MANAGER, ((Object)resourcesManagedOnlyByUser).toString());
        }
        if (!resourcesCreatedByUser.isEmpty()) {
            throw new DeletionNotAllowedException(DeletionNotAllowedException.Reason.IS_RESOURCE_CREATOR, ((Object)resourcesCreatedByUser).toString());
        }
    }

    private void removeUserFromResourceManagers(User user) {
        for (Resource r : this.resourceManager.list(user)) {
            r.getManagers().remove(user);
            this.resourceManager.save(r);
        }
    }

    public String delete() {
        User currentUser = this.getCurrentUser();
        if (currentUser.getEmail().equalsIgnoreCase(this.id)) {
            LOG.error("Cannot remove an account {} when logged in to it", (Object)this.id);
            this.addActionError(this.getText("admin.user.deleted.current"));
        } else {
            try {
                User userToBeDeleted = this.userManager.get(this.id);
                if (userToBeDeleted == null) {
                    return "404";
                }
                this.checkUserResourcesBeforeDeletion(this.id);
                this.removeUserFromResourceManagers(userToBeDeleted);
                boolean result = this.userManager.delete(this.id);
                if (result) {
                    this.userManager.save();
                    LOG.info("User {} has been successfully deleted by {}", (Object)this.id, (Object)currentUser.getEmail());
                    this.addActionMessage(this.getText("admin.user.deleted"));
                    return "success";
                }
                LOG.info("Failed to delete user {}", (Object)this.id);
                return "input";
            }
            catch (DeletionNotAllowedException e) {
                if (DeletionNotAllowedException.Reason.LAST_ADMIN == e.getReason()) {
                    this.addActionError(this.getText("admin.user.deleted.lastadmin"));
                } else if (DeletionNotAllowedException.Reason.LAST_RESOURCE_MANAGER == e.getReason()) {
                    this.addActionError(this.getText("admin.user.deleted.lastmanager", new String[]{e.getMessage()}));
                } else if (DeletionNotAllowedException.Reason.IS_RESOURCE_CREATOR == e.getReason()) {
                    this.addActionError(this.getText("admin.user.deleted.error.creator", new String[]{e.getMessage()}));
                } else {
                    this.addActionError(this.getText("admin.user.deleted.error"));
                }
            }
            catch (IOException e) {
                this.addActionError(this.getText("admin.user.cantSave", new String[]{e.getMessage()}));
            }
        }
        return "input";
    }

    public String getPassword2() {
        return this.password2;
    }

    public String getNewUser() {
        return this.newUser ? "yes" : "no";
    }

    public User getUser() {
        return this.user;
    }

    public List<User> getUsers() {
        return this.users;
    }

    public String list() {
        this.users = this.userManager.list();
        return "success";
    }

    public void prepare() {
        super.prepare();
        if (this.id == null) {
            this.newUser = true;
        } else {
            this.user = this.userManager.get(this.id);
        }
        if (this.id != null && this.user == null) {
            this.notFound = true;
        }
        if (this.user == null) {
            this.id = null;
            this.user = new User();
            this.newUser = true;
        } else {
            try {
                this.user = (User)this.user.clone();
            }
            catch (CloneNotSupportedException e) {
                LOG.error("An exception occurred while retrieving user: " + e.getMessage(), (Throwable)e);
            }
        }
    }

    public String save() {
        User currentUser = this.getCurrentUser();
        try {
            if (this.id == null) {
                String passwordBeforeSaving = this.user.getPassword();
                this.userManager.create(this.user);
                String emailLink = String.format(EMAIL_NEW_ACCOUNT, this.user.getEmail(), this.user.getFirstname(), this.cfg.getBaseUrl(), this.user.getEmail(), passwordBeforeSaving, this.user.getRole());
                LOG.info("User {} has been created by {}", (Object)this.id, (Object)currentUser.getEmail());
                this.addActionMessage(this.getText("admin.user.added", new String[]{emailLink}));
            } else if (this.resetPassword) {
                String newPassword = PASSWORD_GENERATOR.generate(8);
                String hash = BCrypt.withDefaults().hashToString(12, newPassword.toCharArray());
                this.user.setPassword(hash);
                this.userManager.save(this.user);
                String emailLink = String.format(EMAIL_PASSWORD_CHANGE, this.user.getEmail(), this.user.getFirstname(), this.cfg.getBaseUrl(), this.user.getEmail(), newPassword);
                LOG.info("User {} password has been changed by {}", (Object)this.user.getEmail(), (Object)currentUser.getEmail());
                this.addActionMessage(this.getText("admin.user.passwordChanged", new String[]{this.user.getEmail(), newPassword, emailLink}));
            } else {
                User currentStateUser = this.userManager.get(this.user.getEmail());
                if (currentStateUser.getRole() != this.user.getRole()) {
                    LOG.info("User {} role has been changed from {} to {} by {}", (Object)this.user.getEmail(), (Object)currentStateUser.getRole(), (Object)this.user.getRole(), (Object)currentUser.getEmail());
                }
                if (currentStateUser.getRole() == User.Role.Admin && this.user.getRole() != User.Role.Admin && this.userManager.list(User.Role.Admin).size() < 2) {
                    LOG.error("Cannot change the role of the last administrator");
                    this.addActionError(this.getText("admin.user.changed.current"));
                    return "input";
                }
                if (this.user.getEmail().equals(this.getCurrentUser().getEmail())) {
                    this.getCurrentUser().setRole(this.user.getRole());
                }
                this.userManager.save(this.user);
                if (this.getCurrentUser().getRole() != User.Role.Admin) {
                    return "home";
                }
                LOG.info("User {} has been successfully updated by {}", (Object)this.user.getEmail(), (Object)currentUser.getEmail());
                this.addActionMessage(this.getText("admin.user.changed"));
            }
            return "success";
        }
        catch (IOException e) {
            LOG.error("User change couldn't be saved: " + e.getMessage(), (Throwable)e);
            this.addActionError(this.getText("admin.user.saveError"));
            this.addActionError(e.getMessage());
            return "input";
        }
        catch (AlreadyExistingException e) {
            LOG.error("User with the email address {} already exists", (Object)this.user.getEmail(), (Object)e);
            this.addActionError(this.getText("admin.user.exists", new String[]{this.user.getEmail()}));
            this.user = new User();
            return "input";
        }
    }

    public void setPassword2(String password2) {
        this.password2 = password2;
    }

    public void setResetPassword(String pass) {
        this.resetPassword = StringUtils.trimToNull((String)pass) != null;
    }

    public void setUser(User user) {
        this.user = user;
    }

    public void setUsers(List<User> users) {
        this.users = users;
    }

    public void validateHttpPostOnly() {
        this.validator.validate((BaseAction)this, this.user);
        if (this.newUser && StringUtils.trimToNull((String)this.user.getPassword()) != null && !this.user.getPassword().equals(this.password2)) {
            this.addFieldError("password2", this.getText("validation.password2.wrong"));
            this.password2 = null;
            this.user.setPassword(null);
        }
    }
}

