/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.ipt.action.admin;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.struts2.ServletActionContext;
import org.gbif.ipt.action.BaseAction;
import org.gbif.ipt.action.POSTAction;
import org.gbif.ipt.config.AppConfig;
import org.gbif.ipt.model.Ipt;
import org.gbif.ipt.model.KeyNamePair;
import org.gbif.ipt.model.Network;
import org.gbif.ipt.model.Organisation;
import org.gbif.ipt.model.Resource;
import org.gbif.ipt.model.voc.PublicationStatus;
import org.gbif.ipt.service.AlreadyExistingException;
import org.gbif.ipt.service.RegistryException;
import org.gbif.ipt.service.admin.RegistrationManager;
import org.gbif.ipt.service.manage.ResourceManager;
import org.gbif.ipt.service.registry.RegistryManager;
import org.gbif.ipt.struts2.SimpleTextProvider;
import org.gbif.ipt.validation.IptValidator;
import org.gbif.ipt.validation.OrganisationSupport;

public class RegistrationAction
extends POSTAction {
    private static final Logger LOG = LogManager.getLogger(RegistrationAction.class);
    private static final long serialVersionUID = -6522969037528106704L;
    private static final String SESSION_ORGANISATIONS_KEY = "organisations";
    private static final String SESSION_ORGANISATIONS_LAST_UPDATED_KEY = "organisations.lastUpdated";
    private static final String SESSION_NETWORKS_KEY = "networks";
    private static final String SESSION_NETWORKS_LAST_UPDATED_KEY = "networks.lastUpdated";
    private final RegistryManager registryManager;
    private final ResourceManager resourceManager;
    private final OrganisationSupport organisationValidation;
    private final IptValidator iptValidation;
    private String registeredIptPassword;
    private String hostingOrganisationToken;
    protected boolean tokenChange = false;
    private String networkKey;
    private boolean applyToExistingResources = false;
    private boolean validatedBaseURL = false;
    private List<Organisation> organisations = new ArrayList();
    private Map<String, String> networks = new LinkedHashMap();
    private Organisation organisation;
    private Ipt ipt;

    @Inject
    public RegistrationAction(SimpleTextProvider textProvider, AppConfig cfg, RegistrationManager registrationManager, RegistryManager registryManager, ResourceManager resourceManager, OrganisationSupport organisationValidation, IptValidator iptValidation) {
        super(textProvider, cfg, registrationManager);
        this.registryManager = registryManager;
        this.resourceManager = resourceManager;
        this.organisationValidation = organisationValidation;
        this.iptValidation = iptValidation;
    }

    private void loadOrganisations() {
        HttpSession session = ServletActionContext.getRequest().getSession();
        Object sessionOrganisationsRaw = session.getAttribute(SESSION_ORGANISATIONS_KEY);
        boolean requestRegistry = false;
        if (sessionOrganisationsRaw == null) {
            requestRegistry = true;
        } else if (sessionOrganisationsRaw instanceof List) {
            List organisationsGenericList = (List)sessionOrganisationsRaw;
            if (!organisationsGenericList.isEmpty() && organisationsGenericList.get(0) instanceof Organisation) {
                this.organisations = (List)sessionOrganisationsRaw;
            } else {
                requestRegistry = true;
            }
        } else {
            requestRegistry = true;
        }
        if (requestRegistry) {
            LOG.debug("Fetching organisations from registry");
            try {
                this.organisations = this.registryManager.getOrganisations();
                LOG.debug("Organisations returned from the Registry: {}", (Object)this.organisations.size());
                Organisation o = new Organisation();
                o.setName("");
                this.organisations.add(0, o);
                session.setAttribute(SESSION_ORGANISATIONS_KEY, (Object)this.organisations);
                session.setAttribute(SESSION_ORGANISATIONS_LAST_UPDATED_KEY, (Object)new Date());
            }
            catch (RegistryException e) {
                String msg = this.getText("admin.registration.error.registry");
                if (e.getType() == RegistryException.Type.PROXY) {
                    msg = this.getText("admin.registration.error.proxy");
                } else if (e.getType() == RegistryException.Type.SITE_DOWN) {
                    msg = this.getText("admin.registration.error.siteDown");
                } else if (e.getType() == RegistryException.Type.NO_INTERNET) {
                    msg = this.getText("admin.registration.error.internetConnection");
                }
                LOG.error(msg, (Throwable)e);
                this.addActionError(msg);
            }
        }
    }

    private void loadNetworks() {
        HttpSession session = ServletActionContext.getRequest().getSession();
        Object sessionNetworksRaw = session.getAttribute(SESSION_NETWORKS_KEY);
        boolean requestRegistry = false;
        if (sessionNetworksRaw == null) {
            requestRegistry = true;
        } else if (sessionNetworksRaw instanceof List) {
            Map networksGenericList = (Map)sessionNetworksRaw;
            if (!networksGenericList.isEmpty() && networksGenericList.get(0) instanceof String) {
                this.networks = (Map)sessionNetworksRaw;
            } else {
                requestRegistry = true;
            }
        } else {
            requestRegistry = true;
        }
        if (requestRegistry) {
            LOG.debug("Fetching networks from registry");
            try {
                this.networks = this.registryManager.getNetworksBrief().stream().collect(Collectors.toMap(KeyNamePair::getKey, KeyNamePair::getName));
                LOG.debug("Networks returned from the Registry: {}", (Object)this.networks.size());
                this.networks.put("", this.getText("admin.ipt.network.selection"));
                session.setAttribute(SESSION_NETWORKS_KEY, (Object)this.networks);
                session.setAttribute(SESSION_NETWORKS_LAST_UPDATED_KEY, (Object)new Date());
            }
            catch (RegistryException e) {
                LOG.error("Failed to load networks", (Throwable)e);
                String msg = RegistryException.logRegistryException((RegistryException)e, (BaseAction)this);
                this.addActionWarning(this.getText("admin.networks.couldnt.load", new String[]{this.cfg.getRegistryUrl()}) + msg);
                this.networks = new HashMap();
            }
        }
    }

    public Organisation getHostingOrganisation() {
        return this.registrationManager.getHostingOrganisation();
    }

    public Network getNetwork() {
        return this.registrationManager.getNetwork();
    }

    public Ipt getIpt() {
        return this.ipt;
    }

    public Organisation getOrganisation() {
        return this.organisation;
    }

    public List<Organisation> getOrganisations() {
        this.loadOrganisations();
        return this.organisations;
    }

    public String getRegistryURL() {
        return this.cfg.getRegistryUrl() + "/registry/";
    }

    public boolean getValidatedBaseURL() {
        return this.validatedBaseURL;
    }

    public void prepare() {
        super.prepare();
        if (this.getRegisteredIpt() == null) {
            this.loadOrganisations();
        }
        this.loadNetworks();
    }

    public String save() {
        if (this.getRegisteredIpt() == null) {
            try {
                this.registryManager.registerIPT(this.ipt, this.organisation);
                this.registrationManager.addHostingOrganisation(this.organisation);
                this.registrationManager.addAssociatedOrganisation(this.organisation);
                this.registrationManager.addIptInstance(this.ipt);
                this.registrationManager.save();
                this.addActionMessage(this.getText("admin.registration.success"));
                return "success";
            }
            catch (RegistryException re) {
                String msg = RegistryException.logRegistryException((RegistryException)re, (BaseAction)this);
                this.addActionError(msg);
                LOG.error(msg);
                msg = this.getText("admin.registration.failed");
                this.addActionError(msg);
                LOG.error(msg);
                return "input";
            }
            catch (AlreadyExistingException e) {
                LOG.error((Object)e);
            }
            catch (IOException e) {
                LOG.error("The organisation association couldnt be saved: " + e.getMessage(), (Throwable)e);
                this.addActionError(this.getText("admin.organisation.saveError"));
                this.addActionError(e.getMessage());
                return "input";
            }
        }
        this.addActionError(this.getText("admin.registration.error.alreadyRegistered1"));
        this.addActionError(this.getText("admin.registration.error.alreadyRegistered2"));
        return "success";
    }

    public void setIpt(Ipt ipt) {
        this.ipt = ipt;
    }

    public void setOrganisation(Organisation organisation) {
        this.organisation = organisation;
    }

    public void setOrganisations(List<Organisation> organisations) {
        this.organisations = organisations;
    }

    public String update() {
        try {
            if (this.cancel) {
                return this.cancel();
            }
            this.registryManager.updateIpt(this.getRegisteredIpt());
            this.updateResources(this.getRegisteredIpt());
            this.registrationManager.save();
            this.addActionMessage(this.getText("admin.registration.success.update"));
        }
        catch (RegistryException e) {
            String msg = RegistryException.logRegistryException((RegistryException)e, (BaseAction)this);
            this.addActionError(msg);
            LOG.error(msg);
            msg = this.getText("admin.registration.failed.update", new String[]{e.getMessage()});
            this.addActionError(msg);
            LOG.error(msg);
            return "input";
        }
        catch (Exception e) {
            this.addActionError(e.getMessage());
            LOG.error("Exception caught", (Throwable)e);
            return "input";
        }
        return "success";
    }

    private void updateResources(Ipt ipt) {
        List resources = this.resourceManager.list(PublicationStatus.REGISTERED);
        if (!resources.isEmpty()) {
            LOG.info("Next, update {} resource registrations...", (Object)resources.size());
            for (Resource resource : resources) {
                try {
                    this.registryManager.updateResource(resource, ipt.getKey().toString());
                }
                catch (IllegalArgumentException e) {
                    LOG.error(e.getMessage());
                }
            }
            LOG.info("Resource registrations updated successfully!");
        }
    }

    public String changeTokens() {
        try {
            if (this.cancel) {
                return this.cancel();
            }
            if (StringUtils.isNotEmpty((CharSequence)this.hostingOrganisationToken)) {
                this.getHostingOrganisation().setPassword(this.hostingOrganisationToken);
            }
            if (StringUtils.isNotEmpty((CharSequence)this.registeredIptPassword)) {
                this.getRegisteredIpt().setWsPassword(this.registeredIptPassword);
            }
            this.registrationManager.save();
            this.addActionMessage(this.getText("admin.ipt.success.update"));
        }
        catch (Exception e) {
            this.addActionError(this.getText("admin.ipt.update.failed"));
            LOG.error("Exception caught", (Throwable)e);
            return "input";
        }
        return "success";
    }

    public String associateWithNetwork() {
        try {
            if (this.cancel) {
                return this.cancel();
            }
            if (StringUtils.isNotEmpty((CharSequence)this.networkKey)) {
                String networkName = (String)this.networks.get(this.networkKey);
                this.registrationManager.associateWithNetwork(this.networkKey, networkName);
                if (this.applyToExistingResources) {
                    List resources = this.resourceManager.list();
                    for (Resource resource : resources) {
                        if (!resource.isRegistered()) continue;
                        this.registryManager.addResourceToNetwork(resource, this.networkKey);
                    }
                }
                this.addActionMessage(this.getText("admin.ipt.success.associateWithNetwork", new String[]{networkName}));
            } else {
                Network network = this.getNetwork();
                if (network != null) {
                    String networkName = Optional.ofNullable(network.getName()).orElse("");
                    String networkKey = Optional.ofNullable(network.getKey()).map(UUID::toString).orElse("");
                    this.registrationManager.removeAssociationWithNetwork();
                    if (this.applyToExistingResources) {
                        List resources = this.resourceManager.list();
                        for (Resource resource : resources) {
                            if (!resource.isRegistered()) continue;
                            this.registryManager.removeResourceFromNetwork(resource, networkKey);
                        }
                    }
                    this.addActionMessage(this.getText("admin.ipt.success.associationWithNetworkRemoved", new String[]{networkName}));
                }
            }
        }
        catch (Exception e) {
            this.addActionError(this.getText("admin.ipt.update.failed"));
            LOG.error("Exception caught", (Throwable)e);
            return "input";
        }
        return "success";
    }

    public void validate() {
        if (!this.isHttpPost() || this.cancel) {
            return;
        }
        if (this.tokenChange) {
            if (StringUtils.isNotEmpty((CharSequence)this.hostingOrganisationToken)) {
                this.organisationValidation.validateOrganisationToken((BaseAction)this, this.getHostingOrganisation().getKey(), this.hostingOrganisationToken);
            }
            if (StringUtils.isNotEmpty((CharSequence)this.registeredIptPassword)) {
                this.iptValidation.validateIptPassword((BaseAction)this, this.registeredIptPassword);
            }
        } else if (this.getRegisteredIpt() != null) {
            this.iptValidation.validateUpdate((BaseAction)this, this.getRegisteredIpt());
        } else {
            this.iptValidation.validate((BaseAction)this, this.ipt);
            this.validatedBaseURL = true;
            this.organisationValidation.validate((BaseAction)this, this.organisation);
        }
    }

    public String getRegisteredIptPassword() {
        return this.registeredIptPassword;
    }

    public void setRegisteredIptPassword(String registeredIptPassword) {
        this.registeredIptPassword = registeredIptPassword;
    }

    public String getHostingOrganisationToken() {
        return this.hostingOrganisationToken;
    }

    public void setHostingOrganisationToken(String hostingOrganisationToken) {
        this.hostingOrganisationToken = hostingOrganisationToken;
    }

    public boolean isTokenChange() {
        return this.tokenChange;
    }

    public void setTokenChange(boolean tokenChange) {
        this.tokenChange = tokenChange;
    }

    public Map<String, String> getNetworks() {
        return this.networks;
    }

    public String getNetworkKey() {
        return this.networkKey;
    }

    public void setNetworkKey(String networkKey) {
        this.networkKey = networkKey;
    }

    public boolean isApplyToExistingResources() {
        return this.applyToExistingResources;
    }

    public void setApplyToExistingResources(boolean applyToExistingResources) {
        this.applyToExistingResources = applyToExistingResources;
    }
}

