/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.ipt.action.admin;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.gbif.ipt.action.BaseAction;
import org.gbif.ipt.action.admin.PublishAllResourcesAction;
import org.gbif.ipt.config.AppConfig;
import org.gbif.ipt.model.Ipt;
import org.gbif.ipt.model.Resource;
import org.gbif.ipt.model.voc.PublicationStatus;
import org.gbif.ipt.service.InvalidConfigException;
import org.gbif.ipt.service.PublicationException;
import org.gbif.ipt.service.RegistryException;
import org.gbif.ipt.service.admin.RegistrationManager;
import org.gbif.ipt.service.manage.ResourceManager;
import org.gbif.ipt.service.registry.RegistryManager;
import org.gbif.ipt.struts2.SimpleTextProvider;
import org.gbif.ipt.validation.DataPackageMetadataValidator;
import org.gbif.ipt.validation.EmlValidator;

public class PublishAllResourcesAction
extends BaseAction {
    private static final Logger LOG = LogManager.getLogger(PublishAllResourcesAction.class);
    private static final long serialVersionUID = -2717994514136947049L;
    protected ResourceManager resourceManager;
    protected RegistryManager registryManager;
    private final EmlValidator emlValidator;
    private final DataPackageMetadataValidator dpMetadataValidator;
    private List<Resource> resources;
    private List<String> selectedResources;
    private List<String> excludedResources;
    private BulkPublicationType publishMode;

    @Inject
    public PublishAllResourcesAction(SimpleTextProvider textProvider, AppConfig cfg, RegistrationManager registrationManager, ResourceManager resourceManager, RegistryManager registryManager, DataPackageMetadataValidator dpMetadataValidator) {
        super(textProvider, cfg, registrationManager);
        this.resourceManager = resourceManager;
        this.registryManager = registryManager;
        this.dpMetadataValidator = dpMetadataValidator;
        this.emlValidator = new EmlValidator(cfg, registrationManager, textProvider);
    }

    public String execute() throws Exception {
        List resources;
        if (this.cancel) {
            return this.cancel();
        }
        this.resources = this.resourceManager.list();
        try {
            Ipt ipt = this.registrationManager.getIpt();
            if (ipt != null) {
                this.registryManager.updateIpt(ipt);
                this.updateResources(ipt);
            }
        }
        catch (RegistryException e) {
            String msg = RegistryException.logRegistryException((RegistryException)e, (BaseAction)this);
            this.addActionError(msg);
            LOG.error(msg);
        }
        this.resourceManager.clearProcessReports();
        List allResources = this.resourceManager.list();
        boolean skipIfNotChanged = false;
        if (this.publishMode == BulkPublicationType.SELECTED) {
            resources = allResources.stream().filter(res -> this.selectedResources.contains(res.getShortname())).collect(Collectors.toList());
        } else if (this.publishMode == BulkPublicationType.EXCLUDED) {
            resources = allResources.stream().filter(res -> !this.excludedResources.contains(res.getShortname())).collect(Collectors.toList());
        } else if (this.publishMode == BulkPublicationType.CHANGED) {
            resources = allResources;
            skipIfNotChanged = true;
        } else {
            resources = allResources;
        }
        if (resources.isEmpty()) {
            this.addActionWarning(this.getText("admin.config.updateMetadata.none"));
            return "success";
        }
        for (Resource resource : resources) {
            BigDecimal nextVersion = new BigDecimal(resource.getNextVersion().toPlainString());
            try {
                if (!this.resourceManager.hasMaxProcessFailures(resource)) {
                    boolean isValidMetadata = resource.isDataPackage() ? this.dpMetadataValidator.isValid(resource) : this.emlValidator.isValid(resource, null);
                    if (isValidMetadata) {
                        this.resourceManager.publish(resource, nextVersion, (BaseAction)this, skipIfNotChanged);
                        continue;
                    }
                    this.addActionError(this.getText("publishing.failed", new String[]{nextVersion.toPlainString(), resource.getShortname(), this.getText("manage.overview.published.missing.metadata")}));
                    continue;
                }
                this.addActionError(this.getText("publishing.skipping", new String[]{String.valueOf(resource.getNextVersion()), resource.getTitleAndShortname()}));
            }
            catch (PublicationException e) {
                if (PublicationException.TYPE.LOCKED == e.getType()) {
                    this.addActionError(this.getText("manage.overview.resource.being.published", new String[]{resource.getTitleAndShortname()}));
                    continue;
                }
                this.addActionError(this.getText("publishing.failed", new String[]{nextVersion.toPlainString(), resource.getShortname(), e.getMessage()}));
                this.resourceManager.restoreVersion(resource, nextVersion, (BaseAction)this);
                this.resourceManager.getProcessFailures().put((Object)resource.getShortname(), (Object)new Date());
            }
            catch (InvalidConfigException e) {
                String msg = this.getText("publishing.failed", new String[]{nextVersion.toPlainString(), resource.getShortname(), e.getMessage()});
                LOG.error(msg, (Throwable)e);
                this.addActionError(msg);
            }
            catch (Exception e) {
                LOG.error(e.getMessage(), (Throwable)e);
            }
        }
        while (!this.resourceManager.getProcessFutures().isEmpty()) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                LOG.error("Thread waiting during publish all resources was interrupted", (Throwable)e);
            }
        }
        this.clearMessages();
        this.addActionMessage(this.getText("admin.config.updateMetadata.summary"));
        return "success";
    }

    private void updateResources(Ipt ipt) {
        List resources = this.resourceManager.list(PublicationStatus.REGISTERED);
        if (!resources.isEmpty()) {
            LOG.info("Next, update {} resource registrations...", (Object)resources.size());
            for (Resource resource : resources) {
                try {
                    this.registryManager.updateResource(resource, ipt.getKey().toString());
                }
                catch (IllegalArgumentException e) {
                    LOG.error(e.getMessage());
                }
            }
            LOG.info("Resource registrations updated successfully!");
        }
    }

    public List<Resource> getResources() {
        return this.resources;
    }

    public void setSelectedResources(List<String> selectedResources) {
        this.selectedResources = selectedResources;
    }

    public void setExcludedResources(List<String> excludedResources) {
        this.excludedResources = excludedResources;
    }

    public void setPublishMode(BulkPublicationType publishMode) {
        this.publishMode = publishMode;
    }
}

