/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.ipt.action.admin;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.gbif.ipt.action.BaseAction;
import org.gbif.ipt.action.POSTAction;
import org.gbif.ipt.config.AppConfig;
import org.gbif.ipt.config.ConfigWarnings;
import org.gbif.ipt.model.Extension;
import org.gbif.ipt.model.ExtensionProperty;
import org.gbif.ipt.model.Resource;
import org.gbif.ipt.model.Vocabulary;
import org.gbif.ipt.service.DeletionNotAllowedException;
import org.gbif.ipt.service.InvalidConfigException;
import org.gbif.ipt.service.RegistryException;
import org.gbif.ipt.service.admin.ExtensionManager;
import org.gbif.ipt.service.admin.RegistrationManager;
import org.gbif.ipt.service.admin.VocabulariesManager;
import org.gbif.ipt.service.manage.ResourceManager;
import org.gbif.ipt.service.registry.RegistryManager;
import org.gbif.ipt.struts2.SimpleTextProvider;

public class ExtensionsAction
extends POSTAction {
    private static final Logger LOG = LogManager.getLogger(ExtensionsAction.class);
    private final ExtensionManager extensionManager;
    private final VocabulariesManager vocabManager;
    private final RegistryManager registryManager;
    private List<Extension> latestExtensionVersions;
    private List<Extension> extensions;
    private List<Vocabulary> vocabularies;
    private Map<String, List<ExtensionProperty>> propertiesByGroup = new HashMap();
    private Extension extension;
    private String url;
    private Boolean synchronise = false;
    private Date lastSynchronised;
    private List<Extension> newExtensions;
    private ConfigWarnings configWarnings;
    private ResourceManager resourceManager;
    private boolean upToDate = true;

    @Inject
    public ExtensionsAction(SimpleTextProvider textProvider, AppConfig cfg, RegistrationManager registrationManager, ExtensionManager extensionManager, VocabulariesManager vocabManager, RegistryManager registryManager, ConfigWarnings configWarnings, ResourceManager resourceManager) {
        super(textProvider, cfg, registrationManager);
        this.extensionManager = extensionManager;
        this.vocabManager = vocabManager;
        this.registryManager = registryManager;
        this.configWarnings = configWarnings;
        this.resourceManager = resourceManager;
    }

    public String delete() throws Exception {
        try {
            for (Resource r : this.resourceManager.list()) {
                if (r.getMappings(this.id).isEmpty()) continue;
                LOG.warn("Extension mapped in resource {}", (Object)r.getShortname());
                String msg = this.getText("admin.extension.delete.error.mapped", new String[]{r.getShortname()});
                throw new DeletionNotAllowedException(DeletionNotAllowedException.Reason.EXTENSION_MAPPED, msg);
            }
            this.extensionManager.uninstallSafely(this.id);
            this.addActionMessage(this.getText("admin.extension.delete.success", new String[]{this.id}));
        }
        catch (DeletionNotAllowedException e) {
            this.addActionWarning(this.getText("admin.extension.delete.error", new String[]{this.id}));
            this.addActionExceptionWarning((Exception)((Object)e));
        }
        return "success";
    }

    public String update() throws Exception {
        try {
            LOG.info("Updating extension {} to latest version...", (Object)this.id);
            Extension installed = this.extensionManager.get(this.id);
            Extension latestVersion = this.extensionManager.update(this.id);
            if (installed != null && latestVersion != null && latestVersion.getUrl() != null) {
                ArrayList<Resource> resourcesToMigrate = new ArrayList<Resource>();
                for (Resource r : this.resourceManager.list()) {
                    if (r.getMappings(this.id).isEmpty()) continue;
                    resourcesToMigrate.add(r);
                }
                if (!resourcesToMigrate.isEmpty()) {
                    for (Resource r : resourcesToMigrate) {
                        LOG.info("Updating {} mappings for resource: {}...", (Object)this.id, (Object)r.getTitleAndShortname());
                        this.extensionManager.migrateResourceToNewExtensionVersion(r, installed, latestVersion);
                        this.resourceManager.save(r);
                        LOG.info("Updated {} mappings successfully for resource: {}", (Object)this.id, (Object)r.getTitleAndShortname());
                    }
                }
            }
            this.addActionMessage(this.getText("admin.extension.update.success", new String[]{this.id}));
        }
        catch (Exception e) {
            LOG.error((Object)e);
            this.addActionWarning(this.getText("admin.extension.update.error", new String[]{e.getMessage()}), e);
        }
        return "success";
    }

    public Extension getExtension() {
        return this.extension;
    }

    public List<Extension> getExtensions() {
        return this.extensions;
    }

    public List<Vocabulary> getVocabularies() {
        return this.vocabularies;
    }

    public List<Extension> getNewExtensions() {
        return this.newExtensions;
    }

    public String list() {
        if (this.synchronise.booleanValue()) {
            try {
                this.synchronise();
                this.addActionMessage(this.getText("admin.extensions.synchronise.success"));
            }
            catch (Exception e) {
                String errorMsg = e.getMessage();
                if (e instanceof RegistryException) {
                    errorMsg = RegistryException.logRegistryException((RegistryException)((RegistryException)((Object)e)), (BaseAction)this);
                }
                this.addActionWarning(this.getText("admin.extensions.synchronise.error", new String[]{errorMsg}));
                LOG.error((Object)e);
            }
        }
        this.extensions = this.extensionManager.list();
        this.extensions.sort(Comparator.comparing(Extension::getTitle));
        this.vocabularies = this.vocabManager.list();
        this.vocabularies.sort(Comparator.comparing(Vocabulary::getTitle));
        this.updateIsLatest(this.extensions);
        this.updateIsLatestVocabularies(this.vocabularies);
        this.newExtensions = this.getLatestExtensionVersions();
        for (Extension e : this.extensions) {
            this.newExtensions.remove(e);
        }
        this.newExtensions.sort(Comparator.comparing(Extension::getTitle));
        for (Extension ex : this.extensions) {
            if (this.lastSynchronised != null && !this.lastSynchronised.before(ex.getModified())) continue;
            this.lastSynchronised = ex.getModified();
        }
        return "success";
    }

    public void prepare() {
        super.prepare();
        this.loadLatestExtensionVersions();
        this.vocabManager.load();
        if (this.id != null) {
            this.extension = this.extensionManager.get(this.id);
            if (this.extension == null) {
                this.notFound = true;
            } else {
                this.propertiesByGroup = this.extension.getProperties().stream().collect(Collectors.groupingBy(prop -> StringUtils.trimToEmpty((String)prop.getGroup())));
            }
        }
    }

    public Map<String, List<ExtensionProperty>> getPropertiesByGroup() {
        return this.propertiesByGroup;
    }

    protected void updateIsLatest(List<Extension> extensions) {
        if (!extensions.isEmpty()) {
            try {
                List registered = this.registryManager.getExtensions();
                block2: for (Extension extension : extensions) {
                    extension.setLatest(true);
                    for (Extension rExtension : registered) {
                        if (!rExtension.isLatest() || !extension.getRowType().equalsIgnoreCase(rExtension.getRowType())) continue;
                        Date issuedOne = extension.getIssued();
                        Date issuedTwo = rExtension.getIssued();
                        if (issuedOne == null && issuedTwo != null) {
                            this.setUpToDate(false);
                            extension.setLatest(false);
                            LOG.debug("Installed extension with rowType {} has no issued date. A newer version issued {} exists.", (Object)extension.getRowType(), (Object)issuedTwo);
                            continue block2;
                        }
                        if (issuedTwo != null && issuedTwo.compareTo(issuedOne) > 0) {
                            this.setUpToDate(false);
                            extension.setLatest(false);
                            LOG.debug("Installed extension with rowType {} was issued {}. A newer version issued {} exists.", (Object)extension.getRowType(), (Object)issuedOne, (Object)issuedTwo);
                            continue block2;
                        }
                        LOG.debug("Installed extension with rowType {} is the latest version", (Object)extension.getRowType());
                        continue block2;
                    }
                }
            }
            catch (RegistryException e) {
                String msg = RegistryException.logRegistryException((RegistryException)e, (BaseAction)this);
                this.configWarnings.addStartupError(msg);
                LOG.error(msg);
                msg = this.getText("admin.extensions.couldnt.load", new String[]{this.cfg.getRegistryUrl()});
                this.configWarnings.addStartupError(msg);
                LOG.error(msg);
            }
        }
    }

    protected void updateIsLatestVocabularies(List<Vocabulary> vocabularies) {
        if (!vocabularies.isEmpty()) {
            try {
                List registered = this.registryManager.getVocabularies();
                block2: for (Vocabulary vocabulary : vocabularies) {
                    vocabulary.setLatest(true);
                    for (Vocabulary rVocabulary : registered) {
                        if (!rVocabulary.isLatest() || !vocabulary.getUriString().equalsIgnoreCase(rVocabulary.getUriString())) continue;
                        Date issuedOne = vocabulary.getIssued();
                        Date issuedTwo = rVocabulary.getIssued();
                        if (issuedOne == null && issuedTwo != null) {
                            this.setUpToDate(false);
                            vocabulary.setLatest(false);
                            LOG.debug("Installed vocabulary {} has no issued date. A newer version issued {} exists.", (Object)vocabulary.getUriString(), (Object)issuedTwo);
                            continue block2;
                        }
                        if (issuedTwo != null && issuedTwo.compareTo(issuedOne) > 0) {
                            this.setUpToDate(false);
                            vocabulary.setLatest(false);
                            LOG.debug("Installed vocabulary {} was issued {}. A newer version issued {} exists.", (Object)vocabulary.getUriString(), (Object)issuedOne, (Object)issuedTwo);
                            continue block2;
                        }
                        LOG.debug("Installed vocabulary {} is the latest version", (Object)vocabulary.getUriString());
                        continue block2;
                    }
                }
            }
            catch (RegistryException e) {
                String msg = RegistryException.logRegistryException((RegistryException)e, (BaseAction)this);
                this.configWarnings.addStartupError(msg);
                LOG.error(msg);
                msg = this.getText("admin.extensions.vocabularies.couldnt.load", new String[]{this.cfg.getRegistryUrl()});
                this.configWarnings.addStartupError(msg);
                LOG.error(msg);
            }
        }
    }

    private void loadLatestExtensionVersions() {
        try {
            List all = this.registryManager.getExtensions();
            if (!all.isEmpty()) {
                this.setLatestExtensionVersions(this.getLatestVersions(all));
            }
        }
        catch (RegistryException e) {
            String msg = RegistryException.logRegistryException((RegistryException)e, (BaseAction)this);
            this.configWarnings.addStartupError(msg);
            LOG.error(msg);
            msg = this.getText("admin.extensions.couldnt.load", new String[]{this.cfg.getRegistryUrl()});
            this.configWarnings.addStartupError(msg);
            LOG.error(msg);
        }
        finally {
            if (this.getLatestExtensionVersions() == null) {
                this.setLatestExtensionVersions(new ArrayList());
            }
        }
    }

    protected List<Extension> getLatestVersions(List<Extension> extensions) {
        List sorted = extensions.stream().sorted(Comparator.comparing(Extension::getIssued, Comparator.nullsLast(Comparator.reverseOrder()))).collect(Collectors.toList());
        HashMap<String, Extension> extensionsByRowtype = new HashMap<String, Extension>();
        if (!sorted.isEmpty()) {
            for (Extension extension : sorted) {
                String rowType = extension.getRowType();
                if (rowType == null || extensionsByRowtype.containsKey(rowType)) continue;
                extensionsByRowtype.put(rowType, extension);
            }
        }
        return new ArrayList<Extension>(extensionsByRowtype.values());
    }

    public String save() {
        try {
            this.extensionManager.install(new URL(this.url));
            this.addActionMessage(this.getText("admin.extension.install.success", new String[]{this.url}));
        }
        catch (Exception e) {
            LOG.error((Object)e);
            this.addActionWarning(this.getText("admin.extension.install.error", new String[]{this.url}), e);
        }
        return "success";
    }

    private void synchronise() throws IOException, RegistryException, InvalidConfigException {
        LOG.info("Update default vocabularies to use latest versions...");
        this.vocabManager.installOrUpdateDefaults();
        LOG.info("Updating content of all installed vocabularies...");
        this.vocabManager.updateIfChanged();
        LOG.info("Updating content of all installed extensions...");
        this.extensionManager.updateIfChanged();
    }

    public void setExtension(Extension extension) {
        this.extension = extension;
    }

    public boolean getSynchronise() {
        return this.synchronise;
    }

    public void setSynchronise(String synchronise) {
        this.synchronise = StringUtils.trimToNull((String)synchronise) != null;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public List<Extension> getLatestExtensionVersions() {
        return this.latestExtensionVersions;
    }

    public void setLatestExtensionVersions(List<Extension> latestExtensionVersions) {
        this.latestExtensionVersions = latestExtensionVersions;
    }

    public boolean isUpToDate() {
        return this.upToDate;
    }

    public void setUpToDate(boolean upToDate) {
        this.upToDate = upToDate;
    }

    public Date getLastSynchronised() {
        return this.lastSynchronised;
    }
}

