/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.ipt.action.admin;

import java.math.BigDecimal;
import javax.inject.Inject;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.gbif.ipt.action.POSTAction;
import org.gbif.ipt.config.AppConfig;
import org.gbif.ipt.model.Resource;
import org.gbif.ipt.service.admin.RegistrationManager;
import org.gbif.ipt.service.manage.ResourceManager;
import org.gbif.ipt.struts2.SimpleTextProvider;

public class DeleteVersionAction
extends POSTAction {
    private static final Logger LOG = LogManager.getLogger(DeleteVersionAction.class);
    protected final ResourceManager resourceManager;
    protected Resource resource;
    protected String version;

    @Inject
    public DeleteVersionAction(SimpleTextProvider textProvider, AppConfig cfg, RegistrationManager registrationManager, ResourceManager resourceManager) {
        super(textProvider, cfg, registrationManager);
        this.resourceManager = resourceManager;
    }

    public void prepare() {
        super.prepare();
        String res = StringUtils.trimToNull((String)this.req.getParameter("r"));
        this.resource = this.resourceManager.get(res);
        if (this.resource == null) {
            this.notFound = true;
        }
        this.version = StringUtils.trimToNull((String)this.req.getParameter("v"));
        if (this.version == null) {
            this.notFound = true;
        }
    }

    public String execute() {
        this.resourceManager.removeVersion(this.resource, new BigDecimal(this.version));
        return "success";
    }
}

