/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.ipt.action.admin;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.gbif.ipt.action.POSTAction;
import org.gbif.ipt.config.AppConfig;
import org.gbif.ipt.model.Resource;
import org.gbif.ipt.model.voc.PublicationStatus;
import org.gbif.ipt.service.InvalidConfigException;
import org.gbif.ipt.service.admin.ConfigManager;
import org.gbif.ipt.service.admin.RegistrationManager;
import org.gbif.ipt.service.manage.ResourceManager;
import org.gbif.ipt.struts2.SimpleTextProvider;
import org.gbif.ipt.utils.URLUtils;

public class ConfigAction
extends POSTAction {
    private static final Logger LOG = LogManager.getLogger(ConfigAction.class);
    private static final long serialVersionUID = 4726973323043063968L;
    protected ConfigManager configManager;
    private final ResourceManager resourceManager;
    private static final Map<String, String> DEFAULT_LOCALES = new HashMap();
    protected String baseUrl;
    protected String proxy;
    protected String logoRedirectUrl;
    protected Boolean debug;
    protected String analyticsKey;
    protected String adminEmail;
    protected Double latitude;
    protected Double longitude;
    protected Boolean archivalMode;
    protected Integer archivalLimit;
    protected String defaultLocale;

    @Inject
    public ConfigAction(SimpleTextProvider textProvider, AppConfig cfg, RegistrationManager registrationManager, ConfigManager configManager, ResourceManager resourceManager) {
        super(textProvider, cfg, registrationManager);
        this.configManager = configManager;
        this.resourceManager = resourceManager;
    }

    public String getAnalyticsKey() {
        return this.cfg.getAnalyticsKey();
    }

    public String getAdminEmail() {
        return this.cfg.getAdminEmail();
    }

    public String getBaseUrl() {
        return this.cfg.getBaseUrl();
    }

    public String getLogoRedirectUrl() {
        return this.cfg.getLogoRedirectUrl();
    }

    public String getDataDir() {
        return this.cfg.getDataDir().dataFile("").getAbsolutePath();
    }

    public Boolean getDebug() {
        return this.cfg.debug();
    }

    public Double getLatitude() {
        return this.cfg.getLatitude();
    }

    public String getLogDir() {
        return this.cfg.getDataDir().loggingDir().getAbsolutePath();
    }

    public Double getLongitude() {
        return this.cfg.getLongitude();
    }

    public String getProxy() {
        return this.cfg.getProxy();
    }

    public String getRegistryUrl() {
        return this.cfg.getRegistryUrl();
    }

    public Boolean getArchivalMode() {
        return this.cfg.isArchivalMode();
    }

    public Integer getArchivalLimit() {
        return this.cfg.getArchivalLimit();
    }

    public String getDefaultLocale() {
        return this.cfg.getDefaultLocale();
    }

    public Map<String, String> getDefaultLocales() {
        return DEFAULT_LOCALES;
    }

    public String save() {
        LOG.info("Changing the IPT configuration");
        boolean baseUrlChanged = false;
        if (!this.stringEquals((Object)this.baseUrl, (Object)this.cfg.getBaseUrl())) {
            LOG.info("Changing the installation baseURL from [" + this.cfg.getBaseUrl() + "] to [" + this.baseUrl + "]");
            try {
                URL burl = new URL(this.baseUrl);
                this.configManager.setBaseUrl(burl);
                this.updateAllAlternateIdentifiersForIPTURLToResource();
                LOG.info("Installation baseURL successfully changed to[" + this.baseUrl + "]");
                this.addActionMessage(this.getText("admin.config.baseUrl.changed"));
                this.addActionMessage(this.getText("admin.user.login"));
                this.addActionMessage(this.getText("admin.config.baseUrl.changed.reminder"));
                this.session.remove("curr_user");
                if (URLUtils.isLocalhost((URL)burl)) {
                    this.addActionWarning(this.getText("admin.config.error.localhostURL"));
                } else if (URLUtils.isHostName((URL)burl)) {
                    LOG.info("Machine name used in base URL");
                    this.addActionWarning(this.getText("admin.config.baseUrl.sameHostName"));
                }
                baseUrlChanged = true;
            }
            catch (MalformedURLException e) {
                this.addActionError(this.getText("admin.config.error.invalidBaseURL"));
                return "input";
            }
            catch (InvalidConfigException e) {
                if (e.getType() == InvalidConfigException.TYPE.INVALID_BASE_URL) {
                    this.addActionError(this.getText("admin.config.baseUrl.invalidBaseURL") + " " + this.baseUrl);
                } else if (e.getType() == InvalidConfigException.TYPE.INACCESSIBLE_BASE_URL) {
                    this.addActionError(this.getText("admin.config.baseUrl.inaccessible") + " " + this.baseUrl);
                } else {
                    this.addActionError(this.getText("admin.error.invalidConfiguration", new String[]{e.getMessage()}));
                }
                return "input";
            }
        }
        try {
            this.configManager.setAdminEmail(this.adminEmail);
        }
        catch (InvalidConfigException e) {
            this.addActionError(this.getText(e.getMessage()) + " " + this.adminEmail);
            return "input";
        }
        try {
            this.configManager.setProxy(this.proxy);
        }
        catch (InvalidConfigException e) {
            this.addActionError(this.getText(e.getMessage()) + " " + this.proxy);
            return "input";
        }
        try {
            this.configManager.setLogoRedirectUrl(this.logoRedirectUrl);
        }
        catch (InvalidConfigException e) {
            this.addActionError(this.getText(e.getMessage()) + " " + this.logoRedirectUrl);
            return "input";
        }
        if (this.debug != null) {
            try {
                this.configManager.setDebugMode(this.debug.booleanValue());
            }
            catch (InvalidConfigException e) {
                this.addActionError(this.getText("admin.config.debug.error"));
                return "input";
            }
        }
        if (this.archivalMode != null) {
            try {
                this.configManager.setArchivalMode(this.archivalMode.booleanValue());
            }
            catch (InvalidConfigException e) {
                if (e.getType() == InvalidConfigException.TYPE.DOI_REGISTRATION_ALREADY_ACTIVATED) {
                    this.addActionError(this.getText("admin.error.invalidConfiguration.doiAccount.activated"));
                } else {
                    this.addActionError(this.getText("admin.config.archivalMode.error"));
                }
                return "input";
            }
        }
        try {
            this.configManager.setArchivalLimit(this.archivalLimit);
        }
        catch (InvalidConfigException e) {
            this.addActionError(this.getText("admin.config.archivalLimit.error"));
            return "input";
        }
        if (this.analyticsKey != null) {
            try {
                this.configManager.setAnalyticsKey(this.analyticsKey);
            }
            catch (InvalidConfigException e) {
                this.addActionError(this.getText("admin.config.analyticsKey.error"));
                return "input";
            }
        }
        try {
            this.configManager.setIptLocation(this.latitude, this.longitude);
        }
        catch (InvalidConfigException e) {
            this.addActionError(this.getText("admin.config.server.location.error"));
            return "input";
        }
        try {
            this.configManager.setDefaultLocale(this.defaultLocale);
        }
        catch (InvalidConfigException e) {
            this.addActionWarning(this.getText("admin.config.defaultLocale.error"));
            return "input";
        }
        try {
            this.configManager.saveConfig();
        }
        catch (InvalidConfigException e) {
            LOG.error("couldnt write config settings", (Throwable)e);
            this.addActionError(this.getText("admin.config.save.error"));
            return "input";
        }
        if (baseUrlChanged) {
            return "home";
        }
        this.addActionMessage(this.getText("admin.config.success"));
        return "success";
    }

    public void setAnalyticsKey(String analyticsKey) {
        this.analyticsKey = analyticsKey;
    }

    public void setAdminEmail(String adminEmail) {
        this.adminEmail = adminEmail;
    }

    public void setBaseUrl(String baseUrl) {
        this.baseUrl = baseUrl;
    }

    public void setLogoRedirectUrl(String logoRedirectUrl) {
        this.logoRedirectUrl = logoRedirectUrl;
    }

    public void setDebug(Boolean debug) {
        this.debug = debug;
    }

    public void setLatitude(Double latitude) {
        this.latitude = latitude;
    }

    public void setLongitude(Double longitude) {
        this.longitude = longitude;
    }

    public void setProxy(String proxy) {
        this.proxy = StringUtils.trimToNull((String)proxy);
    }

    public void setArchivalMode(Boolean archivalMode) {
        this.archivalMode = archivalMode;
    }

    public void setArchivalLimit(Integer archivalLimit) {
        this.archivalLimit = archivalLimit;
    }

    public void setDefaultLocale(String defaultLocale) {
        this.defaultLocale = defaultLocale;
    }

    private void updateAllAlternateIdentifiersForIPTURLToResource() {
        List resources = this.resourceManager.list(PublicationStatus.PUBLIC);
        resources.addAll(this.resourceManager.list(PublicationStatus.REGISTERED));
        if (!resources.isEmpty()) {
            LOG.debug("Updating all public resources' IPT URL to resource alternate identifier");
        }
        for (Resource resource : resources) {
            this.resourceManager.updateAlternateIdentifierForIPTURLToResource(resource);
        }
    }

    static {
        DEFAULT_LOCALES.put("en", "English");
        DEFAULT_LOCALES.put("fr", "Fran\u00e7aise");
        DEFAULT_LOCALES.put("es", "Espa\u00f1ol");
        DEFAULT_LOCALES.put("zh", "\u7e41\u9ad4\u4e2d\u6587");
        DEFAULT_LOCALES.put("pt", "Portugu\u00eas");
        DEFAULT_LOCALES.put("ja", "\u65e5\u672c\u8a9e");
        DEFAULT_LOCALES.put("ru", "\u0420\u0443\u0441\u0441\u043a\u0438\u0439");
    }
}

