/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.ipt.action;

import java.io.IOException;
import java.util.List;
import javax.inject.Inject;
import javax.servlet.http.Cookie;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.gbif.ipt.action.POSTAction;
import org.gbif.ipt.config.AppConfig;
import org.gbif.ipt.model.User;
import org.gbif.ipt.service.admin.RegistrationManager;
import org.gbif.ipt.service.admin.UserAccountManager;
import org.gbif.ipt.struts2.SimpleTextProvider;

public class LoginAction
extends POSTAction {
    private static final Logger LOG = LogManager.getLogger(LoginAction.class);
    private static final long serialVersionUID = -863287752175768744L;
    private final UserAccountManager userManager;
    private String redirectUrl;
    private String email;
    private String password;
    private String adminEmail;
    private String csrfToken;

    @Inject
    public LoginAction(SimpleTextProvider textProvider, AppConfig cfg, RegistrationManager registrationManager, UserAccountManager userManager) {
        super(textProvider, cfg, registrationManager);
        this.userManager = userManager;
    }

    public void prepare() {
        super.prepare();
        this.adminEmail = this.userManager.getDefaultAdminEmail();
        if (StringUtils.isBlank((CharSequence)this.adminEmail)) {
            List users = this.userManager.list(User.Role.Admin);
            if (!users.isEmpty()) {
                this.adminEmail = ((User)users.get(0)).getEmail();
            } else {
                LOG.error("Failed to load the default admin email");
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public String login() throws IOException {
        Cookie csrfCookie = this.getCookie("CSRFtoken");
        if (this.session.get("curr_user") != null) {
            return "success";
        }
        if (this.email == null) return "input";
        if (StringUtils.isBlank((CharSequence)this.csrfToken)) return "input";
        if (csrfCookie == null) return "input";
        if (!this.csrfToken.equals(csrfCookie.getValue())) {
            LOG.warn("CSRF login token wrong! A potential malicious attack.");
            return "input";
        }
        User authUser = this.userManager.authenticate(this.email.trim(), this.password.trim());
        if (authUser == null) {
            this.addActionError(this.getText("admin.user.wrong.email.password.combination"));
            LOG.info("User {} failed to log in", (Object)this.email);
            return "input";
        }
        LOG.info("User {} logged in successfully", (Object)this.email);
        authUser.setLastLoginToNow();
        this.userManager.save();
        this.session.put("curr_user", authUser);
        int sessionTimeout = this.cfg.getSessionTimeout();
        LOG.debug("Setting session timeout to {} seconds", (Object)sessionTimeout);
        this.req.getSession().setMaxInactiveInterval(sessionTimeout);
        this.setRedirectUrl();
        return "success";
    }

    public String logout() {
        this.redirectUrl = this.getBase() + "/";
        this.session.clear();
        return "success";
    }

    private void setRedirectUrl() {
        this.redirectUrl = this.getBase() + "/";
        String referer = (String)this.session.get("referer");
        LOG.debug("Session's referer: {}", (Object)referer);
        if (StringUtils.isNotEmpty((CharSequence)referer) && !referer.endsWith("login.do") && !referer.endsWith("login")) {
            this.redirectUrl = this.getBase() + referer;
        }
        this.session.remove("referer");
        LOG.info("Redirecting to {}", (Object)this.redirectUrl);
    }

    public String getRedirectUrl() {
        return this.redirectUrl;
    }

    public void setRedirectUrl(String redirectUrl) {
        this.redirectUrl = redirectUrl;
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getAdminEmail() {
        return this.adminEmail;
    }

    public void setAdminEmail(String adminEmail) {
        this.adminEmail = adminEmail;
    }

    public void setCsrfToken(String csrfToken) {
        this.csrfToken = csrfToken;
    }
}

