/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.ipt.action;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import javax.inject.Inject;
import org.apache.commons.io.FileUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.struts2.ServletActionContext;
import org.apache.struts2.json.annotations.JSON;
import org.gbif.ipt.action.BaseAction;
import org.gbif.ipt.action.HealthAction;
import org.gbif.ipt.config.AppConfig;
import org.gbif.ipt.config.DataDir;
import org.gbif.ipt.service.admin.RegistrationManager;
import org.gbif.ipt.struts2.SimpleTextProvider;
import org.gbif.utils.ExtendedResponse;
import org.gbif.utils.HttpClient;

public class HealthAction
extends BaseAction {
    private static final Logger LOG = LogManager.getLogger(HealthAction.class);
    private DataDir dataDir;
    private final HttpClient http;
    public Status status;
    public String networkRegistryURL = "";
    public boolean networkRegistry = false;
    public String networkRepositoryURL = "http://rs.gbif.org";
    public boolean networkRepository = false;
    public String networkPublicAccessURL = "";
    public String networkCheckPublicAccessURL = "https://tools.gbif.org/ws-validurl/?url=";
    public boolean networkPublicAccess = false;
    public long diskTotal = 0L;
    public long diskUsed = 0L;
    public long diskFree = 0L;
    public int diskUsedRatio = 0;
    public boolean readConfigDir = false;
    public boolean readLogDir = false;
    public boolean writeLogDir = false;
    public boolean readTmpDir = false;
    public boolean writeTmpDir = false;
    public boolean readResourcesDir = false;
    public boolean writeResourcesDir = false;
    public boolean readSubResourcesDir = false;
    public boolean writeSubResourcesDir = false;
    public String hrDiskTotal = "";
    public String hrDiskUsed = "";
    public String hrDiskFree = "";
    public String osName = "";
    public String osVersion = "";
    public String javaVersion = "";
    public String appServerVersion = "";
    public String iptMode = "";

    @Inject
    public HealthAction(SimpleTextProvider textProvider, AppConfig cfg, HttpClient client, RegistrationManager registrationManager, DataDir dataDir) {
        super(textProvider, cfg, registrationManager);
        this.dataDir = dataDir;
        this.http = client;
    }

    public void prepare() {
        ExtendedResponse resp3;
        super.prepare();
        try {
            this.networkRegistryURL = this.cfg.getRegistryUrl();
            resp3 = this.http.get(this.networkRegistryURL);
            if (resp3 != null && resp3.getStatusCode() == 200) {
                this.networkRegistry = true;
            }
        }
        catch (Exception resp2) {
            // empty catch block
        }
        try {
            resp3 = this.http.get(this.networkRepositoryURL);
            if (resp3 != null && resp3.getStatusCode() == 200) {
                this.networkRepository = true;
            }
        }
        catch (Exception resp3) {
            // empty catch block
        }
        try {
            JsonObject jsonObject;
            JsonElement success;
            this.networkPublicAccessURL = this.cfg.getBaseUrl();
            resp3 = this.http.get(this.networkCheckPublicAccessURL + this.networkPublicAccessURL);
            if (resp3 != null && resp3.getStatusCode() == 200 && (success = (jsonObject = new JsonParser().parse(resp3.getContent()).getAsJsonObject()).get("success")) != null && success.getAsBoolean()) {
                this.networkPublicAccess = true;
            }
        }
        catch (Exception resp4) {
            // empty catch block
        }
        this.diskTotal = this.dataDir.getDataDirTotalSpace();
        this.diskFree = this.dataDir.getDataDirUsableSpace();
        this.diskUsed = this.diskTotal - this.diskFree;
        this.diskUsedRatio = (int)(100L * this.diskUsed / this.diskTotal);
        this.hrDiskTotal = FileUtils.byteCountToDisplaySize((long)this.diskTotal);
        this.hrDiskUsed = FileUtils.byteCountToDisplaySize((long)this.diskUsed);
        this.hrDiskFree = FileUtils.byteCountToDisplaySize((long)this.diskFree);
        DataDir.DirStatus configDirStatus = this.dataDir.getDirectoryReadWriteStatus(this.dataDir.configDir());
        this.readConfigDir = configDirStatus == DataDir.DirStatus.READ_ONLY || configDirStatus == DataDir.DirStatus.READ_WRITE;
        DataDir.DirStatus logDirStatus = this.dataDir.getDirectoryReadWriteStatus(this.dataDir.loggingDir());
        this.readLogDir = logDirStatus == DataDir.DirStatus.READ_ONLY || logDirStatus == DataDir.DirStatus.READ_WRITE;
        this.writeLogDir = logDirStatus == DataDir.DirStatus.READ_WRITE;
        DataDir.DirStatus tmpDirStatus = this.dataDir.getDirectoryReadWriteStatus(this.dataDir.tmpRootDir());
        this.readTmpDir = tmpDirStatus == DataDir.DirStatus.READ_ONLY || tmpDirStatus == DataDir.DirStatus.READ_WRITE;
        this.writeTmpDir = tmpDirStatus == DataDir.DirStatus.READ_WRITE;
        DataDir.DirStatus resourcesDirStatus = this.dataDir.getDirectoryReadWriteStatus(this.dataDir.resourcesDir());
        this.readResourcesDir = resourcesDirStatus == DataDir.DirStatus.READ_ONLY || resourcesDirStatus == DataDir.DirStatus.READ_WRITE;
        this.writeResourcesDir = resourcesDirStatus == DataDir.DirStatus.READ_WRITE;
        DataDir.DirStatus subResourcesDirStatus = this.dataDir.getSubDirectoriesReadWriteStatus(this.dataDir.resourcesDir());
        this.readSubResourcesDir = subResourcesDirStatus == DataDir.DirStatus.READ_ONLY || subResourcesDirStatus == DataDir.DirStatus.READ_WRITE;
        this.writeSubResourcesDir = subResourcesDirStatus == DataDir.DirStatus.READ_WRITE;
        this.osName = System.getProperty("os.name");
        this.osVersion = System.getProperty("os.version");
        this.javaVersion = Runtime.class.getPackage().getImplementationVersion();
        if (this.javaVersion == null) {
            this.javaVersion = System.getProperty("java.version");
        }
        this.appServerVersion = ServletActionContext.getServletContext().getServerInfo();
        this.iptMode = this.cfg != null && this.cfg.getRegistryType() != null ? this.cfg.getRegistryType().name() : "";
    }

    public String execute() {
        this.status = new Status();
        this.status.setNetworkRegistryURL(this.networkRegistryURL);
        this.status.setNetworkRegistry(this.networkRegistry);
        this.status.setNetworkRepositoryURL(this.networkRepositoryURL);
        this.status.setNetworkRepository(this.networkRepository);
        this.status.setNetworkPublicAccessURL(this.networkPublicAccessURL);
        this.status.setNetworkPublicAccess(this.networkPublicAccess);
        this.status.setDiskTotal(this.diskTotal);
        this.status.setDiskUsed(this.diskUsed);
        this.status.setDiskFree(this.diskFree);
        this.status.setDiskUsedRatio(this.diskUsedRatio);
        this.status.setReadConfigDir(this.readConfigDir);
        this.status.setReadLogDir(this.readLogDir);
        this.status.setWriteLogDir(this.writeLogDir);
        this.status.setReadTmpDir(this.readTmpDir);
        this.status.setWriteTmpDir(this.writeTmpDir);
        this.status.setReadResourcesDir(this.readResourcesDir);
        this.status.setWriteResourcesDir(this.writeResourcesDir);
        this.status.setReadSubResourcesDir(this.readSubResourcesDir);
        this.status.setWriteSubResourcesDir(this.writeSubResourcesDir);
        return "success";
    }

    @JSON(name="status")
    public Status getStatus() {
        return this.status;
    }
}

