    <#include "/WEB-INF/pages/inc/header.ftl">
    <title><@s.text name='manage.datapackagemetadata.camtrap.citation.title'/></title>
    <script src="${baseURL}/js/jconfirmation.jquery.js"></script>
    <link rel="stylesheet" href="${baseURL}/styles/select2/select2-4.0.13.min.css">
    <link rel="stylesheet" href="${baseURL}/styles/select2/select2-bootstrap4.min.css">
    <link rel="stylesheet" href="${baseURL}/styles/smaller-inputs.css">
    <script src="${baseURL}/js/select2/select2-4.0.13.min.js"></script>
    <script>
        $(document).ready(function(){
            window.onLoad = populateCitationWithAutoGeneratedCitation();

            function populateCitationWithAutoGeneratedCitation() {
                var isAutoGenerated = ${resource.isCitationAutoGenerated()?c};
                if (isAutoGenerated) {
                    // auto-generated citation string
                    var autoCitation = "${action.resource.generateDataPackageResourceCitation(resource.getNextVersion().toPlainString()?string, cfg.getResourceVersionUri(resource.getShortname(), resource.getNextVersion().toPlainString()?string))!}";
                    $("#metadata\\.bibliographicCitation").val(autoCitation);
                    $('#cit').attr("value", "true");
                    $("#generateOff").show();
                    $("#generateOn").hide();
                }
            }

            $("#generateOn").click(function(event) {
                event.preventDefault();
                // auto-generated citation string
                var autoCitation = "${action.resource.generateDataPackageResourceCitation(resource.getNextVersion().toPlainString()?string, cfg.getResourceVersionUri(resource.getShortname(), resource.getNextVersion().toPlainString()?string))!}";
                $("#metadata\\.bibliographicCitation").val(autoCitation);
                $('#cit').attr("value", "true");
                $("#generateOff").show();
                $("#generateOn").hide();
            });

            $("#generateOff").click(function(event) {
                event.preventDefault();
                $("#metadata\\.bibliographicCitation").val("")
                $('#cit').attr("value", "false");
                $("#generateOn").show();
                $("#generateOff").hide();
            });

            makeSureResourceParameterIsPresentInURL('${resource.shortname}');
        });
    </script>
    <#assign currentMenu="manage"/>
    <#assign currentMetadataPage = "citation"/>
    <#include "/WEB-INF/pages/inc/menu.ftl">
    <#include "/WEB-INF/pages/macros/forms.ftl"/>

    <div class="container px-0">
        <#include "/WEB-INF/pages/inc/action_alerts.ftl">
    </div>

    <form class="needs-validation track-unsaved" action="camtrap-metadata-${section}.do" method="post" novalidate>
        <input type="hidden" name="r" value="${resource.shortname}" />

        <div class="container-fluid bg-body border-bottom">
            <div class="container bg-body border rounded-2 mb-4">
                <div class="container my-3 p-3">
                    <div class="text-center fs-smaller">
                        <div class="text-center fs-smaller">
                            <nav style="--bs-breadcrumb-divider: url(&#34;data:image/svg+xml,%3Csvg xmlns='http://www.w3.org/2000/svg' width='8' height='8'%3E%3Cpath d='M2.5 0L1 1.5 3.5 4 1 6.5 2.5 8l4-4-4-4z' fill='currentColor'/%3E%3C/svg%3E&#34;);" aria-label="breadcrumb">
                                <ol class="breadcrumb justify-content-center mb-0">
                                    <li class="breadcrumb-item"><a href="/manage/"><@s.text name="breadcrumb.manage"/></a></li>
                                    <li class="breadcrumb-item"><a href="resource?r=${resource.shortname}"><@s.text name="breadcrumb.manage.overview"/></a></li>
                                    <li class="breadcrumb-item active" aria-current="page"><@s.text name="breadcrumb.manage.overview.metadata"/></li>
                                </ol>
                            </nav>
                        </div>
                    </div>

                    <div class="text-center">
                        <h1 class="py-2 mb-0 text-gbif-header fs-2 fw-normal">
                            <@s.text name='manage.datapackagemetadata.camtrap.citation.title'/>
                        </h1>
                    </div>

                    <div class="text-center fs-smaller">
                        <a href="resource.do?r=${resource.shortname}" title="${resource.title!resource.shortname}">
                            <#if resource.title?has_content>
                                ${resource.title}
                            <#else>
                                ${resource.shortname}
                            </#if>
                        </a>
                    </div>

                    <div class="text-center mt-2">
                        <@s.submit cssClass="button btn btn-sm btn-outline-gbif-primary top-button" name="save" key="button.save"/>
                        <@s.submit cssClass="button btn btn-sm btn-outline-secondary top-button" name="cancel" key="button.back"/>
                    </div>
                </div>
            </div>
        </div>

        <#--        <#include "metadata_section_select.ftl"/>-->

        <div class="container-fluid bg-body">
            <div class="container bd-layout main-content-container">
                <main class="bd-main bd-main">
                    <div class="bd-toc mt-4 mb-5 ps-3 mb-lg-5 text-muted">
                        <#include "metadata_sidebar.ftl"/>
                    </div>

                    <div class="bd-content">
                        <div class="my-md-3 p-3">
                            <div class="callout callout-info text-smaller">
                                <@s.text name='datapackagemetadata.citation.warning'/>
                            </div>

                            <div class="mt-4 d-flex justify-content-end">
                                <a id="generateOff" class="removeLink metadata-action-link custom-link" <#if resource.citationAutoGenerated?c != "true">style="display: none"</#if> href="">
                                    <span>
                                        <svg viewBox="0 0 24 24" class="link-icon link-icon-primary">
                                            <path d="M12 6v3l4-4-4-4v3c-4.42 0-8 3.58-8 8 0 1.57.46 3.03 1.24 4.26L6.7 14.8c-.45-.83-.7-1.79-.7-2.8 0-3.31 2.69-6 6-6zm6.76 1.74L17.3 9.2c.44.84.7 1.79.7 2.8 0 3.31-2.69 6-6 6v-3l-4 4 4 4v-3c4.42 0 8-3.58 8-8 0-1.57-.46-3.03-1.24-4.26z"></path>
                                        </svg>
                                    </span>
                                    <span><@s.text name='datapackagemetadata.citation.generate.turn.off'/></span>
                                </a>
                                <a id="generateOn" class="removeLink metadata-action-link custom-link" <#if resource.citationAutoGenerated?c == "true">style="display: none"</#if> href="">
                                    <span>
                                        <svg viewBox="0 0 24 24" class="link-icon link-icon-primary">
                                            <path d="M12 6v3l4-4-4-4v3c-4.42 0-8 3.58-8 8 0 1.57.46 3.03 1.24 4.26L6.7 14.8c-.45-.83-.7-1.79-.7-2.8 0-3.31 2.69-6 6-6zm6.76 1.74L17.3 9.2c.44.84.7 1.79.7 2.8 0 3.31-2.69 6-6 6v-3l-4 4 4 4v-3c4.42 0 8-3.58 8-8 0-1.57-.46-3.03-1.24-4.26z"></path>
                                        </svg>
                                    </span>
                                    <span><@s.text name='datapackagemetadata.citation.generate.turn.on'/></span>
                                </a>
                                <input id="cit" name="resource.citationAutoGenerated" type=hidden value="${resource.citationAutoGenerated?c}"/>
                            </div>

                            <div class="row g-3">
                                <div class="col-12">
                                    <@text name="metadata.bibliographicCitation" help="i18n" i18nkey="datapackagemetadata.other.bibliographicCitation" />
                                </div>
                            </div>
                        </div>
                    </div>
                </main>
            </div>
        </div>
    </form>

    <#include "/WEB-INF/pages/manage/eml/unsaved_changes_modal.ftl">

    <#include "/WEB-INF/pages/inc/footer.ftl">
