/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.ipt.validation;

import com.bedatadriven.jackson.datatype.jts.JtsModule;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.gbif.ipt.model.datapackage.metadata.camtrap.Geojson;
import org.gbif.ipt.validation.ValidGeojson;
import org.geojson.GeoJsonObject;

public class ValidGeojsonValidator
implements ConstraintValidator<ValidGeojson, Geojson> {
    private static final Logger LOG = LogManager.getLogger(ValidGeojsonValidator.class);
    private final ObjectMapper objectMapper = new ObjectMapper();

    public ValidGeojsonValidator() {
        this.objectMapper.registerModule((Module)new JtsModule());
    }

    public boolean isValid(Geojson geojson, ConstraintValidatorContext ctx) {
        try {
            String geojsonString = this.objectMapper.writeValueAsString((Object)geojson);
            this.objectMapper.readValue(geojsonString, GeoJsonObject.class);
            return true;
        }
        catch (IOException e) {
            LOG.error("GeoJSON validation failed: {}", (Object)e.getMessage());
            return false;
        }
    }
}

