/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.ipt.validation;

import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.gbif.ipt.action.BaseAction;
import org.gbif.ipt.model.Resource;

public class ResourceValidator {
    private static Pattern shortnamePattern = Pattern.compile("^[a-zA-Z0-9_-]+$");

    public void validate(BaseAction action, Resource resource) {
        if (resource != null) {
            this.validateShortname(action, resource.getShortname());
        }
    }

    public void validateShortname(BaseAction action, String shortname) {
        if (shortname == null) {
            action.addFieldError("resource.shortname", action.getText("validation.resource.shortname.required"));
        } else if (shortname.length() < 3 || !shortnamePattern.matcher(shortname).matches()) {
            action.addFieldError("resource.shortname", action.getText("validation.resource.shortname.invalid"));
        }
    }

    public void validateCreateNew(BaseAction action, String shortname, String resourceType) {
        if (shortname == null) {
            action.addFieldError("resource.shortname", action.getText("validation.resource.shortname.required"));
        } else if (shortname.length() < 3 || !shortnamePattern.matcher(shortname).matches()) {
            action.addFieldError("resource.shortname", action.getText("validation.resource.shortname.invalid"));
        } else if (StringUtils.isEmpty((CharSequence)resourceType)) {
            action.addFieldError("resourceType", action.getText("validation.resource.type.required"));
        }
    }
}

