/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.ipt.validation;

import java.util.Date;
import java.util.UUID;
import javax.inject.Inject;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.gbif.api.model.common.DOI;
import org.gbif.doi.metadata.datacite.DataCiteMetadata;
import org.gbif.doi.service.DoiException;
import org.gbif.doi.service.InvalidMetadataException;
import org.gbif.doi.service.datacite.RestJsonApiDataCiteService;
import org.gbif.ipt.action.BaseAction;
import org.gbif.ipt.config.AppConfig;
import org.gbif.ipt.model.Organisation;
import org.gbif.ipt.model.Resource;
import org.gbif.ipt.model.voc.DOIRegistrationAgency;
import org.gbif.ipt.service.registry.RegistryManager;
import org.gbif.ipt.utils.DOIUtils;
import org.gbif.ipt.utils.DataCiteMetadataBuilder;
import org.gbif.metadata.eml.ipt.model.Agent;

/*
 * Exception performing whole class analysis ignored.
 */
public class OrganisationSupport {
    private static final Logger LOG = LogManager.getLogger(OrganisationSupport.class);
    private RegistryManager registryManager;
    private AppConfig cfg;

    @Inject
    public OrganisationSupport(RegistryManager registryManager, AppConfig cfg) {
        this.registryManager = registryManager;
        this.cfg = cfg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean validate(BaseAction action, Organisation organisation) {
        boolean valid = true;
        if (organisation.getKey() == null || organisation.getKey().toString().length() < 1) {
            valid = false;
            action.addFieldError("organisation.key", action.getText("validation.organisation.key.required"));
        }
        if (StringUtils.trimToNull((String)organisation.getPassword()) == null) {
            valid = false;
            action.addFieldError("organisation.password", action.getText("validation.organisation.password.required"));
        }
        if (organisation.getKey() != null && organisation.getPassword() != null && organisation.getKey().toString().length() > 0 && organisation.getPassword().length() > 0 && !this.registryManager.validateOrganisation(organisation.getKey().toString(), organisation.getPassword())) {
            valid = false;
            action.addFieldError("organisation.password", action.getText("validation.organisation.password.invalid"));
        }
        DOIRegistrationAgency agency = organisation.getDoiRegistrationAgency();
        String agencyUsername = StringUtils.trimToNull((String)organisation.getAgencyAccountUsername());
        String agencyPassword = StringUtils.trimToNull((String)organisation.getAgencyAccountPassword());
        String prefix = StringUtils.trimToNull((String)organisation.getDoiPrefix());
        boolean isAgencyAccountPrimary = organisation.isAgencyAccountPrimary();
        if (agency != null || agencyUsername != null || agencyPassword != null || prefix != null || isAgencyAccountPrimary) {
            if (isAgencyAccountPrimary && !this.cfg.isArchivalMode()) {
                valid = false;
                action.addFieldError("organisation.agencyAccountPrimary", action.getText("admin.organisation.doiAccount.activated.failed"));
            }
            if (agency == null) {
                valid = false;
                action.addFieldError("organisation.doiRegistrationAgency", action.getText("validation.organisation.doiRegistrationAgency.required"));
            }
            if (agencyUsername == null) {
                valid = false;
                action.addFieldError("organisation.agencyAccountUsername", action.getText("validation.organisation.agencyAccountUsername.required"));
            }
            if (agencyPassword == null) {
                valid = false;
                action.addFieldError("organisation.agencyAccountPassword", action.getText("validation.organisation.agencyAccountPassword.required"));
            }
            if (prefix == null) {
                valid = false;
                action.addFieldError("organisation.doiPrefix", action.getText("validation.organisation.doiPrefix.required"));
            } else if (!prefix.startsWith("10.")) {
                valid = false;
                action.addFieldError("organisation.doiPrefix", action.getText("validation.organisation.doiPrefix.invalid"));
            } else if (this.cfg.getRegistryType() == AppConfig.REGISTRY_TYPE.DEVELOPMENT && !"10.21373".equalsIgnoreCase(prefix)) {
                action.addActionWarning(action.getText("validation.organisation.doiPrefix.invalid.testMode"));
            } else if (this.cfg.getRegistryType() == AppConfig.REGISTRY_TYPE.PRODUCTION && "10.21373".equalsIgnoreCase(prefix)) {
                valid = false;
                action.addFieldError("organisation.doiPrefix", action.getText("validation.organisation.doiPrefix.invalid.productionMode"));
            }
            if (valid) {
                RestJsonApiDataCiteService service = new RestJsonApiDataCiteService(this.cfg.getDataCiteUrl(), agencyUsername, agencyPassword);
                try {
                    DOI doi = DOIUtils.mintDOI((DOIRegistrationAgency)agency, (String)prefix);
                    DataCiteMetadata metadata = OrganisationSupport.getTestDataCiteMetadata((DOI)doi);
                    service.reserve(doi, metadata);
                    service.delete(doi);
                }
                catch (DoiException e) {
                    valid = false;
                    String msg = action.getText("validation.organisation.agencyAccount.cantAuthenticate");
                    LOG.error(msg, (Throwable)e);
                    action.addActionError(msg);
                }
                finally {
                    organisation.setAgencyAccountUsername(agencyUsername);
                    organisation.setAgencyAccountPassword(agencyPassword);
                    organisation.setDoiPrefix(prefix);
                }
            } else {
                LOG.debug("Not all DOI Registration agency fields were entered correctly - bypassing DOI Registration Agency validation");
            }
        }
        return valid;
    }

    public void validateOrganisationToken(BaseAction action, UUID organisationKey, String organisationToken) {
        if (organisationKey != null && organisationToken != null && organisationKey.toString().length() > 0 && organisationToken.length() > 0 && !this.registryManager.validateOrganisation(organisationKey.toString(), organisationToken)) {
            action.addFieldError("hostingOrganisationToken", action.getText("validation.organisation.password.invalid"));
        }
    }

    private static DataCiteMetadata getTestDataCiteMetadata(DOI doi) throws InvalidMetadataException {
        Resource testResource = new Resource();
        testResource.getEml().setTitle("Test Resource");
        Agent creator = new Agent();
        creator.setFirstName("John");
        creator.setLastName("Smith");
        testResource.getEml().addCreator(creator);
        Organisation testOrganisation = new Organisation();
        testOrganisation.setKey(UUID.randomUUID().toString());
        testOrganisation.setName("Test Organisation");
        testResource.setOrganisation(testOrganisation);
        testResource.setCoreType("Occurrence");
        testResource.getEml().setDateStamp(new Date());
        return DataCiteMetadataBuilder.createDataCiteMetadata((DOI)doi, (Resource)testResource);
    }
}

