/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.ipt.validation;

import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.List;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.lang3.StringUtils;
import org.gbif.ipt.validation.NotNullLastNameForPeopleContributors;

public class NotNullForPeopleContributorsValidator
implements ConstraintValidator<NotNullLastNameForPeopleContributors, Object> {
    private static final List<String> ROLES = Arrays.asList("contact", "principalInvestigator", "contributor");

    public boolean isValid(Object value, ConstraintValidatorContext ctx) {
        try {
            String roleValue = BeanUtils.getProperty((Object)value, (String)"role");
            String lastName = StringUtils.trimToNull((String)BeanUtils.getProperty((Object)value, (String)"lastName"));
            if ((ROLES.contains(roleValue) || StringUtils.isEmpty((CharSequence)roleValue)) && StringUtils.isEmpty((CharSequence)lastName)) {
                ctx.disableDefaultConstraintViolation();
                ctx.buildConstraintViolationWithTemplate(ctx.getDefaultConstraintMessageTemplate()).addPropertyNode("lastName").addConstraintViolation();
                return false;
            }
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException ex) {
            throw new RuntimeException(ex);
        }
        return true;
    }
}

