/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.ipt.validation;

import org.gbif.ipt.action.BaseAction;
import org.gbif.ipt.model.Ipt;
import org.gbif.ipt.validation.BaseValidator;
import org.gbif.ipt.validation.EmailValidationMessageTranslator;
import org.gbif.ipt.validation.ValidationResult;

public class IptValidator
extends BaseValidator {
    public void validate(BaseAction action, Ipt ipt) {
        this.validateBasic(action, ipt, "ipt");
        if (ipt.getWsPassword() == null || ipt.getWsPassword().length() < 1) {
            action.addFieldError("ipt.wsPassword", action.getText("validation.ipt.password.required"));
        }
        if (ipt.getWsPassword() != null && ipt.getWsPassword().length() < 6) {
            action.addFieldError("ipt.wsPassword", action.getText("validation.ipt.password.short"));
        }
    }

    public void validateIptPassword(BaseAction action, String password) {
        if (password != null && password.length() < 6) {
            action.addFieldError("registeredIptPassword", action.getText("validation.ipt.password.short"));
        }
    }

    public void validateUpdate(BaseAction action, Ipt ipt) {
        this.validateBasic(action, ipt, "registeredIpt");
    }

    private void validateBasic(BaseAction action, Ipt ipt, String fieldPrefix) {
        ValidationResult result;
        if (ipt.getName() == null || ipt.getName().length() < 1) {
            action.addFieldError(fieldPrefix + ".name", action.getText("validation.ipt.name.required"));
        }
        if (ipt.getName() != null && ipt.getName().length() < 3) {
            action.addFieldError(fieldPrefix + ".name", action.getText("validation.ipt.name.short"));
        }
        if (ipt.getDescription() == null || ipt.getDescription().length() < 1) {
            action.addFieldError(fieldPrefix + ".description", action.getText("validation.required", new String[]{action.getText("basic.description")}));
        }
        if (ipt.getPrimaryContactName() == null || ipt.getPrimaryContactName().length() < 1) {
            action.addFieldError(fieldPrefix + ".primaryContactName", action.getText("validation.ipt.contactName.required"));
        }
        if (ipt.getPrimaryContactEmail() == null || ipt.getPrimaryContactEmail().length() < 1) {
            action.addFieldError(fieldPrefix + ".primaryContactEmail", action.getText("validation.ipt.contactEmail.required"));
        }
        if (ipt.getPrimaryContactEmail() != null && ipt.getPrimaryContactEmail().length() < 6) {
            action.addFieldError(fieldPrefix + ".primaryContactEmail", action.getText("validation.ipt.contactEmail.short"));
        }
        if (!(result = this.checkEmailValid(ipt.getPrimaryContactEmail())).isValid()) {
            action.addFieldError(fieldPrefix + ".primaryContactEmail", action.getText(EmailValidationMessageTranslator.EMAIL_ERROR_TRANSLATIONS.getOrDefault(result.getMessage(), "validation.ipt.contactEmail.invalid")));
        }
    }
}

