/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.ipt.validation;

import java.util.List;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import org.apache.commons.lang3.StringUtils;
import org.gbif.ipt.model.datapackage.metadata.License;
import org.gbif.ipt.model.datapackage.metadata.camtrap.CamtrapLicense;
import org.gbif.ipt.validation.HasOpenDefinitionCompatibleLicense;

public class HasOpenDefinitionCompatibleLicenseValidator
implements ConstraintValidator<HasOpenDefinitionCompatibleLicense, List<License>> {
    private static final String[] OPEN_DEFINITION_COMPATIBLE_LICENSES = new String[]{"AAL", "AFL-3.0", "AGPL-3.0", "APL-1.0", "APSL-2.0", "Against-DRM", "Apache-1.1", "Apache-2.0", "Artistic-2.0", "BSD-2-Clause", "BSD-3-Clause", "BSL-1.0", "BitTorrent-1.1", "CATOSL-1.1", "CC-BY-4.0", "CC-BY-NC-4.0", "CC-BY-NC-ND-4.0", "CC-BY-NC-SA-4.0", "CC-BY-ND-4.0", "CC-BY-SA-4.0", "CC0-1.0", "CDDL-1.0", "CECILL-2.1", "CNRI-Python", "CPAL-1.0", "CUA-OPL-1.0", "DSL", "ECL-2.0", "EFL-2.0", "EPL-1.0", "EPL-2.0", "EUDatagrid", "EUPL-1.1", "Entessa", "FAL-1.3", "Fair", "Frameworx-1.0", "GFDL-1.3-no-cover-texts-no-invariant-sections", "GPL-2.0", "GPL-3.0", "HPND", "IPA", "IPL-1.0", "ISC", "Intel", "LGPL-2.1", "LGPL-3.0", "LO-FR-2.0", "LPL-1.0", "LPL-1.02", "LPPL-1.3c", "MIT", "MPL-1.0", "MPL-1.1", "MPL-2.0", "MS-PL", "MS-RL", "MirOS", "Motosoto", "Multics", "NASA-1.3", "NCSA", "NGPL", "NPOSL-3.0", "NTP", "Naumen", "Nokia", "OCLC-2.0", "ODC-BY-1.0", "ODbL-1.0", "OFL-1.1", "OGL-Canada-2.0", "OGL-UK-1.0", "OGL-UK-2.0", "OGL-UK-3.0", "OGTSL", "OSL-3.0", "PDDL-1.0", "PHP-3.0", "PostgreSQL", "Python-2.0", "QPL-1.0", "RPL-1.5", "RPSL-1.0", "RSCPL", "SISSL", "SPL-1.0", "SimPL-2.0", "Sleepycat", "Talis", "Unlicense", "VSL-1.0", "W3C", "WXwindows", "Watcom-1.0", "Xnet", "ZPL-2.0", "Zlib", "dli-model-use", "geogratis", "hesa-withrights", "localauth-withrights", "met-office-cp", "mitre", "notspecified", "other-at", "other-closed", "other-nc", "other-open", "other-pd", "ukclickusepsi", "ukcrown", "ukcrown-withrights", "ukpsi"};

    public boolean isValid(List<License> value, ConstraintValidatorContext context) {
        if (value == null) {
            return true;
        }
        boolean isValid = true;
        for (License license : value) {
            CamtrapLicense camtrapLicense;
            if (!(license instanceof CamtrapLicense) || !this.isMediaLicense(camtrapLicense = (CamtrapLicense)license) || this.isValid(camtrapLicense)) continue;
            isValid = false;
            context.disableDefaultConstraintViolation();
            context.buildConstraintViolationWithTemplate(context.getDefaultConstraintMessageTemplate()).addConstraintViolation();
        }
        return isValid;
    }

    private boolean isMediaLicense(CamtrapLicense license) {
        return license.getScope() == CamtrapLicense.Scope.MEDIA;
    }

    private boolean isValid(CamtrapLicense license) {
        return StringUtils.equalsAny((CharSequence)license.getName(), (CharSequence[])OPEN_DEFINITION_COMPATIBLE_LICENSES);
    }
}

