/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.ipt.validation;

import java.util.List;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import org.apache.commons.lang3.StringUtils;
import org.gbif.ipt.model.datapackage.metadata.License;
import org.gbif.ipt.model.datapackage.metadata.camtrap.CamtrapLicense;
import org.gbif.ipt.validation.HasGbifCompatibleLicense;

public class HasGbifCompatibleLicenseValidator
implements ConstraintValidator<HasGbifCompatibleLicense, List<License>> {
    private static final String[] GBIF_COMPATIBLE_LICENSES = new String[]{"CC0-1.0", "CC-BY-4.0", "CC-BY-NC-4.0"};

    public boolean isValid(List<License> value, ConstraintValidatorContext context) {
        if (value == null) {
            return true;
        }
        boolean isValid = true;
        for (License license : value) {
            CamtrapLicense camtrapLicense;
            if (!(license instanceof CamtrapLicense) || !this.isDataLicense(camtrapLicense = (CamtrapLicense)license) || this.isValid(camtrapLicense)) continue;
            isValid = false;
            context.disableDefaultConstraintViolation();
            context.buildConstraintViolationWithTemplate(context.getDefaultConstraintMessageTemplate()).addConstraintViolation();
        }
        return isValid;
    }

    private boolean isDataLicense(CamtrapLicense license) {
        return license.getScope() == CamtrapLicense.Scope.DATA;
    }

    private boolean isValid(CamtrapLicense license) {
        return StringUtils.equalsAny((CharSequence)license.getName(), (CharSequence[])GBIF_COMPATIBLE_LICENSES);
    }
}

