/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.ipt.validation;

import java.net.URI;
import java.net.URISyntaxException;
import java.time.temporal.ChronoField;
import java.time.temporal.TemporalAccessor;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.gbif.common.parsers.core.ParseResult;
import org.gbif.common.parsers.date.DateParsers;
import org.gbif.common.parsers.date.TemporalParser;
import org.gbif.dwc.ArchiveField;
import org.gbif.dwc.terms.Term;
import org.gbif.ipt.model.Extension;
import org.gbif.ipt.model.ExtensionMapping;
import org.gbif.ipt.model.ExtensionProperty;
import org.gbif.ipt.model.PropertyMapping;
import org.gbif.ipt.model.Resource;
import org.gbif.ipt.validation.ExtensionMappingValidator;

public class ExtensionMappingValidator {
    private static final Logger LOG = LogManager.getLogger(ExtensionMappingValidator.class);
    private static final TemporalParser TEXTDATE_PARSER = DateParsers.defaultTemporalParser();

    private boolean isValidDataType(ArchiveField.DataType dt, PropertyMapping pm, List<String[]> peek) {
        if (dt == null || dt == ArchiveField.DataType.string) {
            return true;
        }
        HashSet<String> testData = new HashSet<String>();
        testData.add(pm.getDefaultValue());
        if (pm.getIndex() != null) {
            for (String[] row : peek) {
                if (pm.getIndex() >= row.length || pm.getIndex() < 0) continue;
                testData.add(row[pm.getIndex()]);
            }
        }
        for (String val : testData) {
            if ((val = StringUtils.trimToNull((String)val)) == null) continue;
            try {
                if (ArchiveField.DataType.bool == dt) {
                    if (!val.equals("1")) continue;
                    continue;
                }
                if (ArchiveField.DataType.date == dt) {
                    ParseResult parsedDateResult = TEXTDATE_PARSER.parse(val);
                    TemporalAccessor parsedDateTa = (TemporalAccessor)parsedDateResult.getPayload();
                    if (parsedDateTa == null) {
                        return false;
                    }
                    if (parsedDateTa.isSupported(ChronoField.YEAR)) continue;
                    return false;
                }
                if (ArchiveField.DataType.decimal == dt) {
                    Float.parseFloat(val);
                    continue;
                }
                if (ArchiveField.DataType.integer == dt) {
                    Integer.parseInt(val);
                    continue;
                }
                if (ArchiveField.DataType.uri != dt) continue;
                new URI(val);
            }
            catch (NumberFormatException | URISyntaxException e) {
                return false;
            }
        }
        return true;
    }

    public ValidationStatus validate(ExtensionMapping mapping, Resource resource, List<String[]> peek, List<String> columns) {
        ValidationStatus v = new ValidationStatus();
        Extension ext = mapping.getExtension();
        if (ext != null) {
            for (Object p : ext.getProperties()) {
                if (!p.isRequired() || mapping.isMapped((Term)p)) continue;
                v.addMissingRequiredField((Term)p);
            }
            HashSet<Integer> translatedColumns = new HashSet<Integer>();
            for (Object pm : mapping.getFields()) {
                ArchiveField.DataType type;
                ExtensionProperty extProperty = mapping.getExtension().getProperty(pm.getTerm());
                ArchiveField.DataType dataType = type = extProperty != null ? extProperty.getType() : null;
                if (type != null && ArchiveField.DataType.string != type && !this.isValidDataType(type, (PropertyMapping)pm, peek)) {
                    v.addWrongDataTypeField(pm.getTerm());
                }
                if (pm.getIndex() == null || pm.getTranslation() == null) continue;
                if (translatedColumns.contains(pm.getIndex())) {
                    String columnName = columns.get(pm.getIndex());
                    v.getMultipleTranslationsForSameColumn().add(columnName);
                    continue;
                }
                translatedColumns.add(pm.getIndex());
            }
            if (mapping.getIdColumn() == null) {
                if (!ext.isCore()) {
                    v.setIdProblem("validation.mapping.coreid.missing");
                }
            } else if (mapping.getIdColumn().equals(ExtensionMapping.IDGEN_LINE_NUMBER)) {
                if (StringUtils.isNumericSpace((CharSequence)StringUtils.trimToNull((String)mapping.getIdSuffix()))) {
                    v.setIdProblem("validation.mapping.coreid.linenumber.integer");
                }
                if (ext.isCore()) {
                    HashSet maps = new HashSet(resource.getMappings(ext.getRowType()));
                    maps.remove(mapping);
                    if (!maps.isEmpty()) {
                        for (ExtensionMapping m : maps) {
                            if (m.getIdColumn() == null || !m.getIdColumn().equals(ExtensionMapping.IDGEN_LINE_NUMBER) || !StringUtils.trimToEmpty((String)mapping.getIdSuffix()).equals(m.getIdSuffix())) continue;
                            v.setIdProblem("validation.mapping.coreid.linenumber.samesufix");
                        }
                    }
                } else {
                    boolean found = false;
                    for (ExtensionMapping m : resource.getCoreMappings()) {
                        if (m.getIdColumn() == null || !m.getIdColumn().equals(ExtensionMapping.IDGEN_LINE_NUMBER) || !StringUtils.trimToEmpty((String)mapping.getIdSuffix()).equals(StringUtils.trimToEmpty((String)m.getIdSuffix()))) continue;
                        found = true;
                        break;
                    }
                    if (!found) {
                        v.setIdProblem("validation.mapping.coreid.linenumber.nocoresuffix");
                    }
                }
            } else if (mapping.getIdColumn().equals(ExtensionMapping.IDGEN_UUID)) {
                if (ext.isCore()) {
                    for (ExtensionMapping m : resource.getMappings()) {
                        if (m.isCore()) continue;
                        v.setIdProblem("validation.mapping.coreid.uuid.extensions.exist");
                    }
                } else {
                    v.setIdProblem("validation.mapping.coreid.uuid.extension");
                }
            }
        }
        return v;
    }
}

