/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.ipt.validation;

import java.util.Date;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.validator.routines.EmailValidator;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.gbif.ipt.validation.ValidationResult;

public abstract class BaseValidator {
    private static final Logger LOG = LogManager.getLogger(BaseValidator.class);
    private EmailValidator emailValidator = EmailValidator.getInstance();

    protected boolean exists(String x) {
        return this.exists(x, 2);
    }

    protected boolean exists(Integer i) {
        return i != null;
    }

    protected boolean exists(Date d) {
        return d != null;
    }

    protected boolean exists(String x, int minLength) {
        return x != null && x.trim().length() >= minLength;
    }

    protected boolean existsInRange(String x, int minLength, int maxLength) {
        return (x = StringUtils.trimToNull((String)x)) != null && x.length() >= minLength && x.length() <= maxLength;
    }

    protected boolean isValidEmail(String email) {
        if (email != null) {
            try {
                InternetAddress internetAddress = new InternetAddress(email);
                internetAddress.validate();
                return true;
            }
            catch (AddressException e) {
                LOG.error("Email address was invalid: {}. Reason: {}", (Object)StringUtils.trimToEmpty((String)email), (Object)e.getMessage());
            }
        }
        return false;
    }

    protected ValidationResult checkEmailValid(String email) {
        ValidationResult result = new ValidationResult();
        try {
            if (email != null) {
                InternetAddress internetAddress = new InternetAddress(email);
                internetAddress.validate();
                result.setValid(true);
                boolean validationResult = this.emailValidator.isValid(email);
                result.setValid(validationResult);
                if (!validationResult) {
                    result.setMessage("Email is invalid");
                }
            }
        }
        catch (AddressException e) {
            LOG.error("Email address was invalid: {}. Reason: {}", (Object)StringUtils.trimToEmpty((String)email), (Object)e.getMessage());
            result.setValid(false);
            result.setMessage(e.getMessage());
        }
        return result;
    }
}

