/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.ipt.utils;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import com.fasterxml.jackson.dataformat.yaml.YAMLGenerator;
import java.io.File;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.Locale;
import java.util.Objects;
import java.util.UUID;
import javax.annotation.Nullable;
import javax.validation.constraints.NotNull;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.gbif.api.model.common.DOI;
import org.gbif.ipt.model.Organisation;
import org.gbif.ipt.model.Resource;
import org.gbif.ipt.model.VersionHistory;
import org.gbif.ipt.model.datapackage.metadata.DataPackageMetadata;
import org.gbif.ipt.model.datapackage.metadata.camtrap.CamtrapMetadata;
import org.gbif.ipt.model.datapackage.metadata.col.ColMetadata;
import org.gbif.ipt.model.datapackage.metadata.col.FrictionlessColMetadata;
import org.gbif.ipt.utils.EmlUtils;
import org.gbif.metadata.eml.ipt.model.Eml;

/*
 * Exception performing whole class analysis ignored.
 */
public class ResourceUtils {
    protected static final Logger LOG = LogManager.getLogger(ResourceUtils.class);
    private static final ObjectMapper jsonMapper = new ObjectMapper();
    private static final ObjectMapper yamlMapper = new ObjectMapper((JsonFactory)new YAMLFactory().disable(YAMLGenerator.Feature.WRITE_DOC_START_MARKER));

    private ResourceUtils() {
    }

    public static Resource reconstructVersion(@NotNull BigDecimal version, @NotNull String shortname, @NotNull String coreTypeOrPackageType, @Nullable String dataPackageIdentifier, @Nullable DOI doi, @Nullable Organisation organisation, @Nullable VersionHistory versionHistory, @Nullable File versionMetadataFile, @Nullable UUID key) {
        boolean isDataPackageResource;
        Objects.requireNonNull(version);
        Objects.requireNonNull(shortname);
        boolean bl = isDataPackageResource = dataPackageIdentifier != null;
        if (organisation == null && !isDataPackageResource) {
            throw new IllegalArgumentException("Failed to reconstruct resource version: organisation is null");
        }
        if (versionHistory == null) {
            throw new IllegalArgumentException("Failed to reconstruct resource version: version history is null");
        }
        if (versionMetadataFile == null) {
            throw new IllegalArgumentException("Failed to reconstruct resource version: version eml file is null");
        }
        Resource resource = new Resource();
        resource.setCoreType(coreTypeOrPackageType);
        resource.setDataPackageIdentifier(dataPackageIdentifier);
        resource.setShortname(shortname);
        resource.setMetadataVersion(version);
        resource.setDoi(doi);
        resource.setOrganisation(organisation);
        resource.setKey(key);
        resource.setStatus(versionHistory.getPublicationStatus());
        resource.setIdentifierStatus(versionHistory.getStatus());
        resource.setRecordsPublished(versionHistory.getRecordsPublished());
        resource.setLastPublished(versionHistory.getReleased());
        resource.setRecordsByExtension(versionHistory.getRecordsByExtension());
        if (versionMetadataFile.exists()) {
            if (isDataPackageResource) {
                if ("coldp".equals(coreTypeOrPackageType)) {
                    try {
                        ColMetadata metadata = (ColMetadata)yamlMapper.readValue(versionMetadataFile, ColMetadata.class);
                        resource.setDataPackageMetadata((DataPackageMetadata)metadata);
                    }
                    catch (IOException e) {
                        LOG.error("Failed to produce ColDP metadata for the resource {}", (Object)shortname);
                        LOG.error((Object)e);
                        throw new RuntimeException(e);
                    }
                } else {
                    try {
                        DataPackageMetadata metadata = (DataPackageMetadata)jsonMapper.readValue(versionMetadataFile, ResourceUtils.getDataPackageClass((String)dataPackageIdentifier));
                        resource.setDataPackageMetadata(metadata);
                    }
                    catch (IOException e) {
                        LOG.error("Failed to produce metadata for the data package resource {}", (Object)shortname);
                        LOG.error((Object)e);
                        throw new RuntimeException(e);
                    }
                }
            } else {
                Eml eml = EmlUtils.loadWithLocale((File)versionMetadataFile, (Locale)Locale.US);
                resource.setEml(eml);
            }
        } else {
            LOG.error("Failed to reconstruct resource: {} not found!", (Object)versionMetadataFile.getAbsolutePath());
            throw new IllegalArgumentException("Failed to reconstruct resource: " + versionMetadataFile.getAbsolutePath() + " not found!");
        }
        return resource;
    }

    private static Class<? extends DataPackageMetadata> getDataPackageClass(String dataPackageIdentifier) {
        if (dataPackageIdentifier.contains("camtrap-dp")) {
            return CamtrapMetadata.class;
        }
        return FrictionlessColMetadata.class;
    }

    public static boolean assertVersionOrder(BigDecimal b, BigDecimal a) {
        if (a != null && b != null) {
            if (b.intValue() > a.intValue()) {
                return true;
            }
            if (b.intValue() == a.intValue()) {
                int scaleA;
                BigDecimal scaledA;
                int scaleB = b.scale();
                BigDecimal scaledB = b.scaleByPowerOfTen(scaleB);
                return scaledB.compareTo(scaledA = a.scaleByPowerOfTen(scaleA = a.scale())) > 0;
            }
        }
        return false;
    }
}

