/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.ipt.utils;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.text.NumberFormat;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.lang3.LocaleUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.gbif.ipt.model.UrlMetadata;

/*
 * Exception performing whole class analysis ignored.
 */
public class FileUtils {
    public static final String UTF8 = "UTF8";
    private static final Logger LOG = LogManager.getLogger(FileUtils.class);
    private static final int BUFFER_SIZE = 8192;
    private static final int TEMP_DIR_ATTEMPTS = 10000;

    private FileUtils() {
    }

    public static void copyStreams(InputStream in, OutputStream out) throws IOException {
        int bytesRead;
        byte[] buffer = new byte[8192];
        while ((bytesRead = in.read(buffer, 0, 8192)) != -1) {
            out.write(buffer, 0, bytesRead);
        }
        out.close();
        in.close();
    }

    public static void copyStreamToFile(InputStream in, File out) throws IOException {
        FileUtils.copyStreams((InputStream)in, (OutputStream)new FileOutputStream(out));
    }

    public static String formatSize(long longSize, int decimalPos) {
        return FileUtils.formatSize((long)longSize, (int)decimalPos, (boolean)false);
    }

    public static String formatSize(long longSize, int decimalPos, boolean inseparableDelimiter) {
        return FileUtils.formatSize((long)longSize, (int)decimalPos, (String)Locale.UK.toString(), (boolean)inseparableDelimiter);
    }

    public static String formatSize(long longSize, int decimalPos, String strLocale, boolean inseparableDelimiter) {
        double val;
        String delimiter = inseparableDelimiter ? "&nbsp;" : " ";
        Locale locale = Optional.ofNullable(strLocale).map(LocaleUtils::toLocale).orElse(Locale.UK);
        NumberFormat fmt = NumberFormat.getNumberInstance(locale);
        if (decimalPos >= 0) {
            fmt.setMaximumFractionDigits(decimalPos);
        }
        if ((val = (double)((float)longSize / 1.0E9f)) > 1.0) {
            return fmt.format(val) + delimiter + "GB";
        }
        val = (float)longSize / 1000000.0f;
        if (val > 1.0) {
            return fmt.format(val) + delimiter + "MB";
        }
        val = (float)longSize / 1000.0f;
        if (val > 1.0) {
            return fmt.format(val) + delimiter + "KB";
        }
        return longSize + delimiter + "bytes";
    }

    public static Reader getUtf8Reader(File file) throws FileNotFoundException {
        BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), StandardCharsets.UTF_8));
        return reader;
    }

    public static Writer startNewUtf8File(File file) throws IOException {
        try {
            org.apache.commons.io.FileUtils.touch((File)file);
        }
        catch (IOException e) {
            if (file.exists() && file.canWrite()) {
                LOG.warn("Cant touch file, but it was created: " + e.getMessage());
                LOG.debug((Object)e);
            }
            throw e;
        }
        return new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file, false), StandardCharsets.UTF_8));
    }

    public static String getSuffixedFileName(String name, String suffix) {
        Objects.requireNonNull(name);
        Objects.requireNonNull(suffix);
        return name.replaceAll("[/.:]+", "_") + suffix;
    }

    public static File createTempDir() {
        File baseDir = new File(System.getProperty("java.io.tmpdir"));
        String baseName = System.currentTimeMillis() + "-";
        for (int counter = 0; counter < 10000; ++counter) {
            File tempDir = new File(baseDir, baseName + counter);
            if (!tempDir.mkdir()) continue;
            return tempDir;
        }
        throw new IllegalStateException("Failed to create directory within 10000 attempts (tried " + baseName + "0 to " + baseName + "9999)");
    }

    public static String getFileExtension(File file) {
        String fileName = file.getName();
        int lastIndexOfDot = fileName.lastIndexOf(".");
        if (lastIndexOfDot == -1) {
            return "";
        }
        return fileName.substring(lastIndexOfDot + 1);
    }

    public static UrlMetadata fetchUrlMetadata(String url) throws IOException {
        URL remoteUrl = new URL(url);
        HttpURLConnection conn = (HttpURLConnection)remoteUrl.openConnection();
        conn.setRequestMethod("HEAD");
        conn.connect();
        int status = conn.getResponseCode();
        String contentType = conn.getContentType();
        long contentLength = conn.getContentLengthLong();
        String lastModified = conn.getHeaderField("Last-Modified");
        String acceptRanges = conn.getHeaderField("Accept-Ranges");
        return new UrlMetadata(status, contentType, contentLength, lastModified, acceptRanges);
    }
}

