/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.ipt.utils;

import freemarker.template.TemplateException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.gbif.ipt.model.Resource;
import org.gbif.ipt.service.InvalidConfigException;
import org.gbif.metadata.eml.ipt.EmlFactory;
import org.gbif.metadata.eml.ipt.IptEmlWriter;
import org.gbif.metadata.eml.ipt.model.Eml;
import org.gbif.metadata.eml.ipt.model.KeywordSet;
import org.xml.sax.SAXException;

public class EmlUtils {
    protected static final Logger LOG = LogManager.getLogger(EmlUtils.class);

    private EmlUtils() {
    }

    public static void addOrUpdateKeywordSet(List<KeywordSet> keywords, String keyword, String thesaurus) {
        if (StringUtils.isNotBlank((CharSequence)keyword) && StringUtils.isNotBlank((CharSequence)thesaurus)) {
            String capped = StringUtils.capitalize((String)keyword.toLowerCase());
            boolean found = false;
            for (KeywordSet ks : keywords) {
                String keywordThesaurus = ks.getKeywordThesaurus();
                if (!StringUtils.isNotBlank((CharSequence)keywordThesaurus) || !keywordThesaurus.equalsIgnoreCase(thesaurus)) continue;
                String keywordString = ks.getKeywordsString();
                if (StringUtils.isBlank((CharSequence)keywordString)) {
                    ks.setKeywordsString(capped);
                }
                found = true;
                break;
            }
            if (!found) {
                KeywordSet ks = new KeywordSet();
                ks.setKeywordThesaurus(thesaurus);
                ks.setKeywordsString(capped);
                keywords.add(ks);
            }
        }
    }

    public static void removeKeywordSet(List<KeywordSet> keywords, String thesaurus) {
        if (StringUtils.isNotBlank((CharSequence)thesaurus)) {
            Iterator<KeywordSet> iterator = keywords.iterator();
            while (iterator.hasNext()) {
                String keywordThesaurus = iterator.next().getKeywordThesaurus();
                if (!StringUtils.isNotBlank((CharSequence)keywordThesaurus) || !keywordThesaurus.equalsIgnoreCase(thesaurus)) continue;
                iterator.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeWithLocale(File emlFile, Resource resource, Locale locale) {
        Locale currentLocale = Locale.getDefault();
        try {
            Locale locale2 = currentLocale;
            synchronized (locale2) {
                Locale.setDefault(locale);
                IptEmlWriter.writeEmlFile((File)emlFile, (Eml)resource.getEml());
                Locale.setDefault(currentLocale);
            }
        }
        catch (IOException e) {
            LOG.error((Object)e);
            throw new InvalidConfigException(InvalidConfigException.TYPE.CONFIG_WRITE, "IO exception when writing eml for " + String.valueOf(resource), (Exception)e);
        }
        catch (TemplateException e) {
            LOG.error("EML template exception", (Throwable)e);
            throw new InvalidConfigException(InvalidConfigException.TYPE.EML, "EML template exception when writing eml for " + String.valueOf(resource) + ": " + e.getMessage(), (Exception)((Object)e));
        }
        finally {
            Locale.setDefault(currentLocale);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Eml loadWithLocale(File emlFile, Locale locale) {
        Eml eml = null;
        Locale currentLocale = Locale.getDefault();
        try {
            FileInputStream in = new FileInputStream(emlFile);
            Locale locale2 = currentLocale;
            synchronized (locale2) {
                Locale.setDefault(locale);
                eml = EmlFactory.build((InputStream)in);
                Locale.setDefault(currentLocale);
            }
        }
        catch (FileNotFoundException e) {
            eml = new Eml();
        }
        catch (IOException e) {
            LOG.error((Object)e);
        }
        catch (SAXException e) {
            LOG.error("Invalid EML document", (Throwable)e);
            eml = new Eml();
        }
        catch (Exception e) {
            eml = new Eml();
        }
        finally {
            Locale.setDefault(currentLocale);
        }
        return eml;
    }
}

