/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.ipt.utils;

import java.text.DecimalFormat;

public class CoordinateUtils {
    public static final String LATITUDE = "LAT";
    public static final String LONGITUDE = "LON";
    public static final double MIN_LONGITUDE = -180.0;
    public static final double MAX_LONGITUDE = 180.0;
    public static final double MIN_LATITUDE = -90.0;
    public static final double MAX_LATITUDE = 90.0;

    private CoordinateUtils() {
    }

    public static String decToDms(double decimalCoordinate, String coordinateType) {
        if (coordinateType != null && coordinateType.length() != 0) {
            StringBuilder dms = new StringBuilder();
            double absCoordinate = Math.abs(decimalCoordinate);
            int integer = (int)Math.floor(absCoordinate);
            dms.append(integer);
            dms.append("\u00b0");
            int min = (int)Math.floor(60.0 * (absCoordinate - (double)integer));
            dms.append(min);
            dms.append('\'');
            double sec = (60.0 * (absCoordinate - (double)integer) - (double)min) * 60.0;
            DecimalFormat f = new DecimalFormat("###.##");
            dms.append(f.format(sec));
            dms.append("''");
            if (coordinateType.equals(LATITUDE)) {
                dms.append(Math.signum(decimalCoordinate) < 0.0 ? "S" : "N");
            }
            if (coordinateType.equals(LONGITUDE)) {
                dms.append(Math.signum(decimalCoordinate) < 0.0 ? "W" : "E");
            }
            return dms.toString();
        }
        return "";
    }
}

