/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.ipt.utils;

import org.apache.logging.log4j.Logger;
import org.gbif.ipt.action.BaseAction;

public class ActionLogger {
    private final Logger log;
    private final BaseAction action;

    public ActionLogger(Logger log, BaseAction action) {
        this.log = log;
        this.action = action;
    }

    public void error(String message) {
        if (message != null) {
            this.action.addActionWarning(this.action.getText(message));
            this.log.error(this.action.getText(message) == null ? message : this.action.getText(message));
        }
    }

    public void error(String message, String[] args) {
        if (message != null) {
            this.action.addActionWarning(this.action.getText(message, args));
            this.log.error(this.action.getText(message) == null ? message : this.action.getText(message, args));
        }
    }

    public void error(String message, String[] args, Throwable t) {
        if (message == null) {
            this.error(t);
        } else {
            this.action.addActionWarning(this.action.getText(message, args));
            this.log.error(this.action.getText(message) == null ? message : this.action.getText(message, args), t);
        }
    }

    public void error(String message, Throwable t) {
        if (message == null) {
            this.error(t);
        } else {
            this.action.addActionWarning(this.action.getText(message));
            this.log.error(this.action.getText(message) == null ? message : this.action.getText(message), t);
        }
    }

    public void error(Throwable t) {
        if (t.getMessage() != null) {
            this.action.addActionWarning(t.getMessage());
        }
        this.log.error((Object)t);
    }

    public void info(String message) {
        if (message != null) {
            this.action.addActionMessage(this.action.getText(message));
            this.log.info(this.action.getText(message) == null ? message : this.action.getText(message));
        }
    }

    public void info(String message, String[] args) {
        if (message != null) {
            this.action.addActionMessage(this.action.getText(message, args));
            this.log.info(this.action.getText(message) == null ? message : this.action.getText(message, args));
        }
    }

    public void info(String message, String[] args, Throwable t) {
        if (message == null) {
            this.info(t);
        } else {
            this.action.addActionMessage(this.action.getText(message, args));
            this.log.info(this.action.getText(message) == null ? message : this.action.getText(message, args), t);
        }
    }

    public void info(String message, Throwable t) {
        if (message == null) {
            this.info(t);
        } else {
            this.action.addActionMessage(this.action.getText(message));
            this.log.info(this.action.getText(message) == null ? message : this.action.getText(message), t);
        }
    }

    public void info(Throwable t) {
        if (t.getMessage() != null) {
            this.action.addActionMessage(t.getMessage());
        }
        this.log.info((Object)t);
    }

    public void warn(String message) {
        if (message != null) {
            this.action.addActionWarning(this.action.getText(message));
            this.log.warn(this.action.getText(message) == null ? message : this.action.getText(message));
        }
    }

    public void warn(String message, String[] args) {
        if (message != null) {
            this.action.addActionWarning(this.action.getText(message, args));
            this.log.warn(this.action.getText(message) == null ? message : this.action.getText(message, args));
        }
    }

    public void warn(String message, String[] args, Throwable t) {
        if (message == null) {
            this.info(t);
        } else {
            this.action.addActionWarning(this.action.getText(message, args));
            this.log.warn(this.action.getText(message) == null ? message : this.action.getText(message, args), t);
        }
    }

    public void warn(String message, Throwable t) {
        if (message == null) {
            this.info(t);
        } else {
            this.action.addActionWarning(this.action.getText(message));
            this.log.warn(this.action.getText(message) == null ? message : this.action.getText(message), t);
        }
    }

    public void warn(Throwable t) {
        if (t.getMessage() != null) {
            this.action.addActionWarning(t.getMessage());
        }
        this.log.warn((Object)t);
    }
}

