/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.ipt.task;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.gbif.ipt.task.TaskMessage;

public class StatusReport {
    private final boolean completed;
    private final Exception exception;
    private final long timestamp;
    private final String state;
    private final List<TaskMessage> messages;

    public StatusReport(boolean completed, String state, List<TaskMessage> messages) {
        this.completed = completed;
        this.state = state;
        this.messages = messages;
        this.timestamp = new Date().getTime();
        this.exception = null;
    }

    public StatusReport(Exception exception, String state, List<TaskMessage> messages) {
        this.completed = true;
        this.state = state;
        this.messages = messages;
        this.timestamp = new Date().getTime();
        this.exception = exception;
    }

    public StatusReport(String state, List<TaskMessage> messages) {
        this.completed = false;
        this.state = state;
        this.messages = messages;
        this.timestamp = new Date().getTime();
        this.exception = null;
    }

    public String getExceptionMessage() {
        return this.exception != null ? this.exception.getMessage() : null;
    }

    public List<String> getExceptionStacktrace() {
        ArrayList<String> trace = new ArrayList<String>();
        if (this.exception != null) {
            for (StackTraceElement el : this.exception.getStackTrace()) {
                trace.add(el.toString());
            }
        }
        return trace;
    }

    public boolean hasException() {
        return this.exception != null;
    }

    public String toString() {
        return this.state + ":" + StringUtils.join((Iterable)this.messages, (String)";");
    }

    public boolean isCompleted() {
        return this.completed;
    }

    public Exception getException() {
        return this.exception;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public String getState() {
        return this.state;
    }

    public List<TaskMessage> getMessages() {
        return this.messages;
    }
}

