/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.ipt.task;

import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.gbif.ipt.config.DataDir;
import org.gbif.ipt.task.ReportHandler;
import org.gbif.ipt.task.StatusReport;
import org.gbif.ipt.task.TaskMessage;

public abstract class ReportingTask {
    protected Logger log = LogManager.getLogger(this.getClass());
    protected final DataDir dataDir;
    private final String resourceShortname;
    private final ReportHandler handler;
    private List<TaskMessage> messages = new ArrayList();
    private final int reportingIntervall;
    private StatusReport lastReport;
    protected BufferedWriter publicationLogWriter;

    protected ReportingTask(int reportingIntervall, String resourceShortname, ReportHandler handler, DataDir dataDir) {
        this.resourceShortname = resourceShortname;
        this.handler = handler;
        this.reportingIntervall = reportingIntervall;
        this.dataDir = dataDir;
        this.publicationLogWriter = this.getPublicationLogWriter(resourceShortname);
    }

    protected void addMessage(Level lvl, String msg) {
        if (Level.ERROR.equals((Object)lvl)) {
            this.log.error(msg);
        } else if (Level.WARN.equals((Object)lvl)) {
            this.log.warn(msg);
        } else if (Level.INFO.equals((Object)lvl)) {
            this.log.info(msg);
        } else {
            this.log.debug(msg);
        }
        this.messages.add(new TaskMessage(lvl, msg));
        this.writePublicationLogMessage(msg);
    }

    protected abstract boolean completed();

    protected abstract Exception currentException();

    protected abstract String currentState();

    public StatusReport report() {
        Exception e = this.currentException();
        this.lastReport = e != null ? new StatusReport(e, this.currentState(), this.messages) : new StatusReport(this.completed(), this.currentState(), this.messages);
        this.handler.report(this.resourceShortname, this.lastReport);
        return this.lastReport;
    }

    public void reportIfNeeded() {
        if (this.lastReport == null || new Date().getTime() - this.lastReport.getTimestamp() > (long)this.reportingIntervall) {
            this.report();
        }
    }

    protected BufferedWriter getPublicationLogWriter(String resourceShortname) {
        File logFile = this.dataDir.resourcePublicationLogFile(resourceShortname);
        try {
            return Files.newBufferedWriter(logFile.toPath(), StandardCharsets.UTF_8, new OpenOption[0]);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected void writePublicationLogMessage(String message) {
        try {
            this.publicationLogWriter.write(message + "\n");
        }
        catch (IOException e) {
            this.log.error("Publication log file could not be written to by writer: " + e.getMessage(), (Throwable)e);
        }
    }

    protected void closePublicationLogWriter() {
        if (this.publicationLogWriter != null) {
            try {
                this.publicationLogWriter.flush();
                this.publicationLogWriter.close();
            }
            catch (IOException e) {
                this.log.error("Publication log file writer could not be closed: " + e.getMessage(), (Throwable)e);
            }
        }
    }
}

