/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.ipt.task;

import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.math.BigDecimal;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOCase;
import org.apache.commons.io.filefilter.WildcardFileFilter;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.Level;
import org.gbif.api.model.common.DOI;
import org.gbif.dwc.Archive;
import org.gbif.dwc.ArchiveField;
import org.gbif.dwc.ArchiveFile;
import org.gbif.dwc.DwcFiles;
import org.gbif.dwc.MetaDescriptorWriter;
import org.gbif.dwc.terms.DwcTerm;
import org.gbif.dwc.terms.Term;
import org.gbif.dwc.terms.TermFactory;
import org.gbif.ipt.config.AppConfig;
import org.gbif.ipt.config.DataDir;
import org.gbif.ipt.model.Extension;
import org.gbif.ipt.model.ExtensionMapping;
import org.gbif.ipt.model.ExtensionProperty;
import org.gbif.ipt.model.PropertyMapping;
import org.gbif.ipt.model.RecordFilter;
import org.gbif.ipt.model.Resource;
import org.gbif.ipt.service.admin.VocabulariesManager;
import org.gbif.ipt.service.manage.SourceManager;
import org.gbif.ipt.task.GenerateDwca;
import org.gbif.ipt.task.GeneratorException;
import org.gbif.ipt.task.ReportHandler;
import org.gbif.ipt.task.ReportingTask;
import org.gbif.ipt.task.StatusReport;
import org.gbif.ipt.utils.MapUtils;
import org.gbif.metadata.eml.EMLProfileVersion;
import org.gbif.metadata.eml.EmlValidator;
import org.gbif.metadata.eml.InvalidEmlException;
import org.gbif.utils.file.ClosableReportingIterator;
import org.gbif.utils.file.CompressionUtil;
import org.gbif.utils.file.csv.CSVReader;
import org.gbif.utils.file.csv.CSVReaderFactory;
import org.gbif.utils.text.LineComparator;
import org.xml.sax.SAXException;

public class GenerateDwca
extends ReportingTask
implements Callable<Map<String, Integer>> {
    private static final Pattern escapeChars = Pattern.compile("[\t\n\r]");
    private final Resource resource;
    private Map<String, Integer> recordsByExtension = new HashMap();
    private Archive archive;
    private File dwcaFolder;
    private int currRecords = 0;
    private int currRecordsSkipped = 0;
    private String currExtension;
    private STATE state = STATE.WAITING;
    private final SourceManager sourceManager;
    private final VocabulariesManager vocabManager;
    private Map<String, String> basisOfRecords;
    private Map<String, String> basisOfRecordsSnakeCase;
    private Exception exception;
    private AppConfig cfg;
    private static final int ID_COLUMN_INDEX = 0;
    public static final String CHARACTER_ENCODING = "UTF-8";
    private static final TermFactory TERM_FACTORY = TermFactory.instance();
    private static final String SORTED_FILE_PREFIX = "sorted_";
    private static final org.gbif.utils.file.FileUtils GBIF_FILE_UTILS = new org.gbif.utils.file.FileUtils();
    public static final String CANCELLED_STATE_MSG = "Archive generation cancelled";
    public static final String ID_COLUMN_NAME = "id";
    public static final String TEXT_FILE_EXTENSION = ".txt";
    public static final String WILDCARD_CHARACTER = "*";
    public static final Set<DwcTerm> DWC_MULTI_VALUE_TERMS;
    private static final Comparator<String> IGNORE_CASE_COMPARATOR;

    public GenerateDwca(Resource resource, ReportHandler handler, DataDir dataDir, SourceManager sourceManager, AppConfig cfg, VocabulariesManager vocabManager) {
        super(1000, resource.getShortname(), handler, dataDir);
        this.resource = resource;
        this.sourceManager = sourceManager;
        this.cfg = cfg;
        this.vocabManager = vocabManager;
    }

    public void addDataFile(List<ExtensionMapping> mappings, @Nullable Integer rowLimit) throws IOException, IllegalArgumentException, InterruptedException, GeneratorException {
        this.checkForInterruption();
        if (mappings == null || mappings.isEmpty()) {
            return;
        }
        this.currRecords = 0;
        this.currRecordsSkipped = 0;
        Extension ext = mappings.get(0).getExtension();
        this.currExtension = ext.getTitle();
        for (ExtensionMapping m : mappings) {
            if (ext.equals((Object)m.getExtension())) continue;
            throw new IllegalArgumentException("All mappings for a single data file need to be mapped to the same extension: " + ext.getRowType());
        }
        ArchiveFile af = ArchiveFile.buildTabFile();
        af.setRowType(TERM_FACTORY.findTerm(ext.getRowType()));
        af.setEncoding(CHARACTER_ENCODING);
        af.setDateFormat("YYYY-MM-DD");
        ArchiveField idField = new ArchiveField();
        idField.setIndex(Integer.valueOf(0));
        af.setId(idField);
        Set mappedConceptTerms = this.addFieldsToArchive(mappings, af);
        List propertyList = this.getOrderedMappedExtensionProperties(ext, mappedConceptTerms);
        this.assignIndexesOrderedByExtension(propertyList, af);
        int totalColumns = 1 + propertyList.size();
        String extensionName = ext.getName() == null ? "f" : ext.getName().toLowerCase().replaceAll("\\s", "_");
        String fn = this.createFileName(this.dwcaFolder, extensionName);
        File dataFile = new File(this.dwcaFolder, fn);
        try (Writer writer = org.gbif.utils.file.FileUtils.startNewUtf8File((File)dataFile);){
            af.addLocation(dataFile.getName());
            this.addMessage(Level.INFO, "Start writing data file for " + this.currExtension);
            boolean headerWritten = false;
            for (ExtensionMapping m : mappings) {
                PropertyMapping[] inCols = new PropertyMapping[totalColumns];
                for (ArchiveField f : af.getFields().values()) {
                    if (f.getIndex() == null || f.getIndex() <= 0) continue;
                    inCols[f.getIndex().intValue()] = m.getField(f.getTerm().qualifiedName());
                }
                if (!headerWritten) {
                    this.writeHeaderLine(propertyList, totalColumns, af, writer);
                    headerWritten = true;
                }
                this.dumpData(writer, inCols, m, totalColumns, rowLimit, this.resource.getDoi());
                this.recordsByExtension.put(ext.getRowType(), this.currRecords);
            }
        }
        catch (IOException e) {
            this.log.error("Fatal DwC-A Generator Error encountered while writing header line to data file", (Throwable)e);
            this.setState((Exception)e);
            throw new GeneratorException("Error writing header line to data file", (Throwable)e);
        }
        if (this.resource.getCoreRowType() != null && this.resource.getCoreRowType().equalsIgnoreCase(ext.getRowType())) {
            this.archive.setCore(af);
        } else {
            this.archive.addExtension(af);
        }
        this.addMessage(Level.INFO, "Data file written for " + this.currExtension + " with " + this.currRecords + " records and " + totalColumns + " columns");
        if (this.currRecordsSkipped > 0) {
            this.addMessage(Level.WARN, "!!! " + this.currRecordsSkipped + " records were skipped for " + this.currExtension + " due to errors interpreting line, or because the line was empty");
        }
    }

    private void writeHeaderLine(List<ExtensionProperty> propertyList, int totalColumns, ArchiveFile af, Writer writer) throws IOException {
        String[] headers = new String[totalColumns];
        headers[0] = ID_COLUMN_NAME;
        int c = 1;
        for (ExtensionProperty property : propertyList) {
            headers[c] = property.simpleName();
            ++c;
        }
        String headerLine = this.tabRow(headers);
        af.setIgnoreHeaderLines(Integer.valueOf(1));
        writer.write(headerLine);
    }

    private void addEmlFile() throws GeneratorException, InterruptedException {
        this.checkForInterruption();
        this.setState(STATE.METADATA);
        try {
            this.addMessage(Level.INFO, "? Validating EML file");
            EmlValidator emlValidator = EmlValidator.newValidator((EMLProfileVersion)EMLProfileVersion.GBIF_1_3);
            try (FileInputStream is = FileUtils.openInputStream((File)this.dataDir.resourceEmlFile(this.resource.getShortname()));){
                emlValidator.validate((InputStream)is);
                this.addMessage(Level.INFO, "\u2713 Validated EML file");
            }
        }
        catch (IOException | SAXException e) {
            this.log.error("Exception caught while validating EML file", (Throwable)e);
            this.addMessage(Level.ERROR, "Failed to validate EML file");
            this.setState(e);
            throw new GeneratorException("Problem occurred while validating DwC-A (EML)", (Throwable)e);
        }
        catch (InvalidEmlException e) {
            this.log.error("Invalid EML", (Throwable)e);
            this.addMessage(Level.ERROR, "Invalid EML file: " + e.getMessage());
        }
        try {
            FileUtils.copyFile((File)this.dataDir.resourceEmlFile(this.resource.getShortname()), (File)new File(this.dwcaFolder, "eml.xml"));
            this.archive.setMetadataLocation("eml.xml");
        }
        catch (IOException e) {
            throw new GeneratorException("Problem occurred while adding EML file to DwC-A folder", (Throwable)e);
        }
        this.addMessage(Level.INFO, "EML file added");
    }

    private ArchiveField buildField(Term term, @Nullable String delimitedBy) {
        ArchiveField f = new ArchiveField();
        f.setTerm(term);
        f.setDefaultValue(null);
        if (delimitedBy != null && term instanceof DwcTerm && DWC_MULTI_VALUE_TERMS.contains(term)) {
            f.setDelimitedBy(delimitedBy);
        }
        return f;
    }

    private void bundleArchive() throws GeneratorException, InterruptedException {
        block8: {
            this.checkForInterruption();
            this.setState(STATE.BUNDLING);
            File zip = null;
            BigDecimal version = this.resource.getEmlVersion();
            try {
                zip = this.dataDir.tmpFile("dwca", ".zip");
                CompressionUtil.zipDir((File)this.dwcaFolder, (File)zip);
                if (zip.exists()) {
                    File versionedFile = this.dataDir.resourceDwcaFile(this.resource.getShortname(), version);
                    if (versionedFile.exists()) {
                        FileUtils.forceDelete((File)versionedFile);
                    }
                    FileUtils.moveFile((File)zip, (File)versionedFile);
                    break block8;
                }
                throw new GeneratorException("Archive bundling failed: temp archive not created: " + zip.getAbsolutePath());
            }
            catch (IOException e) {
                throw new GeneratorException("Problem occurred while bundling DwC-A", (Throwable)e);
            }
            finally {
                if (zip != null && zip.exists()) {
                    FileUtils.deleteQuietly((File)zip);
                }
            }
        }
        this.addMessage(Level.INFO, "Archive has been compressed");
    }

    private void validate() throws GeneratorException, InterruptedException {
        this.checkForInterruption();
        this.setState(STATE.VALIDATING);
        try {
            Archive arch = DwcFiles.fromLocation((Path)this.dwcaFolder.toPath());
            this.loadBasisOfRecordMapFromVocabulary();
            this.validateCoreDataFile(arch.getCore(), !arch.getExtensions().isEmpty());
            if (this.isEventCore(arch)) {
                this.validateEventCore(arch);
            }
            if (!arch.getExtensions().isEmpty()) {
                this.validateExtensionDataFiles(arch.getExtensions());
            }
        }
        catch (IOException e) {
            throw new GeneratorException("Problem occurred while validating DwC-A", (Throwable)e);
        }
        this.addMessage(Level.INFO, "\u2713 Archive validated");
    }

    private File sortCoreDataFile(ArchiveFile file, int column) throws IOException {
        File unsorted = (File)file.getLocationFiles().get(0);
        File sorted = new File(unsorted.getParentFile(), SORTED_FILE_PREFIX + unsorted.getName());
        int headerLines = file.getIgnoreHeaderLines();
        String columnDelimiter = file.getFieldsTerminatedBy();
        Character enclosedBy = file.getFieldsEnclosedBy();
        String newlineDelimiter = file.getLinesTerminatedBy();
        long time = System.currentTimeMillis();
        LineComparator lineComparator = new LineComparator(column, columnDelimiter, enclosedBy, IGNORE_CASE_COMPARATOR);
        GBIF_FILE_UTILS.sort(unsorted, sorted, CHARACTER_ENCODING, column, columnDelimiter, enclosedBy, newlineDelimiter, headerLines, (Comparator)lineComparator, true);
        this.log.debug("Finished sorting file " + unsorted.getAbsolutePath() + " in " + (System.currentTimeMillis() - time) / 1000L + " secs, check: " + String.valueOf(sorted.getAbsoluteFile()));
        return sorted;
    }

    private void validateExtensionDataFiles(Set<ArchiveFile> extensions) throws InterruptedException, GeneratorException, IOException {
        for (ArchiveFile extension : extensions) {
            this.validateExtensionDataFile(extension);
        }
    }

    private void loadBasisOfRecordMapFromVocabulary() {
        if (this.basisOfRecords == null || this.basisOfRecordsSnakeCase == null) {
            this.basisOfRecords = new HashMap();
            this.basisOfRecordsSnakeCase = new HashMap();
            Map basisOfRecordsVocab = this.vocabManager.getI18nVocab("http://rs.tdwg.org/dwc/dwctype/", Locale.ENGLISH.getLanguage(), false);
            this.basisOfRecords = MapUtils.getMapWithLowercaseKeys((Map)basisOfRecordsVocab);
            this.basisOfRecordsSnakeCase = MapUtils.getMapWithSnakecaseKeys((Map)basisOfRecordsVocab);
        }
    }

    private void validateExtensionDataFile(ArchiveFile extFile) throws GeneratorException, InterruptedException, IOException {
        Objects.requireNonNull(this.resource.getCoreRowType());
        this.addMessage(Level.INFO, "Validating the extension file: " + extFile.getTitle() + ". Depending on the number of records, this can take a while.");
        Term id = TERM_FACTORY.findTerm(AppConfig.coreIdTerm((String)this.resource.getCoreRowType()));
        Term occurrenceId = TERM_FACTORY.findTerm("http://rs.tdwg.org/dwc/terms/occurrenceID");
        Term basisOfRecord = TERM_FACTORY.findTerm("http://rs.tdwg.org/dwc/terms/basisOfRecord");
        int basisOfRecordIndex = -1;
        if (this.isOccurrenceFile(extFile)) {
            if (!extFile.hasTerm(basisOfRecord)) {
                this.addMessage(Level.ERROR, "Archive validation failed, because required term basisOfRecord was not mapped in the occurrence extension data file: " + extFile.getTitle());
                throw new GeneratorException("Can't validate DwC-A for resource " + this.resource.getShortname() + "Required term basisOfRecord was not mapped in the occurrence extension data file: " + extFile.getTitle());
            }
            this.addMessage(Level.INFO, "? Validating the basisOfRecord in the occurrence extension data file is always present and its value matches the Darwin Core Type Vocabulary.");
            if (extFile.hasTerm(occurrenceId)) {
                this.addMessage(Level.INFO, "? Validating the occurrenceId in occurrence extension data file is always present and unique. ");
            } else {
                this.addMessage(Level.WARN, "No occurrenceId found in occurrence extension. To be indexed by GBIF, each occurrence record within a resource must have a unique record level identifier.");
            }
            basisOfRecordIndex = extFile.getField(basisOfRecord).getIndex();
        }
        if (extFile.getId() == null) {
            this.addMessage(Level.ERROR, "Archive validation failed, because the ID field " + id.simpleName() + "was not mapped in the extension data file: " + extFile.getTitle());
            throw new GeneratorException("Can't validate DwC-A for resource " + this.resource.getShortname() + ". The ID field was not mapped in the extension data file: " + extFile.getTitle());
        }
        this.addMessage(Level.INFO, "? Validating the ID field " + id.simpleName() + " is always present in extension data file. ");
        int sortColumnIndex = extFile.hasTerm(occurrenceId) && extFile.getField(occurrenceId).getIndex() != null ? extFile.getField(occurrenceId).getIndex() : 0;
        File sortedFile = this.sortCoreDataFile(extFile, sortColumnIndex);
        int recordsWithNoId = 0;
        AtomicInteger recordsWithNoOccurrenceId = new AtomicInteger(0);
        AtomicInteger recordsWithDuplicateOccurrenceId = new AtomicInteger(0);
        AtomicInteger recordsWithNoBasisOfRecord = new AtomicInteger(0);
        AtomicInteger recordsWithNonMatchingBasisOfRecord = new AtomicInteger(0);
        AtomicInteger recordsWithAmbiguousBasisOfRecord = new AtomicInteger(0);
        this.currRecords = 0;
        this.currRecordsSkipped = 0;
        this.currExtension = extFile.getTitle();
        CSVReader reader = CSVReaderFactory.build((File)sortedFile, (String)CHARACTER_ENCODING, (String)extFile.getFieldsTerminatedBy(), (Character)extFile.getFieldsEnclosedBy(), (Integer)extFile.getIgnoreHeaderLines());
        String lastId = null;
        try {
            while (reader.hasNext()) {
                String[] record;
                ++this.currRecords;
                if (this.currRecords % 1000 == 0) {
                    this.checkForInterruption(this.currRecords);
                    this.reportIfNeeded();
                }
                if ((record = reader.next()) == null || record.length == 0) continue;
                if (reader.hasRowError() && reader.getException() != null) {
                    throw new GeneratorException("A fatal error was encountered while trying to validate sorted extension data file: " + reader.getErrorMessage(), (Throwable)reader.getException());
                }
                if (StringUtils.isBlank((CharSequence)record[0])) {
                    ++recordsWithNoId;
                }
                if (!this.isOccurrenceFile(extFile)) continue;
                if (extFile.hasTerm(occurrenceId)) {
                    lastId = this.validateIdentifier(record[sortColumnIndex], lastId, recordsWithNoOccurrenceId, recordsWithDuplicateOccurrenceId);
                }
                this.validateBasisOfRecord(record[basisOfRecordIndex], this.currRecords, recordsWithNoBasisOfRecord, recordsWithNonMatchingBasisOfRecord, recordsWithAmbiguousBasisOfRecord);
            }
        }
        catch (InterruptedException e) {
            this.setState((Exception)e);
            throw e;
        }
        catch (Exception e) {
            this.log.error("Exception caught while validating extension file", (Throwable)e);
            this.setState(e);
            throw new GeneratorException("Error while validating extension file occurred on line " + this.currRecords, (Throwable)e);
        }
        finally {
            if (!reader.hasRowError() && reader.getErrorMessage() != null) {
                this.writePublicationLogMessage("Error reading data: " + reader.getErrorMessage());
            }
            reader.close();
            FileUtils.deleteQuietly((File)sortedFile);
        }
        if (recordsWithNoId > 0) {
            this.addMessage(Level.ERROR, recordsWithNoId + " line(s) in extension missing an ID " + id.simpleName() + ", which is required when linking the extension record and core record together");
            throw new GeneratorException("Can't validate DwC-A for resource " + this.resource.getShortname() + ". Each line in extension must have an ID " + id.simpleName() + ", which is required in order to link the extension to the core ");
        }
        this.addMessage(Level.INFO, "\u2713 Validated each line in extension has an ID " + id.simpleName());
        this.writePublicationLogMessage("No lines in extension are missing an ID " + id.simpleName());
        if (this.isOccurrenceFile(extFile)) {
            if (extFile.hasTerm(occurrenceId)) {
                this.summarizeIdentifierValidation(recordsWithNoOccurrenceId, recordsWithDuplicateOccurrenceId, occurrenceId.simpleName());
            }
            this.summarizeBasisOfRecordValidation(recordsWithNoBasisOfRecord, recordsWithNonMatchingBasisOfRecord, recordsWithAmbiguousBasisOfRecord);
        }
    }

    private void validateCoreDataFile(ArchiveFile coreFile, boolean archiveHasExtensions) throws GeneratorException, InterruptedException, IOException {
        Objects.requireNonNull(this.resource.getCoreRowType());
        this.addMessage(Level.INFO, "Validating the core file: " + coreFile.getTitle() + ". Depending on the number of records, this can take a while.");
        Term id = TERM_FACTORY.findTerm(AppConfig.coreIdTerm((String)this.resource.getCoreRowType()));
        Term basisOfRecord = TERM_FACTORY.findTerm("http://rs.tdwg.org/dwc/terms/basisOfRecord");
        int basisOfRecordIndex = -1;
        if (this.isOccurrenceFile(coreFile)) {
            if (!coreFile.hasTerm(basisOfRecord)) {
                this.addMessage(Level.ERROR, "Archive validation failed, because required term basisOfRecord was not mapped in the occurrence core");
                throw new GeneratorException("Can't validate DwC-A for resource " + this.resource.getShortname() + ". Required term basisOfRecord was not mapped in the occurrence core");
            }
            this.addMessage(Level.INFO, "? Validating the core basisOfRecord is always present and its value matches the Darwin Core Type Vocabulary.");
            basisOfRecordIndex = coreFile.getField(basisOfRecord).getIndex();
        }
        if (coreFile.hasTerm(id) || archiveHasExtensions) {
            String msg = "? Validating the core ID field " + id.simpleName() + " is always present and unique.";
            if (archiveHasExtensions) {
                msg = msg + " Note: the core ID field is required to link core records and extension records together. ";
            }
            this.addMessage(Level.INFO, msg);
        }
        if (!coreFile.hasTerm(id)) {
            this.addMessage(Level.WARN, coreFile.getTitle() + " does not have the core ID field " + id.simpleName() + ". The data cannot be indexed on GBIF.");
        }
        this.currRecords = 0;
        this.currRecordsSkipped = 0;
        this.currExtension = coreFile.getTitle();
        File sortedCore = this.sortCoreDataFile(coreFile, 0);
        CSVReader reader = CSVReaderFactory.build((File)sortedCore, (String)CHARACTER_ENCODING, (String)coreFile.getFieldsTerminatedBy(), (Character)coreFile.getFieldsEnclosedBy(), (Integer)coreFile.getIgnoreHeaderLines());
        AtomicInteger recordsWithNoId = new AtomicInteger(0);
        AtomicInteger recordsWithDuplicateId = new AtomicInteger(0);
        AtomicInteger recordsWithNoBasisOfRecord = new AtomicInteger(0);
        AtomicInteger recordsWithNonMatchingBasisOfRecord = new AtomicInteger(0);
        AtomicInteger recordsWithAmbiguousBasisOfRecord = new AtomicInteger(0);
        String lastId = null;
        try {
            while (reader.hasNext()) {
                String[] record;
                ++this.currRecords;
                if (this.currRecords % 1000 == 0) {
                    this.checkForInterruption(this.currRecords);
                    this.reportIfNeeded();
                }
                if ((record = reader.next()) == null || record.length == 0) continue;
                if (reader.hasRowError() && reader.getException() != null) {
                    throw new GeneratorException("A fatal error was encountered while trying to validate sorted core data file: " + reader.getErrorMessage(), (Throwable)reader.getException());
                }
                if (coreFile.hasTerm(id) || archiveHasExtensions) {
                    lastId = this.validateIdentifier(record[0], lastId, recordsWithNoId, recordsWithDuplicateId);
                }
                if (!this.isOccurrenceFile(coreFile)) continue;
                this.validateBasisOfRecord(record[basisOfRecordIndex], this.currRecords, recordsWithNoBasisOfRecord, recordsWithNonMatchingBasisOfRecord, recordsWithAmbiguousBasisOfRecord);
            }
        }
        catch (InterruptedException e) {
            this.setState((Exception)e);
            throw e;
        }
        catch (Exception e) {
            this.log.error("Exception caught while validating archive", (Throwable)e);
            this.setState(e);
            throw new GeneratorException("Error while validating archive occurred on line " + this.currRecords, (Throwable)e);
        }
        finally {
            if (!reader.hasRowError() && reader.getErrorMessage() != null) {
                this.writePublicationLogMessage("Error reading data: " + reader.getErrorMessage());
            }
            reader.close();
            FileUtils.deleteQuietly((File)sortedCore);
        }
        if (coreFile.hasTerm(id) || archiveHasExtensions) {
            this.summarizeIdentifierValidation(recordsWithNoId, recordsWithDuplicateId, id.simpleName());
        }
        if (this.isOccurrenceFile(coreFile)) {
            this.summarizeBasisOfRecordValidation(recordsWithNoBasisOfRecord, recordsWithNonMatchingBasisOfRecord, recordsWithAmbiguousBasisOfRecord);
        }
    }

    private String validateIdentifier(String id, String lastId, AtomicInteger recordsWithNoId, AtomicInteger recordsWithDuplicateId) {
        if (StringUtils.isBlank((CharSequence)id)) {
            recordsWithNoId.getAndIncrement();
        }
        if (StringUtils.isNotBlank((CharSequence)lastId) && StringUtils.isNotBlank((CharSequence)id) && id.equalsIgnoreCase(lastId)) {
            this.writePublicationLogMessage("Duplicate id found: " + id);
            recordsWithDuplicateId.getAndIncrement();
        }
        return id;
    }

    private void validateBasisOfRecord(String bor, int line, AtomicInteger recordsWithNoBasisOfRecord, AtomicInteger recordsWithNonMatchingBasisOfRecord, AtomicInteger recordsWithAmbiguousBasisOfRecord) {
        if (StringUtils.isBlank((CharSequence)bor)) {
            recordsWithNoBasisOfRecord.getAndIncrement();
        } else if (!this.basisOfRecords.containsKey(bor.toLowerCase()) && !this.basisOfRecordsSnakeCase.containsKey(bor.toLowerCase())) {
            this.writePublicationLogMessage("Line #" + line + " has basisOfRecord [" + bor + "] that does not match the Darwin Core Type Vocabulary");
            recordsWithNonMatchingBasisOfRecord.getAndIncrement();
        } else if (bor.equalsIgnoreCase("occurrence")) {
            recordsWithAmbiguousBasisOfRecord.getAndIncrement();
        }
    }

    private void validateEventCore(Archive arch) throws GeneratorException {
        boolean validEventCore = true;
        ArchiveFile occurrenceExtension = arch.getExtension((Term)DwcTerm.Occurrence);
        if (occurrenceExtension == null) {
            validEventCore = false;
        } else if (!occurrenceExtension.iterator().hasNext()) {
            validEventCore = false;
        }
        if (!validEventCore) {
            this.addMessage(Level.WARN, "The sampling event resource has no associated occurrences.");
        }
    }

    private void summarizeBasisOfRecordValidation(AtomicInteger recordsWithNoBasisOfRecord, AtomicInteger recordsWithNonMatchingBasisOfRecord, AtomicInteger recordsWithAmbiguousBasisOfRecord) throws GeneratorException {
        if (recordsWithNoBasisOfRecord.get() > 0) {
            this.addMessage(Level.ERROR, String.valueOf(recordsWithNoBasisOfRecord) + " line(s) are missing a basisOfRecord");
        } else {
            this.writePublicationLogMessage("No lines are missing a basisOfRecord");
        }
        if (recordsWithNonMatchingBasisOfRecord.get() > 0) {
            this.addMessage(Level.ERROR, String.valueOf(recordsWithNonMatchingBasisOfRecord) + " line(s) have basisOfRecord that does not match the Darwin Core Type Vocabulary (please note comparisons are case insensitive)");
        } else {
            this.writePublicationLogMessage("All lines have basisOfRecord that matches the Darwin Core Type Vocabulary");
        }
        if (recordsWithAmbiguousBasisOfRecord.get() > 0) {
            this.addMessage(Level.WARN, String.valueOf(recordsWithAmbiguousBasisOfRecord) + " line(s) use ambiguous basisOfRecord 'occurrence'. It is advised that occurrence be reserved for cases when the basisOfRecord is unknown. Otherwise, a more specific basisOfRecord should be chosen.");
        } else {
            this.writePublicationLogMessage("No lines have ambiguous basisOfRecord 'occurrence'.");
        }
        if (recordsWithNoBasisOfRecord.get() != 0 || recordsWithNonMatchingBasisOfRecord.get() != 0) {
            this.addMessage(Level.ERROR, "Archive validation failed, because not every row in the occurrence file(s) has a valid basisOfRecord (please note all basisOfRecord must match Darwin Core Type Vocabulary, and comparisons are case insensitive)");
            throw new GeneratorException("Can't validate DwC-A for resource " + this.resource.getShortname() + ". Each row in the occurrence file(s) must have a basisOfRecord, and each basisOfRecord must match the Darwin Core Type Vocabulary (please note comparisons are case insensitive)");
        }
        this.addMessage(Level.INFO, "\u2713 Validated each line has a basisOfRecord, and each basisOfRecord matches the Darwin Core Type Vocabulary");
    }

    private void summarizeIdentifierValidation(AtomicInteger recordsWithNoId, AtomicInteger recordsWithDuplicateId, String term) throws GeneratorException {
        if (recordsWithNoId.get() > 0) {
            this.addMessage(Level.ERROR, String.valueOf(recordsWithNoId) + " line(s) missing " + term);
        } else {
            this.writePublicationLogMessage("No lines are missing " + term);
        }
        if (recordsWithDuplicateId.get() > 0) {
            this.addMessage(Level.ERROR, String.valueOf(recordsWithDuplicateId) + " line(s) having a duplicate " + term + " (please note comparisons are case insensitive)");
        } else {
            this.writePublicationLogMessage("No lines have duplicate " + term);
        }
        if (recordsWithNoId.get() != 0 || recordsWithDuplicateId.get() != 0) {
            this.addMessage(Level.ERROR, "Archive validation failed, because not every line has a unique " + term + " (please note comparisons are case insensitive)");
            throw new GeneratorException("Can't validate DwC-A for resource " + this.resource.getShortname() + ". Each line must have a " + term + ", and each " + term + " must be unique (please note comparisons are case insensitive)");
        }
        this.addMessage(Level.INFO, "\u2713 Validated each line has a " + term + ", and each " + term + " is unique");
    }

    private boolean isOccurrenceFile(ArchiveFile archiveFile) {
        return archiveFile.getRowType().equals(DwcTerm.Occurrence);
    }

    private boolean isEventCore(Archive arch) {
        return arch.getCore().getRowType().equals(DwcTerm.Event);
    }

    @Override
    public Map<String, Integer> call() throws Exception {
        try {
            this.checkForInterruption();
            this.setState(STATE.STARTED);
            this.addMessage(Level.INFO, "Archive generation started for version #" + String.valueOf(this.resource.getEmlVersion()));
            this.dwcaFolder = this.dataDir.tmpDir();
            this.archive = new Archive();
            this.createDataFiles();
            this.addEmlFile();
            this.createMetaFile();
            this.validate();
            this.bundleArchive();
            this.addMessage(Level.INFO, "Archive version #" + String.valueOf(this.resource.getEmlVersion()) + " generated successfully!");
            this.setState(STATE.COMPLETED);
            Map map = this.recordsByExtension;
            return map;
        }
        catch (GeneratorException e) {
            this.setState((Exception)((Object)e));
            if (this.cfg.debug()) {
                this.writeFailureToPublicationLog((Throwable)e);
            } else {
                this.log.error("Exception occurred trying to generate Darwin Core Archive for resource " + this.resource.getTitleAndShortname() + ": " + e.getMessage(), (Throwable)e);
            }
            throw e;
        }
        catch (InterruptedException e) {
            this.setState((Exception)e);
            this.writeFailureToPublicationLog((Throwable)e);
            throw e;
        }
        catch (Exception e) {
            this.setState(e);
            this.writeFailureToPublicationLog((Throwable)e);
            throw new GeneratorException((Throwable)e);
        }
        finally {
            if (this.dwcaFolder != null && this.dwcaFolder.exists()) {
                FileUtils.deleteQuietly((File)this.dwcaFolder);
            }
            this.closePublicationLogWriter();
        }
    }

    private void checkForInterruption() throws InterruptedException {
        if (Thread.interrupted()) {
            StatusReport report = this.report();
            String msg = "Interrupting dwca generator. Last status: " + report.getState();
            this.log.info(msg);
            throw new InterruptedException(msg);
        }
    }

    private void checkForInterruption(int line) throws InterruptedException {
        if (Thread.interrupted()) {
            StatusReport report = this.report();
            String msg = "Interrupting dwca generator at line " + line + ". Last status: " + report.getState();
            this.log.info(msg);
            throw new InterruptedException(msg);
        }
    }

    protected boolean completed() {
        return STATE.COMPLETED == this.state;
    }

    private void createDataFiles() throws GeneratorException, InterruptedException {
        this.checkForInterruption();
        this.setState(STATE.DATAFILES);
        if (!this.resource.hasCore() || this.resource.getCoreRowType() == null || ((ExtensionMapping)this.resource.getCoreMappings().get(0)).getSource() == null) {
            throw new GeneratorException("Core is not mapped");
        }
        for (Extension ext : this.resource.getMappedExtensions()) {
            this.report();
            try {
                this.addDataFile(this.resource.getMappings(ext.getRowType()), null);
            }
            catch (IOException | IllegalArgumentException e) {
                throw new GeneratorException("Problem occurred while writing data file", (Throwable)e);
            }
        }
        this.addMessage(Level.INFO, "All data files completed");
        this.report();
    }

    private void createMetaFile() throws GeneratorException, InterruptedException {
        this.checkForInterruption();
        this.setState(STATE.METADATA);
        try {
            MetaDescriptorWriter.writeMetaFile((File)new File(this.dwcaFolder, "meta.xml"), (Archive)this.archive);
        }
        catch (IOException e) {
            throw new GeneratorException("Meta.xml file could not be written", (Throwable)e);
        }
        this.addMessage(Level.INFO, "meta.xml archive descriptor written");
    }

    protected Exception currentException() {
        return this.exception;
    }

    protected String currentState() {
        switch (1.$SwitchMap$org$gbif$ipt$task$GenerateDwca$STATE[this.state.ordinal()]) {
            case 1: {
                return "Not started yet";
            }
            case 2: {
                return "Starting archive generation";
            }
            case 3: {
                return "Processing record " + this.currRecords + " for data file <em>" + this.currExtension + "</em>";
            }
            case 4: {
                return "Creating metadata files";
            }
            case 5: {
                return "Compressing archive";
            }
            case 6: {
                return "Archive generated!";
            }
            case 7: {
                return "Validating archive, " + this.currRecords + " for data file <em>" + this.currExtension + "</em>";
            }
            case 8: {
                return "Archiving version of archive";
            }
            case 9: {
                return CANCELLED_STATE_MSG;
            }
            case 10: {
                return "Failed. Fatal error!";
            }
        }
        return "You should never see this";
    }

    private void dumpData(Writer writer, PropertyMapping[] inCols, ExtensionMapping mapping, int dataFileRowSize, @Nullable Integer rowLimit, @Nullable DOI doi) throws GeneratorException, InterruptedException {
        String idSuffix = StringUtils.trimToEmpty((String)mapping.getIdSuffix());
        RecordFilter filter = mapping.getFilter();
        int maxColumnIndex = mapping.getIdColumn() == null ? -1 : mapping.getIdColumn();
        for (PropertyMapping pm : mapping.getFields()) {
            if (pm.getIndex() == null || maxColumnIndex >= pm.getIndex()) continue;
            maxColumnIndex = pm.getIndex();
        }
        int recordsWithError = 0;
        int linesWithWrongColumnNumber = 0;
        int recordsFiltered = 0;
        int emptyLines = 0;
        ClosableReportingIterator iter = null;
        int line = 0;
        try {
            iter = this.sourceManager.rowIterator(mapping.getSource());
            while (iter.hasNext()) {
                String newRow;
                String[] in;
                if (++line % 1000 == 0) {
                    this.checkForInterruption(line);
                    this.reportIfNeeded();
                }
                if ((in = (String[])iter.next()) == null || in.length == 0) continue;
                if (iter.hasRowError()) {
                    this.writePublicationLogMessage("Error reading line #" + line + "\n" + iter.getErrorMessage());
                    ++recordsWithError;
                    ++this.currRecordsSkipped;
                    continue;
                }
                if (this.isEmptyLine(in)) {
                    this.writePublicationLogMessage("Empty line was skipped. SourceBase:" + mapping.getSource().getName() + " Line #" + line + ": " + this.printLine(in));
                    ++emptyLines;
                    ++this.currRecordsSkipped;
                    continue;
                }
                if (in.length <= maxColumnIndex) {
                    this.writePublicationLogMessage("Line with fewer columns than mapped. SourceBase:" + mapping.getSource().getName() + " Line #" + line + " has " + in.length + " Columns: " + this.printLine(in));
                    String[] in2 = new String[maxColumnIndex + 1];
                    System.arraycopy(in, 0, in2, 0, in.length);
                    in = in2;
                    ++linesWithWrongColumnNumber;
                }
                String[] record = new String[dataFileRowSize];
                boolean alreadyTranslated = false;
                if (filter != null && filter.getColumn() != null && filter.getComparator() != null && filter.getParam() != null) {
                    boolean matchesFilter;
                    if (filter.getFilterTime() == RecordFilter.FilterTime.AfterTranslation) {
                        this.applyTranslations(inCols, in, record, mapping.isDoiUsedForDatasetId(), doi);
                        matchesFilter = filter.matches(in);
                        alreadyTranslated = true;
                    } else {
                        matchesFilter = filter.matches(in);
                    }
                    if (!matchesFilter) {
                        this.writePublicationLogMessage("Line did not match the filter criteria and was skipped. SourceBase:" + mapping.getSource().getName() + " Line #" + line + ": " + this.printLine(in));
                        ++recordsFiltered;
                        continue;
                    }
                }
                if (mapping.getIdColumn() == null) {
                    record[0] = null;
                } else if (mapping.getIdColumn().equals(ExtensionMapping.IDGEN_LINE_NUMBER)) {
                    record[0] = line + idSuffix;
                } else if (mapping.getIdColumn().equals(ExtensionMapping.IDGEN_UUID)) {
                    record[0] = UUID.randomUUID().toString();
                } else if (mapping.getIdColumn() >= 0) {
                    String string = record[0] = StringUtils.isBlank((CharSequence)in[mapping.getIdColumn()]) ? idSuffix : in[mapping.getIdColumn()] + idSuffix;
                }
                if (!alreadyTranslated) {
                    this.applyTranslations(inCols, in, record, mapping.isDoiUsedForDatasetId(), doi);
                }
                if ((newRow = this.tabRow(record)) == null) continue;
                writer.write(newRow);
                ++this.currRecords;
                if (rowLimit == null || this.currRecords < rowLimit) continue;
                break;
            }
        }
        catch (InterruptedException e) {
            this.setState((Exception)e);
            throw e;
        }
        catch (Exception e) {
            this.log.error("Fatal DwC-A Generator Error encountered", (Throwable)e);
            this.setState(e);
            throw new GeneratorException("Error writing data file for mapping " + mapping.getExtension().getTitle() + " in source " + mapping.getSource().getName() + ", line " + line, (Throwable)e);
        }
        finally {
            if (iter != null) {
                if (!iter.hasRowError() && iter.getErrorMessage() != null) {
                    this.writePublicationLogMessage("Error reading data: " + iter.getErrorMessage());
                }
                try {
                    iter.close();
                }
                catch (Exception e) {
                    this.log.error("Error while closing iterator", (Throwable)e);
                }
            }
        }
        String mp = " for mapping " + mapping.getExtension().getTitle() + " in source " + mapping.getSource().getName();
        if (recordsWithError > 0) {
            this.addMessage(Level.WARN, recordsWithError + " record(s) skipped due to errors" + mp);
        } else {
            this.writePublicationLogMessage("No lines were skipped due to errors" + mp);
        }
        if (emptyLines > 0) {
            this.addMessage(Level.WARN, emptyLines + " empty line(s) skipped" + mp);
        } else {
            this.writePublicationLogMessage("No lines were skipped due to errors" + mp);
        }
        if (linesWithWrongColumnNumber > 0) {
            this.addMessage(Level.WARN, linesWithWrongColumnNumber + " line(s) with fewer columns than mapped" + mp);
        } else {
            this.writePublicationLogMessage("No lines with fewer columns than mapped" + mp);
        }
        if (recordsFiltered > 0) {
            this.addMessage(Level.INFO, recordsFiltered + " line(s) did not match the filter criteria and got skipped " + mp);
        } else {
            this.writePublicationLogMessage("All lines match the filter criteria" + mp);
        }
    }

    private void setState(Exception e) {
        this.exception = e;
        this.state = this.exception instanceof InterruptedException ? STATE.CANCELLED : STATE.FAILED;
        this.report();
    }

    private void setState(STATE s) {
        this.state = s;
        this.report();
    }

    protected String tabRow(String[] columns) {
        Objects.requireNonNull(columns);
        boolean empty = true;
        for (int i = 0; i < columns.length; ++i) {
            if (columns[i] == null) continue;
            empty = false;
            columns[i] = StringUtils.trimToNull((String)escapeChars.matcher(columns[i]).replaceAll(" "));
        }
        if (empty) {
            return null;
        }
        return StringUtils.join((Object[])columns, (char)'\t') + "\n";
    }

    private void applyTranslations(PropertyMapping[] inCols, String[] in, String[] record, boolean doiUsedForDatasetId, DOI doi) {
        for (int i = 1; i < inCols.length; ++i) {
            PropertyMapping pm = inCols[i];
            String val = null;
            if (pm != null) {
                if (pm.getIndex() != null) {
                    val = in[pm.getIndex()];
                    if (pm.getTranslation() != null && pm.getTranslation().containsKey(val)) {
                        in[pm.getIndex().intValue()] = val = (String)pm.getTranslation().get(val);
                    }
                }
                if (val == null) {
                    val = pm.getDefaultValue();
                }
                if (pm.getTerm().qualifiedName().equalsIgnoreCase("http://rs.tdwg.org/dwc/terms/datasetID") && doiUsedForDatasetId && doi != null) {
                    val = doi.getDoiString();
                }
            }
            record[i] = val;
        }
    }

    private String printLine(String[] in) {
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        for (int i = 0; i < in.length; ++i) {
            sb.append(in[i]);
            if (i == in.length - 1) continue;
            sb.append("; ");
        }
        sb.append("]");
        return sb.toString();
    }

    private void writeFailureToPublicationLog(Throwable e) {
        StringBuilder sb = new StringBuilder();
        sb.append("Archive generation failed!\n");
        StringWriter sw = new StringWriter();
        e.printStackTrace(new PrintWriter(sw));
        sb.append(sw);
        this.writePublicationLogMessage(sb.toString());
    }

    private Set<Term> addFieldsToArchive(List<ExtensionMapping> mappings, ArchiveFile af) throws GeneratorException {
        HashSet<Term> mappedConceptTerms = new HashSet<Term>();
        for (ExtensionMapping m : mappings) {
            String delimitedBy = StringUtils.trimToNull((String)m.getSource().getMultiValueFieldsDelimitedBy());
            for (PropertyMapping pm : m.getFields()) {
                Term term = TERM_FACTORY.findTerm(pm.getTerm().qualifiedName());
                if (term == null || m.getExtension().getProperty(term) == null) continue;
                if (af.hasTerm(term)) {
                    ArchiveField field = af.getField(term);
                    mappedConceptTerms.add(term);
                    if (field.getDelimitedBy() == null || field.getDelimitedBy().equals(delimitedBy)) continue;
                    throw new GeneratorException("More than one type of multi-value field delimiter is being used in the source files mapped to the " + m.getExtension().getName() + " extension. Please either ensure all source files mapped to this extension use the same delimiter, otherwise just leave the delimiter blank.");
                }
                if ((pm.getIndex() == null || pm.getIndex() < 0) && pm.getIndex() != null) continue;
                this.log.debug("Handling property mapping for term: " + term.qualifiedName() + " (index " + pm.getIndex() + ")");
                af.addField(this.buildField(term, delimitedBy));
                mappedConceptTerms.add(term);
            }
            ExtensionProperty ep = m.getExtension().getProperty(DwcTerm.datasetID.qualifiedName());
            if (ep == null || !m.isDoiUsedForDatasetId()) continue;
            this.log.debug("Detected that resource DOI to be used as value for datasetID mapping..");
            ArchiveField f = this.buildField((Term)DwcTerm.datasetID, null);
            af.addField(f);
            PropertyMapping pm = new PropertyMapping(f);
            pm.setTerm((Term)ep);
            m.getFields().add(pm);
            mappedConceptTerms.add((Term)DwcTerm.datasetID);
        }
        return mappedConceptTerms;
    }

    private void assignIndexesOrderedByExtension(List<ExtensionProperty> propertyList, ArchiveFile af) {
        for (int propertyIndex = 0; propertyIndex < propertyList.size(); ++propertyIndex) {
            ExtensionProperty extensionProperty = propertyList.get(propertyIndex);
            Term term = TERM_FACTORY.findTerm(extensionProperty.getQualname());
            ArchiveField f = af.getField(term);
            if (f != null && f.getIndex() == null) {
                int fieldIndex = propertyIndex + 1;
                f.setIndex(Integer.valueOf(fieldIndex));
                continue;
            }
            this.log.warn("Skipping ExtensionProperty: " + extensionProperty.getQualname());
        }
    }

    private List<ExtensionProperty> getOrderedMappedExtensionProperties(Extension ext, Set<Term> mappedConceptTerms) {
        ArrayList<ExtensionProperty> propertyList = new ArrayList<ExtensionProperty>(ext.getProperties());
        HashSet<String> names = new HashSet<String>();
        for (Term conceptTerm : mappedConceptTerms) {
            names.add(conceptTerm.qualifiedName());
        }
        Iterator iterator = propertyList.iterator();
        while (iterator.hasNext()) {
            ExtensionProperty extensionProperty = (ExtensionProperty)iterator.next();
            if (extensionProperty.qualifiedName() == null || names.contains(extensionProperty.qualifiedName())) continue;
            iterator.remove();
        }
        return propertyList;
    }

    protected String createFileName(File dwcaFolder, String extensionName) {
        String wildcard = extensionName + "*.txt";
        WildcardFileFilter fileFilter = new WildcardFileFilter(wildcard, IOCase.INSENSITIVE);
        File[] files = dwcaFolder.listFiles((FileFilter)fileFilter);
        if (files.length > 0) {
            int max = 1;
            String fileName = null;
            for (File file : files) {
                try {
                    fileName = file.getName();
                    int suffixEndIndex = fileName.indexOf(TEXT_FILE_EXTENSION);
                    String suffix = file.getName().substring(extensionName.length(), suffixEndIndex);
                    int suffixInt = Integer.parseInt(suffix);
                    if (suffixInt < max) continue;
                    max = suffixInt;
                }
                catch (NumberFormatException e) {
                    this.log.debug("No numerical suffix could be parsed from file name: " + StringUtils.trimToEmpty((String)fileName));
                }
            }
            return extensionName + (max + 1) + TEXT_FILE_EXTENSION;
        }
        return extensionName + TEXT_FILE_EXTENSION;
    }

    public void setDwcaFolder(File dwcaFolder) {
        this.dwcaFolder = dwcaFolder;
    }

    public void setArchive(Archive archive) {
        this.archive = archive;
    }

    private boolean isEmptyLine(String[] line) {
        String joined = Arrays.stream(line).filter(Objects::nonNull).collect(Collectors.joining(""));
        return StringUtils.isBlank((CharSequence)joined);
    }

    static {
        IGNORE_CASE_COMPARATOR = Comparator.nullsFirst(String::compareToIgnoreCase);
        HashSet<DwcTerm> dwcTermsInternal = new HashSet<DwcTerm>();
        dwcTermsInternal.add(DwcTerm.recordedBy);
        dwcTermsInternal.add(DwcTerm.preparations);
        dwcTermsInternal.add(DwcTerm.associatedMedia);
        dwcTermsInternal.add(DwcTerm.associatedReferences);
        dwcTermsInternal.add(DwcTerm.associatedSequences);
        dwcTermsInternal.add(DwcTerm.associatedTaxa);
        dwcTermsInternal.add(DwcTerm.otherCatalogNumbers);
        dwcTermsInternal.add(DwcTerm.associatedOccurrences);
        dwcTermsInternal.add(DwcTerm.associatedOrganisms);
        dwcTermsInternal.add(DwcTerm.previousIdentifications);
        dwcTermsInternal.add(DwcTerm.higherGeography);
        dwcTermsInternal.add(DwcTerm.georeferencedBy);
        dwcTermsInternal.add(DwcTerm.georeferenceSources);
        dwcTermsInternal.add(DwcTerm.typeStatus);
        dwcTermsInternal.add(DwcTerm.identifiedBy);
        dwcTermsInternal.add(DwcTerm.identificationReferences);
        dwcTermsInternal.add(DwcTerm.higherClassification);
        dwcTermsInternal.add(DwcTerm.measurementDeterminedBy);
        DWC_MULTI_VALUE_TERMS = Collections.unmodifiableSet(dwcTermsInternal);
    }
}

