/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.ipt.task;

import java.io.File;
import java.io.InputStream;
import java.lang.invoke.CallSite;
import java.math.BigDecimal;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.validation.constraints.NotNull;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.gbif.api.model.common.DOI;
import org.gbif.api.vocabulary.Language;
import org.gbif.common.parsers.LanguageParser;
import org.gbif.common.parsers.core.ParseResult;
import org.gbif.ipt.config.AppConfig;
import org.gbif.ipt.model.Ipt;
import org.gbif.ipt.model.Organisation;
import org.gbif.ipt.model.Resource;
import org.gbif.ipt.model.VersionHistory;
import org.gbif.ipt.service.InvalidConfigException;
import org.gbif.ipt.service.admin.RegistrationManager;
import org.gbif.ipt.service.manage.ResourceManager;
import org.gbif.ipt.task.GenerateDCAT;
import org.gbif.ipt.utils.InputStreamUtils;
import org.gbif.ipt.utils.ResourceUtils;
import org.gbif.metadata.eml.ipt.model.Agent;
import org.gbif.metadata.eml.ipt.model.BBox;
import org.gbif.metadata.eml.ipt.model.Eml;
import org.gbif.metadata.eml.ipt.model.GeospatialCoverage;
import org.gbif.metadata.eml.ipt.model.KeywordSet;

public class GenerateDCAT {
    private static final Logger LOG = LogManager.getLogger(GenerateDCAT.class);
    private static final String DCAT_SETTINGS = "org/gbif/metadata/eml/dcatsettings.properties";
    private static final String PREFIXES_PROPERTIES = "org/gbif/metadata/eml/dcat.properties";
    private static final LanguageParser LANGUAGE_PARSER = LanguageParser.getInstance();
    private static final DateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mmXXX");
    private static final InputStreamUtils streamUtils = new InputStreamUtils();
    private static final String CATALOG_THEME_TITLE_KEY = "catalogThemeTitle";
    private static final String THEME_TAXONOMY_URI_KEY = "themeTaxonomyUri";
    private static final String DATASET_THEME_LABEL_KEY = "datasetThemeLabel";
    private static final String THEME_URI_KEY = "themeUri";
    private static final String LANGUAGE_LINK_KEY = "languageLink";
    private static final String PUBLISHER_BASELINK_KEY = "publisherBaselink";
    private static final String DATASET_BASELINK_KEY = "datasetBaselink";
    private static final String CATALOG_RIGHTS_KEY = "catalogRights";
    private static final String CACHING_TIME_KEY = "cachingTime";
    private final Map<String, String> settings;
    private final Map<String, String> prefixes;
    private String feed = "";
    private long time = 0L;
    private final AppConfig cfg;
    private final RegistrationManager registrationManager;
    private final ResourceManager resourceManager;

    @Inject
    public GenerateDCAT(AppConfig cfg, RegistrationManager registrationManager, ResourceManager resourceManager) {
        this.cfg = cfg;
        this.registrationManager = registrationManager;
        this.resourceManager = resourceManager;
        this.settings = Collections.unmodifiableMap(this.loadDCATSettings());
        this.prefixes = Collections.unmodifiableMap(this.loadDCATPrefixes());
    }

    public String getFeed() {
        long cacheTime;
        try {
            cacheTime = Long.parseLong((String)this.settings.get(CACHING_TIME_KEY));
        }
        catch (NumberFormatException e) {
            throw new InvalidConfigException(InvalidConfigException.TYPE.INVALID_PROPERTIES_FILE, "Invalid caching time in properties file: org/gbif/metadata/eml/dcatsettings.properties");
        }
        long now = System.currentTimeMillis();
        if (now > this.time + cacheTime || this.cfg.devMode()) {
            this.feed = this.createDCATFeed();
            this.time = now;
            LOG.info("Updated DCAT feed");
        }
        return this.feed;
    }

    private String createDCATFeed() {
        StringBuilder feed = new StringBuilder();
        if (!this.prefixes.isEmpty()) {
            feed.append(this.createPrefixesInformation());
            feed.append("\n");
        }
        feed.append(this.createDCATCatalogInformation());
        feed.append("\n");
        HashSet<CallSite> organisations = new HashSet<CallSite>();
        String publisherBaselink = (String)this.settings.get(PUBLISHER_BASELINK_KEY);
        if (this.registrationManager.getHostingOrganisation() != null && publisherBaselink != null) {
            String homepagesStrWithoutBrackets;
            Organisation org = this.registrationManager.getHostingOrganisation();
            String publisher = publisherBaselink + String.valueOf(org.getKey()) + "#Organization";
            String organisation = this.encapsulateObject(publisher, ObjectTypes.RESOURCE) + " a foaf:Agent ; foaf:name \"" + org.getName() + "\"";
            if (org.getHomepageURL() != null && StringUtils.isNotBlank((CharSequence)(homepagesStrWithoutBrackets = StringUtils.substringBetween((String)org.getHomepageURL(), (String)"[", (String)"]")))) {
                String[] homepages = homepagesStrWithoutBrackets.split(",");
                String homepagesStr = Arrays.stream(homepages).map(String::trim).map(h -> this.encapsulateObject(h, ObjectTypes.RESOURCE)).collect(Collectors.joining(" , "));
                organisation = organisation + " ; foaf:homepage " + homepagesStr;
            }
            organisation = organisation + " .";
            organisations.add((CallSite)((Object)organisation));
        }
        HashSet<CallSite> themes = new HashSet<CallSite>();
        String themeUri = (String)this.settings.get(THEME_URI_KEY);
        String datasetThemeLabel = (String)this.settings.get(DATASET_THEME_LABEL_KEY);
        String themeTaxonomyUri = (String)this.settings.get(THEME_TAXONOMY_URI_KEY);
        boolean foundDatasets = false;
        for (Resource resource : this.resourceManager.listPublishedPublicVersions()) {
            if (themeUri == null || datasetThemeLabel == null || themeTaxonomyUri == null || publisherBaselink == null) continue;
            BigDecimal v = resource.getLastPublishedVersionsVersion();
            String shortname = resource.getShortname();
            File versionEmlFile = this.cfg.getDataDir().resourceEmlFile(shortname, v);
            Resource publishedPublicVersion = ResourceUtils.reconstructVersion((BigDecimal)v, (String)resource.getShortname(), (String)resource.getCoreType(), (String)resource.getDataPackageIdentifier(), (DOI)resource.getAssignedDoi(), (Organisation)resource.getOrganisation(), (VersionHistory)resource.findVersionHistory(v), (File)versionEmlFile, (UUID)resource.getKey());
            if (publishedPublicVersion.getEml() == null || publishedPublicVersion.getEml().parseLicenseUrl() == null) continue;
            feed.append(this.createDCATDatasetInformation(publishedPublicVersion));
            feed.append("\n");
            feed.append(this.createDCATDistributionInformation(publishedPublicVersion));
            feed.append("\n");
            foundDatasets = true;
            if (publishedPublicVersion.getOrganisation() != null) {
                String homepagesStrWithoutBrackets;
                String publisher = publisherBaselink + String.valueOf(publishedPublicVersion.getOrganisation().getKey()) + "#Organization";
                String organisation = this.encapsulateObject(publisher, ObjectTypes.RESOURCE) + " a foaf:Agent ; foaf:name \"" + publishedPublicVersion.getOrganisation().getName() + "\"";
                if (publishedPublicVersion.getOrganisation().getHomepageURL() != null && StringUtils.isNotBlank((CharSequence)(homepagesStrWithoutBrackets = StringUtils.substringBetween((String)publishedPublicVersion.getOrganisation().getHomepageURL(), (String)"[", (String)"]")))) {
                    String[] homepages = homepagesStrWithoutBrackets.split(",");
                    String homepagesStr = Arrays.stream(homepages).map(String::trim).map(h -> this.encapsulateObject(h, ObjectTypes.RESOURCE)).collect(Collectors.joining(" , "));
                    organisation = organisation + " ; foaf:homepage " + homepagesStr;
                }
                organisation = organisation + " .";
                organisations.add((CallSite)((Object)organisation));
            }
            themes.add((CallSite)((Object)(this.encapsulateObject(themeUri, ObjectTypes.RESOURCE) + " a skos:Concept ; skos:prefLabel \"" + datasetThemeLabel + "\"@en ; skos:inScheme <" + themeTaxonomyUri + "> .")));
        }
        if (foundDatasets) {
            LOG.debug("Resources appended to DCAT feed.");
        } else {
            feed.append("\n#No published public resources added to DCAT feed, a valid DCAT feed requires at least one!\n");
        }
        for (String string : organisations) {
            feed.append(string);
            feed.append("\n");
        }
        feed.append("\n");
        for (String string : themes) {
            feed.append(string);
            feed.append("\n");
        }
        return feed.toString();
    }

    private Map<String, String> loadDCATSettings() {
        HashMap<String, String> loadedSettings = new HashMap<String, String>();
        try (InputStream configStream = streamUtils.classpathStream(DCAT_SETTINGS);){
            if (configStream == null) {
                LOG.error("Failed to load DCAT settings: org/gbif/metadata/eml/dcatsettings.properties");
            } else {
                Properties properties = new Properties();
                properties.load(configStream);
                for (Map.Entry<Object, Object> entry : properties.entrySet()) {
                    String key = StringUtils.trim((String)((String)entry.getKey()));
                    String value = StringUtils.trim((String)((String)entry.getValue()));
                    if (key != null && value != null) {
                        loadedSettings.put(key, value);
                        continue;
                    }
                    throw new InvalidConfigException(InvalidConfigException.TYPE.INVALID_PROPERTIES_FILE, "Invalid properties file: org/gbif/metadata/eml/dcatsettings.properties");
                }
                LOG.debug("Loaded static DCAT settings: " + String.valueOf(loadedSettings));
            }
        }
        catch (Exception e) {
            LOG.error("Failed to load DCAT settings from: org/gbif/metadata/eml/dcatsettings.properties", (Throwable)e);
        }
        return loadedSettings;
    }

    private Map<String, String> loadDCATPrefixes() {
        HashMap<String, String> prefixes = new HashMap<String, String>();
        InputStreamUtils streamUtils = new InputStreamUtils();
        try (InputStream configStream = streamUtils.classpathStream(PREFIXES_PROPERTIES);){
            if (configStream == null) {
                LOG.error("Could not load DCAT prefixes from file: org/gbif/metadata/eml/dcat.properties");
            } else {
                Properties properties = new Properties();
                properties.load(configStream);
                for (Map.Entry<Object, Object> entry : properties.entrySet()) {
                    String key = StringUtils.trim((String)((String)entry.getKey()));
                    String value = StringUtils.trim((String)((String)entry.getValue()));
                    if (key != null && value != null) {
                        prefixes.put(key, value);
                        continue;
                    }
                    throw new InvalidConfigException(InvalidConfigException.TYPE.INVALID_PROPERTIES_FILE, "Invalid properties file: org/gbif/metadata/eml/dcat.properties");
                }
                LOG.debug("Loaded DCAT prefixes: " + String.valueOf(prefixes));
            }
        }
        catch (Exception e) {
            LOG.error("Exception while loading DCAT prefixes", (Throwable)e);
        }
        return prefixes;
    }

    protected String createPrefixesInformation() {
        StringBuilder prefixBuilder = new StringBuilder();
        for (String pre : this.prefixes.keySet()) {
            prefixBuilder.append("@prefix ");
            prefixBuilder.append(pre);
            prefixBuilder.append(": <");
            prefixBuilder.append((String)this.prefixes.get(pre));
            prefixBuilder.append("> .\n");
        }
        return prefixBuilder.toString();
    }

    protected String createDCATCatalogInformation() {
        StringBuilder catalogBuilder = new StringBuilder();
        ArrayList<CallSite> themeTaxonomies = new ArrayList<CallSite>();
        Ipt ipt = this.registrationManager.getIpt();
        ArrayList<CallSite> uris = new ArrayList<CallSite>();
        Date firstCreation = new Date();
        boolean firstPublishedDatePresent = false;
        Date lastModification = new Date(0L);
        boolean lastPublishedDatePresent = false;
        for (Resource res : this.resourceManager.listPublishedPublicVersions()) {
            if (res.getEml().parseLicenseUrl() == null) continue;
            String uri = this.cfg.getResourceUrl(res.getShortname()) + "#Dataset";
            uris.add((CallSite)((Object)uri));
            if (res.getCreated() != null && res.getCreated().before(firstCreation)) {
                firstCreation = res.getCreated();
                firstPublishedDatePresent = true;
            }
            if (res.getLastPublished() == null || !res.getLastPublished().after(lastModification)) continue;
            lastModification = res.getLastPublished();
            lastPublishedDatePresent = true;
        }
        Object url = this.cfg.getBaseUrl();
        url = (String)url + "#Catalog";
        catalogBuilder.append(this.encapsulateObject((String)url, ObjectTypes.RESOURCE));
        catalogBuilder.append("\n");
        catalogBuilder.append(" a dcat:Catalog");
        String publisherBaselink = (String)this.settings.get(PUBLISHER_BASELINK_KEY);
        if (ipt != null && publisherBaselink != null) {
            String catalogRights;
            this.addPredicateToBuilder(catalogBuilder, "dct:title");
            this.addObjectToBuilder(catalogBuilder, ipt.getName(), ObjectTypes.LITERAL);
            if (ipt.getDescription() != null) {
                this.addPredicateToBuilder(catalogBuilder, "dct:description");
                this.addObjectToBuilder(catalogBuilder, ipt.getDescription(), ObjectTypes.LITERAL);
            } else {
                LOG.debug("IPT description is null");
            }
            this.addPredicateToBuilder(catalogBuilder, "dct:publisher");
            String publisher = publisherBaselink + String.valueOf(ipt.getOrganisationKey()) + "#Organization";
            this.addObjectToBuilder(catalogBuilder, publisher, ObjectTypes.RESOURCE);
            if (!uris.isEmpty()) {
                this.addPredicateToBuilder(catalogBuilder, "dcat:dataset");
                this.addObjectsToBuilder(catalogBuilder, uris, ObjectTypes.RESOURCE);
            }
            if (this.cfg.getBaseUrl() != null) {
                this.addPredicateToBuilder(catalogBuilder, "foaf:homepage");
                this.addObjectToBuilder(catalogBuilder, this.cfg.getBaseUrl(), ObjectTypes.RESOURCE);
            }
            if (firstPublishedDatePresent) {
                this.addPredicateToBuilder(catalogBuilder, "dct:issued");
                this.addObjectToBuilder(catalogBuilder, this.parseToIsoDate(firstCreation), ObjectTypes.LITERAL);
            }
            if (lastPublishedDatePresent) {
                this.addPredicateToBuilder(catalogBuilder, "dct:modified");
                this.addObjectToBuilder(catalogBuilder, this.parseToIsoDate(lastModification), ObjectTypes.LITERAL);
            }
            String string = (String)this.settings.get(THEME_TAXONOMY_URI_KEY);
            String catalogThemeTitle = (String)this.settings.get(CATALOG_THEME_TITLE_KEY);
            if (string != null && catalogThemeTitle != null) {
                this.addPredicateToBuilder(catalogBuilder, "dcat:themeTaxonomy");
                themeTaxonomies.add((CallSite)((Object)(this.encapsulateObject(string, ObjectTypes.RESOURCE) + " a skos:ConceptScheme ; dct:title \"" + catalogThemeTitle + "\"@en .")));
                this.addObjectToBuilder(catalogBuilder, string, ObjectTypes.RESOURCE);
            }
            if ((catalogRights = (String)this.settings.get(CATALOG_RIGHTS_KEY)) != null) {
                this.addPredicateToBuilder(catalogBuilder, "dct:license");
                this.addObjectToBuilder(catalogBuilder, catalogRights, ObjectTypes.RESOURCE);
            }
            if (this.cfg.getLongitude() != null && this.cfg.getLatitude() != null) {
                this.addPredicateToBuilder(catalogBuilder, "dct:spatial");
                String spatial = " a dct:Location ; locn:geometry \"{ \\\"type\\\": \\\"Point\\\", \\\"coordinates\\\": [ " + this.cfg.getLongitude() + "," + this.cfg.getLatitude() + " ] }\" ";
                this.addObjectToBuilder(catalogBuilder, spatial, ObjectTypes.OBJECT);
            } else {
                LOG.debug("No spatial data defined for the IPT");
            }
            Object languageLink = (String)this.settings.get(LANGUAGE_LINK_KEY);
            if (languageLink != null) {
                languageLink = (String)languageLink + "en";
                this.addPredicateToBuilder(catalogBuilder, "dct:language");
                this.addObjectToBuilder(catalogBuilder, (String)languageLink, ObjectTypes.RESOURCE);
            }
        } else {
            LOG.error("IPT has not been registered yet");
        }
        catalogBuilder.append(" .\n");
        catalogBuilder.append("\n");
        for (String string : themeTaxonomies) {
            catalogBuilder.append(string);
            catalogBuilder.append("\n");
        }
        return catalogBuilder.toString();
    }

    protected String createDCATDatasetInformation(Resource resource) {
        String theme;
        StringBuilder datasetBuilder = new StringBuilder();
        Eml eml = resource.getEml();
        String url = this.cfg.getResourceUrl(resource.getShortname()) + "#Dataset";
        datasetBuilder.append(this.encapsulateObject(url, ObjectTypes.RESOURCE));
        datasetBuilder.append("\n");
        datasetBuilder.append("a dcat:Dataset");
        if (eml.getTitle() != null) {
            this.addPredicateToBuilder(datasetBuilder, "dct:title");
            this.addObjectToBuilder(datasetBuilder, eml.getTitle(), ObjectTypes.LITERAL);
        }
        if (eml.getDescription() != null) {
            this.addPredicateToBuilder(datasetBuilder, "dct:description");
            this.addObjectToBuilder(datasetBuilder, eml.getDescription(), ObjectTypes.LITERAL);
        }
        if (!eml.getKeywords().isEmpty()) {
            ArrayList<String> keywords = new ArrayList<String>();
            for (KeywordSet keywordSet : eml.getKeywords()) {
                for (String keyword : keywordSet.getKeywords()) {
                    if (!StringUtils.isNotBlank((CharSequence)keyword) || keywords.contains(keyword)) continue;
                    keywords.add(keyword);
                }
            }
            this.addPredicateToBuilder(datasetBuilder, "dcat:keyword");
            this.addObjectsToBuilder(datasetBuilder, keywords, ObjectTypes.LITERAL);
        }
        if ((theme = (String)this.settings.get(THEME_URI_KEY)) != null) {
            this.addPredicateToBuilder(datasetBuilder, "dcat:theme");
            this.addObjectToBuilder(datasetBuilder, theme, ObjectTypes.RESOURCE);
        }
        for (Agent contact : eml.getContacts()) {
            this.addPredicateToBuilder(datasetBuilder, "dcat:contactPoint");
            String agent = " a vcard:Individual ; vcard:fn \"" + contact.getFullName() + "\"";
            if (contact.getEmail() != null && !contact.getEmail().isEmpty()) {
                agent = agent + "; vcard:hasEmail <mailto:" + (String)contact.getEmail().get(0) + "> ";
            }
            this.addObjectToBuilder(datasetBuilder, agent, ObjectTypes.OBJECT);
        }
        if (resource.getCreated() != null) {
            this.addPredicateToBuilder(datasetBuilder, "dct:issued");
            this.addObjectToBuilder(datasetBuilder, this.parseToIsoDate(resource.getCreated()), ObjectTypes.LITERAL);
        }
        if (resource.getLastPublished() != null) {
            this.addPredicateToBuilder(datasetBuilder, "dct:modified");
            this.addObjectToBuilder(datasetBuilder, this.parseToIsoDate(resource.getLastPublished()), ObjectTypes.LITERAL);
        }
        for (GeospatialCoverage coverage : eml.getGeospatialCoverages()) {
            BBox bb = coverage.getBoundingCoordinates();
            this.addPredicateToBuilder(datasetBuilder, "dct:spatial");
            String spatial = " a dct:Location ; locn:geometry \"{ \\\"type\\\": \\\"Polygon\\\", \\\"coordinates\\\": [ [ [" + bb.getMin().getLongitude() + "," + bb.getMin().getLatitude() + "], [" + bb.getMin().getLongitude() + "," + bb.getMax().getLatitude() + "], [" + bb.getMax().getLongitude() + "," + bb.getMax().getLatitude() + "], [" + bb.getMax().getLongitude() + "," + bb.getMin().getLatitude() + "], [" + bb.getMin().getLongitude() + "," + bb.getMin().getLatitude() + "] ] ] }\" ";
            this.addObjectToBuilder(datasetBuilder, spatial, ObjectTypes.OBJECT);
        }
        if (resource.getLastPublishedVersionsVersion() != null) {
            this.addPredicateToBuilder(datasetBuilder, "adms:versionInfo");
            this.addObjectToBuilder(datasetBuilder, resource.getLastPublishedVersionsVersion().toPlainString(), ObjectTypes.LITERAL);
        }
        if (resource.getLastPublishedVersionsChangeSummary() != null) {
            this.addPredicateToBuilder(datasetBuilder, "adms:versionNotes");
            this.addObjectToBuilder(datasetBuilder, resource.getLastPublishedVersionsChangeSummary(), ObjectTypes.LITERAL);
        }
        String landingPage = this.cfg.getResourceUrl(resource.getShortname());
        this.addPredicateToBuilder(datasetBuilder, "dcat:landingPage");
        this.addObjectToBuilder(datasetBuilder, landingPage, ObjectTypes.RESOURCE);
        if (eml.getHomepageUrl() != null) {
            this.addPredicateToBuilder(datasetBuilder, "foaf:homepage");
            this.addObjectToBuilder(datasetBuilder, eml.getHomepageUrl(), ObjectTypes.RESOURCE);
        }
        String datasetBaselink = (String)this.settings.get(DATASET_BASELINK_KEY);
        if (resource.getKey() != null && datasetBaselink != null) {
            this.addPredicateToBuilder(datasetBuilder, "dct:identifier");
            this.addObjectToBuilder(datasetBuilder, datasetBaselink + String.valueOf(resource.getKey()), ObjectTypes.LITERAL);
        }
        String publisherBaselink = (String)this.settings.get(PUBLISHER_BASELINK_KEY);
        if (resource.getOrganisation() != null && publisherBaselink != null) {
            this.addPredicateToBuilder(datasetBuilder, "dct:publisher");
            String publisherLink = publisherBaselink + String.valueOf(resource.getOrganisation().getKey()) + "#Organization";
            this.addObjectToBuilder(datasetBuilder, publisherLink, ObjectTypes.RESOURCE);
        }
        this.addPredicateToBuilder(datasetBuilder, "dcat:distribution");
        String dist = this.cfg.getResourceArchiveUrl(resource.getShortname());
        this.addObjectToBuilder(datasetBuilder, dist, ObjectTypes.RESOURCE);
        String languageLink = (String)this.settings.get(LANGUAGE_LINK_KEY);
        if (languageLink != null) {
            this.addPredicateToBuilder(datasetBuilder, "dct:language");
            ParseResult result = LANGUAGE_PARSER.parse(eml.getMetadataLanguage());
            String ln = result.isSuccessful() ? languageLink + ((Language)result.getPayload()).getIso2LetterCode().toLowerCase() : languageLink + "en";
            this.addObjectToBuilder(datasetBuilder, ln, ObjectTypes.RESOURCE);
        }
        datasetBuilder.append(" .\n");
        return datasetBuilder.toString();
    }

    protected String createDCATDistributionInformation(Resource resource) {
        Objects.requireNonNull(resource.getEml());
        Objects.requireNonNull(resource.getEml().parseLicenseUrl());
        StringBuilder distributionBuilder = new StringBuilder();
        String url = this.cfg.getResourceArchiveUrl(resource.getShortname());
        distributionBuilder.append(this.encapsulateObject(url, ObjectTypes.RESOURCE));
        distributionBuilder.append("\n");
        distributionBuilder.append("a dcat:Distribution");
        if (resource.getEml().getTitle() != null) {
            this.addPredicateToBuilder(distributionBuilder, "dct:title");
            this.addObjectToBuilder(distributionBuilder, "Darwin Core Archive of " + resource.getEml().getTitle(), ObjectTypes.LITERAL);
        }
        this.addPredicateToBuilder(distributionBuilder, "dct:description");
        this.addObjectToBuilder(distributionBuilder, "Darwin Core Archive", ObjectTypes.LITERAL);
        this.addPredicateToBuilder(distributionBuilder, "dct:license");
        this.addObjectToBuilder(distributionBuilder, resource.getEml().parseLicenseUrl(), ObjectTypes.RESOURCE);
        this.addPredicateToBuilder(distributionBuilder, "dct:format");
        this.addObjectToBuilder(distributionBuilder, "dwc-a", ObjectTypes.LITERAL);
        this.addPredicateToBuilder(distributionBuilder, "dcat:mediaType");
        this.addObjectToBuilder(distributionBuilder, "application/zip", ObjectTypes.LITERAL);
        this.addPredicateToBuilder(distributionBuilder, "dcat:downloadURL");
        this.addObjectToBuilder(distributionBuilder, this.cfg.getResourceArchiveUrl(resource.getShortname()), ObjectTypes.RESOURCE);
        this.addPredicateToBuilder(distributionBuilder, "dcat:accessURL");
        String accessURLClass = this.encapsulateObject(this.cfg.getResourceUrl(resource.getShortname()), ObjectTypes.RESOURCE) + " a rdfs:Resource .";
        this.addObjectToBuilder(distributionBuilder, this.cfg.getResourceUrl(resource.getShortname()), ObjectTypes.RESOURCE);
        distributionBuilder.append(" .\n");
        distributionBuilder.append(accessURLClass);
        distributionBuilder.append("\n");
        return distributionBuilder.toString();
    }

    private void addPredicateToBuilder(@NotNull StringBuilder builder, @NotNull String predicate) {
        builder.append(" ;\n");
        builder.append(predicate);
        builder.append(" ");
    }

    private void addObjectToBuilder(@NotNull StringBuilder builder, @NotNull String object, @NotNull ObjectTypes type) {
        builder.append(this.encapsulateObject(object, type));
    }

    private void addObjectsToBuilder(@NotNull StringBuilder builder, @NotNull List<String> objects, @NotNull ObjectTypes type) {
        if (objects.size() == 0) {
            throw new IllegalArgumentException();
        }
        for (String s : objects) {
            if (objects.indexOf(s) != 0) {
                builder.append(" , ");
            }
            builder.append(this.encapsulateObject(s, type));
        }
    }

    private String encapsulateObject(@NotNull String object, @NotNull ObjectTypes type) {
        Object ret = "";
        switch (1.$SwitchMap$org$gbif$ipt$task$GenerateDCAT$ObjectTypes[type.ordinal()]) {
            case 1: {
                if (object.contains("\r") || object.contains("\n")) {
                    ret = (String)ret + "\"\"\"";
                    break;
                }
                ret = (String)ret + "\"";
                break;
            }
            case 2: {
                ret = (String)ret + "<";
                break;
            }
            case 3: {
                ret = (String)ret + "[";
            }
        }
        ret = (String)ret + (ObjectTypes.LITERAL == type ? this.escapeString(object) : object);
        switch (1.$SwitchMap$org$gbif$ipt$task$GenerateDCAT$ObjectTypes[type.ordinal()]) {
            case 1: {
                if (object.contains("\r") || object.contains("\n")) {
                    ret = (String)ret + "\"\"\"";
                    break;
                }
                ret = (String)ret + "\"";
                break;
            }
            case 2: {
                ret = (String)ret + ">";
                break;
            }
            case 3: {
                ret = (String)ret + "]";
            }
        }
        return ret;
    }

    private String parseToIsoDate(@NotNull Date dateStamp) {
        return dateFormat.format(dateStamp);
    }

    private String escapeString(String s) {
        return s == null ? null : s.replaceAll("\"", "\\\\\"");
    }
}

