/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.ipt.task;

import com.lowagie.text.Anchor;
import com.lowagie.text.Chunk;
import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Element;
import com.lowagie.text.Font;
import com.lowagie.text.FontFactory;
import com.lowagie.text.List;
import com.lowagie.text.ListItem;
import com.lowagie.text.Paragraph;
import com.lowagie.text.Phrase;
import java.awt.Color;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.ResourceBundle;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.WordUtils;
import org.gbif.ipt.config.AppConfig;
import org.gbif.ipt.model.Resource;
import org.gbif.ipt.model.Vocabulary;
import org.gbif.ipt.model.VocabularyConcept;
import org.gbif.ipt.model.voc.PublicationStatus;
import org.gbif.ipt.service.admin.VocabulariesManager;
import org.gbif.ipt.utils.CoordinateUtils;
import org.gbif.metadata.eml.ipt.model.Agent;
import org.gbif.metadata.eml.ipt.model.BBox;
import org.gbif.metadata.eml.ipt.model.Citation;
import org.gbif.metadata.eml.ipt.model.Collection;
import org.gbif.metadata.eml.ipt.model.Eml;
import org.gbif.metadata.eml.ipt.model.GeospatialCoverage;
import org.gbif.metadata.eml.ipt.model.JGTICuratorialUnit;
import org.gbif.metadata.eml.ipt.model.JGTICuratorialUnitType;
import org.gbif.metadata.eml.ipt.model.KeywordSet;
import org.gbif.metadata.eml.ipt.model.PhysicalData;
import org.gbif.metadata.eml.ipt.model.TaxonKeyword;
import org.gbif.metadata.eml.ipt.model.TaxonomicCoverage;
import org.gbif.metadata.eml.ipt.model.TemporalCoverage;
import org.gbif.metadata.eml.ipt.model.TemporalCoverageType;

public class Eml2Rtf {
    private final Font font = FontFactory.getFont((String)"Times-Roman", (float)12.0f, (int)0, (Color)Color.BLACK);
    private final Font fontToComplete = FontFactory.getFont((String)"Times-Roman", (float)12.0f, (int)0, (Color)Color.RED);
    private final Font fontTitle = FontFactory.getFont((String)"Times-Bold", (float)12.0f, (int)1, (Color)Color.BLACK);
    private final Font fontHeader = FontFactory.getFont((String)"Times-Bold", (float)14.0f, (int)1, (Color)Color.BLACK);
    private final Font fontLinkTitle = FontFactory.getFont((String)"Times-Bold", (float)12.0f, (int)4, (Color)Color.BLUE);
    private final Font fontLink = FontFactory.getFont((String)"Times-Roman", (float)12.0f, (int)4, (Color)Color.BLUE);
    private static final String DEFAULT_LANGUAGE = Locale.ENGLISH.getLanguage();
    private ResourceBundle resourceBundle;
    private AppConfig appConfig;
    private VocabulariesManager vocabManager;

    public Eml2Rtf(AppConfig appConfig, VocabulariesManager vocabManager) {
        this.appConfig = appConfig;
        this.vocabManager = vocabManager;
    }

    private void addAbstract(Document doc, Eml eml) throws DocumentException {
        if (this.exists((Object)eml.getDescription())) {
            Paragraph p = new Paragraph();
            p.setAlignment(3);
            p.setFont(this.font);
            p.add((Element)new Phrase(this.getText("rtf.abstract"), this.fontTitle));
            p.add((Element)Chunk.NEWLINE);
            p.add((Element)Chunk.NEWLINE);
            p.add(eml.getDescription());
            p.add((Element)Chunk.NEWLINE);
            doc.add((Element)p);
            p.clear();
        }
    }

    private void addResourceCitation(Document doc, Eml eml) throws DocumentException {
        if (this.exists((Object)eml.getCitation())) {
            Paragraph p = new Paragraph();
            p.setAlignment(3);
            p.setFont(this.font);
            p.add((Element)new Phrase(this.getText("eml.citation.citation"), this.fontTitle));
            p.add((Element)Chunk.NEWLINE);
            p.add((Element)Chunk.NEWLINE);
            if (this.exists((Object)eml.getCitation().getCitation())) {
                p.add(eml.getCitation().getCitation().replace("\r\n", "\n"));
            }
            if (this.exists((Object)eml.getCitation().getIdentifier())) {
                p.add(" ");
                p.add(eml.getCitation().getIdentifier());
            }
            p.add((Element)Chunk.NEWLINE);
            doc.add((Element)p);
            p.clear();
        }
    }

    private void addAuthors(Document doc, Eml eml) throws DocumentException {
        int c;
        LinkedHashSet<Agent> tempAgents = new LinkedHashSet<Agent>();
        for (Agent creator : eml.getCreators()) {
            if (!StringUtils.isNotBlank((CharSequence)creator.getLastName())) continue;
            tempAgents.add(creator);
        }
        for (Agent metadataProvider : eml.getMetadataProviders()) {
            if (!StringUtils.isNotBlank((CharSequence)metadataProvider.getLastName())) continue;
            tempAgents.add(metadataProvider);
        }
        for (Agent party : eml.getAssociatedParties()) {
            if (!StringUtils.isNotBlank((CharSequence)party.getLastName())) continue;
            tempAgents.add(party);
        }
        ArrayList<Integer> toRemove = new ArrayList<Integer>();
        int counter = 0;
        Iterator i = tempAgents.iterator();
        while (i.hasNext()) {
            if (toRemove.contains(counter)) {
                i.next();
                i.remove();
            } else {
                Agent agentA = (Agent)i.next();
                boolean flag = false;
                int countTemp = 0;
                for (Agent agentB : tempAgents) {
                    if (flag) {
                        if (Objects.equals(agentA.getLastName(), agentB.getLastName()) && Objects.equals(agentA.getFirstName(), agentB.getFirstName()) && Objects.equals(agentA.getAddress(), agentB.getAddress())) {
                            toRemove.add(countTemp);
                        }
                    } else if (agentA.equals((Object)agentB)) {
                        flag = true;
                    }
                    ++countTemp;
                }
            }
            ++counter;
        }
        Agent[] agentsArray = new Agent[tempAgents.size()];
        tempAgents.toArray(agentsArray);
        Paragraph p = new Paragraph();
        p.setFont(this.font);
        p.setAlignment(1);
        ArrayList<Agent> affiliations = new ArrayList<Agent>();
        int superScriptCounter = 1;
        for (c = 0; c < agentsArray.length; ++c) {
            if (!this.exists((Object)agentsArray[c].getLastName())) continue;
            if (c != 0) {
                p.add(", ");
            }
            if (this.exists((Object)agentsArray[c].getFirstName())) {
                p.add(agentsArray[c].getFirstName() + " ");
            }
            p.add(agentsArray[c].getLastName());
            boolean isRepeated = false;
            for (int index = 0; index < affiliations.size(); ++index) {
                if (!Objects.equals(agentsArray[c].getAddress(), ((Agent)affiliations.get(index)).getAddress()) || !Objects.equals(agentsArray[c].getOrganisation(), ((Agent)affiliations.get(index)).getOrganisation())) continue;
                p.add((Element)this.createSuperScript(String.valueOf(index + 1)));
                isRepeated = true;
                break;
            }
            if (isRepeated) continue;
            p.add((Element)this.createSuperScript(String.valueOf(superScriptCounter)));
            affiliations.add(agentsArray[c]);
            ++superScriptCounter;
        }
        doc.add((Element)p);
        p.clear();
        doc.add((Element)Chunk.NEWLINE);
        tempAgents.clear();
        p = new Paragraph();
        p.setFont(this.font);
        p.setAlignment(3);
        for (c = 0; c < affiliations.size(); ++c) {
            if (c != 0) {
                p.add("; ");
            }
            p.add(c + 1 + " ");
            if (this.exists((Object)((Agent)affiliations.get(c)).getOrganisation())) {
                p.add(((Agent)affiliations.get(c)).getOrganisation() + ", ");
            }
            if (this.exists((Object)((Agent)affiliations.get(c)).getAddress().getAddress())) {
                p.add(String.valueOf(((Agent)affiliations.get(c)).getAddress().getAddress()) + ", ");
            }
            if (this.exists((Object)((Agent)affiliations.get(c)).getAddress().getPostalCode())) {
                p.add(((Agent)affiliations.get(c)).getAddress().getPostalCode() + ", ");
            }
            if (this.exists((Object)((Agent)affiliations.get(c)).getAddress().getCity())) {
                p.add(((Agent)affiliations.get(c)).getAddress().getCity());
            }
            if (!this.exists((Object)((Agent)affiliations.get(c)).getAddress().getCountry())) continue;
            VocabularyConcept concept = this.vocabManager.get("http://iso.org/iso3166-1/alpha2").findConcept(((Agent)affiliations.get(c)).getAddress().getCountry());
            if (this.exists((Object)concept)) {
                p.add(", " + WordUtils.capitalizeFully((String)concept.getPreferredTerm(DEFAULT_LANGUAGE).getTitle()));
                continue;
            }
            p.add(", " + WordUtils.capitalizeFully((String)((Agent)affiliations.get(c)).getAddress().getCountry()));
        }
        doc.add((Element)p);
        p.clear();
        doc.add((Element)Chunk.NEWLINE);
        p = new Paragraph();
        p.setAlignment(3);
        p.add((Element)new Phrase(this.getText("rtf.authors") + ": ", this.fontTitle));
        p.setFont(this.font);
        boolean isFirst = true;
        for (Agent creator : eml.getCreators()) {
            if (StringUtils.isNotBlank((CharSequence)creator.getFirstName())) {
                p.add(creator.getFirstName() + " ");
            }
            p.add(creator.getLastName());
            if (!creator.getEmail().isEmpty()) {
                p.add(" (" + (String)creator.getEmail().get(0) + ")");
            }
            isFirst = false;
        }
        for (Agent metadataProvider : eml.getMetadataProviders()) {
            boolean sameAsCreator = false;
            for (Agent creator : eml.getCreators()) {
                if (!Objects.equals(metadataProvider.getAddress(), creator.getAddress()) || !Objects.equals(metadataProvider.getEmail(), creator.getEmail())) continue;
                sameAsCreator = true;
                break;
            }
            if (sameAsCreator) continue;
            if (!isFirst) {
                p.add(", ");
            }
            if (StringUtils.isNotBlank((CharSequence)metadataProvider.getFirstName())) {
                p.add(metadataProvider.getFirstName() + " ");
            }
            p.add(metadataProvider.getLastName());
            if (!metadataProvider.getEmail().isEmpty()) {
                p.add(" (" + (String)metadataProvider.getEmail().get(0) + ")");
            }
            isFirst = false;
        }
        p.add((Element)Chunk.NEWLINE);
        doc.add((Element)p);
        p.clear();
    }

    private void addCitations(Document doc) throws DocumentException {
        Paragraph p = new Paragraph();
        p.setAlignment(3);
        p.setFont(this.fontToComplete);
        p.add((Element)new Phrase(this.getText("rtf.citations") + ": ", this.fontTitle));
        p.add(this.getText("rtf.citations.description"));
        p.add((Element)Chunk.NEWLINE);
        doc.add((Element)p);
        p.clear();
    }

    private void addDatasetDescriptions(Document doc, Resource resource) throws DocumentException {
        Paragraph p = new Paragraph();
        p.setAlignment(3);
        p.setFont(this.font);
        Eml eml = resource.getEml();
        if (resource.hasMappedData()) {
            p.add((Element)new Phrase(this.getText("rtf.datasets"), this.fontTitle));
            p.add((Element)Chunk.NEWLINE);
            p.add((Element)Chunk.NEWLINE);
            p.add((Element)new Phrase(this.getText("rtf.datasets.description"), this.fontTitle));
            p.add((Element)Chunk.NEWLINE);
            p.add((Element)new Phrase(this.getText("rtf.datasets.object") + ": ", this.fontTitle));
            p.add(this.getText("rtf.datasets.dwca") + " " + eml.getTitle());
            p.add((Element)Chunk.NEWLINE);
            p.add((Element)new Phrase(this.getText("rtf.datasets.character") + ": ", this.fontTitle));
            p.add("UTF-8");
            p.add((Element)Chunk.NEWLINE);
            p.add((Element)new Phrase(this.getText("rtf.datasets.format") + ": ", this.fontTitle));
            p.add(this.getText("rtf.datasets.dwca.format"));
            p.add((Element)Chunk.NEWLINE);
            p.add((Element)new Phrase(this.getText("rtf.datasets.format.version") + ": ", this.fontTitle));
            p.add("1.0");
            p.add((Element)Chunk.NEWLINE);
            p.add((Element)new Phrase(this.getText("rtf.datasets.distribution") + ": ", this.fontTitle));
            String dwcaLink = this.appConfig.getBaseUrl() + "/archive.do?r=" + resource.getShortname();
            Anchor distributionLink = new Anchor(dwcaLink, this.fontLink);
            distributionLink.setReference(dwcaLink);
            p.add((Element)distributionLink);
            p.add((Element)Chunk.NEWLINE);
            if (this.exists((Object)eml.getPubDate())) {
                p.add((Element)new Phrase(this.getText("rtf.publication") + ": ", this.fontTitle));
                SimpleDateFormat f = new SimpleDateFormat("yyyy-MM-dd");
                p.add(f.format(eml.getPubDate()));
                p.add((Element)Chunk.NEWLINE);
            }
            VocabularyConcept vocabConcept = this.vocabManager.get("http://iso.org/639-2").findConcept(eml.getLanguage());
            p.add((Element)new Phrase(this.getText("rtf.language") + ": ", this.fontTitle));
            if (this.exists((Object)vocabConcept)) {
                p.add(vocabConcept.getPreferredTerm(DEFAULT_LANGUAGE).getTitle());
            } else {
                p.add(this.getText("rtf.unknown"));
            }
            p.add((Element)Chunk.NEWLINE);
            this.addLicense(p, eml);
            doc.add((Element)p);
        } else if (!eml.getPhysicalData().isEmpty()) {
            p.add((Element)new Phrase(this.getText("rtf.datasets"), this.fontTitle));
            p.add((Element)Chunk.NEWLINE);
            p.add((Element)Chunk.NEWLINE);
            p.add((Element)new Phrase(this.getText("rtf.datasets.description"), this.fontTitle));
            p.add((Element)Chunk.NEWLINE);
            p.add(this.getText("rtf.datasets.noPublished"));
            p.add((Element)Chunk.NEWLINE);
            VocabularyConcept vocabConcept = this.vocabManager.get("http://iso.org/639-2").findConcept(eml.getLanguage());
            p.add((Element)new Phrase(this.getText("rtf.language") + ": ", this.fontTitle));
            if (this.exists((Object)vocabConcept)) {
                p.add(vocabConcept.getPreferredTerm(DEFAULT_LANGUAGE).getTitle());
            } else {
                p.add(this.getText("rtf.unknown"));
            }
            p.add((Element)Chunk.NEWLINE);
            this.addLicense(p, eml);
            doc.add((Element)p);
        }
        this.addExternalLinks(doc, eml);
        p.clear();
    }

    private void addLicense(Paragraph p, Eml eml) throws DocumentException {
        String licenseTitle = eml.parseLicenseTitle();
        String licenseUrl = eml.parseLicenseUrl();
        if (StringUtils.isNotBlank((CharSequence)licenseTitle) && StringUtils.isNotBlank((CharSequence)licenseUrl)) {
            p.add((Element)new Phrase(this.getText("rtf.license") + ": ", this.fontTitle));
            Anchor licenseLink = new Anchor(eml.parseLicenseTitle(), this.fontLink);
            licenseLink.setReference(eml.parseLicenseUrl());
            p.add((Element)licenseLink);
            p.add((Element)Chunk.NEWLINE);
        }
    }

    private void addDates(Document doc) throws DocumentException {
        Paragraph p = new Paragraph();
        Phrase phrase = new Phrase("{" + this.getText("rtf.date") + "}", this.fontToComplete);
        p.setFont(this.font);
        p.add(this.getText("rtf.received") + " ");
        p.add((Element)phrase);
        p.add("; " + this.getText("rtf.revised") + " ");
        p.add((Element)phrase);
        p.add("; " + this.getText("rtf.accepted") + " ");
        p.add((Element)phrase);
        p.add("; " + this.getText("rtf.published") + " ");
        p.add((Element)phrase);
        p.add((Element)Chunk.NEWLINE);
        doc.add((Element)p);
        p.clear();
    }

    private void addExternalLinks(Document doc, Eml eml) throws DocumentException {
        if (!eml.getPhysicalData().isEmpty()) {
            Paragraph p = new Paragraph();
            p.setAlignment(3);
            p.setFont(this.font);
            p.add((Element)new Phrase(this.getText("rtf.dtasets.external"), this.fontTitle));
            p.add((Element)Chunk.NEWLINE);
            p.add((Element)Chunk.NEWLINE);
            for (PhysicalData data : eml.getPhysicalData()) {
                p.add((Element)new Phrase(this.getText("rtf.datasets.description"), this.fontTitle));
                p.add((Element)Chunk.NEWLINE);
                if (this.exists((Object)data.getName())) {
                    p.add((Element)new Phrase(this.getText("rtf.datasets.object") + ": ", this.fontTitle));
                    p.add(data.getName());
                    p.add((Element)Chunk.NEWLINE);
                }
                if (this.exists((Object)data.getCharset())) {
                    p.add((Element)new Phrase(this.getText("rtf.datasets.character") + ": ", this.fontTitle));
                    p.add(data.getCharset());
                    p.add((Element)Chunk.NEWLINE);
                }
                if (this.exists((Object)data.getFormat())) {
                    p.add((Element)new Phrase(this.getText("rtf.datasets.format") + ": ", this.fontTitle));
                    p.add(data.getFormat());
                    p.add((Element)Chunk.NEWLINE);
                }
                if (this.exists((Object)data.getFormatVersion())) {
                    p.add((Element)new Phrase(this.getText("rtf.datasets.format.version") + ": ", this.fontTitle));
                    p.add(data.getFormatVersion());
                    p.add((Element)Chunk.NEWLINE);
                }
                if (this.exists((Object)data.getDistributionUrl())) {
                    p.add((Element)new Phrase(this.getText("rtf.datasets.distribution") + ": ", this.fontTitle));
                    Anchor distributionLink = new Anchor(data.getDistributionUrl(), this.fontLink);
                    distributionLink.setReference(data.getDistributionUrl());
                    p.add((Element)distributionLink);
                    p.add((Element)Chunk.NEWLINE);
                }
                p.add((Element)Chunk.NEWLINE);
            }
            doc.add((Element)p);
            p.clear();
        }
    }

    private void addGeneralDescription(Document doc, Eml eml) throws DocumentException {
        if (this.exists((Object)eml.getPurpose()) || this.exists((Object)eml.getAdditionalInfo())) {
            Paragraph p = new Paragraph();
            p.setAlignment(3);
            p.setFont(this.font);
            p.add((Element)new Phrase(this.getText("rtf.generalDesciption"), this.fontTitle));
            p.add((Element)Chunk.NEWLINE);
            p.add((Element)Chunk.NEWLINE);
            if (this.exists((Object)eml.getPurpose())) {
                p.add((Element)new Phrase(this.getText("rtf.purpose") + ": ", this.fontTitle));
                p.add(eml.getPurpose().replace("\r\n", "\n"));
                p.add((Element)Chunk.NEWLINE);
            }
            if (this.exists((Object)eml.getAdditionalInfo())) {
                p.add((Element)new Phrase("Additional information: ", this.fontTitle));
                p.add(eml.getAdditionalInfo().replace("\r\n", "\n"));
                p.add((Element)Chunk.NEWLINE);
            }
            doc.add((Element)p);
            p.clear();
        }
    }

    private void addKeywords(Document doc, String keys) throws DocumentException {
        if (keys != null && keys.length() != 0) {
            Paragraph p = new Paragraph();
            p.setAlignment(3);
            p.setFont(this.font);
            p.add((Element)new Phrase(this.getText("rtf.keywords") + ": ", this.fontTitle));
            p.add(keys);
            p.add((Element)Chunk.NEWLINE);
            doc.add((Element)p);
            p.clear();
        }
    }

    private void addMetadataDescriptions(Document doc, Eml eml) throws DocumentException {
        VocabularyConcept vocabConcept;
        Vocabulary vocab;
        VocabularyConcept vocabConcept2;
        Paragraph p = new Paragraph();
        p.setAlignment(3);
        p.setFont(this.font);
        if (this.exists((Object)eml.getMetadataLanguage()) && this.exists((Object)(vocabConcept2 = (vocab = this.vocabManager.get("http://iso.org/639-2")).findConcept(eml.getMetadataLanguage())))) {
            p.add((Element)new Phrase(this.getText("rtf.metadata.language") + ": ", this.fontTitle));
            p.add(vocabConcept2.getPreferredTerm(DEFAULT_LANGUAGE).getTitle());
            p.add((Element)Chunk.NEWLINE);
        }
        if (this.exists((Object)eml.getDateStamp())) {
            p.add((Element)new Phrase(this.getText("rtf.metadata.creation") + ": ", this.fontTitle));
            SimpleDateFormat f = new SimpleDateFormat("yyyy-MM-dd");
            p.add(f.format(eml.getDateStamp()));
            p.add((Element)Chunk.NEWLINE);
        }
        if (this.exists((Object)eml.getHierarchyLevel())) {
            p.add((Element)new Phrase(this.getText("rtf.metadata.level") + ": ", this.fontTitle));
            p.add(WordUtils.capitalizeFully((String)eml.getHierarchyLevel()));
            p.add((Element)Chunk.NEWLINE);
        }
        if (this.exists((Object)eml.getMetadataLocale()) && this.exists((Object)(vocabConcept = this.vocabManager.get("http://iso.org/639-2").findConcept(eml.getMetadataLocale().getLanguage())))) {
            p.add((Element)new Phrase(this.getText("rtf.metadata.locale") + ": ", this.fontTitle));
            p.add(vocabConcept.getPreferredTerm(DEFAULT_LANGUAGE).getTitle());
            p.add((Element)Chunk.NEWLINE);
        }
        doc.add((Element)p);
        p.clear();
    }

    private void addMethods(Document doc, Eml eml) throws DocumentException {
        if (this.exists((Object)eml.getMethodSteps()) && !eml.getMethodSteps().isEmpty() || this.exists((Object)eml.getStudyExtent()) || this.exists((Object)eml.getStudyExtent()) || this.exists((Object)eml.getStudyExtent())) {
            Paragraph p = new Paragraph();
            p.setAlignment(3);
            p.setFont(this.font);
            p.add((Element)new Phrase(this.getText("rtf.methods"), this.fontTitle));
            p.add((Element)Chunk.NEWLINE);
            p.add((Element)Chunk.NEWLINE);
            if (eml.getMethodSteps().size() == 1) {
                p.add((Element)new Phrase(this.getText("rtf.methods.description") + ": ", this.fontTitle));
                p.add(((String)eml.getMethodSteps().get(0)).replace("\r\n", "\n"));
                p.add((Element)Chunk.NEWLINE);
            } else if (eml.getMethodSteps().size() > 1) {
                p.add((Element)new Phrase(this.getText("rtf.methods.description") + ": ", this.fontTitle));
                p.add((Element)Chunk.NEWLINE);
                List list = new List(false, 0.0f);
                list.setIndentationLeft(20.0f);
                for (String method : eml.getMethodSteps()) {
                    list.add((Element)new ListItem(method.replace("\r\n", "\n"), this.font));
                }
                p.add((Element)list);
            }
            if (this.exists((Object)eml.getStudyExtent())) {
                p.add((Element)new Phrase(this.getText("rtf.methods.studyExtent") + ": ", this.fontTitle));
                p.add(eml.getStudyExtent().replace("\r\n", "\n"));
                p.add((Element)Chunk.NEWLINE);
            }
            if (this.exists((Object)eml.getStudyExtent())) {
                p.add((Element)new Phrase(this.getText("rtf.methods.sampling") + ": ", this.fontTitle));
                p.add(eml.getSampleDescription().replace("\r\n", "\n"));
                p.add((Element)Chunk.NEWLINE);
            }
            if (this.exists((Object)eml.getQualityControl())) {
                p.add((Element)new Phrase(this.getText("rtf.methods.quality") + ": ", this.fontTitle));
                p.add(eml.getQualityControl().replace("\r\n", "\n"));
                p.add((Element)Chunk.NEWLINE);
            }
            doc.add((Element)p);
            p.clear();
        }
    }

    private void addNaturalCollections(Document doc, Eml eml) throws DocumentException {
        if (!(eml.getCollections().isEmpty() && eml.getTemporalCoverages().isEmpty() && eml.getSpecimenPreservationMethods().isEmpty() && eml.getJgtiCuratorialUnits().isEmpty())) {
            Paragraph p = new Paragraph();
            p.setAlignment(3);
            p.setFont(this.font);
            for (Collection collection : eml.getCollections()) {
                if (!this.exists((Object)collection.getParentCollectionId()) && !this.exists((Object)collection.getCollectionName()) && !this.exists((Object)collection.getCollectionId())) continue;
                p.add((Element)new Phrase(this.getText("rtf.collections.description"), this.fontTitle));
                p.add((Element)Chunk.NEWLINE);
                p.add((Element)Chunk.NEWLINE);
                if (this.exists((Object)collection.getParentCollectionId())) {
                    p.add((Element)new Phrase(this.getText("rtf.collections.parent") + ": ", this.fontTitle));
                    p.add(collection.getParentCollectionId());
                    p.add((Element)Chunk.NEWLINE);
                }
                if (this.exists((Object)collection.getCollectionName())) {
                    p.add((Element)new Phrase(this.getText("rtf.collections.name") + ": ", this.fontTitle));
                    p.add(collection.getCollectionName());
                    p.add((Element)Chunk.NEWLINE);
                }
                if (!this.exists((Object)collection.getCollectionId())) continue;
                p.add((Element)new Phrase(this.getText("rtf.collections.identifier") + ": ", this.fontTitle));
                p.add(collection.getCollectionId());
                p.add((Element)Chunk.NEWLINE);
            }
            for (TemporalCoverage coverage : eml.getTemporalCoverages()) {
                if (coverage.getType() != TemporalCoverageType.FORMATION_PERIOD) continue;
                p.add((Element)new Phrase(this.getText("rtf.collections.formatPeriod") + ": ", this.fontTitle));
                p.add(coverage.getFormationPeriod());
                p.add((Element)Chunk.NEWLINE);
            }
            for (TemporalCoverage coverage : eml.getTemporalCoverages()) {
                if (coverage.getType() != TemporalCoverageType.LIVING_TIME_PERIOD) continue;
                p.add((Element)new Phrase(this.getText("rtf.collections.livingPeriod") + ": ", this.fontTitle));
                p.add(coverage.getLivingTimePeriod());
                p.add((Element)Chunk.NEWLINE);
            }
            for (String preservationMethod : eml.getSpecimenPreservationMethods()) {
                if (!this.exists((Object)preservationMethod)) continue;
                p.add((Element)new Phrase(this.getText("rtf.collections.specimen") + ": ", this.fontTitle));
                VocabularyConcept vocabConcept = this.vocabManager.get("http://rs.gbif.org/vocabulary/gbif/preservation_method").findConcept(preservationMethod);
                if (this.exists((Object)vocabConcept)) {
                    p.add(vocabConcept.getPreferredTerm(DEFAULT_LANGUAGE).getTitle());
                } else {
                    p.add(preservationMethod.replace("\r\n", "\n"));
                }
                p.add((Element)Chunk.NEWLINE);
            }
            for (JGTICuratorialUnit unit : eml.getJgtiCuratorialUnits()) {
                p.add((Element)new Phrase(this.getText("rtf.collections.curatorial") + ": ", this.fontTitle));
                if (unit.getType() == JGTICuratorialUnitType.COUNT_RANGE) {
                    p.add("Between " + unit.getRangeStart() + " and " + unit.getRangeEnd());
                }
                if (unit.getType() == JGTICuratorialUnitType.COUNT_WITH_UNCERTAINTY) {
                    p.add(unit.getRangeMean() + " " + this.getText("rtf.collections.curatorial.text") + " " + unit.getUncertaintyMeasure());
                }
                p.add(" (" + unit.getUnitType() + ")");
                p.add((Element)Chunk.NEWLINE);
            }
            if (!p.isEmpty()) {
                doc.add((Element)p);
            }
            p.clear();
        }
    }

    private void addPara(Document doc, String text, Font font, int spacing, int alignType) throws DocumentException {
        Paragraph p = new Paragraph(text, font);
        if (spacing != 0) {
            p.setSpacingBefore((float)spacing);
        }
        if (alignType != 0) {
            p.setAlignment(alignType);
        }
        doc.add((Element)p);
        p.clear();
    }

    private void addProjectData(Document doc, Eml eml) throws DocumentException {
        if (this.exists((Object)eml.getProject().getTitle()) || !eml.getProject().getPersonnel().isEmpty() || this.exists((Object)eml.getProject().getFunding()) || this.exists((Object)eml.getProject().getStudyAreaDescription().getDescriptorValue()) || this.exists((Object)eml.getProject().getDesignDescription())) {
            Paragraph p = new Paragraph();
            p.setAlignment(3);
            p.setFont(this.font);
            p.add((Element)new Phrase(this.getText("rtf.project.details"), this.fontTitle));
            p.add((Element)Chunk.NEWLINE);
            p.add((Element)Chunk.NEWLINE);
            if (this.exists((Object)eml.getProject().getTitle())) {
                p.add((Element)new Phrase(this.getText("rtf.project.title") + ": ", this.fontTitle));
                p.add(eml.getProject().getTitle());
                p.add((Element)Chunk.NEWLINE);
            }
            if (!eml.getProject().getPersonnel().isEmpty()) {
                p.add((Element)new Phrase(this.getText("rtf.project.personnel") + ": ", this.fontTitle));
                Iterator iter = eml.getProject().getPersonnel().iterator();
                while (iter.hasNext()) {
                    Agent personnel = (Agent)iter.next();
                    if (StringUtils.isNotBlank((CharSequence)personnel.getFirstName())) {
                        p.add(personnel.getFirstName() + " " + personnel.getLastName());
                    }
                    if (!iter.hasNext()) continue;
                    p.add(", ");
                }
                p.add((Element)Chunk.NEWLINE);
            }
            if (this.exists((Object)eml.getProject().getFunding())) {
                p.add((Element)new Phrase(this.getText("rtf.project.funding") + ": ", this.fontTitle));
                p.add(eml.getProject().getFunding().replace("\r\n", "\n"));
                p.add((Element)Chunk.NEWLINE);
            }
            if (this.exists((Object)eml.getProject().getStudyAreaDescription().getDescriptorValue())) {
                p.add((Element)new Phrase(this.getText("rtf.project.area") + ": ", this.fontTitle));
                p.add(eml.getProject().getStudyAreaDescription().getDescriptorValue().replace("\r\n", "\n"));
                p.add((Element)Chunk.NEWLINE);
            }
            if (this.exists((Object)eml.getProject().getDesignDescription())) {
                p.add((Element)new Phrase(this.getText("rtf.project.design") + ": ", this.fontTitle));
                p.add(eml.getProject().getDesignDescription().replace("\r\n", "\n"));
                p.add((Element)Chunk.NEWLINE);
            }
            doc.add((Element)p);
            p.clear();
        }
    }

    private void addReferences(Document doc, Eml eml) throws DocumentException {
        if (this.exists((Object)eml.getBibliographicCitationSet()) && !eml.getBibliographicCitationSet().getBibliographicCitations().isEmpty()) {
            Paragraph p = new Paragraph();
            p.setAlignment(3);
            p.setFont(this.font);
            p.add((Element)new Phrase(this.getText("rtf.references"), this.fontTitle));
            p.add((Element)Chunk.NEWLINE);
            for (Citation citation : eml.getBibliographicCitationSet().getBibliographicCitations()) {
                if (this.exists((Object)citation.getCitation())) {
                    p.add(citation.getCitation().replace("\r\n", "\n"));
                }
                if (this.exists((Object)citation.getIdentifier())) {
                    p.add(" ");
                    p.add(citation.getIdentifier());
                }
                p.add((Element)Chunk.NEWLINE);
            }
            doc.add((Element)p);
            p.clear();
        }
    }

    private void addResourceLink(Document doc, Resource resource) throws DocumentException {
        if (resource.getStatus() != PublicationStatus.PRIVATE) {
            Paragraph p = new Paragraph();
            p.setFont(this.font);
            p.add((Element)new Phrase(this.getText("rtf.resourceLink") + " ", this.fontTitle));
            Anchor gbifLink = new Anchor("GBIF", this.fontLinkTitle);
            gbifLink.setReference("https://www.gbif.org");
            p.add((Element)gbifLink);
            p.add(": ");
            String link = this.appConfig.getResourceUrl(resource.getShortname());
            Anchor resourceLink = new Anchor(link, this.fontLink);
            resourceLink.setReference(link);
            p.add((Element)resourceLink);
            p.add((Element)Chunk.NEWLINE);
            doc.add((Element)p);
            p.clear();
        }
    }

    private void addSpatialCoverage(Document doc, Eml eml) throws DocumentException {
        if (this.exists((Object)eml.getGeospatialCoverages()) && !eml.getGeospatialCoverages().isEmpty()) {
            Paragraph p = new Paragraph();
            p.setAlignment(3);
            p.setFont(this.font);
            boolean firstCoverage = true;
            for (GeospatialCoverage coverage : eml.getGeospatialCoverages()) {
                if (firstCoverage) {
                    firstCoverage = false;
                } else {
                    p.add((Element)Chunk.NEWLINE);
                }
                if (this.exists((Object)coverage.getDescription())) {
                    p.add((Element)new Phrase(this.getText("rtf.spatialCoverage"), this.fontTitle));
                    p.add((Element)Chunk.NEWLINE);
                    p.add((Element)Chunk.NEWLINE);
                    p.add((Element)new Phrase(this.getText("rtf.spatialCoverage.general") + ": ", this.fontTitle));
                    p.add(coverage.getDescription().replace("\r\n", "\n"));
                    p.add((Element)Chunk.NEWLINE);
                }
                p.add((Element)new Phrase(this.getText("rtf.spatialCoverage.coordinates") + ": ", this.fontTitle));
                BBox coordinates = coverage.getBoundingCoordinates();
                p.add(CoordinateUtils.decToDms((double)coordinates.getMin().getLatitude(), (String)"LAT"));
                p.add(" " + this.getText("rtf.spatialCoverage.and") + " ");
                p.add(CoordinateUtils.decToDms((double)coordinates.getMax().getLatitude(), (String)"LAT"));
                p.add(" " + this.getText("rtf.spatialCoverage.latitude") + "; ");
                p.add(CoordinateUtils.decToDms((double)coordinates.getMin().getLongitude(), (String)"LON"));
                p.add(" " + this.getText("rtf.spatialCoverage.and") + " ");
                p.add(CoordinateUtils.decToDms((double)coordinates.getMax().getLongitude(), (String)"LON"));
                p.add(" " + this.getText("rtf.spatialCoverage.longitude") + " ");
                p.add((Element)Chunk.NEWLINE);
            }
            doc.add((Element)p);
            p.clear();
        }
    }

    private void addTaxonomicCoverages(Document doc, Eml eml) throws DocumentException {
        if (this.exists((Object)eml.getTaxonomicCoverages()) && !eml.getTaxonomicCoverages().isEmpty()) {
            Paragraph p = new Paragraph();
            p.setAlignment(3);
            p.setFont(this.font);
            boolean firstTaxon = true;
            for (TaxonomicCoverage taxcoverage : eml.getTaxonomicCoverages()) {
                if (!firstTaxon) {
                    p.add((Element)Chunk.NEWLINE);
                }
                firstTaxon = false;
                p.add((Element)new Phrase(this.getText("rtf.taxcoverage"), this.fontTitle));
                p.add((Element)Chunk.NEWLINE);
                p.add((Element)Chunk.NEWLINE);
                if (this.exists((Object)taxcoverage.getDescription())) {
                    p.add((Element)new Phrase(this.getText("rtf.taxcoverage.description") + ": ", this.fontTitle));
                    p.add(taxcoverage.getDescription().replace("\r\n", "\n"));
                    p.add((Element)Chunk.NEWLINE);
                }
                Map ranks = this.vocabManager.getI18nVocab("http://rs.gbif.org/vocabulary/gbif/rank", Locale.getDefault().getLanguage(), false);
                boolean firstRank = true;
                for (String rank : ranks.keySet()) {
                    boolean wroteRank = false;
                    for (TaxonKeyword keyword : taxcoverage.getTaxonKeywords()) {
                        if (!this.exists((Object)keyword.getRank()) || !keyword.getRank().equals(rank)) continue;
                        if (!wroteRank) {
                            if (firstRank) {
                                p.add((Element)new Phrase(this.getText("rtf.taxcoverage.rank"), this.fontTitle));
                            }
                            p.add((Element)Chunk.NEWLINE);
                            p.add(StringUtils.capitalize((String)rank) + ": ");
                            p.add(keyword.getScientificName());
                            wroteRank = true;
                            firstRank = false;
                            continue;
                        }
                        p.add(", " + keyword.getScientificName());
                    }
                }
                p.add((Element)Chunk.NEWLINE);
                boolean isFirst = true;
                for (TaxonKeyword keyword : taxcoverage.getTaxonKeywords()) {
                    if (!this.exists((Object)keyword.getCommonName())) continue;
                    if (isFirst) {
                        p.add((Element)new Phrase(this.getText("rtf.taxcoverage.common") + ": ", this.fontTitle));
                    } else {
                        p.add(", ");
                    }
                    isFirst = false;
                    p.add(keyword.getCommonName());
                }
            }
            p.add((Element)Chunk.NEWLINE);
            doc.add((Element)p);
            p.clear();
        }
    }

    private void addTemporalCoverages(Document doc, Eml eml) throws DocumentException {
        if (this.exists((Object)eml.getTemporalCoverages()) && !eml.getTemporalCoverages().isEmpty()) {
            Paragraph p = new Paragraph();
            p.setAlignment(3);
            p.setFont(this.font);
            DateFormat dateFormat = DateFormat.getDateInstance(1);
            SimpleDateFormat timeFormat = new SimpleDateFormat("SSS");
            SimpleDateFormat yearFormat = new SimpleDateFormat("yyyy");
            boolean firstCoverage = true;
            for (TemporalCoverage coverage : eml.getTemporalCoverages()) {
                if (coverage.getType().equals((Object)TemporalCoverageType.SINGLE_DATE)) {
                    if (coverage.getStartDate() == null) continue;
                    if (firstCoverage) {
                        firstCoverage = false;
                    } else {
                        p.add((Element)Chunk.NEWLINE);
                    }
                    p.add((Element)new Phrase(this.getText("rtf.tempcoverage") + ": ", this.fontTitle));
                    if (timeFormat.format(coverage.getStartDate()).equals("001")) {
                        p.add(yearFormat.format(coverage.getStartDate()));
                    } else {
                        p.add(dateFormat.format(coverage.getStartDate()));
                    }
                    p.add((Element)Chunk.NEWLINE);
                    continue;
                }
                if (coverage.getType() != TemporalCoverageType.DATE_RANGE || coverage.getStartDate() == null || coverage.getEndDate() == null) continue;
                if (firstCoverage) {
                    firstCoverage = false;
                } else {
                    p.add((Element)Chunk.NEWLINE);
                }
                p.add((Element)new Phrase(this.getText("rtf.tempcoverage") + ": ", this.fontTitle));
                if (timeFormat.format(coverage.getStartDate()).equals("001")) {
                    p.add(yearFormat.format(coverage.getStartDate()));
                } else {
                    p.add(dateFormat.format(coverage.getStartDate()));
                }
                p.add(" - ");
                if (timeFormat.format(coverage.getEndDate()).equals("001")) {
                    p.add(yearFormat.format(coverage.getEndDate()));
                } else {
                    p.add(dateFormat.format(coverage.getEndDate()));
                }
                p.add((Element)Chunk.NEWLINE);
            }
            doc.add((Element)p);
            p.clear();
        }
    }

    private Chunk createSuperScript(String text) {
        return new Chunk(text).setTextRise(5.0f);
    }

    private boolean exists(Object obj) {
        if (obj == null) {
            return false;
        }
        return !(obj instanceof String) || !StringUtils.isEmpty((CharSequence)((String)obj));
    }

    public String getText(String key) {
        return this.resourceBundle.getString(key);
    }

    public void setAppConfig(AppConfig appConfig) {
        this.appConfig = appConfig;
    }

    public void setVocabManager(VocabulariesManager vocabManager) {
        this.vocabManager = vocabManager;
    }

    public void writeEmlIntoRtf(Document doc, Resource resource) throws DocumentException {
        this.resourceBundle = ResourceBundle.getBundle("ApplicationResources", Locale.ENGLISH);
        Eml eml = resource.getEml();
        doc.setMargins(72.0f, 72.0f, 72.0f, 72.0f);
        doc.addAuthor(resource.getCreator().getName());
        doc.addCreationDate();
        doc.addTitle(eml.getTitle() == null ? resource.getShortname() : eml.getTitle());
        StringBuilder keys = new StringBuilder();
        for (KeywordSet kw : eml.getKeywords()) {
            if (keys.length() == 0) {
                keys.append(kw.getKeywordsString(", "));
                continue;
            }
            keys.append(", " + kw.getKeywordsString(", "));
        }
        String keysValue = keys.toString();
        doc.addKeywords(keysValue);
        doc.open();
        this.addPara(doc, eml.getTitle(), this.fontHeader, 0, 1);
        doc.add((Element)Chunk.NEWLINE);
        this.addAuthors(doc, eml);
        this.addDates(doc);
        this.addCitations(doc);
        this.addResourceCitation(doc, eml);
        this.addAbstract(doc, eml);
        this.addKeywords(doc, keysValue);
        this.addGeneralDescription(doc, eml);
        this.addProjectData(doc, eml);
        this.addResourceLink(doc, resource);
        this.addTaxonomicCoverages(doc, eml);
        this.addSpatialCoverage(doc, eml);
        this.addTemporalCoverages(doc, eml);
        this.addNaturalCollections(doc, eml);
        this.addMethods(doc, eml);
        this.addDatasetDescriptions(doc, resource);
        this.addMetadataDescriptions(doc, eml);
        this.addReferences(doc, eml);
        doc.close();
    }
}

