/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.ipt.struts2;

import com.opensymphony.xwork2.LocaleProvider;
import java.text.MessageFormat;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SimpleTextProvider {
    private static final Logger LOG = LogManager.getLogger(SimpleTextProvider.class);
    private static final String DEFAULT_BUNDLE = "ApplicationResources";
    private final Set<String> baseBundleNames = new HashSet();

    public SimpleTextProvider() {
        this.baseBundleNames.add(DEFAULT_BUNDLE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResourceBundle findResourceBundle(String aBundleName, Locale locale) {
        Locale currentLocale = Locale.getDefault();
        try {
            Locale.setDefault(Locale.ENGLISH);
            ResourceBundle resourceBundle = ResourceBundle.getBundle(aBundleName, locale, Thread.currentThread().getContextClassLoader());
            return resourceBundle;
        }
        catch (Exception e) {
            ResourceBundle resourceBundle = ResourceBundle.getBundle(aBundleName, Locale.ENGLISH, Thread.currentThread().getContextClassLoader());
            return resourceBundle;
        }
        finally {
            Locale.setDefault(currentLocale);
        }
    }

    public String findText(ResourceBundle bundle, String aTextName, String defaultMessage, Object[] args) {
        try {
            String text;
            String message = bundle.getString(aTextName);
            try {
                text = MessageFormat.format(message, args);
            }
            catch (IllegalArgumentException e) {
                LOG.debug((Object)e);
                text = message;
            }
            return text;
        }
        catch (MissingResourceException missingResourceException) {
            return defaultMessage != null ? defaultMessage : aTextName;
        }
    }

    public String getText(LocaleProvider localeProvider, String key, String defaultValue, List args) {
        Object[] argsArray = args != null ? args.toArray() : null;
        return this.getText(localeProvider, key, defaultValue, argsArray);
    }

    public String getText(LocaleProvider localeProvider, String key, String defaultValue, Object[] args) {
        String resName;
        ResourceBundle bundle;
        Locale locale = localeProvider.getLocale() == null ? Locale.ENGLISH : localeProvider.getLocale();
        String text = null;
        Iterator iterator = this.baseBundleNames.iterator();
        while (iterator.hasNext() && (text = this.findText(bundle = this.findResourceBundle(resName = (String)iterator.next(), locale), key, defaultValue, args)) == null) {
        }
        if (text != null) {
            try {
                text = MessageFormat.format(text, args != null ? args : new Object[]{});
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return text;
    }

    public ResourceBundle getTexts(Locale locale) {
        return this.findResourceBundle(DEFAULT_BUNDLE, locale);
    }

    public ResourceBundle getTexts(String bundleName, Locale locale) {
        return this.findResourceBundle(bundleName, locale);
    }
}

