/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.ipt.struts2;

import com.opensymphony.xwork2.ActionContext;
import com.opensymphony.xwork2.ActionInvocation;
import com.opensymphony.xwork2.interceptor.AbstractInterceptor;
import java.util.Map;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.struts2.dispatcher.Parameter;
import org.gbif.ipt.model.Resource;
import org.gbif.ipt.model.User;
import org.gbif.ipt.service.manage.ResourceManager;

/*
 * Exception performing whole class analysis ignored.
 */
public class RequireManagerInterceptor
extends AbstractInterceptor {
    private static final Logger LOG = LogManager.getLogger(RequireManagerInterceptor.class);
    private static final long serialVersionUID = -7688584369470756187L;
    private ResourceManager resourceManager;

    protected static String getResourceParam(ActionInvocation invocation) {
        String requestedResource = null;
        Parameter requestedResourceName = invocation.getInvocationContext().getParameters().get((Object)"r");
        if (requestedResourceName.isDefined()) {
            requestedResource = StringUtils.trimToNull((String)requestedResourceName.getValue());
        }
        return requestedResource;
    }

    protected static boolean hasResourceParam(ActionInvocation invocation) {
        return invocation.getInvocationContext().getParameters().containsKey((Object)"r");
    }

    public static boolean isAuthorized(User user, Resource resource) {
        if (user.hasAdminRights()) {
            return true;
        }
        if (resource != null && user.hasManagerRights()) {
            if (resource.getCreator().equals((Object)user)) {
                return true;
            }
            for (User m : resource.getManagers()) {
                if (!user.equals((Object)m)) continue;
                return true;
            }
        }
        return false;
    }

    public String intercept(ActionInvocation invocation) throws Exception {
        Map session = invocation.getInvocationContext().getSession();
        User user = (User)session.get("curr_user");
        if (user == null) {
            LOG.debug("User is not logged in, redirecting to login page");
            ActionContext context = invocation.getInvocationContext();
            HttpServletRequest request = (HttpServletRequest)context.get("com.opensymphony.xwork2.dispatcher.HttpServletRequest");
            String queryString = request.getQueryString();
            Object referer = request.getServletPath();
            if (queryString != null) {
                referer = (String)referer + "?" + queryString;
            }
            LOG.debug("Put referer into session: {}", referer);
            session.put("referer", referer);
            return "login";
        }
        if (user.hasManagerRights()) {
            String requestedResource = RequireManagerInterceptor.getResourceParam((ActionInvocation)invocation);
            if (requestedResource != null) {
                Resource resource = this.resourceManager.get(requestedResource);
                if (resource == null) {
                    return "404";
                }
                if (!RequireManagerInterceptor.isAuthorized((User)user, (Resource)resource)) {
                    return "401";
                }
                if (this.resourceManager.isLocked(requestedResource)) {
                    return "locked";
                }
            }
            return invocation.invoke();
        }
        return "401-manager";
    }

    @Inject
    public void setResourceManager(ResourceManager resourceManager) {
        this.resourceManager = resourceManager;
    }
}

