/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.ipt.struts2;

import com.opensymphony.xwork2.ActionInvocation;
import com.opensymphony.xwork2.interceptor.AbstractInterceptor;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Map;
import javax.inject.Inject;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.struts2.dispatcher.Parameter;
import org.gbif.ipt.model.Resource;
import org.gbif.ipt.model.User;
import org.gbif.ipt.model.VersionHistory;
import org.gbif.ipt.model.voc.PublicationStatus;
import org.gbif.ipt.service.manage.ResourceManager;
import org.gbif.ipt.struts2.RequireManagerInterceptor;

/*
 * Exception performing whole class analysis ignored.
 */
public class PrivateDeletedResourceInterceptor
extends AbstractInterceptor {
    private static final long serialVersionUID = 2340800191217429210L;
    private ResourceManager resourceManager;

    public String intercept(ActionInvocation invocation) throws Exception {
        String requestedResource = RequireManagerInterceptor.getResourceParam((ActionInvocation)invocation);
        if (requestedResource != null) {
            PublicationStatus resourceStatus;
            Resource resource = this.resourceManager.get(requestedResource);
            if (resource == null) {
                return "404";
            }
            Map session = invocation.getInvocationContext().getSession();
            User user = (User)session.get("curr_user");
            String requestedResourceVersion = PrivateDeletedResourceInterceptor.getResourceVersionParam((ActionInvocation)invocation);
            if (requestedResourceVersion != null) {
                try {
                    BigDecimal version = new BigDecimal(requestedResourceVersion);
                    VersionHistory history = resource.findVersionHistory(version);
                    if (history != null) {
                        if (history.getPublicationStatus() == PublicationStatus.PRIVATE) {
                            if (user == null || !this.isAuthorized(user, resource)) {
                                return "401";
                            }
                        } else if (!(history.getPublicationStatus() != PublicationStatus.DELETED || user != null && this.isAuthorized(user, resource))) {
                            return "410";
                        }
                    }
                }
                catch (NumberFormatException e) {
                    return "404";
                }
            }
            if (!(PublicationStatus.DELETED != resource.getStatus() || user != null && this.isAuthorized(user, resource))) {
                return "410";
            }
            PublicationStatus publicationStatus = resourceStatus = CollectionUtils.isNotEmpty((Collection)resource.getVersionHistory()) ? ((VersionHistory)resource.getVersionHistory().get(0)).getPublicationStatus() : resource.getStatus();
            if (!(PublicationStatus.PRIVATE != resourceStatus || user != null && this.isAuthorized(user, resource))) {
                return "401";
            }
        }
        return invocation.invoke();
    }

    private boolean isAuthorized(User user, Resource resource) {
        if (user.hasAdminRights()) {
            return true;
        }
        if (resource != null && resource.getCreator().equals((Object)user)) {
            return true;
        }
        if (user.hasManagerRights()) {
            for (User m : resource.getManagers()) {
                if (!user.equals((Object)m)) continue;
                return true;
            }
        }
        return false;
    }

    private static String getResourceVersionParam(ActionInvocation invocation) {
        String version = null;
        Parameter requestedResourceVersion = invocation.getInvocationContext().getParameters().get((Object)"v");
        if (requestedResourceVersion.isDefined()) {
            version = StringUtils.trimToNull((String)requestedResourceVersion.getValue());
        }
        return version;
    }

    @Inject
    public void setResourceManager(ResourceManager resourceManager) {
        this.resourceManager = resourceManager;
    }
}

