/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.ipt.struts2;

import com.opensymphony.xwork2.ActionContext;
import com.opensymphony.xwork2.ActionInvocation;
import com.opensymphony.xwork2.interceptor.AbstractInterceptor;
import java.net.URI;
import java.security.SecureRandom;
import java.util.Map;
import javax.inject.Inject;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.gbif.ipt.action.portal.AppFileAction;
import org.gbif.ipt.config.AppConfig;

public class CsrfLoginInterceptor
extends AbstractInterceptor {
    private static final String AB = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz";
    public static final String CSRFtoken = "CSRFtoken";
    private static final int TOKEN_LENGTH = 32;
    private static SecureRandom rnd = new SecureRandom();
    private AppConfig cfg;

    public String intercept(ActionInvocation invocation) throws Exception {
        ActionContext ac = invocation.getInvocationContext();
        HttpServletResponse resp = (HttpServletResponse)ac.get("com.opensymphony.xwork2.dispatcher.HttpServletResponse");
        Map session = ac.getSession();
        if (invocation.getAction() instanceof AppFileAction) {
            return invocation.invoke();
        }
        Cookie csrfCookie = new Cookie(CSRFtoken, null);
        if (session.containsKey("curr_user")) {
            csrfCookie.setMaxAge(0);
        } else {
            StringBuilder sb = new StringBuilder(32);
            for (int i = 0; i < 32; ++i) {
                sb.append(AB.charAt(rnd.nextInt(AB.length())));
            }
            String token = sb.toString();
            csrfCookie.setValue(token);
            csrfCookie.setMaxAge(this.cfg.getCsrfTokenExpiration());
            csrfCookie.setHttpOnly(true);
            try {
                URI iptUri = URI.create(this.cfg.getBaseUrl());
                csrfCookie.setPath(StringUtils.isEmpty((CharSequence)iptUri.getPath()) ? "/" : iptUri.getPath());
                csrfCookie.setDomain(iptUri.getHost());
                csrfCookie.setSecure(iptUri.getScheme().equalsIgnoreCase("https"));
            }
            catch (Exception exception) {
                // empty catch block
            }
            ac.put("newCsrfToken", (Object)token);
        }
        resp.addCookie(csrfCookie);
        return invocation.invoke();
    }

    @Inject
    public void setCfg(AppConfig cfg) {
        this.cfg = cfg;
    }
}

