/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.ipt.service.registry.impl;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonSyntaxException;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.net.ConnectException;
import java.net.SocketTimeoutException;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.NameValuePair;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.message.BasicNameValuePair;
import org.gbif.api.model.common.DOI;
import org.gbif.api.model.registry.Network;
import org.gbif.dwc.terms.DwcTerm;
import org.gbif.dwc.terms.Term;
import org.gbif.ipt.action.BaseAction;
import org.gbif.ipt.config.AppConfig;
import org.gbif.ipt.config.ConfigWarnings;
import org.gbif.ipt.config.DataDir;
import org.gbif.ipt.model.DataPackageSchema;
import org.gbif.ipt.model.Extension;
import org.gbif.ipt.model.Ipt;
import org.gbif.ipt.model.KeyNamePair;
import org.gbif.ipt.model.Organisation;
import org.gbif.ipt.model.Resource;
import org.gbif.ipt.model.VersionHistory;
import org.gbif.ipt.model.Vocabulary;
import org.gbif.ipt.model.datapackage.metadata.DataPackageMetadata;
import org.gbif.ipt.model.datapackage.metadata.col.ColMetadata;
import org.gbif.ipt.service.BaseManager;
import org.gbif.ipt.service.RegistryException;
import org.gbif.ipt.service.registry.RegistryManager;
import org.gbif.ipt.service.registry.impl.RegistryManagerImpl;
import org.gbif.ipt.struts2.SimpleTextProvider;
import org.gbif.ipt.utils.RegistryEntryHandler;
import org.gbif.ipt.validation.AgentValidator;
import org.gbif.metadata.eml.ipt.EmlFactory;
import org.gbif.metadata.eml.ipt.model.Agent;
import org.gbif.metadata.eml.ipt.model.Eml;
import org.gbif.utils.ExtendedResponse;
import org.gbif.utils.HttpClient;
import org.gbif.utils.HttpUtil;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class RegistryManagerImpl
extends BaseManager
implements RegistryManager {
    private final RegistryEntryHandler newRegistryEntryHandler = new RegistryEntryHandler();
    private static final String SERVICE_TYPE_EML = "EML";
    private static final String SERVICE_TYPE_CAMTRAP_DP = "CAMTRAP_DP";
    private static final String SERVICE_TYPE_COLDP = "COLDP";
    private static final String SERVICE_TYPE_OCCURRENCE = "DWC-ARCHIVE-OCCURRENCE";
    private static final String SERVICE_TYPE_MATERIAL_ENTITY = "DWC-ARCHIVE-MATERIAL-ENTITY";
    private static final String SERVICE_TYPE_CHECKLIST = "DWC-ARCHIVE-CHECKLIST";
    private static final String SERVICE_TYPE_SAMPLING_EVENT = "DWC-ARCHIVE-SAMPLING-EVENT";
    private static final String SERVICE_SUBTYPE_SPECIMEN = "";
    private static final String SERVICE_SUBTYPE_OBSERVATION = "";
    private static final String SERVICE_SUBTYPE_TAXONOMIC_AUTHORITY = "";
    private static final String SERVICE_SUBTYPE_NOMENCLATOR_AUTHORITY = "";
    private static final String SERVICE_SUBTYPE_INVENTORY_THEMATIC = "";
    private static final String SERVICE_SUBTYPE_INVENTORY_REGIONAL = "";
    private static final String SERVICE_SUBTYPE_GLOBAL_SPECIES_DATASET = "";
    private static final String SERVICE_SUBTYPE_DERIVED_FROM_OCCURRENCE = "";
    private static final String SERVICE_TYPE_RSS = "RSS";
    private static final String CONTACT_TYPE_TECHNICAL = "technical";
    private static final String CONTACT_TYPE_ADMINISTRATIVE = "administrative";
    private final HttpClient http;
    private SAXParser saxParser;
    private Gson gson;
    private ConfigWarnings warnings;
    private BaseAction baseAction;

    @Inject
    public RegistryManagerImpl(AppConfig cfg, DataDir dataDir, HttpClient client, SAXParserFactory saxFactory, ConfigWarnings warnings, SimpleTextProvider textProvider) throws ParserConfigurationException, SAXException {
        super(cfg, dataDir);
        this.saxParser = saxFactory.newSAXParser();
        this.http = client;
        this.gson = new GsonBuilder().setDateFormat("yyyy-MM-dd").create();
        this.warnings = warnings;
        this.baseAction = new BaseAction(textProvider, cfg, null);
    }

    private List<NameValuePair> buildRegistryParameters(Resource resource) {
        ArrayList<NameValuePair> data = new ArrayList<NameValuePair>();
        Eml eml = resource.getEml();
        DOI doi = resource.getAssignedDoi();
        if (doi != null) {
            data.add((NameValuePair)new BasicNameValuePair("doi", doi.toString()));
            this.LOG.debug("Including registry param doi=" + String.valueOf(doi));
        } else {
            DOI existingDoi = this.getLastPublishedVersionExistingDoi(resource);
            if (existingDoi != null) {
                data.add((NameValuePair)new BasicNameValuePair("doi", existingDoi.toString()));
                this.LOG.debug("Including registry param doi=" + String.valueOf(existingDoi));
            }
        }
        data.add((NameValuePair)new BasicNameValuePair("name", resource.getTitle() != null ? StringUtils.trimToEmpty((String)resource.getTitle()) : StringUtils.trimToEmpty((String)resource.getShortname())));
        data.add((NameValuePair)new BasicNameValuePair("description", String.join((CharSequence)System.lineSeparator(), eml.getDescription())));
        data.add((NameValuePair)new BasicNameValuePair("homepageURL", StringUtils.trimToEmpty((String)eml.getDistributionUrl())));
        data.add((NameValuePair)new BasicNameValuePair("logoURL", StringUtils.trimToEmpty((String)eml.getLogoUrl())));
        Agent primaryContact = this.getPrimaryContact(resource.getEml());
        if (primaryContact == null) {
            primaryContact = new Agent();
            primaryContact.setEmail(Collections.singletonList(resource.getCreator().getEmail()));
            primaryContact.setFirstName(resource.getCreator().getFirstname());
            primaryContact.setLastName(resource.getCreator().getLastname());
            primaryContact.setRole(null);
        }
        String primaryContactType = primaryContact.getRole() == null ? CONTACT_TYPE_TECHNICAL : CONTACT_TYPE_ADMINISTRATIVE;
        primaryContact.setRole(null);
        data.add((NameValuePair)new BasicNameValuePair("primaryContactType", primaryContactType));
        data.add((NameValuePair)new BasicNameValuePair("primaryContactEmail", !primaryContact.getEmail().isEmpty() ? StringUtils.trimToEmpty((String)((String)primaryContact.getEmail().get(0))) : ""));
        data.add((NameValuePair)new BasicNameValuePair("primaryContactName", StringUtils.trimToNull((String)StringUtils.trimToEmpty((String)primaryContact.getFullName()))));
        data.add((NameValuePair)new BasicNameValuePair("primaryContactAddress", StringUtils.trimToEmpty((String)primaryContact.getAddress().toFormattedString())));
        data.add((NameValuePair)new BasicNameValuePair("primaryContactPhone", !primaryContact.getPhone().isEmpty() ? StringUtils.trimToEmpty((String)((String)primaryContact.getPhone().get(0))) : ""));
        RegistryServices services = this.buildServiceTypeParams(resource);
        data.add((NameValuePair)new BasicNameValuePair("serviceTypes", services.serviceTypes));
        data.add((NameValuePair)new BasicNameValuePair("serviceURLs", services.serviceURLs));
        if (resource.getSubtype() != null) {
            data.add((NameValuePair)new BasicNameValuePair("subtype", resource.getSubtype()));
        }
        return data;
    }

    private List<NameValuePair> buildRegistryParametersForDataPackage(Resource resource) {
        if ("coldp".equals(resource.getCoreType())) {
            return this.buildRegistryParametersForColDP(resource);
        }
        if ("camtrap-dp".equals(resource.getCoreType())) {
            return this.buildRegistryParametersForCamtrapDP(resource);
        }
        this.LOG.error("Unknown data package type: {}", (Object)resource.getCoreType());
        return Collections.emptyList();
    }

    private List<NameValuePair> buildRegistryParametersForColDP(Resource resource) {
        ArrayList<NameValuePair> data = new ArrayList<NameValuePair>();
        DataPackageMetadata metadata = resource.getDataPackageMetadata();
        ColMetadata colMetadata = null;
        if (metadata instanceof ColMetadata) {
            colMetadata = (ColMetadata)metadata;
        }
        if (colMetadata != null) {
            data.add((NameValuePair)new BasicNameValuePair("name", resource.getTitle() != null ? StringUtils.trimToEmpty((String)resource.getTitle()) : StringUtils.trimToEmpty((String)resource.getShortname())));
            data.add((NameValuePair)new BasicNameValuePair("description", metadata.getDescription()));
            data.add((NameValuePair)new BasicNameValuePair("primaryContactType", CONTACT_TYPE_TECHNICAL));
            data.add((NameValuePair)new BasicNameValuePair("primaryContactEmail", resource.getCreator().getEmail()));
            data.add((NameValuePair)new BasicNameValuePair("primaryContactName", resource.getCreator().getFirstname()));
            data.add((NameValuePair)new BasicNameValuePair("serviceTypes", SERVICE_TYPE_COLDP));
            data.add((NameValuePair)new BasicNameValuePair("serviceUrls", this.cfg.getResourceArchiveUrl(resource.getShortname())));
            this.LOG.debug(data);
        } else {
            this.LOG.debug("Failed to extract ColMetadata to build registry parameters! Metadata type is {}", (Object)metadata.getClass().getSimpleName());
        }
        return data;
    }

    private List<NameValuePair> buildRegistryParametersForCamtrapDP(Resource resource) {
        ArrayList<NameValuePair> data = new ArrayList<NameValuePair>();
        DataPackageMetadata metadata = resource.getDataPackageMetadata();
        data.add((NameValuePair)new BasicNameValuePair("name", resource.getTitle() != null ? StringUtils.trimToEmpty((String)resource.getTitle()) : StringUtils.trimToEmpty((String)resource.getShortname())));
        data.add((NameValuePair)new BasicNameValuePair("description", metadata.getDescription()));
        data.add((NameValuePair)new BasicNameValuePair("primaryContactType", CONTACT_TYPE_TECHNICAL));
        data.add((NameValuePair)new BasicNameValuePair("primaryContactEmail", resource.getCreator().getEmail()));
        data.add((NameValuePair)new BasicNameValuePair("primaryContactName", resource.getCreator().getFirstname()));
        data.add((NameValuePair)new BasicNameValuePair("serviceTypes", SERVICE_TYPE_CAMTRAP_DP));
        data.add((NameValuePair)new BasicNameValuePair("serviceUrls", this.cfg.getResourceArchiveUrl(resource.getShortname())));
        return data;
    }

    private RegistryServices buildServiceTypeParams(Resource resource) {
        RegistryServices rs = new RegistryServices();
        rs.serviceTypes = SERVICE_TYPE_EML;
        rs.serviceURLs = this.cfg.getResourceEmlUrl(resource.getShortname());
        Term resourceCoreTypeTerm = resource.getCoreTypeTerm();
        String resourceShortname = resource.getShortname();
        if (resource.hasPublishedData() && resourceCoreTypeTerm != null) {
            if (DwcTerm.Occurrence == resourceCoreTypeTerm) {
                this.LOG.debug("Registering EML & DwC-A Occurrence Service");
                rs.serviceURLs = rs.serviceURLs + "|" + this.cfg.getResourceArchiveUrl(resourceShortname);
                rs.serviceTypes = rs.serviceTypes + "|DWC-ARCHIVE-OCCURRENCE";
            } else if (DwcTerm.MaterialEntity == resourceCoreTypeTerm) {
                this.LOG.debug("Registering EML & DwC-A Material Entity Service");
                rs.serviceURLs = rs.serviceURLs + "|" + this.cfg.getResourceArchiveUrl(resourceShortname);
                rs.serviceTypes = rs.serviceTypes + "|DWC-ARCHIVE-MATERIAL-ENTITY";
            } else if (DwcTerm.Taxon == resourceCoreTypeTerm) {
                this.LOG.debug("Registering EML & DwC-A Checklist Service");
                rs.serviceURLs = rs.serviceURLs + "|" + this.cfg.getResourceArchiveUrl(resourceShortname);
                rs.serviceTypes = rs.serviceTypes + "|DWC-ARCHIVE-CHECKLIST";
            } else if (DwcTerm.Event == resourceCoreTypeTerm) {
                this.LOG.debug("Registering EML & DwC-A Sampling Event Service");
                rs.serviceURLs = rs.serviceURLs + "|" + this.cfg.getResourceArchiveUrl(resourceShortname);
                rs.serviceTypes = rs.serviceTypes + "|DWC-ARCHIVE-SAMPLING-EVENT";
            } else {
                this.LOG.warn("Unknown core resource type " + String.valueOf(resourceCoreTypeTerm));
                this.LOG.debug("Registering EML service only");
            }
        } else {
            this.LOG.debug("Resource has no published data, therefore only the EML Service will be registered");
        }
        return rs;
    }

    public void deregister(Resource resource) throws RegistryException {
        String url = this.getDeleteResourceUri(resource.getKey().toString());
        try {
            if (resource.getOrganisation() != null) {
                ExtendedResponse resp = this.http.delete(url, this.orgCredentials(resource.getOrganisation()));
                if (!HttpUtil.success((ExtendedResponse)resp)) {
                    this.LOG.error("Deregister resource response received=" + resp.getStatusCode() + ": " + resp.getContent());
                    throw new RegistryException(RegistryException.Type.BAD_RESPONSE, url, "Empty registry response");
                }
            } else {
                throw new RegistryException(RegistryException.Type.NOT_AUTHORISED, null, "Credentials should be specified");
            }
            this.LOG.info("The resource has been deleted. Resource key: " + resource.getKey().toString());
        }
        catch (IOException e) {
            throw new RegistryException(RegistryException.Type.IO_ERROR, url, (Exception)e);
        }
        catch (Exception e) {
            String msg = "Bad registry response: " + e.getMessage();
            this.LOG.error(msg, (Throwable)e);
            throw new RegistryException(RegistryException.Type.BAD_RESPONSE, url, msg);
        }
    }

    private String getDeleteResourceUri(String resourceKey) {
        return String.format("%s%s%s", this.cfg.getRegistryUrl(), "/registry/ipt/resource/", resourceKey);
    }

    public List<Extension> getLatestExtensions() throws RegistryException {
        Map jSONExtensions = (Map)this.gson.fromJson(this.requestHttpGetFromRegistry(this.getExtensionsURL(true)).getContent(), new /* Unavailable Anonymous Inner Class!! */.getType());
        List allExtensions = jSONExtensions.get("extensions") == null ? new ArrayList() : (List)jSONExtensions.get("extensions");
        return allExtensions.stream().filter(Extension::isLatest).collect(Collectors.toList());
    }

    public List<Extension> getExtensions() throws RegistryException {
        Map jSONExtensions = (Map)this.gson.fromJson(this.requestHttpGetFromRegistry(this.getExtensionsURL(true)).getContent(), new /* Unavailable Anonymous Inner Class!! */.getType());
        return jSONExtensions.get("extensions") == null ? new ArrayList() : (List)jSONExtensions.get("extensions");
    }

    public List<DataPackageSchema> getLatestDataPackageSchemas() throws RegistryException {
        Map jSONDataSchemas = (Map)this.gson.fromJson(this.requestHttpGetFromRegistry(this.getDataSchemasURL()).getContent(), new /* Unavailable Anonymous Inner Class!! */.getType());
        return jSONDataSchemas.get("dataPackages") == null ? new ArrayList() : (List)jSONDataSchemas.get("dataPackages");
    }

    public String getLatestCompatibleSchemaVersion(String schemaName, String schemaVersion) throws RegistryException {
        Map jSON = (Map)this.gson.fromJson(this.requestHttpGetFromRegistry(this.getDataSchemaVersionURL(schemaName, schemaVersion)).getContent(), new /* Unavailable Anonymous Inner Class!! */.getType());
        return (String)jSON.get("latestCompatibleVersion");
    }

    public DataPackageSchema getSchema(String schemaName, String schemaVersion) throws RegistryException {
        return (DataPackageSchema)this.gson.fromJson(this.requestHttpGetFromRegistry(this.getDataSchemaURL(schemaName, schemaVersion)).getContent(), new /* Unavailable Anonymous Inner Class!! */.getType());
    }

    public List<DataPackageSchema> getSupportedDataSchemas() throws RegistryException {
        ArrayList<DataPackageSchema> result = new ArrayList<DataPackageSchema>();
        Map schemasWithVersions = this.baseAction.getCfg().getSupportedDataSchemaNamesWithVersions();
        for (Map.Entry entrySchemaVersion : schemasWithVersions.entrySet()) {
            DataPackageSchema jsonDataSchema = (DataPackageSchema)this.gson.fromJson(this.requestHttpGetFromRegistry(this.getDataSchemaURL((String)entrySchemaVersion.getKey(), (String)entrySchemaVersion.getValue())).getContent(), new /* Unavailable Anonymous Inner Class!! */.getType());
            result.add(jsonDataSchema);
        }
        return result;
    }

    private String getExtensionsURL(boolean json) {
        return String.format("%s%s%s", this.cfg.getRegistryUrl(), "/registry/extensions", json ? ".json" : "/");
    }

    private String getDataSchemasURL() {
        return this.cfg.getRegistryUrl() + "/registry/dataPackages.json";
    }

    private String getDataSchemaURL(String schemaName, String schemaVersion) {
        return this.cfg.getRegistryUrl() + "/registry/dataPackages/" + schemaName + "/" + schemaVersion;
    }

    private String getDataSchemaVersionURL(String schemaName, String schemaVersion) {
        return this.cfg.getRegistryUrl() + "/registry/dataPackages/" + schemaName + "/" + schemaVersion + "/version.json";
    }

    private String getIptResourceUri() {
        return String.format("%s%s", this.cfg.getRegistryUrl(), "/registry/ipt/resource");
    }

    private String getIptUpdateResourceUri(String resourceKey) {
        return String.format("%s%s%s", this.cfg.getRegistryUrl(), "/registry/ipt/resource/", resourceKey);
    }

    private String getIptUpdateUri(String iptKey) {
        return String.format("%s%s%s", this.cfg.getRegistryUrl(), "/registry/ipt/update/", iptKey);
    }

    private String getIptUri() {
        return String.format("%s%s", this.cfg.getRegistryUrl(), "/registry/ipt/register");
    }

    private String getLoginURL(String organisationKey) {
        return String.format("%s%s%s%s", this.cfg.getRegistryUrl(), "/registry/organisation/", organisationKey, "?op=login");
    }

    @Deprecated
    private String getOrganisationsResourcesUri(String organisationKey) {
        return String.format("%s%s%s", this.cfg.getRegistryUrl(), "/registry/resource.json?organisationKey=", organisationKey);
    }

    private String getResourceBelongsToOrganisationUri(String resourceKey, String organisationKey) {
        return this.cfg.getRegistryUrl() + "/registry/resource/" + resourceKey + "/belongs/organisation/" + organisationKey;
    }

    private String getOrganisationUri(String organisationKey) {
        return String.format("%s%s%s", this.cfg.getRegistryUrl(), "/registry/organisation/", organisationKey + ".json");
    }

    public List<Organisation> getOrganisations() {
        String msg;
        List organisationsTemp = new ArrayList();
        try {
            organisationsTemp = (List)this.gson.fromJson(this.requestHttpGetFromRegistry(this.getOrganisationsURL()).getContent(), new /* Unavailable Anonymous Inner Class!! */.getType());
        }
        catch (RegistryException e) {
            msg = RegistryException.logRegistryException((RegistryException)e, (BaseAction)this.baseAction);
            this.warnings.addStartupError(msg);
            this.LOG.error(msg);
            msg = this.baseAction.getText("admin.organisations.couldnt.load", new String[]{this.cfg.getRegistryUrl()});
            this.warnings.addStartupError(msg);
            this.LOG.error(msg);
        }
        catch (JsonSyntaxException e) {
            msg = this.baseAction.getText("admin.organisations.couldnt.load", new String[]{this.cfg.getRegistryUrl()});
            this.warnings.addStartupError(msg);
            this.LOG.error(msg);
        }
        ArrayList<Organisation> organisations = new ArrayList<Organisation>();
        int invalid = 0;
        for (Map org : organisationsTemp) {
            if (org.isEmpty() || StringUtils.isBlank((CharSequence)((CharSequence)org.get("key"))) || StringUtils.isBlank((CharSequence)((CharSequence)org.get("name")))) {
                ++invalid;
            } else {
                Organisation o = new Organisation();
                o.setName((String)org.get("name"));
                try {
                    o.setKey((String)org.get("key"));
                    organisations.add(o);
                }
                catch (IllegalArgumentException e) {
                    ++invalid;
                }
            }
            if (invalid <= 0) continue;
            this.LOG.debug("Skipped " + invalid + " invalid organisation JSON objects");
        }
        return organisations;
    }

    public Organisation getRegisteredOrganisation(String key) {
        Organisation organisation = null;
        if (StringUtils.isNotBlank((CharSequence)key)) {
            try {
                organisation = (Organisation)this.gson.fromJson(this.requestHttpGetFromRegistry(this.getOrganisationUri(key)).getContent(), new /* Unavailable Anonymous Inner Class!! */.getType());
            }
            catch (RegistryException e) {
                String msg = RegistryException.logRegistryException((RegistryException)e, (BaseAction)this.baseAction);
                this.warnings.addStartupError(msg);
                this.LOG.error(msg);
                msg = this.baseAction.getText("admin.organisation.couldnt.load", new String[]{key, this.cfg.getRegistryUrl()});
                this.warnings.addStartupError(msg);
                this.LOG.error(msg);
            }
            catch (JsonSyntaxException e) {
                String msg = this.baseAction.getText("admin.organisation.couldnt.load", new String[]{key, this.cfg.getRegistryUrl()});
                this.warnings.addStartupError(msg);
                this.LOG.error(msg);
            }
        }
        return organisation;
    }

    private String getOrganisationsURL() {
        return this.cfg.getRegistryUrl() + "/registry/organisation.json";
    }

    private String getListNetworksURL() {
        return this.cfg.getRegistryUrl() + "/registry/network.json";
    }

    private String getResourceListNetworksURL(String resourceKey) {
        return this.cfg.getRegistryUrl() + "/registry/resource/" + resourceKey + "/networks";
    }

    private String getAddOrRemoveNetworkURL(String resourceKey, String networkKey) {
        return this.cfg.getRegistryUrl() + "/registry/resource/" + resourceKey + "/network/" + networkKey;
    }

    private Agent getPrimaryContact(Eml eml) {
        ArrayList<Agent> agents = new ArrayList<Agent>();
        for (Agent contact : eml.getContacts()) {
            contact.setRole("PointOfContact");
            agents.add(contact);
        }
        for (Agent creator : eml.getCreators()) {
            creator.setRole("Originator");
            agents.add(creator);
        }
        for (Agent metadataProvider : eml.getMetadataProviders()) {
            metadataProvider.setRole("MetadataProvider");
            agents.add(metadataProvider);
        }
        for (Agent agent : agents) {
            if (!AgentValidator.hasCompleteContactInfo((Agent)agent)) continue;
            return agent;
        }
        return null;
    }

    private String getRssFeedURL() {
        return String.format("%s/rss.do", this.cfg.getBaseUrl());
    }

    protected InputStream getStream(String source) {
        return new ByteArrayInputStream(source.getBytes(StandardCharsets.UTF_8));
    }

    public List<Vocabulary> getVocabularies() throws RegistryException {
        Map jSONVocabularies = (Map)this.gson.fromJson(this.requestHttpGetFromRegistry(this.getVocabulariesURL(true)).getContent(), new /* Unavailable Anonymous Inner Class!! */.getType());
        return jSONVocabularies.get("thesauri") == null ? new ArrayList() : (List)jSONVocabularies.get("thesauri");
    }

    public boolean isResourceBelongsToOrganisation(String key, String organisationKey) throws RegistryException {
        String url = this.getResourceBelongsToOrganisationUri(key, organisationKey);
        String rawContent = this.requestHttpGetFromRegistry(url).getContent();
        return BooleanUtils.toBoolean((String)rawContent);
    }

    @Deprecated
    public List<Resource> getOrganisationsResources(String organisationKey) throws RegistryException {
        List resourcesTemp;
        String url = this.getOrganisationsResourcesUri(organisationKey);
        try {
            resourcesTemp = (List)this.gson.fromJson(this.requestHttpGetFromRegistry(url).getContent(), new /* Unavailable Anonymous Inner Class!! */.getType());
        }
        catch (JsonSyntaxException e) {
            throw new RegistryException(RegistryException.Type.BAD_RESPONSE, url, "Unexpected, non-parsable response format encountered.");
        }
        ArrayList<Resource> resources = new ArrayList<Resource>();
        int invalid = 0;
        for (Map res : resourcesTemp) {
            if (res.isEmpty() || StringUtils.isBlank((CharSequence)((CharSequence)res.get("key"))) || StringUtils.isBlank((CharSequence)((CharSequence)res.get("name")))) {
                ++invalid;
            } else {
                Resource r = new Resource();
                r.setShortname((String)res.get("name"));
                r.setTitle((String)res.get("name"));
                String key = (String)res.get("key");
                try {
                    UUID uuid = UUID.fromString(key);
                    r.setKey(uuid);
                }
                catch (IllegalArgumentException e) {
                    ++invalid;
                }
                resources.add(r);
            }
            if (invalid <= 0) continue;
            this.LOG.debug("Skipped " + invalid + " invalid dataset JSON objects");
        }
        return resources;
    }

    public List<Network> getResourceNetworks(Resource resource) throws RegistryException {
        List<Object> networks = new ArrayList<Network>();
        if (resource != null && resource.getKey() != null) {
            try {
                ExtendedResponse response = this.requestHttpGetFromRegistry(this.getResourceListNetworksURL(resource.getKey().toString()));
                if (response.getStatusCode() != 200) {
                    throw new RegistryException(RegistryException.Type.BAD_RESPONSE, this.getResourceListNetworksURL(resource.getKey().toString()), "Wrong response code " + response.getStatusCode());
                }
                String content = response.getContent();
                networks = (List)this.gson.fromJson(content, new /* Unavailable Anonymous Inner Class!! */.getType());
            }
            catch (JsonSyntaxException e) {
                String msg = this.baseAction.getText("admin.networks.couldnt.load", new String[]{this.cfg.getRegistryUrl()});
                this.warnings.addStartupError(msg);
                this.LOG.error(msg);
            }
        }
        return networks;
    }

    public List<KeyNamePair> getNetworksBrief() throws RegistryException {
        ArrayList<KeyNamePair> networks = new ArrayList();
        try {
            ExtendedResponse response = this.requestHttpGetFromRegistry(this.getListNetworksURL());
            if (response.getStatusCode() != 200) {
                throw new RegistryException(RegistryException.Type.BAD_RESPONSE, this.getListNetworksURL(), "Wrong response code " + response.getStatusCode());
            }
            String content = response.getContent();
            networks = (List)this.gson.fromJson(content, new /* Unavailable Anonymous Inner Class!! */.getType());
        }
        catch (JsonSyntaxException e) {
            String msg = this.baseAction.getText("admin.networks.couldnt.load", new String[]{this.cfg.getRegistryUrl()});
            this.warnings.addStartupError(msg);
            this.LOG.error(msg);
        }
        return networks;
    }

    public void addResourceToNetwork(Resource resource, String networkKey) throws RegistryException {
        block6: {
            String url = this.getAddOrRemoveNetworkURL(resource.getKey().toString(), networkKey);
            try {
                if (resource.getOrganisation() != null) {
                    ExtendedResponse resp = this.http.post(url, null, this.orgCredentials(resource.getOrganisation()));
                    if (!HttpUtil.success((ExtendedResponse)resp)) {
                        this.LOG.error("Response received=" + resp.getStatusCode() + ": " + resp.getContent());
                        throw new RegistryException(RegistryException.Type.BAD_REQUEST, url, resp.getContent());
                    }
                } else {
                    throw new RegistryException(RegistryException.Type.NOT_AUTHORISED, null, "Credentials should be specified");
                }
                this.LOG.info("The resource {} has been added to network {}.", (Object)resource.getKey().toString(), (Object)networkKey);
            }
            catch (IOException e) {
                throw new RegistryException(RegistryException.Type.IO_ERROR, url, (Exception)e);
            }
            catch (Exception e) {
                if (e instanceof RegistryException) break block6;
                String msg = "Bad registry response: " + e.getMessage();
                this.LOG.error(msg, (Throwable)e);
                throw new RegistryException(RegistryException.Type.BAD_RESPONSE, url, msg);
            }
        }
    }

    public void removeResourceFromNetwork(Resource resource, String networkKey) throws RegistryException {
        block6: {
            String url = this.getAddOrRemoveNetworkURL(resource.getKey().toString(), networkKey);
            try {
                if (resource.getOrganisation() != null) {
                    ExtendedResponse resp = this.http.delete(url, this.orgCredentials(resource.getOrganisation()));
                    if (!HttpUtil.success((ExtendedResponse)resp)) {
                        this.LOG.error("Response received=" + resp.getStatusCode() + ": " + resp.getContent());
                        throw new RegistryException(RegistryException.Type.BAD_REQUEST, url, resp.getContent());
                    }
                } else {
                    throw new RegistryException(RegistryException.Type.NOT_AUTHORISED, null, "Credentials should be specified");
                }
                this.LOG.info("The resource {} has been removed from network {}.", (Object)resource.getKey().toString(), (Object)networkKey);
            }
            catch (IOException e) {
                throw new RegistryException(RegistryException.Type.IO_ERROR, url, (Exception)e);
            }
            catch (Exception e) {
                if (e instanceof RegistryException) break block6;
                String msg = "Bad registry response: " + e.getMessage();
                this.LOG.error(msg, (Throwable)e);
                throw new RegistryException(RegistryException.Type.BAD_RESPONSE, url, msg);
            }
        }
    }

    private ExtendedResponse requestHttpGetFromRegistry(String url) throws RegistryException {
        try {
            ExtendedResponse resp = this.http.get(url);
            if (resp.getContent() != null) {
                return resp;
            }
            throw new RegistryException(RegistryException.Type.BAD_RESPONSE, url, "Response content is null");
        }
        catch (RegistryException e) {
            throw e;
        }
        catch (ClassCastException e) {
            throw new RegistryException(RegistryException.Type.BAD_RESPONSE, url, (Exception)e);
        }
        catch (ConnectException | SocketTimeoutException e) {
            throw new RegistryException(RegistryException.Type.PROXY, url, (Exception)e);
        }
        catch (UnknownHostException e) {
            try {
                this.http.get("https://www.google.com");
            }
            catch (Exception e1) {
                throw new RegistryException(RegistryException.Type.NO_INTERNET, url, e1);
            }
            throw new RegistryException(RegistryException.Type.SITE_DOWN, url, (Exception)e);
        }
        catch (IOException e) {
            throw new RegistryException(RegistryException.Type.IO_ERROR, url, (Exception)e);
        }
        catch (URISyntaxException e) {
            throw new RegistryException(RegistryException.Type.BAD_REQUEST, url, "Please check the request URL: " + (url != null ? url : "empty URL used!"));
        }
        catch (Exception e) {
            throw new RegistryException(RegistryException.Type.UNKNOWN, url, e);
        }
    }

    private String getVocabulariesURL(boolean json) {
        return String.format("%s%s%s", this.cfg.getRegistryUrl(), "/registry/thesauri", json ? ".json" : "/");
    }

    private UsernamePasswordCredentials orgCredentials(Organisation org) {
        return new UsernamePasswordCredentials(org.getKey().toString(), org.getPassword());
    }

    public UUID register(Resource resource, Organisation org, Ipt ipt) throws RegistryException {
        UUID uuidKey;
        String key;
        ExtendedResponse resp;
        this.LOG.debug("Registering resource...");
        if (!resource.isPublished()) {
            this.LOG.warn("Cannot register, resource not published yet");
            return null;
        }
        List data = resource.isDataPackage() ? this.buildRegistryParametersForDataPackage(resource) : this.buildRegistryParameters(resource);
        data.add(new BasicNameValuePair("organisationKey", StringUtils.trimToEmpty((String)org.getKey().toString())));
        data.add(new BasicNameValuePair("iptKey", StringUtils.trimToEmpty((String)ipt.getKey().toString())));
        String url = this.getIptResourceUri();
        try {
            resp = this.http.post(url, null, this.orgCredentials(org), (HttpEntity)new UrlEncodedFormEntity((Iterable)data, StandardCharsets.UTF_8));
        }
        catch (URISyntaxException e) {
            throw new RegistryException(RegistryException.Type.BAD_REQUEST, url, "Register resource failed: request URI invalid", (Exception)e);
        }
        catch (IOException e) {
            throw new RegistryException(RegistryException.Type.IO_ERROR, url, "Register resource failed: I/O exception occurred", (Exception)e);
        }
        if (!HttpUtil.success((ExtendedResponse)resp)) {
            RegistryException.Type type = this.getRegistryExceptionType(resp.getStatusCode());
            throw new RegistryException(type, url, "Register resource failed: " + String.valueOf(resp.getStatusLine()));
        }
        this.LOG.info("Register resource was successful!");
        try {
            this.saxParser.parse(this.getStream(resp.getContent()), (DefaultHandler)this.newRegistryEntryHandler);
            key = this.newRegistryEntryHandler.key;
            if (StringUtils.trimToNull((String)key) == null) {
                key = this.newRegistryEntryHandler.resourceKey;
            }
        }
        catch (SAXException e) {
            throw new RegistryException(RegistryException.Type.BAD_RESPONSE, url, "Response received from resource registration couldn't be parsed", (Exception)e);
        }
        catch (IOException e) {
            throw new RegistryException(RegistryException.Type.IO_ERROR, url, "Response received from resource registration couldn't be parsed", (Exception)e);
        }
        if (StringUtils.trimToNull((String)key) == null) {
            throw new RegistryException(RegistryException.Type.BAD_RESPONSE, url, "Response received from resource registration missing key!");
        }
        try {
            uuidKey = UUID.fromString(key);
        }
        catch (IllegalArgumentException e) {
            throw new RegistryException(RegistryException.Type.BAD_RESPONSE, url, "Response received from resource registration has invalid key");
        }
        this.LOG.info("A new resource has been registered with GBIF. [Key=" + key + "]");
        resource.setKey(uuidKey);
        resource.setOrganisation(org);
        return uuidKey;
    }

    public String registerIPT(Ipt ipt, Organisation org) throws RegistryException {
        UUID uuidKey;
        String key;
        ExtendedResponse resp;
        this.LOG.info("Registering IPT instance...");
        String orgKey = org.getKey().toString();
        List data = this.buildIPTParameters(ipt, orgKey);
        data.add(new BasicNameValuePair("wsPassword", StringUtils.trimToEmpty((String)ipt.getWsPassword())));
        String url = this.getIptUri();
        try {
            resp = this.http.post(url, null, this.orgCredentials(org), (HttpEntity)new UrlEncodedFormEntity((Iterable)data, StandardCharsets.UTF_8));
        }
        catch (URISyntaxException e) {
            throw new RegistryException(RegistryException.Type.BAD_REQUEST, url, "Register IPT failed: request URI invalid", (Exception)e);
        }
        catch (IOException e) {
            throw new RegistryException(RegistryException.Type.IO_ERROR, url, "Register IPT failed: I/O exception occurred", (Exception)e);
        }
        if (!HttpUtil.success((ExtendedResponse)resp)) {
            RegistryException.Type type = this.getRegistryExceptionType(resp.getStatusCode());
            throw new RegistryException(type, url, "Register IPT failed: " + String.valueOf(resp.getStatusLine()));
        }
        this.LOG.info("Register IPT was successful!");
        try {
            this.saxParser.parse(this.getStream(resp.getContent()), (DefaultHandler)this.newRegistryEntryHandler);
            key = this.newRegistryEntryHandler.key;
        }
        catch (SAXException e) {
            throw new RegistryException(RegistryException.Type.BAD_RESPONSE, url, "Response received from IPT registration couldn't be parsed", (Exception)e);
        }
        catch (IOException e) {
            throw new RegistryException(RegistryException.Type.IO_ERROR, url, "Response received from IPT registration couldn't be parsed", (Exception)e);
        }
        if (StringUtils.trimToNull((String)key) == null) {
            throw new RegistryException(RegistryException.Type.BAD_RESPONSE, url, "Response received from IPT registration missing key!");
        }
        try {
            uuidKey = UUID.fromString(key);
        }
        catch (IllegalArgumentException e) {
            throw new RegistryException(RegistryException.Type.BAD_RESPONSE, url, "Response received from IPT registration has invalid key");
        }
        this.LOG.info("A new ipt has been registered with GBIF. [Key=" + String.valueOf(uuidKey) + "]");
        ipt.setKey(uuidKey.toString());
        return key;
    }

    private UsernamePasswordCredentials iptCredentials(Ipt ipt) {
        return new UsernamePasswordCredentials(ipt.getKey().toString(), ipt.getWsPassword());
    }

    private List<NameValuePair> buildIPTParameters(Ipt ipt, String organisationKey) {
        ArrayList<NameValuePair> data = new ArrayList<NameValuePair>();
        if (ipt != null && organisationKey != null) {
            data.add((NameValuePair)new BasicNameValuePair("organisationKey", StringUtils.trimToEmpty((String)organisationKey)));
            data.add((NameValuePair)new BasicNameValuePair("name", StringUtils.trimToEmpty((String)ipt.getName())));
            data.add((NameValuePair)new BasicNameValuePair("description", StringUtils.trimToEmpty((String)ipt.getDescription())));
            data.add((NameValuePair)new BasicNameValuePair("primaryContactType", StringUtils.trimToEmpty((String)ipt.getPrimaryContactType())));
            data.add((NameValuePair)new BasicNameValuePair("primaryContactName", StringUtils.trimToEmpty((String)ipt.getPrimaryContactName())));
            data.add((NameValuePair)new BasicNameValuePair("primaryContactEmail", StringUtils.trimToEmpty((String)ipt.getPrimaryContactEmail())));
            data.add((NameValuePair)new BasicNameValuePair("serviceTypes", SERVICE_TYPE_RSS));
            data.add((NameValuePair)new BasicNameValuePair("serviceURLs", this.getRssFeedURL()));
        } else {
            this.LOG.debug("One or both of IPT and Organisation key were null. Params needed for ws will be empty");
        }
        return data;
    }

    public void updateIpt(Ipt ipt) throws RegistryException {
        ExtendedResponse resp;
        this.LOG.info("Update IPT registration...");
        String orgKey = ipt != null && ipt.getOrganisationKey() != null ? ipt.getOrganisationKey().toString() : null;
        List data = this.buildIPTParameters(ipt, orgKey);
        String url = this.getIptUpdateUri(ipt.getKey().toString());
        try {
            resp = this.http.post(url, null, this.iptCredentials(ipt), (HttpEntity)new UrlEncodedFormEntity((Iterable)data, StandardCharsets.UTF_8));
        }
        catch (URISyntaxException e) {
            throw new RegistryException(RegistryException.Type.BAD_REQUEST, url, "Update IPT registration failed: request URI invalid", (Exception)e);
        }
        catch (IOException e) {
            throw new RegistryException(RegistryException.Type.IO_ERROR, url, "Update IPT registration failed: I/O exception occurred", (Exception)e);
        }
        if (!HttpUtil.success((ExtendedResponse)resp)) {
            RegistryException.Type type = this.getRegistryExceptionType(resp.getStatusCode());
            throw new RegistryException(type, url, "Update IPT registration failed: " + String.valueOf(resp.getStatusLine()));
        }
        this.LOG.info("Update IPT registration was successful!");
    }

    public void updateResource(Resource resource, String iptKey) throws RegistryException, IllegalArgumentException {
        ExtendedResponse resp;
        if (!resource.isRegistered() || resource.getKey() == null) {
            throw new IllegalArgumentException("Update resource registration failed: resource [shortname=" + resource.getShortname() + "] is not registered");
        }
        this.LOG.info("Update resource registration... [key=" + resource.getKey().toString() + "]");
        List data = resource.isDataPackage() ? this.buildRegistryParametersForDataPackage(resource) : this.buildRegistryParameters(resource);
        data.add(new BasicNameValuePair("iptKey", StringUtils.trimToEmpty((String)iptKey)));
        String url = this.getIptUpdateResourceUri(resource.getKey().toString());
        try {
            resp = this.http.post(url, null, this.orgCredentials(resource.getOrganisation()), (HttpEntity)new UrlEncodedFormEntity((Iterable)data, StandardCharsets.UTF_8));
        }
        catch (URISyntaxException e) {
            throw new RegistryException(RegistryException.Type.BAD_REQUEST, url, "Update resource registration failed: request URI invalid", (Exception)e);
        }
        catch (IOException e) {
            throw new RegistryException(RegistryException.Type.IO_ERROR, url, "Update resource registration failed: I/O exception occurred", (Exception)e);
        }
        if (!HttpUtil.success((ExtendedResponse)resp)) {
            RegistryException.Type type = this.getRegistryExceptionType(resp.getStatusCode());
            throw new RegistryException(type, url, "Update resource registration failed [shortname=" + resource.getShortname() + ", key=" + resource.getKey().toString() + "]: " + String.valueOf(resp.getStatusLine()));
        }
        this.LOG.info("Update resource registration was successful! [key=" + resource.getKey().toString() + "]");
        this.baseAction.addActionMessage(this.baseAction.getText("manage.overview.resource.update.registration", new String[]{resource.getTitle()}));
    }

    protected RegistryException.Type getRegistryExceptionType(int code) {
        RegistryException.Type type;
        if (code <= 300) {
            throw new IllegalArgumentException();
        }
        switch (code) {
            case 400: {
                type = RegistryException.Type.BAD_REQUEST;
                break;
            }
            case 401: {
                type = RegistryException.Type.NOT_AUTHORISED;
                break;
            }
            default: {
                type = RegistryException.Type.BAD_RESPONSE;
            }
        }
        return type;
    }

    public boolean validateOrganisation(String organisationKey, String password) {
        try {
            ExtendedResponse resp = this.http.get(this.getLoginURL(organisationKey), new UsernamePasswordCredentials(organisationKey, password));
            return HttpUtil.success((ExtendedResponse)resp);
        }
        catch (Exception e) {
            this.LOG.warn("The organisation could not be validated using key (" + organisationKey + ") and password (" + password + ")", (Throwable)e);
            return false;
        }
    }

    protected DOI getLastPublishedVersionExistingDoi(Resource resource) {
        VersionHistory lastPublishedVersion = resource.getLastPublishedVersion();
        if (lastPublishedVersion != null) {
            BigDecimal version = new BigDecimal(lastPublishedVersion.getVersion());
            File emlFile = this.cfg.getDataDir().resourceEmlFile(resource.getShortname(), version);
            if (emlFile.exists()) {
                try {
                    String identifier;
                    this.LOG.debug("Loading EML from file: " + emlFile.getAbsolutePath());
                    FileInputStream in = new FileInputStream(emlFile);
                    Eml eml = EmlFactory.build((InputStream)in);
                    if (eml.getCitation() != null && StringUtils.isNotBlank((CharSequence)eml.getCitation().getIdentifier()) && DOI.isParsable((String)(identifier = StringUtils.trimToNull((String)eml.getCitation().getIdentifier())))) {
                        return new DOI(identifier);
                    }
                }
                catch (Exception e) {
                    this.LOG.error("Failed to check last published version citation identifier: " + e.getMessage(), (Throwable)e);
                }
            }
        }
        return null;
    }
}

