/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.ipt.service.registry;

import java.util.List;
import java.util.UUID;
import org.gbif.api.model.registry.Network;
import org.gbif.ipt.model.DataPackageSchema;
import org.gbif.ipt.model.Extension;
import org.gbif.ipt.model.Ipt;
import org.gbif.ipt.model.KeyNamePair;
import org.gbif.ipt.model.Organisation;
import org.gbif.ipt.model.Resource;
import org.gbif.ipt.model.Vocabulary;
import org.gbif.ipt.service.RegistryException;

public interface RegistryManager {
    public void deregister(Resource var1) throws RegistryException;

    public List<Extension> getLatestExtensions() throws RegistryException;

    public List<Extension> getExtensions() throws RegistryException;

    public List<DataPackageSchema> getLatestDataPackageSchemas() throws RegistryException;

    public String getLatestCompatibleSchemaVersion(String var1, String var2) throws RegistryException;

    public DataPackageSchema getSchema(String var1, String var2) throws RegistryException;

    public List<DataPackageSchema> getSupportedDataSchemas() throws RegistryException;

    public List<Organisation> getOrganisations();

    public Organisation getRegisteredOrganisation(String var1);

    public List<Vocabulary> getVocabularies() throws RegistryException;

    public UUID register(Resource var1, Organisation var2, Ipt var3) throws RegistryException;

    public String registerIPT(Ipt var1, Organisation var2) throws RegistryException;

    public void updateIpt(Ipt var1) throws RegistryException;

    public void updateResource(Resource var1, String var2) throws RegistryException, IllegalArgumentException;

    public boolean validateOrganisation(String var1, String var2);

    @Deprecated
    public List<Resource> getOrganisationsResources(String var1) throws RegistryException;

    public boolean isResourceBelongsToOrganisation(String var1, String var2) throws RegistryException;

    public List<Network> getResourceNetworks(Resource var1) throws RegistryException;

    public List<KeyNamePair> getNetworksBrief() throws RegistryException;

    public void addResourceToNetwork(Resource var1, String var2) throws RegistryException;

    public void removeResourceFromNetwork(Resource var1, String var2) throws RegistryException;
}

