/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.ipt.service.manage.impl;

import javax.inject.Inject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.gbif.ipt.model.Resource;
import org.gbif.ipt.service.manage.ResourceManager;
import org.gbif.ipt.service.manage.ResourceUpdateListener;
import org.gbif.ipt.service.manage.SourceManager;

public class ResourceCoordinator
implements ResourceUpdateListener {
    private static final Logger LOG = LogManager.getLogger(ResourceCoordinator.class);
    private final ResourceManager resourceManager;

    @Inject
    public ResourceCoordinator(SourceManager sourceManager, ResourceManager resourceManager) {
        this.resourceManager = resourceManager;
        sourceManager.addListener((ResourceUpdateListener)this);
    }

    public void onSourceUpdated(Resource resource) {
        LOG.info("Resource {} saved after changes to its source", (Object)resource.getShortname());
        this.resourceManager.save(resource);
    }
}

