/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.ipt.service.manage.impl;

import com.fasterxml.jackson.core.PrettyPrinter;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import java.io.File;
import java.io.IOException;
import java.io.Writer;
import org.gbif.ipt.service.manage.JsonService;
import org.gbif.ipt.service.manage.impl.JsonServiceImpl;

public class JsonServiceImpl
implements JsonService {
    private final ObjectMapper objectMapper = new ObjectMapper();
    private final CustomPrettyPrinter prettyPrinter = new CustomPrettyPrinter();

    public JsonServiceImpl() {
        this.objectMapper.enable(SerializationFeature.INDENT_OUTPUT);
    }

    public <T> T readValue(File src, Class<T> valueType) throws IOException {
        return (T)this.objectMapper.readValue(src, valueType);
    }

    public void writeValue(File resultFile, Object value) throws IOException {
        this.objectMapper.writer((PrettyPrinter)this.prettyPrinter).writeValue(resultFile, value);
    }

    public void writeValue(Writer writer, Object value) throws IOException {
        this.objectMapper.writer((PrettyPrinter)this.prettyPrinter).writeValue(writer, value);
    }
}

