/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.ipt.service.manage;

import java.io.File;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadPoolExecutor;
import javax.annotation.Nullable;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.collections4.ListValuedMap;
import org.gbif.ipt.action.BaseAction;
import org.gbif.ipt.model.Ipt;
import org.gbif.ipt.model.Organisation;
import org.gbif.ipt.model.PublicationOptions;
import org.gbif.ipt.model.Resource;
import org.gbif.ipt.model.User;
import org.gbif.ipt.model.datatable.DatatableRequest;
import org.gbif.ipt.model.datatable.DatatableResult;
import org.gbif.ipt.model.voc.PublicationStatus;
import org.gbif.ipt.service.AlreadyExistingException;
import org.gbif.ipt.service.DeletionNotAllowedException;
import org.gbif.ipt.service.ImportException;
import org.gbif.ipt.service.InvalidConfigException;
import org.gbif.ipt.service.InvalidFilenameException;
import org.gbif.ipt.service.InvalidMetadataException;
import org.gbif.ipt.service.PublicationException;
import org.gbif.ipt.task.StatusReport;
import org.gbif.metadata.eml.InvalidEmlException;
import org.xml.sax.SAXException;

public interface ResourceManager {
    public boolean cancelPublishing(String var1, BaseAction var2);

    public Resource create(String var1, String var2, File var3, User var4, BaseAction var5) throws AlreadyExistingException, ImportException, InvalidFilenameException;

    public Resource create(String var1, String var2, User var3) throws AlreadyExistingException;

    public void deleteResourceFromIpt(Resource var1) throws IOException;

    public void delete(Resource var1, boolean var2) throws IOException, DeletionNotAllowedException;

    public Resource get(String var1);

    public boolean isEmlExisting(String var1);

    public boolean isLocked(String var1, BaseAction var2);

    public boolean isLocked(String var1);

    public List<Resource> latest(int var1, int var2);

    public List<Resource> list();

    public List<Resource> list(String var1);

    public List<Resource> list(PublicationStatus var1);

    public List<Resource> listPublishedPublicVersions();

    public DatatableResult listPublishedPublicVersionsSimplified(DatatableRequest var1);

    public List<Resource> list(User var1);

    public DatatableResult list(User var1, DatatableRequest var2);

    public int load(File var1, @Nullable User var2);

    public boolean publish(Resource var1, BigDecimal var2, @Nullable BaseAction var3) throws PublicationException;

    public boolean publish(Resource var1, BigDecimal var2, @Nullable BaseAction var3, boolean var4) throws PublicationException;

    public boolean publish(Resource var1, BigDecimal var2, BaseAction var3, PublicationOptions var4) throws PublicationException;

    public void register(Resource var1, Organisation var2, Ipt var3, BaseAction var4) throws InvalidConfigException;

    public void save(Resource var1) throws InvalidConfigException;

    public void saveEml(Resource var1) throws InvalidConfigException;

    public void saveDatapackageMetadata(Resource var1) throws InvalidConfigException;

    public void saveInferredMetadata(Resource var1) throws InvalidConfigException;

    @Nullable
    public StatusReport status(String var1);

    public void updateRegistration(Resource var1, BaseAction var2) throws PublicationException;

    public void visibilityToPrivate(Resource var1, BaseAction var2) throws InvalidConfigException;

    public void visibilityToPublic(Resource var1, BaseAction var2) throws InvalidConfigException;

    public void restoreVersion(Resource var1, BigDecimal var2, @Nullable BaseAction var3);

    public void updatePublicationMode(Resource var1);

    public Resource updateAlternateIdentifierForIPTURLToResource(Resource var1);

    public ThreadPoolExecutor getExecutor();

    public Map<String, Future<Map<String, Integer>>> getProcessFutures();

    public ListValuedMap<String, Date> getProcessFailures();

    public Map<String, StatusReport> getProcessReports();

    public void clearProcessReports();

    public boolean hasMaxProcessFailures(Resource var1);

    public void removeVersion(Resource var1, BigDecimal var2);

    public void replaceEml(Resource var1, File var2, boolean var3) throws SAXException, ParserConfigurationException, IOException, InvalidEmlException, ImportException;

    public void replaceDatapackageMetadata(BaseAction var1, Resource var2, File var3, boolean var4) throws IOException, ImportException, InvalidMetadataException;

    public void updateOrganisationNameForResources(UUID var1, String var2, String var3);

    public void updateOrganisationNameForResources(Organisation var1);
}

