/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.ipt.service.file;

import java.nio.file.Path;
import org.gbif.ipt.service.file.DataFile;
import org.gbif.ipt.service.file.FileFormat;

public class DataFile {
    private final Path filePath;
    private final String sourceFileName;
    private FileFormat fileFormat;
    private String receivedAsMediaType;
    private String mediaType;

    public Long getSize() {
        if (this.filePath != null) {
            return this.filePath.toFile().length();
        }
        return null;
    }

    public static DataFileBuilder builder() {
        return new DataFileBuilder();
    }

    public Path getFilePath() {
        return this.filePath;
    }

    public String getSourceFileName() {
        return this.sourceFileName;
    }

    public FileFormat getFileFormat() {
        return this.fileFormat;
    }

    public String getReceivedAsMediaType() {
        return this.receivedAsMediaType;
    }

    public String getMediaType() {
        return this.mediaType;
    }

    public void setFileFormat(FileFormat fileFormat) {
        this.fileFormat = fileFormat;
    }

    public void setReceivedAsMediaType(String receivedAsMediaType) {
        this.receivedAsMediaType = receivedAsMediaType;
    }

    public void setMediaType(String mediaType) {
        this.mediaType = mediaType;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DataFile)) {
            return false;
        }
        DataFile other = (DataFile)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Path this$filePath = this.getFilePath();
        Path other$filePath = other.getFilePath();
        if (this$filePath == null ? other$filePath != null : !((Object)this$filePath).equals(other$filePath)) {
            return false;
        }
        String this$sourceFileName = this.getSourceFileName();
        String other$sourceFileName = other.getSourceFileName();
        if (this$sourceFileName == null ? other$sourceFileName != null : !this$sourceFileName.equals(other$sourceFileName)) {
            return false;
        }
        FileFormat this$fileFormat = this.getFileFormat();
        FileFormat other$fileFormat = other.getFileFormat();
        if (this$fileFormat == null ? other$fileFormat != null : !this$fileFormat.equals(other$fileFormat)) {
            return false;
        }
        String this$receivedAsMediaType = this.getReceivedAsMediaType();
        String other$receivedAsMediaType = other.getReceivedAsMediaType();
        if (this$receivedAsMediaType == null ? other$receivedAsMediaType != null : !this$receivedAsMediaType.equals(other$receivedAsMediaType)) {
            return false;
        }
        String this$mediaType = this.getMediaType();
        String other$mediaType = other.getMediaType();
        return !(this$mediaType == null ? other$mediaType != null : !this$mediaType.equals(other$mediaType));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DataFile;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Path $filePath = this.getFilePath();
        result = result * 59 + ($filePath == null ? 43 : ((Object)$filePath).hashCode());
        String $sourceFileName = this.getSourceFileName();
        result = result * 59 + ($sourceFileName == null ? 43 : $sourceFileName.hashCode());
        FileFormat $fileFormat = this.getFileFormat();
        result = result * 59 + ($fileFormat == null ? 43 : $fileFormat.hashCode());
        String $receivedAsMediaType = this.getReceivedAsMediaType();
        result = result * 59 + ($receivedAsMediaType == null ? 43 : $receivedAsMediaType.hashCode());
        String $mediaType = this.getMediaType();
        result = result * 59 + ($mediaType == null ? 43 : $mediaType.hashCode());
        return result;
    }

    public String toString() {
        return "DataFile(filePath=" + String.valueOf(this.getFilePath()) + ", sourceFileName=" + this.getSourceFileName() + ", fileFormat=" + String.valueOf(this.getFileFormat()) + ", receivedAsMediaType=" + this.getReceivedAsMediaType() + ", mediaType=" + this.getMediaType() + ")";
    }

    private DataFile(Path filePath, String sourceFileName, FileFormat fileFormat, String receivedAsMediaType, String mediaType) {
        this.filePath = filePath;
        this.sourceFileName = sourceFileName;
        this.fileFormat = fileFormat;
        this.receivedAsMediaType = receivedAsMediaType;
        this.mediaType = mediaType;
    }

    public static DataFile create(Path filePath, String sourceFileName, FileFormat fileFormat, String receivedAsMediaType, String mediaType) {
        return new DataFile(filePath, sourceFileName, fileFormat, receivedAsMediaType, mediaType);
    }
}

