/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.ipt.service.admin.impl;

import at.favre.lib.crypto.bcrypt.BCrypt;
import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.security.AnyTypePermission;
import java.io.EOFException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import org.apache.commons.lang3.StringUtils;
import org.gbif.ipt.config.AppConfig;
import org.gbif.ipt.config.DataDir;
import org.gbif.ipt.model.User;
import org.gbif.ipt.service.AlreadyExistingException;
import org.gbif.ipt.service.BaseManager;
import org.gbif.ipt.service.DeletionNotAllowedException;
import org.gbif.ipt.service.InvalidConfigException;
import org.gbif.ipt.service.admin.UserAccountManager;
import org.gbif.ipt.utils.FileUtils;
import org.gbif.ipt.utils.PBEEncrypt;

public class UserAccountManagerImpl
extends BaseManager
implements UserAccountManager {
    public static final String PERSISTENCE_FILE = "users.xml";
    private final Map<String, User> users = new LinkedHashMap();
    private boolean allowSimplifiedAdminLogin = true;
    private String onlyAdminEmail;
    private final XStream xstream = new XStream();
    private PBEEncrypt encrypter;
    private User setupUser;

    @Inject
    public UserAccountManagerImpl(AppConfig cfg, DataDir dataDir, PBEEncrypt encrypter) {
        super(cfg, dataDir);
        this.encrypter = encrypter;
        this.defineXstreamMapping();
    }

    private User addUser(User user) {
        if (user != null) {
            if (user.getRole() == User.Role.Admin) {
                this.LOG.debug("Adding admin " + user.getEmail());
                if (this.allowSimplifiedAdminLogin) {
                    if (this.onlyAdminEmail == null || this.users.isEmpty()) {
                        this.onlyAdminEmail = user.getEmail();
                    } else {
                        this.onlyAdminEmail = null;
                        this.allowSimplifiedAdminLogin = false;
                    }
                }
            } else {
                this.LOG.debug("Adding user " + user.getEmail());
            }
            this.users.put(user.getEmail().toLowerCase(), user);
        }
        return user;
    }

    public User authenticate(String email, String password) {
        User agent;
        if (this.allowSimplifiedAdminLogin && email != null && email.equalsIgnoreCase("admin")) {
            email = this.onlyAdminEmail;
        }
        if ((agent = this.get(email)) != null && agent.getPassword() != null && BCrypt.verifyer().verify((char[])password.toCharArray(), (CharSequence)agent.getPassword()).verified) {
            return agent;
        }
        return null;
    }

    public void create(User user) throws AlreadyExistingException, IOException {
        if (user != null) {
            if (this.get(user.getEmail()) != null) {
                throw new AlreadyExistingException();
            }
            String hash = BCrypt.withDefaults().hashToString(12, user.getPassword().toCharArray());
            user.setPassword(hash);
            this.addUser(user);
            this.save();
        }
    }

    private void defineXstreamMapping() {
        this.xstream.addPermission(AnyTypePermission.ANY);
        this.xstream.ignoreUnknownElements();
        this.xstream.alias("user", User.class);
        this.xstream.useAttributeFor(User.class, "email");
        this.xstream.useAttributeFor(User.class, "password");
        this.xstream.useAttributeFor(User.class, "firstname");
        this.xstream.useAttributeFor(User.class, "lastname");
        this.xstream.useAttributeFor(User.class, "role");
        this.xstream.useAttributeFor(User.class, "lastLogin");
    }

    public boolean delete(String email) throws DeletionNotAllowedException, IOException {
        User remUser;
        if (email != null && (remUser = this.get(email)) != null) {
            boolean remove;
            if (remUser.getRole() == User.Role.Admin) {
                boolean lastAdmin = true;
                for (User u : this.users.values()) {
                    if (u.getRole() != User.Role.Admin || u.equals((Object)remUser)) continue;
                    lastAdmin = false;
                    break;
                }
                if (lastAdmin) {
                    this.LOG.warn("Last admin cannot be deleted");
                    throw new DeletionNotAllowedException(DeletionNotAllowedException.Reason.LAST_ADMIN);
                }
            }
            if (remove = this.remove(email)) {
                this.save();
            }
            return remove;
        }
        return false;
    }

    public User get(String email) {
        if (email != null && this.users.containsKey(email.toLowerCase())) {
            return (User)this.users.get(email.toLowerCase());
        }
        return null;
    }

    public boolean remove(String email) {
        if (email != null && this.users.containsKey(email.toLowerCase())) {
            return this.users.remove(email.toLowerCase()) != null;
        }
        return false;
    }

    public String getDefaultAdminEmail() {
        return this.cfg.getAdminEmail();
    }

    public User getSetupUser() {
        return this.setupUser;
    }

    public List<User> list() {
        ArrayList<User> userList = new ArrayList<User>(this.users.values());
        userList.sort(Comparator.comparing(o -> o.getFirstname() + " " + o.getLastname()));
        return userList;
    }

    public List<User> list(User.Role role) {
        ArrayList<User> matchingUsers = new ArrayList<User>();
        for (User u : this.users.values()) {
            if (u.getRole() != role) continue;
            matchingUsers.add(u);
        }
        return matchingUsers;
    }

    public void load() throws InvalidConfigException {
        try (ObjectInputStream in = this.xstream.createObjectInputStream(FileUtils.getUtf8Reader((File)this.dataDir.configFile(PERSISTENCE_FILE)));){
            this.users.clear();
            while (true) {
                try {
                    while (true) {
                        User u = (User)in.readObject();
                        this.addUser(u);
                    }
                }
                catch (EOFException e) {
                }
                catch (ClassNotFoundException e) {
                    this.LOG.error(e.getMessage(), (Throwable)e);
                    continue;
                }
                break;
            }
            boolean isOldPasswordsPresent = this.users.values().stream().map(User::getPassword).anyMatch(arg_0 -> this.isOldEncryptedPassword(arg_0));
            if (isOldPasswordsPresent) {
                this.LOG.info("There are old-fashioned encrypted passwords, start hashing them");
                for (User user : this.users.values()) {
                    String pass = user.getPassword();
                    if (pass == null || !this.isOldEncryptedPassword(pass)) continue;
                    try {
                        String decrypted = this.encrypter.decrypt(pass);
                        String hash = BCrypt.withDefaults().hashToString(12, decrypted.toCharArray());
                        user.setPassword(hash);
                    }
                    catch (PBEEncrypt.EncryptionException e) {
                        this.LOG.error("Cannot decrypt password for the user [{}]", (Object)user.getEmail(), (Object)e);
                    }
                }
                this.save();
            }
        }
        catch (FileNotFoundException e) {
            this.LOG.warn("User accounts not existing, users.xml file missing  (This is normal when first setting up a new datadir)");
        }
        catch (IOException e) {
            this.LOG.error(e.getMessage(), (Throwable)e);
            throw new InvalidConfigException(InvalidConfigException.TYPE.USER_CONFIG, "Couldnt read user accounts: " + e.getMessage());
        }
    }

    private boolean isOldEncryptedPassword(String pass) {
        return !StringUtils.startsWith((CharSequence)pass, (CharSequence)"$2a$");
    }

    public synchronized void save() throws IOException {
        this.LOG.debug("Saving all " + this.users.size() + " user accounts...");
        try (Writer userWriter = FileUtils.startNewUtf8File((File)this.dataDir.configFile(PERSISTENCE_FILE));
             ObjectOutputStream out = this.xstream.createObjectOutputStream(userWriter, "users");){
            for (Map.Entry entry : this.users.entrySet()) {
                out.writeObject(entry.getValue());
            }
        }
    }

    public void save(User user) throws IOException {
        this.addUser(user);
        this.save();
    }

    public void setSetupUser(User setupUser) {
        this.setupUser = setupUser;
    }
}

