/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.ipt.service.admin.impl;

import java.io.File;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.inject.Inject;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOCase;
import org.apache.commons.io.filefilter.SuffixFileFilter;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.StatusLine;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.gbif.dwc.terms.DcTerm;
import org.gbif.dwc.terms.DwcTerm;
import org.gbif.dwc.terms.Term;
import org.gbif.ipt.action.BaseAction;
import org.gbif.ipt.config.AppConfig;
import org.gbif.ipt.config.ConfigWarnings;
import org.gbif.ipt.config.Constants;
import org.gbif.ipt.config.DataDir;
import org.gbif.ipt.model.Extension;
import org.gbif.ipt.model.ExtensionMapping;
import org.gbif.ipt.model.ExtensionProperty;
import org.gbif.ipt.model.PropertyMapping;
import org.gbif.ipt.model.Resource;
import org.gbif.ipt.model.Vocabulary;
import org.gbif.ipt.model.factory.ExtensionFactory;
import org.gbif.ipt.service.BaseManager;
import org.gbif.ipt.service.InvalidConfigException;
import org.gbif.ipt.service.RegistryException;
import org.gbif.ipt.service.admin.ExtensionManager;
import org.gbif.ipt.service.admin.RegistrationManager;
import org.gbif.ipt.service.admin.impl.ExtensionsHolder;
import org.gbif.ipt.service.registry.RegistryManager;
import org.gbif.ipt.struts2.SimpleTextProvider;
import org.gbif.utils.HttpClient;
import org.gbif.utils.HttpUtil;
import org.xml.sax.SAXException;

/*
 * Exception performing whole class analysis ignored.
 */
public class ExtensionManagerImpl
extends BaseManager
implements ExtensionManager {
    private static final Logger LOG = LogManager.getLogger(ExtensionManagerImpl.class);
    public static final String EXTENSION_FILE_SUFFIX = ".xml";
    protected static final String CONFIG_FOLDER = ".extensions";
    private static final String TAXON_KEYWORD = "dwc:taxon";
    private static final String OCCURRENCE_KEYWORD = "dwc:occurrence";
    private static final String EVENT_KEYWORD = "dwc:event";
    private static final String MATERIAL_ENTITY_KEYWORD = "dwc:materialentity";
    private static final String RECORD_LEVEL_CLASS = "Record-level";
    private final ExtensionFactory factory;
    private final HttpClient downloader;
    private final ConfigWarnings warnings;
    private final RegistryManager registryManager;
    private final ExtensionsHolder extensionsHolder;
    private final BaseAction baseAction;
    private static final Map<String, Term> TERMS_REPLACED_BY_ANOTHER_TERM;

    @Inject
    public ExtensionManagerImpl(AppConfig cfg, DataDir dataDir, ExtensionFactory factory, HttpClient client, ConfigWarnings warnings, SimpleTextProvider textProvider, RegistrationManager registrationManager, RegistryManager registryManager, ExtensionsHolder extensionsHolder) {
        super(cfg, dataDir);
        this.factory = factory;
        this.downloader = client;
        this.warnings = warnings;
        this.baseAction = new BaseAction(textProvider, cfg, registrationManager);
        this.registryManager = registryManager;
        this.extensionsHolder = extensionsHolder;
    }

    public static String normalizeRowType(String rowType) {
        if ("http://rs.tdwg.org/dwc/terms/DarwinCore".equalsIgnoreCase(rowType) || "http://rs.tdwg.org/dwc/xsd/simpledarwincore/".equalsIgnoreCase(rowType) || "http://rs.tdwg.org/dwc/terms/SimpleDarwinCore".equalsIgnoreCase(rowType) || "http://rs.tdwg.org/dwc/dwctype/Occurrence".equalsIgnoreCase(rowType) || "http://rs.tdwg.org/dwc/xsd/simpledarwincore/SimpleDarwinRecord".equalsIgnoreCase(rowType)) {
            return Constants.DWC_ROWTYPE_OCCURRENCE;
        }
        if ("http://rs.tdwg.org/dwc/dwctype/Taxon".equalsIgnoreCase(rowType)) {
            return Constants.DWC_ROWTYPE_TAXON;
        }
        return rowType;
    }

    public void uninstallSafely(String rowType) {
        if (this.extensionsHolder.getExtensionsByRowtype().containsKey(rowType)) {
            this.uninstall(rowType);
        } else {
            LOG.warn("Extension not installed locally, cant delete {}", (Object)rowType);
        }
    }

    private void uninstall(String rowType) {
        if (this.extensionsHolder.getExtensionsByRowtype().containsKey(rowType)) {
            this.extensionsHolder.getExtensionsByRowtype().remove(rowType);
            File f = this.getExtensionFile(rowType);
            if (f.exists()) {
                FileUtils.deleteQuietly((File)f);
            } else {
                LOG.warn("Extension doesnt exist locally, cant delete " + rowType);
            }
        } else {
            LOG.warn("Extension not installed locally, cant delete " + rowType);
        }
    }

    public synchronized Extension update(String rowType) throws IOException, RegistryException {
        Extension installed = this.get(rowType);
        Extension latestVersion = null;
        if (installed != null) {
            for (Extension e : this.registryManager.getExtensions()) {
                if (e.getRowType() == null || !e.getRowType().equalsIgnoreCase(rowType) || !e.isLatest()) continue;
                latestVersion = e;
                break;
            }
            boolean isNewVersion = false;
            if (latestVersion != null) {
                Date issued = installed.getIssued();
                Date issuedLatest = latestVersion.getIssued();
                if (issued == null && issuedLatest != null) {
                    isNewVersion = true;
                } else if (issued != null && issuedLatest != null) {
                    boolean bl = isNewVersion = issuedLatest.compareTo(issued) > 0;
                }
            }
            if (isNewVersion && latestVersion.getUrl() != null) {
                File tmpFile = this.download(latestVersion.getUrl());
                Extension extension = this.loadFromFile(tmpFile);
                this.uninstall(rowType);
                this.finishInstall(tmpFile, extension);
                latestVersion.setProperties(extension.getProperties());
                latestVersion.setName(extension.getName());
                latestVersion.setNamespace(extension.getNamespace());
                latestVersion.setLink(extension.getLink());
            } else {
                latestVersion = null;
            }
        }
        return latestVersion;
    }

    public synchronized void updateIfChanged() throws IOException, RegistryException {
        List installedExtensions = this.list();
        List registryExtensions = this.registryManager.getExtensions();
        for (Extension installed : installedExtensions) {
            if (installed == null || installed.getRowType() == null) {
                LOG.error("Installed extension is null or rowType is null");
                continue;
            }
            String rowType = installed.getRowType();
            LOG.debug("Updating extension {}", (Object)rowType);
            Extension matched = null;
            boolean isMatched = false;
            for (Extension ex : registryExtensions) {
                if (ex.getRowType() == null || !ex.getRowType().equalsIgnoreCase(rowType)) continue;
                isMatched = true;
                if (installed.getIssued() == null || ex.getIssued() == null || installed.getIssued().compareTo(ex.getIssued()) >= 0 || !ex.isLatest()) continue;
                matched = ex;
                break;
            }
            if (!isMatched) {
                LOG.error("No matching extension found for {}", (Object)rowType);
                continue;
            }
            if (matched == null) {
                LOG.debug("Extension {} is already up-to-date", (Object)rowType);
                continue;
            }
            if (matched.getUrl() == null) {
                LOG.error("Matched extension {} doesn't have a URL", (Object)rowType);
                continue;
            }
            LOG.debug("Found matching extension {}", (Object)matched.getUrl());
            File extensionFile = this.getExtensionFile(rowType);
            boolean downloadResult = this.downloader.downloadIfChanged(matched.getUrl(), extensionFile);
            if (downloadResult) {
                LOG.debug("Downloaded extension {}", (Object)matched.getUrl());
                Extension result = this.loadFromFile(extensionFile);
                this.extensionsHolder.getExtensionsByRowtype().replace(rowType, result);
                continue;
            }
            LOG.error("Failed to download extension {} from {}", (Object)rowType, (Object)matched.getUrl());
        }
    }

    public void migrateResourceToNewExtensionVersion(Resource r, Extension current, Extension newer) {
        if (!current.getRowType().equalsIgnoreCase(newer.getRowType()) || r.getMappings(current.getRowType()).isEmpty()) {
            throw new IllegalStateException();
        }
        LOG.info("Migrating " + r.getShortname() + " mappings to extension " + current.getRowType() + " to latest extension version");
        HashSet<ExtensionProperty> deprecated = new HashSet<ExtensionProperty>();
        HashSet<ExtensionProperty> vocabulariesRemoved = new HashSet<ExtensionProperty>();
        HashSet<ExtensionProperty> vocabulariesUnchanged = new HashSet<ExtensionProperty>();
        HashSet<ExtensionProperty> vocabulariesUpdated = new HashSet<ExtensionProperty>();
        for (ExtensionProperty property : current.getProperties()) {
            if (!newer.hasProperty(property.qualifiedName())) {
                deprecated.add(property);
                continue;
            }
            if (property.getVocabulary() == null) continue;
            Vocabulary v1 = property.getVocabulary();
            Vocabulary v2 = newer.getProperty(property.qualifiedName()).getVocabulary();
            if (v2 == null) {
                vocabulariesRemoved.add(property);
                continue;
            }
            if (v1.getUriString().equalsIgnoreCase(v2.getUriString())) {
                vocabulariesUnchanged.add(property);
                continue;
            }
            if (v1.getUriString().equalsIgnoreCase(v2.getUriString())) continue;
            vocabulariesUpdated.add(property);
        }
        LOG.debug(deprecated.size() + " properties have been deprecated in the newer version");
        LOG.debug(vocabulariesRemoved.size() + " properties in the newer version of extension no longer use a vocabulary");
        LOG.debug(vocabulariesUnchanged.size() + " properties in the newer version of extension use the same vocabulary");
        LOG.debug(vocabulariesUpdated.size() + " properties in the newer version of extension use a newer vocabulary");
        HashSet<ExtensionProperty> added = new HashSet<ExtensionProperty>();
        for (ExtensionProperty property : newer.getProperties()) {
            if (current.hasProperty(property.qualifiedName())) continue;
            added.add(property);
        }
        LOG.debug("Newer version of extension has " + added.size() + " new properties");
        for (ExtensionMapping extensionMapping : r.getMappings(current.getRowType())) {
            this.migrateExtensionMapping(extensionMapping, newer, deprecated);
        }
    }

    private ExtensionMapping migrateExtensionMapping(ExtensionMapping extensionMapping, Extension newer, Set<ExtensionProperty> deprecated) {
        LOG.debug("Migrating extension mapping...");
        extensionMapping.setExtension(newer);
        for (ExtensionProperty deprecatedProperty : deprecated) {
            Term replacedBy = (Term)TERMS_REPLACED_BY_ANOTHER_TERM.get(deprecatedProperty.qualifiedName());
            if (replacedBy != null && newer.getProperty(replacedBy) != null && !extensionMapping.isMapped(replacedBy)) {
                PropertyMapping pm = extensionMapping.getField(deprecatedProperty.qualifiedName());
                ExtensionProperty ep = newer.getProperty(replacedBy);
                if (pm == null || ep == null) continue;
                pm.setTerm((Term)ep);
                LOG.debug("Mapping to deprecated term " + deprecatedProperty.qualifiedName() + " has been migrated to term " + replacedBy.qualifiedName());
                continue;
            }
            LOG.debug("Mapping to deprecated term " + deprecatedProperty.qualifiedName() + " cannot be migrated therefore it is being removed!");
            this.removePropertyMapping(extensionMapping, deprecatedProperty.qualifiedName());
        }
        return extensionMapping;
    }

    private void removePropertyMapping(ExtensionMapping extensionMapping, String qualifiedName) {
        PropertyMapping pm = extensionMapping.getField(qualifiedName);
        Set propertyMappings = extensionMapping.getFields();
        if (pm != null && propertyMappings.contains(pm)) {
            propertyMappings.remove(pm);
            LOG.debug("Removed mapping to term " + pm.getTerm().qualifiedName());
        }
    }

    public Extension get(String rowType) {
        return (Extension)this.extensionsHolder.getExtensionsByRowtype().get(ExtensionManagerImpl.normalizeRowType((String)rowType));
    }

    private List<Extension> getCoreTypes() {
        ArrayList<Extension> coreTypes = new ArrayList<Extension>();
        try {
            for (Extension ext : this.registryManager.getExtensions()) {
                if (ext.getRowType() == null || !AppConfig.getCoreRowTypes().contains(ext.getRowType()) || !ext.isLatest()) continue;
                coreTypes.add(ext);
            }
        }
        catch (RegistryException e) {
            String msg = RegistryException.logRegistryException((RegistryException)e, (BaseAction)this.baseAction);
            this.warnings.addStartupError(msg);
            LOG.error(msg);
            msg = this.baseAction.getText("admin.extensions.couldnt.load", new String[]{this.cfg.getRegistryUrl()});
            this.warnings.addStartupError(msg);
            LOG.error(msg);
        }
        if (AppConfig.getCoreRowTypes().size() != coreTypes.size()) {
            String msg = "Not all core extensions were loaded!";
            LOG.error(msg);
            throw new InvalidConfigException(InvalidConfigException.TYPE.INVALID_DATA_DIR, msg);
        }
        return coreTypes;
    }

    private File getExtensionFile(String rowType) {
        String filename = org.gbif.ipt.utils.FileUtils.getSuffixedFileName((String)rowType, (String)".xml");
        return this.dataDir.configFile(".extensions/" + filename);
    }

    public synchronized Extension install(URL url) throws InvalidConfigException {
        Objects.requireNonNull(url);
        try {
            File tmpFile = this.download(url);
            Extension extension = this.loadFromFile(tmpFile);
            this.finishInstall(tmpFile, extension);
            return extension;
        }
        catch (InvalidConfigException e) {
            throw e;
        }
        catch (Exception e) {
            String msg = this.baseAction.getText("admin.extension.install.error", new String[]{url.toString()});
            LOG.error(msg, (Throwable)e);
            throw new InvalidConfigException(InvalidConfigException.TYPE.INVALID_EXTENSION, msg, e);
        }
    }

    private void finishInstall(File tmpFile, Extension extension) throws IOException {
        Objects.requireNonNull(tmpFile);
        Objects.requireNonNull(extension);
        Objects.requireNonNull(extension.getRowType());
        try {
            File installedFile = this.getExtensionFile(extension.getRowType());
            FileUtils.moveFile((File)tmpFile, (File)installedFile);
            this.extensionsHolder.getExtensionsByRowtype().put(extension.getRowType(), extension);
        }
        catch (IOException e) {
            LOG.error("Installing extension failed, while trying to move and rename extension file: " + e.getMessage(), (Throwable)e);
            throw e;
        }
    }

    private File download(URL url) throws IOException {
        Objects.requireNonNull(url);
        String filename = org.gbif.ipt.utils.FileUtils.getSuffixedFileName((String)url.toString(), (String)".xml");
        File tmpFile = this.dataDir.tmpFile(filename);
        StatusLine statusLine = this.downloader.download(url, tmpFile);
        if (HttpUtil.success((StatusLine)statusLine)) {
            LOG.info("Successfully downloaded extension: " + String.valueOf(url));
            return tmpFile;
        }
        String msg = "Failed to download extension: " + String.valueOf(url) + ". Response=" + statusLine.getStatusCode();
        LOG.error(msg);
        throw new IOException(msg);
    }

    public void installCoreTypes() throws InvalidConfigException {
        List extensions = this.getCoreTypes();
        for (Extension ext : extensions) {
            this.install(ext.getUrl());
        }
    }

    public List<Extension> list() {
        return new ArrayList<Extension>(this.extensionsHolder.getExtensionsByRowtype().values());
    }

    public List<Extension> list(String coreRowType) {
        if (coreRowType != null) {
            if (coreRowType.equalsIgnoreCase(Constants.DWC_ROWTYPE_OCCURRENCE)) {
                return this.search("dwc:occurrence", true, false);
            }
            if (coreRowType.equalsIgnoreCase(Constants.DWC_ROWTYPE_TAXON)) {
                return this.search("dwc:taxon", true, false);
            }
            if (coreRowType.equalsIgnoreCase(Constants.DWC_ROWTYPE_EVENT)) {
                return this.search("dwc:event", true, false);
            }
            if (coreRowType.equalsIgnoreCase("http://rs.tdwg.org/dwc/terms/MaterialEntity")) {
                HashSet suitableExtensionsSet = new HashSet(this.search("dwc:materialentity", true, false));
                suitableExtensionsSet.addAll(this.search("dwc:occurrence", true, false));
                return new ArrayList<Extension>(suitableExtensionsSet);
            }
            return this.search(coreRowType, true, false);
        }
        return this.list();
    }

    public List<Extension> listCore(String coreRowType) {
        if (coreRowType != null) {
            if (coreRowType.equalsIgnoreCase(Constants.DWC_ROWTYPE_OCCURRENCE)) {
                return this.search("dwc:occurrence", false, true);
            }
            if (coreRowType.equalsIgnoreCase(Constants.DWC_ROWTYPE_TAXON)) {
                return this.search("dwc:taxon", false, true);
            }
            if (coreRowType.equalsIgnoreCase(Constants.DWC_ROWTYPE_EVENT)) {
                return this.search("dwc:event", false, true);
            }
            if (coreRowType.equalsIgnoreCase("http://rs.tdwg.org/dwc/terms/MaterialEntity")) {
                return this.search("dwc:materialentity", false, true);
            }
            return this.search(coreRowType, false, true);
        }
        return this.listCore();
    }

    public List<Extension> listCore() {
        ArrayList<Extension> list = new ArrayList<Extension>();
        for (String rowType : AppConfig.getCoreRowTypes()) {
            Extension e = this.get(rowType);
            if (e == null) continue;
            list.add(e);
        }
        return list;
    }

    public int load() {
        List allRegisteredExtensions;
        File extensionDir = this.dataDir.configFile(".extensions");
        int counter = 0;
        try {
            allRegisteredExtensions = this.registryManager.getLatestExtensions();
        }
        catch (Exception e) {
            LOG.error("Failed to load extensions from the Registry. Cannot check the latest extensions", (Throwable)e);
            allRegisteredExtensions = Collections.emptyList();
        }
        if (extensionDir.isDirectory()) {
            ArrayList<File> extensionFiles = new ArrayList<File>();
            SuffixFileFilter ff = new SuffixFileFilter(".xml", IOCase.INSENSITIVE);
            extensionFiles.addAll(Arrays.asList(extensionDir.listFiles((FilenameFilter)ff)));
            for (File ef : extensionFiles) {
                try {
                    Extension extension = this.loadFromFile(ef);
                    extension.setLatest(this.isLatest(extension, allRegisteredExtensions));
                    this.extensionsHolder.getExtensionsByRowtype().put(extension.getRowType(), extension);
                    ++counter;
                }
                catch (InvalidConfigException e) {
                    if (this.cfg.isTestInstallation()) {
                        FileUtils.deleteQuietly((File)ef);
                        this.warnings.addStartupError("Extension " + ef.getAbsolutePath() + " has been deleted from the IPT data directory because it was invalid or out-of-date. Please install the latest version of this extension if needed and restart your web server. Cause: " + e.getMessage(), (Exception)((Object)e));
                        continue;
                    }
                    this.warnings.addStartupError("Can't load local extension definition: " + e.getMessage(), (Exception)((Object)e));
                }
            }
        }
        return counter;
    }

    protected Extension loadFromFile(File localFile) throws InvalidConfigException {
        Extension extension;
        Objects.requireNonNull(localFile);
        if (!localFile.exists()) {
            throw new IllegalStateException();
        }
        FileInputStream fileIn = new FileInputStream(localFile);
        try {
            Extension extension2 = this.factory.build((InputStream)fileIn);
            extension2.setRowType(ExtensionManagerImpl.normalizeRowType((String)extension2.getRowType()));
            LOG.info("Successfully loaded extension " + extension2.getRowType());
            extension = extension2;
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((InputStream)fileIn).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                LOG.error("Can't access local extension file (" + localFile.getAbsolutePath() + ")", (Throwable)e);
                throw new InvalidConfigException(InvalidConfigException.TYPE.INVALID_EXTENSION, "Can't access local extension file");
            }
            catch (SAXException e) {
                LOG.error("Can't parse local extension file (" + localFile.getAbsolutePath() + ")", (Throwable)e);
                throw new InvalidConfigException(InvalidConfigException.TYPE.INVALID_EXTENSION, "Can't parse local extension file: " + e.getMessage());
            }
            catch (ParserConfigurationException e) {
                LOG.error("Can't create sax parser", (Throwable)e);
                throw new InvalidConfigException(InvalidConfigException.TYPE.INVALID_EXTENSION, "Can't create sax parser");
            }
        }
        ((InputStream)fileIn).close();
        return extension;
    }

    private List<Extension> search(String keyword, boolean includeEmptySubject, boolean searchForCores) {
        ArrayList<Extension> list = new ArrayList<Extension>();
        if ((keyword = StringUtils.trimToNull((String)keyword)) != null) {
            keyword = keyword.toLowerCase();
            for (Extension e : this.extensionsHolder.getExtensionsByRowtype().values()) {
                if (searchForCores && !e.isCore() || !searchForCores && e.isCore() || (!includeEmptySubject || StringUtils.trimToNull((String)e.getSubject()) != null) && !StringUtils.containsIgnoreCase((CharSequence)e.getSubject(), (CharSequence)keyword)) continue;
                list.add(e);
            }
        }
        return list;
    }

    public List<String> getRedundantGroups(Extension extension, Extension core) {
        List groups = extension.getGroups();
        List coreGroups = core.getGroups();
        if (!groups.isEmpty() && !coreGroups.isEmpty()) {
            coreGroups.retainAll(groups);
            coreGroups.remove("Record-level");
            return coreGroups;
        }
        return new ArrayList<String>();
    }

    public boolean isLatest(Extension extension, List<Extension> latestExtensions) {
        for (Extension rExtension : latestExtensions) {
            if (!extension.getRowType().equalsIgnoreCase(rExtension.getRowType())) continue;
            Date installedExtensionIssuedDate = extension.getIssued();
            Date latestExtensionIssuedDate = rExtension.getIssued();
            if (installedExtensionIssuedDate == null && latestExtensionIssuedDate != null) {
                LOG.debug("Installed extension with rowType {} has no issued date. A newer version issued {} exists.", (Object)extension.getRowType(), (Object)latestExtensionIssuedDate);
                return false;
            }
            if (latestExtensionIssuedDate != null && latestExtensionIssuedDate.compareTo(installedExtensionIssuedDate) > 0) {
                LOG.debug("Installed extension with rowType {} was issued {}. A newer version issued {} exists.", (Object)extension.getRowType(), (Object)installedExtensionIssuedDate, (Object)latestExtensionIssuedDate);
                return false;
            }
            LOG.debug("Installed extension with rowType {} is the latest version", (Object)extension.getRowType());
            return true;
        }
        return true;
    }

    static {
        HashMap<String, Object> termsReplacedByAnotherTermInternal = new HashMap<String, Object>();
        termsReplacedByAnotherTermInternal.put("http://purl.org/dc/terms/source", DcTerm.references);
        termsReplacedByAnotherTermInternal.put("http://purl.org/dc/terms/rights", DcTerm.license);
        termsReplacedByAnotherTermInternal.put("http://rs.tdwg.org/dwc/terms/individualID", DwcTerm.organismID);
        termsReplacedByAnotherTermInternal.put("http://rs.tdwg.org/dwc/terms/occurrenceDetails", DcTerm.references);
        TERMS_REPLACED_BY_ANOTHER_TERM = Collections.unmodifiableMap(termsReplacedByAnotherTermInternal);
    }
}

