/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.ipt.service.admin.impl;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.inject.Inject;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOCase;
import org.apache.commons.io.filefilter.SuffixFileFilter;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.StatusLine;
import org.gbif.ipt.action.BaseAction;
import org.gbif.ipt.config.AppConfig;
import org.gbif.ipt.config.ConfigWarnings;
import org.gbif.ipt.config.DataDir;
import org.gbif.ipt.config.SupportedDataPackageType;
import org.gbif.ipt.model.DataPackageSchema;
import org.gbif.ipt.model.DataPackageTableSchema;
import org.gbif.ipt.model.factory.DataSchemaFactory;
import org.gbif.ipt.service.BaseManager;
import org.gbif.ipt.service.InvalidConfigException;
import org.gbif.ipt.service.RegistryException;
import org.gbif.ipt.service.admin.DataPackageSchemaManager;
import org.gbif.ipt.service.admin.RegistrationManager;
import org.gbif.ipt.service.registry.RegistryManager;
import org.gbif.ipt.struts2.SimpleTextProvider;
import org.gbif.utils.HttpClient;
import org.gbif.utils.HttpUtil;

public class DataPackageSchemaManagerImpl
extends BaseManager
implements DataPackageSchemaManager {
    private static final String CONFIG_FOLDER = ".dataPackages";
    private static final String DATA_SCHEMA_FILE_SUFFIX = ".json";
    private final ConfigWarnings warnings;
    private final DataSchemaFactory factory;
    private final RegistryManager registryManager;
    private final HttpClient downloader;
    private final Gson gson;
    private final BaseAction baseAction;
    private List<DataPackageSchema> dataPackageSchemas = new ArrayList();
    private Map<String, DataPackageSchema> dataPackageSchemasByIdentifiers = new HashMap();
    private Map<String, String> dataPackageSchemaRawContentByName = new HashMap();

    @Inject
    public DataPackageSchemaManagerImpl(AppConfig cfg, DataDir dataDir, ConfigWarnings warnings, DataSchemaFactory factory, SimpleTextProvider textProvider, RegistrationManager registrationManager, RegistryManager registryManager, HttpClient downloader) {
        super(cfg, dataDir);
        this.warnings = warnings;
        this.factory = factory;
        this.registryManager = registryManager;
        this.downloader = downloader;
        this.baseAction = new BaseAction(textProvider, cfg, registrationManager);
        this.gson = new GsonBuilder().setPrettyPrinting().setDateFormat("yyyy-MM-dd").create();
    }

    public void uninstallSafely(String schemaIdentifier, String schemaName) {
        if (this.dataPackageSchemasByIdentifiers.containsKey(schemaIdentifier)) {
            this.uninstall(schemaIdentifier, schemaName);
        } else {
            this.LOG.warn("Data schema not installed locally, can't delete {}", (Object)schemaIdentifier);
        }
    }

    public synchronized DataPackageSchema update(String identifier) throws IOException, RegistryException {
        DataPackageSchema installed = this.get(identifier);
        DataPackageSchema latestCompatibleSchema = null;
        if (installed != null) {
            String latestCompatibleSchemaVersion = this.registryManager.getLatestCompatibleSchemaVersion(installed.getName(), installed.getVersion());
            if (latestCompatibleSchemaVersion != null) {
                latestCompatibleSchema = this.registryManager.getSchema(installed.getName(), latestCompatibleSchemaVersion);
            }
            boolean isNewVersion = false;
            if (latestCompatibleSchema != null) {
                Date issued = installed.getIssued();
                Date issuedLatest = latestCompatibleSchema.getIssued();
                if (issued == null && issuedLatest != null) {
                    isNewVersion = true;
                } else if (issued != null && issuedLatest != null) {
                    boolean bl = isNewVersion = issuedLatest.compareTo(issued) > 0;
                }
            }
            if (isNewVersion && latestCompatibleSchema.getUrl() != null) {
                this.uninstall(identifier, latestCompatibleSchema.getName());
                this.install(latestCompatibleSchema);
            } else {
                return null;
            }
        }
        return latestCompatibleSchema;
    }

    public DataPackageSchema get(String identifier) {
        DataPackageSchema result = (DataPackageSchema)this.dataPackageSchemasByIdentifiers.get(identifier);
        if (result == null) {
            if (this.dataPackageSchemas.isEmpty()) {
                this.load();
            }
            for (DataPackageSchema ds : this.dataPackageSchemas) {
                if (!identifier.equals(ds.getName()) && !identifier.equals(ds.getIdentifier())) continue;
                result = ds;
                break;
            }
        }
        return result;
    }

    public String getRawData(String name) {
        return (String)this.dataPackageSchemaRawContentByName.get(name);
    }

    private void uninstall(String identifier, String name) {
        if (this.dataPackageSchemasByIdentifiers.containsKey(identifier)) {
            this.dataPackageSchemasByIdentifiers.remove(identifier);
            this.dataPackageSchemaRawContentByName.remove(name);
            this.dataPackageSchemas.removeIf(d -> StringUtils.equals((CharSequence)d.getIdentifier(), (CharSequence)identifier));
            File f = this.getDataSchemaDirectory(name);
            if (f.exists()) {
                FileUtils.deleteQuietly((File)f);
            } else {
                this.LOG.warn("Data schema doesn't exist locally, can't delete " + identifier);
            }
        } else {
            this.LOG.warn("Data schema not installed locally, can't delete " + identifier);
        }
    }

    public void installSupportedDataPackageSchemas() throws InvalidConfigException {
        List schemas = this.getSupportedDataSchemas();
        for (DataPackageSchema schema : schemas) {
            this.install(schema);
        }
    }

    public synchronized void install(DataPackageSchema dataPackageSchema) throws InvalidConfigException {
        Objects.requireNonNull(dataPackageSchema);
        try {
            String filename = org.gbif.ipt.utils.FileUtils.getSuffixedFileName((String)("_" + dataPackageSchema.getIdentifier().replace(DATA_SCHEMA_FILE_SUFFIX, "")), (String)DATA_SCHEMA_FILE_SUFFIX);
            File tmpFileSchema = this.dataDir.tmpFile(filename);
            String dataPackageFileRawContent = "Failed to read the data package schema file";
            try {
                dataPackageFileRawContent = new String(Files.readAllBytes(tmpFileSchema.toPath()), StandardCharsets.UTF_8);
            }
            catch (IOException e) {
                this.LOG.error("Failed to read the data package schema file " + filename, (Throwable)e);
            }
            try (FileWriter fw = new FileWriter(tmpFileSchema);){
                this.gson.toJson((Object)dataPackageSchema, (Appendable)fw);
            }
            this.finishInstallSchema(tmpFileSchema, dataPackageSchema.getIdentifier(), dataPackageSchema.getName());
            LinkedHashSet<DataPackageTableSchema> tableSchemas = new LinkedHashSet<DataPackageTableSchema>();
            for (DataPackageTableSchema ts : dataPackageSchema.getTableSchemas()) {
                File tmpFile = this.download(ts.getUrl());
                DataPackageTableSchema tableSchema = this.loadTableSchemaFromFile(tmpFile);
                this.finishInstallTableSchema(tmpFile, dataPackageSchema.getIdentifier(), dataPackageSchema.getName(), tableSchema);
                tableSchemas.add(tableSchema);
            }
            dataPackageSchema.setTableSchemas(tableSchemas);
            this.dataPackageSchemasByIdentifiers.put(dataPackageSchema.getIdentifier(), dataPackageSchema);
            this.dataPackageSchemaRawContentByName.put(dataPackageSchema.getName(), dataPackageFileRawContent);
            this.dataPackageSchemas.add(dataPackageSchema);
        }
        catch (InvalidConfigException e) {
            throw e;
        }
        catch (Exception e) {
            String msg = this.baseAction.getText("admin.dataPackages.install.error", new String[]{dataPackageSchema.getUrl().toString()});
            this.LOG.error(msg, (Throwable)e);
            try {
                File schemaConfigFolder = this.dataDir.configFile(".dataPackages/" + dataPackageSchema.getName());
                FileUtils.cleanDirectory((File)schemaConfigFolder);
            }
            catch (IOException ioe) {
                this.LOG.error("Failed to clean directory for schema " + dataPackageSchema.getName(), (Throwable)e);
            }
            throw new InvalidConfigException(InvalidConfigException.TYPE.INVALID_DATA_SCHEMA, msg, e);
        }
    }

    public List<DataPackageSchema> list() {
        if (this.dataPackageSchemas.isEmpty()) {
            this.load();
        }
        return this.dataPackageSchemas;
    }

    public int load() {
        int counter;
        block8: {
            File dataPackageSchemasDir = this.dataDir.configFile(CONFIG_FOLDER);
            counter = 0;
            if (dataPackageSchemasDir.isDirectory()) {
                String[] dataSchemaNames = dataPackageSchemasDir.list((current, name) -> new File(current, name).isDirectory());
                SuffixFileFilter filter = new SuffixFileFilter(DATA_SCHEMA_FILE_SUFFIX, IOCase.INSENSITIVE);
                try {
                    if (dataSchemaNames == null) break block8;
                    this.dataPackageSchemasByIdentifiers.clear();
                    this.dataPackageSchemaRawContentByName.clear();
                    this.dataPackageSchemas.clear();
                    for (String dataSchemaDirectoryName : dataSchemaNames) {
                        LinkedHashSet<DataPackageTableSchema> tableSchemas = new LinkedHashSet<DataPackageTableSchema>();
                        File dataSchemaDirectory = new File(dataPackageSchemasDir, dataSchemaDirectoryName);
                        File[] files = dataSchemaDirectory.listFiles((FilenameFilter)filter);
                        if (files != null) {
                            File mainSchemaFile = this.getMainSchemaFileFromFiles(files);
                            String dataPackageRawContent = "Failed to read the data package schema file";
                            try {
                                dataPackageRawContent = new String(Files.readAllBytes(mainSchemaFile.toPath()), StandardCharsets.UTF_8);
                            }
                            catch (IOException e) {
                                this.LOG.error("Failed to read the data package schema file " + String.valueOf(mainSchemaFile), (Throwable)e);
                            }
                            DataPackageSchema dataPackageSchema = this.loadSchemaFromFile(mainSchemaFile);
                            this.dataPackageSchemasByIdentifiers.put(dataPackageSchema.getIdentifier(), dataPackageSchema);
                            this.dataPackageSchemaRawContentByName.put(dataPackageSchema.getName(), dataPackageRawContent);
                            for (DataPackageTableSchema tableSchema : dataPackageSchema.getTableSchemas()) {
                                String filename = org.gbif.ipt.utils.FileUtils.getSuffixedFileName((String)tableSchema.getIdentifier(), (String)DATA_SCHEMA_FILE_SUFFIX);
                                File tableSchemaFile = this.getTableSchemaConfigFileByName(files, filename);
                                tableSchemas.add(this.loadTableSchemaFromFile(tableSchemaFile));
                            }
                            dataPackageSchema.setTableSchemas(tableSchemas);
                            this.dataPackageSchemas.add(dataPackageSchema);
                        }
                        ++counter;
                    }
                }
                catch (InvalidConfigException e) {
                    this.LOG.error("Failed to load data schemas", (Throwable)e);
                }
            }
        }
        return counter;
    }

    public void installOrUpdateDefaults() {
        try {
            List supportedDataPackageSchemas = this.registryManager.getSupportedDataSchemas();
            for (DataPackageSchema supportedDataPackageSchema : supportedDataPackageSchemas) {
                if (!this.isSchemaInstalled(supportedDataPackageSchema.getIdentifier())) {
                    this.LOG.info("Missing default data package schema {}. Installing", (Object)supportedDataPackageSchema.getIdentifier());
                    this.install(supportedDataPackageSchema);
                    continue;
                }
                DataPackageSchema installedDataSchema = (DataPackageSchema)this.dataPackageSchemasByIdentifiers.get(supportedDataPackageSchema.getIdentifier());
                String installedDataSchemaVersion = installedDataSchema.getVersion();
                String dataSchemaName = installedDataSchema.getName();
                String dataSchemaIdentifier = installedDataSchema.getIdentifier();
                Date installedSchemaIssuedDate = installedDataSchema.getIssued();
                Date supportedSchemaIssuedDate = supportedDataPackageSchema.getIssued();
                if (installedDataSchemaVersion.equals(supportedDataPackageSchema.getVersion()) || installedSchemaIssuedDate.compareTo(supportedSchemaIssuedDate) >= 0) continue;
                this.LOG.info("Schema {} uses outdated version {}. Updating to {}", (Object)supportedDataPackageSchema.getIdentifier(), (Object)installedDataSchemaVersion, (Object)supportedDataPackageSchema.getVersion());
                this.uninstall(dataSchemaIdentifier, dataSchemaName);
                this.install(supportedDataPackageSchema);
            }
        }
        catch (Exception e) {
            this.LOG.error("Failed to install/update default data package schemas", (Throwable)e);
        }
    }

    private File getTableSchemaConfigFileByName(File[] files, String filename) {
        for (File file : files) {
            if (!filename.equals(file.getName())) continue;
            return file;
        }
        throw new InvalidConfigException(InvalidConfigException.TYPE.INVALID_DATA_SCHEMA, "Table schema file was not found: " + filename);
    }

    private File getMainSchemaFileFromFiles(File[] files) {
        for (File file : files) {
            if (!file.getName().startsWith("_")) continue;
            return file;
        }
        throw new InvalidConfigException(InvalidConfigException.TYPE.INVALID_DATA_SCHEMA, "Main schema file was not found!");
    }

    public boolean isSchemaInstalled(String nameOrIdentifier) {
        boolean result = false;
        if (this.dataPackageSchemas.isEmpty()) {
            this.load();
        }
        for (DataPackageSchema dataPackageSchema : this.dataPackageSchemas) {
            if (!dataPackageSchema.getIdentifier().equals(nameOrIdentifier) && !dataPackageSchema.getName().equals(nameOrIdentifier)) continue;
            result = true;
            break;
        }
        return result;
    }

    public boolean isSchemaType(String nameOrIdentifier) {
        boolean result = false;
        List dataPackageSchemas = this.registryManager.getLatestDataPackageSchemas();
        for (DataPackageSchema dataPackageSchema : dataPackageSchemas) {
            if (!dataPackageSchema.getIdentifier().equals(nameOrIdentifier) && !dataPackageSchema.getName().equals(nameOrIdentifier)) continue;
            result = true;
            break;
        }
        return result;
    }

    public String getSchemaIdentifier(String schemaName) {
        String result = null;
        List dataPackageSchemas = this.registryManager.getLatestDataPackageSchemas();
        for (DataPackageSchema dataPackageSchema : dataPackageSchemas) {
            if (!dataPackageSchema.getName().equals(schemaName)) continue;
            result = dataPackageSchema.getIdentifier();
            break;
        }
        return result;
    }

    private File download(URL url) throws IOException {
        Objects.requireNonNull(url);
        String filename = org.gbif.ipt.utils.FileUtils.getSuffixedFileName((String)url.toString().replace(DATA_SCHEMA_FILE_SUFFIX, ""), (String)DATA_SCHEMA_FILE_SUFFIX);
        File tmpFile = this.dataDir.tmpFile(filename);
        StatusLine statusLine = this.downloader.download(url, tmpFile);
        if (HttpUtil.success((StatusLine)statusLine)) {
            this.LOG.info("Successfully downloaded data schema: " + String.valueOf(url));
            return tmpFile;
        }
        String msg = "Failed to download data schema: " + String.valueOf(url) + ". Response=" + statusLine.getStatusCode();
        this.LOG.error(msg);
        throw new IOException(msg);
    }

    private List<DataPackageSchema> getSupportedDataSchemas() {
        ArrayList<DataPackageSchema> supportedDataPackageSchemas = new ArrayList<DataPackageSchema>();
        try {
            for (DataPackageSchema schema : this.registryManager.getSupportedDataSchemas()) {
                if (schema.getIdentifier() == null) continue;
                supportedDataPackageSchemas.add(schema);
            }
        }
        catch (RegistryException e) {
            String msg = RegistryException.logRegistryException((RegistryException)e, (BaseAction)this.baseAction);
            this.warnings.addStartupError(msg);
            this.LOG.error(msg);
            msg = this.baseAction.getText("admin.dataPackages.couldnt.load", new String[]{this.cfg.getRegistryUrl()});
            this.warnings.addStartupError(msg);
            this.LOG.error(msg);
        }
        if (SupportedDataPackageType.values().length != supportedDataPackageSchemas.size()) {
            String msg = "Not all supported data schemas were loaded!";
            this.LOG.error(msg);
            throw new InvalidConfigException(InvalidConfigException.TYPE.INVALID_DATA_DIR, msg);
        }
        return supportedDataPackageSchemas;
    }

    protected DataPackageSchema loadSchemaFromFile(File localFile) throws InvalidConfigException {
        Objects.requireNonNull(localFile);
        if (!localFile.exists()) {
            throw new IllegalStateException();
        }
        try {
            DataPackageSchema dataPackageSchema = this.factory.buildSchema(localFile);
            this.LOG.info("Successfully loaded data package schema file " + dataPackageSchema.getIdentifier());
            return dataPackageSchema;
        }
        catch (IOException e) {
            this.LOG.error("Can't access local data package schema file (" + localFile.getAbsolutePath() + ")", (Throwable)e);
            throw new InvalidConfigException(InvalidConfigException.TYPE.INVALID_DATA_SCHEMA, "Can't access local data schema file");
        }
    }

    protected DataPackageTableSchema loadTableSchemaFromFile(File localFile) throws InvalidConfigException {
        Objects.requireNonNull(localFile);
        if (!localFile.exists()) {
            throw new IllegalStateException();
        }
        try {
            DataPackageTableSchema tableSchema = this.factory.buildTableSchema(localFile);
            this.LOG.info("Successfully loaded table schema file " + tableSchema.getName());
            return tableSchema;
        }
        catch (IOException e) {
            this.LOG.error("Can't access local data schema file (" + localFile.getAbsolutePath() + ")", (Throwable)e);
            throw new InvalidConfigException(InvalidConfigException.TYPE.INVALID_DATA_SCHEMA, "Can't access local data schema file");
        }
    }

    private void finishInstallSchema(File tmpFile, String schemaIdentifier, String schemaName) throws IOException {
        Objects.requireNonNull(tmpFile);
        try {
            File installedFile = this.getDataSchema(schemaIdentifier, schemaName);
            FileUtils.moveFile((File)tmpFile, (File)installedFile);
        }
        catch (IOException e) {
            this.LOG.error("Installing data schema failed, while trying to move and rename data schema file: " + e.getMessage(), (Throwable)e);
            throw e;
        }
    }

    private void finishInstallTableSchema(File tmpFile, String schemaIdentifier, String schemaName, DataPackageTableSchema tableSchema) throws IOException {
        Objects.requireNonNull(tmpFile);
        Objects.requireNonNull(tableSchema, "Table schema must not be null");
        Objects.requireNonNull(tableSchema.getName(), "Table schema name is required");
        try {
            File installedFile = this.getTableSchemaFile(schemaIdentifier, schemaName, tableSchema.getName());
            FileUtils.moveFile((File)tmpFile, (File)installedFile);
        }
        catch (IOException e) {
            this.LOG.error("Installing data schema failed, while trying to move and rename data schema file: " + e.getMessage(), (Throwable)e);
            throw e;
        }
    }

    private File getTableSchemaFile(String schemaIdentifier, String schemaName, String tableSchemaName) {
        String filename = org.gbif.ipt.utils.FileUtils.getSuffixedFileName((String)(schemaIdentifier + "_" + tableSchemaName), (String)DATA_SCHEMA_FILE_SUFFIX);
        return this.dataDir.configFile(".dataPackages/" + schemaName + "/" + filename);
    }

    private File getDataSchema(String schemaIdentifier, String schemaName) {
        String filename = "_" + org.gbif.ipt.utils.FileUtils.getSuffixedFileName((String)schemaIdentifier, (String)DATA_SCHEMA_FILE_SUFFIX);
        return this.dataDir.configFile(".dataPackages/" + schemaName + "/" + filename);
    }

    private File getDataSchemaDirectory(String schemaName) {
        return this.dataDir.configFile(".dataPackages/" + schemaName);
    }
}

