/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.ipt.service.admin.impl;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Optional;
import javax.inject.Inject;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpHost;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.config.RequestConfig;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.config.Configuration;
import org.gbif.ipt.config.AppConfig;
import org.gbif.ipt.config.ConfigWarnings;
import org.gbif.ipt.config.DataDir;
import org.gbif.ipt.config.ExtensionMonitor;
import org.gbif.ipt.config.LoggingConfigFactory;
import org.gbif.ipt.config.LoggingConfiguration;
import org.gbif.ipt.config.PublishingMonitor;
import org.gbif.ipt.model.User;
import org.gbif.ipt.service.BaseManager;
import org.gbif.ipt.service.InvalidConfigException;
import org.gbif.ipt.service.admin.ConfigManager;
import org.gbif.ipt.service.admin.DataPackageSchemaManager;
import org.gbif.ipt.service.admin.ExtensionManager;
import org.gbif.ipt.service.admin.RegistrationManager;
import org.gbif.ipt.service.admin.UserAccountManager;
import org.gbif.ipt.service.admin.VocabulariesManager;
import org.gbif.ipt.service.admin.impl.ConfigManagerImpl;
import org.gbif.ipt.service.manage.ResourceManager;
import org.gbif.ipt.utils.URLUtils;
import org.gbif.utils.ExtendedResponse;
import org.gbif.utils.HttpClient;

public class ConfigManagerImpl
extends BaseManager
implements ConfigManager {
    private final UserAccountManager userManager;
    private final ResourceManager resourceManager;
    private final ExtensionManager extensionManager;
    private final VocabulariesManager vocabManager;
    private final DataPackageSchemaManager schemaManager;
    private final RegistrationManager registrationManager;
    private final ConfigWarnings warnings;
    private final HttpClient client;
    private final PublishingMonitor publishingMonitor;
    private final ExtensionMonitor extensionMonitor;
    private static final String PATH_TO_CSS = "/styles/main.css";
    private static final int DEFAULT_TO = 4000;
    private static final String DEPRECATED_VOCAB_PERSISTENCE_FILE = "vocabularies.xml";

    @Inject
    public ConfigManagerImpl(DataDir dataDir, AppConfig cfg, UserAccountManager userManager, ResourceManager resourceManager, ExtensionManager extensionManager, VocabulariesManager vocabManager, DataPackageSchemaManager schemaManager, RegistrationManager registrationManager, ConfigWarnings warnings, HttpClient client, PublishingMonitor publishingMonitor, ExtensionMonitor extensionMonitor) {
        super(cfg, dataDir);
        this.userManager = userManager;
        this.resourceManager = resourceManager;
        this.extensionManager = extensionManager;
        this.vocabManager = vocabManager;
        this.schemaManager = schemaManager;
        this.registrationManager = registrationManager;
        this.warnings = warnings;
        this.client = client;
        this.publishingMonitor = publishingMonitor;
        this.extensionMonitor = extensionMonitor;
        if (dataDir.isConfigured()) {
            this.LOG.info("IPT DataDir configured - loading its configuration");
            try {
                this.loadDataDirConfig();
            }
            catch (InvalidConfigException e) {
                this.LOG.error("Configuration problems existing. Watch your data dir! " + e.getMessage(), (Throwable)e);
            }
        } else {
            this.LOG.debug("IPT DataDir not configured - no configuration loaded");
        }
    }

    private boolean changeProxy(HttpHost currentProxyHost, String proxy) {
        try {
            boolean proxyWorks;
            HttpHost proxyHost = URLUtils.getHost((String)proxy);
            String testUrl = this.cfg.getRegistryUrl();
            try {
                this.LOG.info("Testing new proxy by fetching " + testUrl + " with 4 second timeout");
                RequestConfig rs = RequestConfig.custom().setProxy(proxyHost).setConnectTimeout(4000).setSocketTimeout(4000).build();
                ExtendedResponse response = this.client.get(testUrl, rs);
                this.LOG.info("Proxy response is " + String.valueOf(response.getStatusLine()));
                proxyWorks = 200 == response.getStatusLine().getStatusCode();
            }
            catch (Exception e) {
                proxyWorks = false;
                this.LOG.warn("Proxy failed because", (Throwable)e);
            }
            if (proxyWorks) {
                this.LOG.info("Proxy tested and working.");
                this.client.setProxy(proxyHost);
            } else {
                this.throwConfigException("Proxy could not be validated (tried to retrieve " + testUrl + ")", currentProxyHost, "admin.config.error.connectionRefused");
            }
        }
        catch (NumberFormatException e) {
            this.throwConfigException(e.getClass().getSimpleName() + " encountered", currentProxyHost, "admin.config.error.invalidPort");
        }
        catch (MalformedURLException e) {
            this.throwConfigException(e.getClass().getSimpleName() + " encountered", currentProxyHost, "admin.config.error.invalidProxyURL");
        }
        return true;
    }

    private void throwConfigException(String logMessage, HttpHost currentProxyHost, String message) {
        if (currentProxyHost != null) {
            this.LOG.info(logMessage + " , reverting to previous proxy setting on HTTP client: " + String.valueOf(currentProxyHost));
        }
        throw new InvalidConfigException(InvalidConfigException.TYPE.INVALID_PROXY, message);
    }

    public String getHostName() {
        return URLUtils.getHostName();
    }

    public boolean isBaseURLValid() {
        try {
            URL baseURL = new URL(this.cfg.getProperty("ipt.baseURL"));
            String proxyUrl = this.cfg.getProperty("proxy");
            HttpHost proxyHost = StringUtils.trimToNull((String)proxyUrl) != null ? URLUtils.getHost((String)proxyUrl) : null;
            return this.isValidBaseUrl(baseURL, proxyHost);
        }
        catch (MalformedURLException e) {
            this.LOG.error("MalformedURLException encountered while validating baseURL");
            return false;
        }
    }

    public void loadDataDirConfig() throws InvalidConfigException {
        this.LOG.info("Reading DATA DIRECTORY: " + this.dataDir.getDataDir().getAbsolutePath());
        this.LOG.info("Loading IPT config ...");
        this.cfg.loadConfig();
        this.LOG.info("Reloading log4j settings ...");
        this.reloadLogger();
        if (this.cfg.getProxy() != null) {
            this.LOG.info("Configuring http proxy ...");
            try {
                this.setProxy(this.cfg.getProxy());
            }
            catch (InvalidConfigException e) {
                this.warnings.addStartupError((Exception)((Object)e));
            }
        }
        this.LOG.info("Loading user accounts ...");
        this.userManager.load();
        this.LOG.info("Loading vocabularies ...");
        this.vocabManager.load();
        this.LOG.info("Ensure latest versions of default vocabularies are installed...");
        this.vocabManager.installOrUpdateDefaults();
        File vocabDir = this.dataDir.configFile(".vocabularies");
        File deprecatedVocabFile = new File(vocabDir, DEPRECATED_VOCAB_PERSISTENCE_FILE);
        if (deprecatedVocabFile.exists()) {
            this.LOG.info("Perform 1-time event: delete deprecated vocabularies.xml file");
            FileUtils.deleteQuietly((File)deprecatedVocabFile);
        }
        this.LOG.info("Loading extensions ...");
        this.extensionManager.load();
        this.LOG.info("Loading data package schemas ...");
        this.schemaManager.load();
        this.LOG.info("Ensure supported versions of default schemas are installed...");
        this.schemaManager.installOrUpdateDefaults();
        if (!this.dataDir.configFile("registration2.xml").exists()) {
            this.LOG.info("Perform 1-time event: migrate registration.xml into registration2.xml with passwords encrypted");
            this.registrationManager.encryptRegistration();
        }
        this.LOG.info("Loading registration configuration...");
        this.registrationManager.load();
        this.LOG.info("Loading resource configurations ...");
        User defaultCreator = this.userManager.list(User.Role.Admin).isEmpty() ? null : (User)this.userManager.list(User.Role.Admin).get(0);
        File resourcesDir = this.dataDir.dataFile("resources");
        this.checkResourcesDirAtStartup(resourcesDir);
        this.resourceManager.load(resourcesDir, defaultCreator);
        this.LOG.info("Starting Publishing Monitor...");
        this.publishingMonitor.start();
        this.LOG.info("Starting Extension Monitor...");
        this.extensionMonitor.start();
    }

    private void checkResourcesDirAtStartup(File resourcesDir) {
        DataDir.DirStatus status = this.dataDir.getDirectoryReadWriteStatus(resourcesDir);
        switch (1.$SwitchMap$org$gbif$ipt$config$DataDir$DirStatus[status.ordinal()]) {
            case 1: {
                this.LOG.error("Resources directory does not exist: " + String.valueOf(resourcesDir));
                this.warnings.addStartupError("Resources directory does not exist: " + String.valueOf(resourcesDir));
                break;
            }
            case 2: {
                this.LOG.error("Resources directory cannot be read. Please check access rights for: " + String.valueOf(resourcesDir));
                this.warnings.addStartupError("Resources directory cannot be read. Please check access rights for: " + String.valueOf(resourcesDir));
                break;
            }
            case 3: {
                this.LOG.error("Resources directory cannot be written. Please check access rights for: " + String.valueOf(resourcesDir));
                this.warnings.addStartupError("Resources directory cannot be written. Please check access rights for: " + String.valueOf(resourcesDir));
                break;
            }
            case 4: {
                File[] files = resourcesDir.listFiles();
                if (files == null) break;
                block10: for (File subResourceDir : files) {
                    DataDir.DirStatus subStatus = this.dataDir.getDirectoryReadWriteStatus(subResourceDir);
                    switch (1.$SwitchMap$org$gbif$ipt$config$DataDir$DirStatus[subStatus.ordinal()]) {
                        case 1: 
                        case 2: {
                            this.LOG.error("At least one resource directory cannot be read. Please check access rights for: " + String.valueOf(subResourceDir));
                            this.warnings.addStartupError("At least one resource directory cannot be read. Please check access rights for: " + String.valueOf(subResourceDir));
                            continue block10;
                        }
                        case 3: {
                            this.LOG.error("At least one resource directory cannot be written. Please check access rights for: " + String.valueOf(subResourceDir));
                            this.warnings.addStartupError("At least one resource directory cannot be written. Please check access rights for: " + String.valueOf(subResourceDir));
                            continue block10;
                        }
                    }
                }
                break;
            }
        }
    }

    private void reloadLogger() {
        LoggingConfiguration.logDirectory = this.dataDir.loggingDir().getAbsolutePath() + "/";
        this.LOG.info("Changing logging directory to {}", (Object)LoggingConfiguration.logDirectory);
        LoggingConfigFactory.useDebug = this.cfg.debug();
        LoggerContext context = (LoggerContext)LogManager.getContext((boolean)false);
        Configuration newConfig = LoggingConfigFactory.newConfigurationBuilder().build(true);
        context.setConfiguration(newConfig);
        context.reconfigure();
        this.LOG.info("Reloaded Log4J2 for {}", (Object)(this.cfg.debug() ? "debugging" : "production"));
        this.LOG.info("Logging to {}", (Object)LoggingConfiguration.logDirectory);
        this.LOG.info("IPT Data Directory: {}", (Object)this.dataDir.dataFile(".").getAbsolutePath());
    }

    public void saveConfig() throws InvalidConfigException {
        try {
            this.cfg.saveConfig();
        }
        catch (IOException e) {
            this.LOG.debug("Cant save IPT configuration: " + e.getMessage(), (Throwable)e);
            throw new InvalidConfigException(InvalidConfigException.TYPE.CONFIG_WRITE, "Cant save IPT configuration: " + e.getMessage());
        }
    }

    public void setAnalyticsKey(String key) throws InvalidConfigException {
        this.cfg.setProperty("analytics.key", StringUtils.trimToEmpty((String)key));
    }

    public void setBaseUrl(URL baseURL) throws InvalidConfigException {
        HttpHost proxyHost;
        boolean validate = true;
        String proxyUrl = this.cfg.getProperty("proxy");
        try {
            proxyHost = StringUtils.trimToNull((String)proxyUrl) != null ? URLUtils.getHost((String)proxyUrl) : null;
        }
        catch (MalformedURLException e) {
            throw new InvalidConfigException(InvalidConfigException.TYPE.INACCESSIBLE_BASE_URL, "Wrong Proxy configuration");
        }
        if (URLUtils.isLocalhost((URL)baseURL)) {
            this.LOG.info("Localhost used in base URL");
            if (this.cfg.getRegistryType() == AppConfig.REGISTRY_TYPE.DEVELOPMENT) {
                if (proxyHost != null) {
                    validate = false;
                    if (!this.isValidBaseUrl(baseURL, proxyHost)) {
                        throw new InvalidConfigException(InvalidConfigException.TYPE.INACCESSIBLE_BASE_URL, "No IPT found at new base URL");
                    }
                }
            } else if (!baseURL.getHost().equalsIgnoreCase(this.getHostName())) {
                throw new InvalidConfigException(InvalidConfigException.TYPE.INACCESSIBLE_BASE_URL, "Localhost base URL not permitted in production mode, since the IPT will not be visible to the outside!");
            }
        }
        if (validate && !this.isValidBaseUrl(baseURL, proxyHost)) {
            throw new InvalidConfigException(InvalidConfigException.TYPE.INACCESSIBLE_BASE_URL, "No IPT found at new base URL");
        }
        this.LOG.info("Updating the baseURL to: " + String.valueOf(baseURL));
        this.cfg.setProperty("ipt.baseURL", baseURL.toString());
    }

    public void setConfigProperty(String key, String value) {
        this.cfg.setProperty(key, value);
    }

    public boolean setDataDir(File dataDir) throws InvalidConfigException {
        boolean created = this.dataDir.setDataDir(dataDir);
        this.loadDataDirConfig();
        return created;
    }

    public void setDebugMode(boolean debug) throws InvalidConfigException {
        this.cfg.setProperty("debug", Boolean.toString(debug));
        this.reloadLogger();
    }

    public void setArchivalMode(boolean archivalMode) throws InvalidConfigException {
        if (!archivalMode && this.registrationManager.findPrimaryDoiAgencyAccount() != null) {
            throw new InvalidConfigException(InvalidConfigException.TYPE.DOI_REGISTRATION_ALREADY_ACTIVATED, "Cannot turn off archival mode sinceDOI registration has been activated");
        }
        this.cfg.setProperty("archivalMode", Boolean.toString(archivalMode));
    }

    public void setArchivalLimit(Integer archivalLimit) throws InvalidConfigException {
        if (archivalLimit == null || archivalLimit == 0) {
            this.cfg.setProperty("archivalLimit", "");
        } else {
            this.cfg.setProperty("archivalLimit", Integer.toString(archivalLimit));
        }
    }

    public void setIptLocation(Double lat, Double lon) throws InvalidConfigException {
        if (lat == null || lon == null) {
            this.cfg.setProperty("location.lat", "");
            this.cfg.setProperty("location.lon", "");
        } else {
            if (lat > 90.0 || lat < -90.0 || lon > 180.0 || lon < -180.0) {
                this.LOG.warn("IPT Lat/Lon is not a valid coordinate");
                throw new InvalidConfigException(InvalidConfigException.TYPE.FORMAT_ERROR, "IPT Lat/Lon is not a valid coordinate");
            }
            this.cfg.setProperty("location.lat", Double.toString(lat));
            this.cfg.setProperty("location.lon", Double.toString(lon));
        }
    }

    public void setProxy(String proxy) throws InvalidConfigException {
        String newProxyValue = StringUtils.trimToNull((String)proxy);
        if (newProxyValue == null) {
            this.LOG.info("No proxy entered, so removing proxy setting on http client");
            this.client.removeProxy();
        } else {
            HttpHost currentProxy = null;
            String proxyProperty = this.cfg.getProperty("proxy");
            if (StringUtils.trimToNull((String)proxyProperty) != null) {
                try {
                    URL currentProxyUrl = new URL(proxyProperty);
                    currentProxy = new HttpHost(currentProxyUrl.getHost(), currentProxyUrl.getPort());
                }
                catch (MalformedURLException e) {
                    this.LOG.info("the proxy URL is invalid", (Throwable)e);
                }
            }
            this.changeProxy(currentProxy, newProxyValue);
        }
        this.cfg.setProperty("proxy", newProxyValue);
    }

    public boolean setupComplete() {
        return this.dataDir.isConfigured() && this.cfg.getRegistryType() != null && !this.userManager.list(User.Role.Admin).isEmpty();
    }

    public boolean isValidBaseUrl(URL baseURL, HttpHost proxy) {
        if (baseURL == null) {
            return false;
        }
        try {
            ExtendedResponse response;
            String testURL = String.valueOf(baseURL) + PATH_TO_CSS;
            this.LOG.info("Validating BaseURL with get request (having 4 second timeout) to: " + testURL);
            RequestConfig.Builder requestConfigBuilder = RequestConfig.custom().setConnectTimeout(4000).setSocketTimeout(4000);
            if (proxy != null) {
                requestConfigBuilder.setProxy(proxy);
            }
            return 200 == (response = this.client.get(testURL, requestConfigBuilder.build())).getStatusLine().getStatusCode();
        }
        catch (ClientProtocolException e) {
            this.LOG.info("Protocol error connecting to new base URL [" + String.valueOf(baseURL) + "]", (Throwable)e);
        }
        catch (IOException e) {
            this.LOG.info("IO error connecting to new base URL [" + String.valueOf(baseURL) + "]", (Throwable)e);
        }
        catch (Exception e) {
            this.LOG.info("Unknown error connecting to new base URL [" + String.valueOf(baseURL) + "]", (Throwable)e);
        }
        return false;
    }

    public void setAdminEmail(String adminEmail) {
        this.cfg.setProperty("admin.email", adminEmail);
    }

    public void setDefaultLocale(String defaultLocale) {
        Optional.ofNullable(defaultLocale).filter(arg_0 -> ((AppConfig)this.cfg).isSupportedLanguage(arg_0)).ifPresent(arg_0 -> ((AppConfig)this.cfg).setDefaultLocale(arg_0));
    }

    public void setLogoRedirectUrl(String logoRedirectUrl) {
        Optional.ofNullable(logoRedirectUrl).ifPresent(arg_0 -> ((AppConfig)this.cfg).setLogoRedirectUrl(arg_0));
    }
}

