/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.ipt.service;

import java.io.IOException;
import java.net.ConnectException;
import java.net.SocketTimeoutException;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import org.gbif.ipt.action.BaseAction;
import org.gbif.ipt.service.RegistryException;

public class RegistryException
extends RuntimeException {
    protected Type type;
    protected String url;

    public RegistryException(String url, Exception e) {
        super(e.getMessage(), e);
        this.type = e instanceof ClassCastException ? Type.BAD_RESPONSE : (e instanceof ConnectException || e instanceof SocketTimeoutException ? Type.PROXY : (e instanceof UnknownHostException ? Type.NO_INTERNET : (e instanceof IOException ? Type.IO_ERROR : (e instanceof URISyntaxException ? Type.BAD_REQUEST : Type.UNKNOWN))));
        this.url = url;
    }

    public RegistryException(Type type, String url, Exception e) {
        super(e.getMessage(), e);
        this.type = type;
        this.url = url;
    }

    public RegistryException(Type type, String url, String message) {
        super(message);
        this.type = type;
        this.url = url;
    }

    public RegistryException(Type type, String url, String message, Exception e) {
        super(message, e);
        this.type = type;
        this.url = url;
    }

    public Type getType() {
        return this.type;
    }

    public static String logRegistryException(RegistryException e, BaseAction action) {
        String msg = action.getText("admin.registration.error.registry");
        if (e.type != null) {
            if (e.type == Type.PROXY) {
                msg = action.getText("admin.registration.error.proxy");
            } else if (e.type == Type.SITE_DOWN) {
                msg = action.getText("admin.registration.error.siteDown");
            } else if (e.type == Type.NO_INTERNET) {
                msg = action.getText("admin.registration.error.internetConnection");
            } else if (e.type == Type.BAD_RESPONSE) {
                msg = action.getText("admin.registration.error.badResponse");
            } else if (e.type == Type.IO_ERROR) {
                msg = action.getText("admin.registration.error.io");
            } else if (e.type == Type.BAD_REQUEST) {
                msg = action.getText("admin.registration.error.badRequest");
            } else if (e.type == Type.UNKNOWN) {
                msg = action.getText("admin.registration.error.unknown");
            }
        }
        return msg + " [" + e.url + "]";
    }
}

