/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.ipt.model.factory;

import java.net.MalformedURLException;
import java.net.URL;
import javax.inject.Inject;
import org.apache.commons.digester.Rule;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.gbif.ipt.model.ExtensionProperty;
import org.gbif.ipt.model.Vocabulary;
import org.gbif.ipt.service.admin.VocabulariesManager;
import org.xml.sax.Attributes;

public class ThesaurusHandlingRule
extends Rule {
    public static final String ATTRIBUTE_THESAURUS = "thesaurus";
    private static final Logger LOG = LogManager.getLogger(ThesaurusHandlingRule.class);
    private final VocabulariesManager vocabManager;

    @Inject
    public ThesaurusHandlingRule(VocabulariesManager vocabManager) {
        this.vocabManager = vocabManager;
    }

    public void begin(String namespace, String name, Attributes attributes) throws Exception {
        for (int i = 0; i < attributes.getLength(); ++i) {
            if (!ATTRIBUTE_THESAURUS.equals(attributes.getQName(i))) continue;
            Vocabulary tv = null;
            try {
                URL url = new URL(attributes.getValue(i));
                tv = this.vocabManager.get(url);
                if (tv == null) {
                    LOG.warn("Installing new vocabulary with URL (" + attributes.getValue(i) + ")...");
                    tv = this.vocabManager.installIfAbsentOrOutdated(url);
                }
            }
            catch (MalformedURLException e) {
                LOG.error("Thesaurus URL (" + attributes.getValue(i) + ") is malformed: " + e.getMessage(), (Throwable)e);
            }
            if (tv == null) {
                LOG.error("No Vocabulary object exists for the URL (" + attributes.getValue(i) + ") so cannot be set");
                break;
            }
            Object extensionPropertyAsObject = this.getDigester().peek();
            if (!(extensionPropertyAsObject instanceof ExtensionProperty)) break;
            ExtensionProperty eProperty = (ExtensionProperty)extensionPropertyAsObject;
            eProperty.setVocabulary(tv);
            LOG.debug("Vocabulary with URI[" + tv.getUriString() + "] added to extension property");
            break;
        }
    }
}

